/**
 * @author tpasquet
 * @date 24/03/2023
 * @version 1.0.0
 * @project SIEau
 * @table chroniques_brutes et chroniques_analyses
 */

# --- !Ups

update prelevements set datedebut = cast(datedebut as date) + cast(heuredebut as time)
where heuredebut notnull and cast(datedebut as time) = '00:00:00' and cast(heuredebut as time) != '00:00:00';

update qualitometres_points_operations set datedebut = cast(datedebut as date) + cast(heuredebut as time)
where heuredebut notnull and cast(datedebut as time) = '00:00:00' and cast(heuredebut as time) != '00:00:00';

create or replace function getallanalysis() returns double precision
language plpgsql
as
$$
DECLARE
my_cursor_station REFCURSOR;;
stations RECORD;;
v_requete VARCHAR (5000);;
d_count double precision;;
v_station_bss VARCHAR(50);;
begin
delete from chroniques_analyses;;
RAISE NOTICE '## PURGE DES DONNEES ANALYSES ##';;
OPEN my_cursor_station for select q.codebss from qualitometres q;;
LOOP
FETCH my_cursor_station into stations;;
EXIT WHEN NOT FOUND;;
begin
v_station_bss := lower(replace(stations.codebss, '-', '_'));;
execute 'select count(*) from analyses_'|| v_station_bss INTO d_count;;
RAISE NOTICE '############# STATION % : %', v_station_bss, d_count;;
EXCEPTION
WHEN undefined_table THEN
d_count := 0;;
RAISE NOTICE '[UNDEFINED TABLE] Error on table count on table % : %', lower(stations.codebss), SQLERRM;;
WHEN OTHERS THEN
d_count := 0;;
RAISE NOTICE '[OTHERS] Error on table count on table % : %', lower(stations.codebss), SQLERRM;;
END;;
IF d_count > 0 THEN
v_requete := 'insert into chroniques_analyses (    codequalitometre,numanalyse,numprelevement,codeoperation,dateanalyse,codeparametre,codeunite,resultat,coderemarque,codelieu, '||
    ' limitequantification,limitedetection,seuilsaturation,codequalification,statutmesure,codefraction,codemethode,codelabo,referencelabo,numechantillon,accreditation, '||
    ' codedifficulte,commentaireanalyse,commentaireresultat,incertitudeanalytique,codesolvant,methodeextraction,rendementextraction,volumefiltre,coderesponsable,resultatref, '||
    ' jobexecutionid,datecreation,datemaj,loginmaj) ' ||
    ' select distinct coalesce(a.codequalitometre, qpo.codequalitometre)as codequalitometre, a.numanalyse, p.numprelevement, qpo.codeoperation, coalesce(a.dateanalyse, p.datedebut) as dateanalyse, '||
    ' a.codeparametre, a.codeunite, round(a.resultat::numeric, 6), a.coderemarque, a.codelieu, a.limitequantification, a.limitedetection, a.seuilsaturation, coalesce(a.codequalification, (qpo.qualification :: varchar)) as codequalification, '||
    ' coalesce(a.statutmesure, (qpo.statut :: varchar)) as statutmesure, coalesce(a.codefraction, p.codefractionprincipal), coalesce(a.codemethode, (qpo.methodeanalyse :: varchar)) as codemethode, '||
    ' coalesce(a.codelabo, p.codelaboprincipal) as codelabo, coalesce(a.referencelabo, p.referencelaboprincipal) as referencelabo, a.numechantillon, coalesce(a.accreditation, coalesce(qpo.accreditation, p.accreditation)) as accreditation, '||
    ' coalesce(a.codedifficulte, p.codedifficulteprincipal) as codedifficulte, a.commentaireanalyse, a.commentaireresultat, a.incertitudeanalytique, a.codesolvant, a.methodeextraction, a.rendementextraction, '||
    ' a.volumefiltre, a.coderesponsable, a.resultatref, coalesce(a.jobexecutionid, qpo.jobexecutionid), current_date as datecreation, current_date as datemaj, ''MIG_QUALITE'' as loginmaj '||
' from qualitometres q join qualitometres_points_operations qpo  '||
' on (q.codequalitometre = qpo.codequalitometre) '||
' join prelevements p  '||
' on (qpo.codequalitometre = p.codequalitometre and qpo.codeoperation = p.codeoperation) '||
' join analyses_'||v_station_bss||' a  '||
' on (qpo.codequalitometre = a.codequalitometre and p.numprelevement = a.numprelevement)';;
BEGIN
--RAISE NOTICE '%',v_requete;;
execute v_requete;;
EXCEPTION
WHEN undefined_table THEN
RAISE NOTICE '[UNDEFINED TABLE] Error on table insert on table % : %', v_station_bss, SQLERRM;;
WHEN OTHERS THEN
RAISE NOTICE '[OTHERS] Error on table insert on table % : %', v_station_bss, SQLERRM;;
END;;
END IF;;
end loop;;
select count(*) into d_count from chroniques_analyses;;
CLOSE my_cursor_station;;
RETURN d_count;;
END;;
$$;;
# --- !Downs