/**
 * @author ebonneau
 * @date 11/07/2023
 * @version 1.0.0
 * @project SIEau
 * @table getallanalysis
 */

# --- !Ups

DROP FUNCTION IF EXISTS public.getallanalysis();

CREATE OR REPLACE FUNCTION public.getallanalysis(p_stationids integer[], p_filtreid character varying, p_job_execution_id integer)
	RETURNS double precision
	LANGUAGE plpgsql
AS $function$
DECLARE
	my_cursor_stations REFCURSOR;;
	stations RECORD;;
	v_requete VARCHAR (5000);;
	d_count double precision;;
	d_logs double precision;;
	v_codebss VARCHAR(50);;
	b_integration BOOLEAN;;
	d_id_job double precision;;
	v_requete_filtre text;;
	i_codequalitometre integer;;

BEGIN

	v_requete := '';;
	d_count := 0;;
	v_codebss := '';;
	d_logs := 0;;
	b_integration := true;;
	d_id_job := 0;;
	v_requete_filtre := '';;
	i_codequalitometre := 0;;

	/* GESTION DE LA TABLE DE LOGS */
	BEGIN
		SELECT count(id) into d_logs from migration_logs;;
		if d_logs >= 0 THEN
			b_integration := true;;
		else
			b_integration := false;;
		end if;;
	EXCEPTION
		WHEN undefined_table THEN
			CREATE TABLE migration_logs (id double precision, commentaire text, valeur text, execution_timestamp timestamp, station varchar(255), job_execution_id integer, type_migration varchar(50));;
			execute 'CREATE INDEX migration_logs_id_idx ON public.migration_logs (id,job_execution_id)';;
			execute 'CREATE INDEX migration_logs_station_idx ON public.migration_logs (station)';;
			execute 'CREATE INDEX migration_logs_job_execution_id_idx ON public.migration_logs (job_execution_id)';;
			execute 'CREATE INDEX migration_logs_type_migration_idx ON public.migration_logs (type_migration)';;
			b_integration := true;;
		WHEN OTHERS THEN
			INSERT INTO migration_logs VALUES(d_id_job, '[OTHERS] Erreur '|| SQLERRM ||' à l''étape 0 pour créer la table de logs', null, now(), null, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;
			b_integration := false;;
	END;;

	IF b_integration = true THEN
		d_id_job := d_id_job +1;;
		/*RAISE NOTICE 'Initialisation du traitement;;*/
		INSERT INTO migration_logs VALUES(d_id_job, 'Initialisation du traitement', null, now(), null, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;
		d_id_job := d_id_job +1;;

		IF p_stationIds is not null THEN
			OPEN my_cursor_stations FOR SELECT q.codequalitometre FROM qualitometres q WHERE q.codequalitometre = ANY(p_stationIds);;
		ELSE
			IF p_filtreId is not null THEN
				SELECT selectionfiltre INTO v_requete_filtre FROM utilisateurs_listes
					WHERE module = 'SIQ'
					AND codeliste = p_filtreId;;
				OPEN my_cursor_stations FOR EXECUTE v_requete_filtre;;
			ELSE
				OPEN my_cursor_stations FOR SELECT q.codequalitometre FROM qualitometres q;;
			END IF;;
		END IF;;

		LOOP
			FETCH my_cursor_stations into i_codeQualitometre;;
			EXIT WHEN NOT FOUND;;

			/* Récupération du codebss de la station */
			SELECT codebss INTO v_codebss FROM qualitometres
				WHERE codequalitometre = i_codeQualitometre;;

			v_codebss :=  lower(replace(v_codebss, '-', '_'));;

			/*RAISE NOTICE 'Traitement de la station %', v_codebss;;*/
			INSERT INTO migration_logs VALUES(d_id_job, 'Start of job on station '||v_codebss, null, now(), v_codebss, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;

			d_id_job := d_id_job +1;;

			IF v_codebss <> '' THEN

				/*RAISE NOTICE 'Suppression des données existantes dans les tables de destination';;*/
				INSERT INTO migration_logs VALUES(d_id_job, 'Suppression des données existantes dans les tables de destination', null, now(), v_codebss, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;
				d_id_job := d_id_job +1;;

				DELETE FROM chroniques_analyses WHERE codequalitometre=i_codeQualitometre;;

				begin
					v_requete := 'select count(*) from analyses_'|| v_codebss;;
					execute v_requete INTO d_count;;
					INSERT INTO migration_logs VALUES(d_id_job, 'Nombre d''analyses pour la station '|| v_codebss ||' : '||d_count, v_requete, now(), v_codebss, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;
					d_id_job := d_id_job +1;;
					b_integration := true;;
				EXCEPTION
					WHEN undefined_table THEN
						d_count := 0;;
						RAISE NOTICE '[UNDEFINED TABLE] Error on table count on table % : %', v_codebss, SQLERRM;;
						INSERT INTO migration_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on table count on table analyses_'|| v_codebss , v_requete, now(), v_codebss, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;
						d_id_job := d_id_job +1;;
						b_integration := false;;
					WHEN OTHERS THEN
						d_count := 0;;
						RAISE NOTICE '[OTHERS] Error on table count on table % : %', v_codebss, SQLERRM;;
						INSERT INTO migration_logs VALUES(d_id_job, '[OTHERS] Error '||SQLERRM||' on table count on table analyses_'|| v_codebss , v_requete, now(), v_codebss, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;
						d_id_job := d_id_job +1;;
						b_integration := false;;
				END;;
				IF d_count > 0 THEN
					v_requete := 'insert into chroniques_analyses (    codequalitometre,numanalyse,numprelevement,codeoperation,dateanalyse,codeparametre,codeunite,resultat,coderemarque,codelieu, '||
					' limitequantification,limitedetection,seuilsaturation,codequalification,statutmesure,codefraction,codemethode,codelabo,referencelabo,numechantillon,accreditation, '||
					' codedifficulte,commentaireanalyse,commentaireresultat,incertitudeanalytique,codesolvant,methodeextraction,rendementextraction,volumefiltre,coderesponsable,resultatref, '||
					' jobexecutionid,datecreation,datemaj,loginmaj) ' ||
					' select distinct coalesce(a.codequalitometre, qpo.codequalitometre)as codequalitometre, a.numanalyse, p.numprelevement, qpo.codeoperation, coalesce(a.dateanalyse, p.datedebut) as dateanalyse, '||
					' a.codeparametre, a.codeunite, round(a.resultat::numeric, 6), a.coderemarque, a.codelieu, a.limitequantification, a.limitedetection, a.seuilsaturation, coalesce(a.codequalification, (qpo.qualification :: varchar)) as codequalification, '||
					' coalesce(a.statutmesure, (qpo.statut :: varchar)) as statutmesure, coalesce(a.codefraction, p.codefractionprincipal), coalesce(a.codemethode, (qpo.methodeanalyse :: varchar)) as codemethode, '||
					' coalesce(a.codelabo, p.codelaboprincipal) as codelabo, coalesce(a.referencelabo, p.referencelaboprincipal) as referencelabo, a.numechantillon, coalesce(a.accreditation, coalesce(qpo.accreditation, p.accreditation)) as accreditation, '||
					' coalesce(a.codedifficulte, p.codedifficulteprincipal) as codedifficulte, a.commentaireanalyse, a.commentaireresultat, a.incertitudeanalytique, a.codesolvant, a.methodeextraction, a.rendementextraction, '||
					' a.volumefiltre, a.coderesponsable, a.resultatref, coalesce(a.jobexecutionid, qpo.jobexecutionid), current_date as datecreation, current_date as datemaj, ''MIG_QUALITE'' as loginmaj '||
					' from qualitometres q join qualitometres_points_operations qpo  '||
					' on (q.codequalitometre = qpo.codequalitometre) '||
					' join prelevements p  '||
					' on (qpo.codequalitometre = p.codequalitometre and qpo.codeoperation = p.codeoperation) '||
					' join analyses_'||v_codebss||' a  '||
					' on (qpo.codequalitometre = a.codequalitometre and p.numprelevement = a.numprelevement)';;
					BEGIN
						execute v_requete;;
						d_id_job := d_id_job +1;;
						b_integration := true;;
					EXCEPTION
						WHEN undefined_table THEN
							RAISE NOTICE '[UNDEFINED TABLE] Error on table insert on table % : %', v_codebss, SQLERRM;;
							INSERT INTO migration_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on insert table chroniques_analyses', v_requete, now(), v_codebss, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;
							d_id_job := d_id_job +1;;
							b_integration := false;;
						WHEN OTHERS THEN
							RAISE NOTICE '[OTHERS] Error on table insert on table % : %', v_codebss, SQLERRM;;
							INSERT INTO migration_logs VALUES(d_id_job, '[OTHERS] Error '||SQLERRM||' on insert table chroniques_analyses', v_requete, now(), v_codebss, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;
							d_id_job := d_id_job +1;;
							b_integration := false;;
					END;;
				END IF;;
			END IF;;
		end loop;;
		select count(*) into d_count from chroniques_analyses;;
		INSERT INTO migration_logs VALUES(d_id_job, 'End of job with '||d_count||' analysis inserted in chroniques_analyses', null, now(), v_codebss, p_job_execution_id, 'MIG_QUALITE_ANALYSIS');;
		CLOSE my_cursor_stations;;
	END IF;;
	RETURN d_count;;
END;;
$function$
;;

ALTER FUNCTION public.getallanalysis(p_stationids integer[], p_filtreid character varying, p_job_execution_id integer) OWNER TO postgres;
GRANT ALL ON FUNCTION public.getallanalysis(p_stationids integer[], p_filtreid character varying, p_job_execution_id integer) TO postgres;


# --- !Downs

