/**
 * @author ebonneau
 * @date 20/07/2023
 * @version 1.0.0
 * @project Myliaq
 * @table codes_sandre
 */

# --- !Ups

create or replace procedure doEvolution285()
 LANGUAGE 'plpgsql'
    as $BODY$

    declare environment int;;
  begin
	  select count(valeur)
      into environment
      from parametres
    where module='script' and identifiant = '285' and valeur='1';;

    if (environment > 0 ) then
        drop view if exists v_eau17sig_reservoirs;;
        drop view if exists eau17sig_reservoirs;;
        drop view if exists lex_precision_xy ;;
        drop view if exists lex_type_validite;;
        drop view if exists v_eau17sig_captages;;
        drop view if exists v_eau17sig_poste_relevage;;
        drop view if exists v_eau17sig_stations_pompages;;
        drop view if exists v_eau17sig_step;;

        ALTER TABLE if exists codes_sandre ALTER COLUMN libelle TYPE varchar(100);;

        -- public.v_eau17sig_reservoirs source

        CREATE OR REPLACE VIEW public.v_eau17sig_reservoirs
        AS SELECT aep_installations.identifiant,
            lex_etat.libelle AS fonctionnement,
            inst_reservoir_gc.nbcuves,
            lex_natures_cuves.libelle AS naturecuves,
            lex_revetements_cuves.libelle AS revetementcuve,
            lex_mode_rempl_cuves.libelle AS moderemplissage,
                CASE
                    WHEN equip_turbidimetre.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presenceturbidimetre,
                CASE
                    WHEN equip_chlore.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presencanalyseurchlore,
                CASE
                    WHEN equip_colonne_seche.codeprotection IS NOT NULL THEN true
                    ELSE false
                END AS colonneseche,
                CASE
                    WHEN equip_fontaine.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS fontaine,
            lex_detection_niveau.libelle AS typedetectionniveau,
            lex_mesure_debit.libelle AS typemesuredebitmetrique,
                CASE
                    WHEN equip_bypass.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presencebypass,
                CASE
                    WHEN equip_robinetflotteur.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presencerobinetflotteur,
                CASE
                    WHEN equip_antiintrusion.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presenceantiintrusion,
            inst_electricite_com.hastelegestion,
            aep_installations.loginmaj,
            aep_installations.datemaj
           FROM aep_installations
             LEFT JOIN inst_reservoir_gc ON aep_installations.codeinstallation = inst_reservoir_gc.codeinstallation
             LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
             LEFT JOIN codes_sandre lex_etat ON aep_installations.statut = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
             LEFT JOIN codes_sandre lex_natures_cuves ON inst_reservoir_gc.naturecuve = lex_natures_cuves.code AND lex_natures_cuves.champ::text = 'CUVES.MATERIAU'::text
             LEFT JOIN codes_sandre lex_revetements_cuves ON inst_reservoir_gc.revetementcuve = lex_revetements_cuves.code AND lex_revetements_cuves.champ::text = 'INSTALLATIONS.REVETEMENTCUVE'::text
             LEFT JOIN codes_sandre lex_mode_rempl_cuves ON inst_reservoir_gc.moderemplissage = lex_mode_rempl_cuves.code AND lex_mode_rempl_cuves.champ::text = 'INSTALLATIONS.MODEREMPLISSAGE'::text
             LEFT JOIN inst_equipements_detail equip_turbidimetre ON aep_installations.codeinstallation = equip_turbidimetre.codeinstallation AND equip_turbidimetre.codeequipement = 0
             LEFT JOIN inst_equipements_detail equip_chlore ON aep_installations.codeinstallation = equip_chlore.codeinstallation AND equip_chlore.codeequipement = 1
             LEFT JOIN inst_equipements_detail equip_fontaine ON aep_installations.codeinstallation = equip_fontaine.codeinstallation AND equip_fontaine.codeequipement = 3
             LEFT JOIN inst_equipements_detail equip_antiintrusion ON aep_installations.codeinstallation = equip_antiintrusion.codeinstallation AND equip_antiintrusion.codeequipement = 39
             LEFT JOIN inst_securite_personnel equip_colonne_seche ON aep_installations.codeinstallation = equip_colonne_seche.codeinstallation AND equip_colonne_seche.codeprotection = 4
             LEFT JOIN inst_reservoir_equipements ON aep_installations.codeinstallation = inst_reservoir_equipements.codeinstallation
             LEFT JOIN codes_sandre lex_detection_niveau ON inst_reservoir_equipements.typedetectionniveau = lex_detection_niveau.code AND lex_detection_niveau.champ::text = 'INSTALLATIONS.TYPEDETECTION'::text
             LEFT JOIN codes_sandre lex_mesure_debit ON inst_reservoir_equipements.mesuredebitmetrique = lex_mesure_debit.code AND lex_mesure_debit.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
             LEFT JOIN inst_equipements_detail equip_bypass ON aep_installations.codeinstallation = equip_bypass.codeinstallation AND equip_bypass.codeequipement = 4
             LEFT JOIN inst_equipements_detail equip_robinetflotteur ON aep_installations.codeinstallation = equip_robinetflotteur.codeinstallation AND equip_robinetflotteur.codeequipement = 5
          WHERE aep_installations.typeinstallation = 12;;

         CREATE OR REPLACE VIEW public.eau17sig_reservoirs
        AS SELECT aep_installations.identifiant,
            inst_reservoir_gc.nbcuves,
            lex_natures_cuves.libelle AS naturecuves,
            lex_revetements_cuves.libelle AS revetementcuve,
            lex_mode_rempl_cuves.libelle AS moderemplissage,
                CASE equip_turbidimetre.codeequipement
                    WHEN 0 THEN true
                    ELSE false
                END AS presenceturbidimetre,
                CASE equip_chlore.codeequipement
                    WHEN 0 THEN true
                    ELSE false
                END AS presencanalyseurchlore,
                CASE equip_colonne_seche.codeprotection
                    WHEN 0 THEN true
                    ELSE false
                END AS colonneseche,
                CASE equip_fontaine.codeequipement
                    WHEN 0 THEN true
                    ELSE false
                END AS fontaine,
            lex_detection_niveau.libelle AS typedetectionniveau,
            lex_mesure_debit.libelle AS typemesuredebitmetrique,
                CASE equip_bypass.codeequipement
                    WHEN 0 THEN true
                    ELSE false
                END AS presencebypass,
                CASE equip_robinetflotteur.codeequipement
                    WHEN 0 THEN true
                    ELSE false
                END AS presencerobinetflotteur,
            aep_installations.loginmaj,
            aep_installations.datemaj
           FROM aep_installations
             LEFT JOIN inst_reservoir_gc ON aep_installations.codeinstallation = inst_reservoir_gc.codeinstallation
             LEFT JOIN codes_sandre lex_natures_cuves ON inst_reservoir_gc.naturecuve = lex_natures_cuves.code AND lex_natures_cuves.champ::text = 'CUVES.MATERIAU'::text
             LEFT JOIN codes_sandre lex_revetements_cuves ON inst_reservoir_gc.revetementcuve = lex_revetements_cuves.code AND lex_revetements_cuves.champ::text = 'INSTALLATIONS.REVETEMENTCUVE'::text
             LEFT JOIN codes_sandre lex_mode_rempl_cuves ON inst_reservoir_gc.moderemplissage = lex_mode_rempl_cuves.code AND lex_mode_rempl_cuves.champ::text = 'INSTALLATIONS.MODEREMPLISSAGE'::text
             LEFT JOIN inst_equipements_detail equip_turbidimetre ON aep_installations.codeinstallation = equip_turbidimetre.codeinstallation AND equip_turbidimetre.codeequipement = 0
             LEFT JOIN inst_equipements_detail equip_chlore ON aep_installations.codeinstallation = equip_chlore.codeinstallation AND equip_chlore.codeequipement = 1
             LEFT JOIN inst_equipements_detail equip_fontaine ON aep_installations.codeinstallation = equip_fontaine.codeinstallation AND equip_fontaine.codeequipement = 3
             LEFT JOIN inst_securite_personnel equip_colonne_seche ON aep_installations.codeinstallation = equip_colonne_seche.codeinstallation AND equip_colonne_seche.codeprotection = 4
             LEFT JOIN inst_reservoir_equipements ON aep_installations.codeinstallation = inst_reservoir_equipements.codeinstallation
             LEFT JOIN codes_sandre lex_detection_niveau ON inst_reservoir_equipements.typedetectionniveau = lex_detection_niveau.code AND lex_detection_niveau.champ::text = 'INSTALLATIONS.TYPEDETECTION'::text
             LEFT JOIN codes_sandre lex_mesure_debit ON inst_reservoir_equipements.mesuredebitmetrique = lex_mesure_debit.code AND lex_mesure_debit.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
             LEFT JOIN inst_equipements_detail equip_bypass ON aep_installations.codeinstallation = equip_bypass.codeinstallation AND equip_bypass.codeequipement = 4
             LEFT JOIN inst_equipements_detail equip_robinetflotteur ON aep_installations.codeinstallation = equip_robinetflotteur.codeinstallation AND equip_robinetflotteur.codeequipement = 5
          WHERE aep_installations.typeinstallation = 12;;

         CREATE OR REPLACE VIEW public.lex_precision_xy
        AS SELECT codes_sandre.code,
            codes_sandre.libelle,
            codes_sandre.libelle AS mnemo,
            codes_sandre.commentaire AS definition
           FROM codes_sandre
          WHERE codes_sandre.champ::text = 'SYSTEME_ALTIMETRIQUE.MODEOBTENTION'::text;;

         CREATE OR REPLACE VIEW public.lex_type_validite
        AS SELECT codes_sandre.code,
            codes_sandre.libelle,
            codes_sandre.libelle AS mnemo,
            codes_sandre.commentaire AS definition
           FROM codes_sandre
          WHERE codes_sandre.champ::text = 'TYPE_VALIDITE'::text;;

         CREATE OR REPLACE VIEW public.v_eau17sig_captages
        AS SELECT aep_installations.identifiant,
            lex_type.libelle,
            aquiferes.libelle AS nappe,
            lex_gisement.libelle AS modegisement,
            aep_installations.datefin AS datedesaffectation,
            lex_etat.libelle AS fonctionnement,
            forages_gc.profondeurforage,
            forages_gc.diametreinternetubage,
            forages_gc.epaisseurtubage,
            lex_tubage.libelle AS naturetubage,
            forages_gc.profondeurtubage,
            forages_gc.ouvragecrepine,
            inst_forages.profpompe,
            forages_gc.cotebride,
            forages_gc.coterepere,
            forages_gc.margelleprotection,
            forages_gc.capotage,
            forages_gc.teteetanche,
            forages_gc.derniereinspection,
            forages_equipements.debitnominal,
            forages_equipements.hmt,
            lex_typepompe.libelle AS typepompe,
            forages_equipements.diametreexterieurcolonneexhaure,
            lex_typecolonneexhaure.libelle AS typecolonneexhaure,
            lex_naturecolonneexhaure.libelle AS naturecolonneexhaure,
            lex_typedetectionniveau.libelle AS typedetectionniveau,
            forages_gc.profondeursonde,
                CASE
                    WHEN equip_ventouse.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS ventouse,
                CASE
                    WHEN equip_mesuredebit.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS mesuredebimetrique,
                CASE
                    WHEN equip_clapet.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS clapetantiretour,
                CASE
                    WHEN equip_antiintrusion.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presenceantiintrusion,
            systemesecurite.nbsystemes,
            inst_electricite_com.hastelegestion,
            aep_installations.loginmaj,
            aep_installations.datemaj
           FROM aep_installations
             LEFT JOIN inst_forages ON aep_installations.codeinstallation = inst_forages.codeinstallation
             LEFT JOIN forages_gc ON aep_installations.codeinstallation = forages_gc.codeinstallation
             LEFT JOIN forages_equipements ON aep_installations.codeinstallation = forages_equipements.codeinstallation
             LEFT JOIN inst_equipements_detail equip_ventouse ON aep_installations.codeinstallation = equip_ventouse.codeinstallation AND (equip_ventouse.codeequipement = 0 OR equip_ventouse.codeequipement IS NULL)
             LEFT JOIN inst_equipements_detail equip_mesuredebit ON aep_installations.codeinstallation = equip_mesuredebit.codeinstallation AND (equip_mesuredebit.codeequipement = 1 OR equip_mesuredebit.codeequipement IS NULL)
             LEFT JOIN inst_equipements_detail equip_clapet ON aep_installations.codeinstallation = equip_clapet.codeinstallation AND (equip_clapet.codeequipement = 2 OR equip_clapet.codeequipement IS NULL)
             LEFT JOIN codes_sandre lex_gisement ON inst_forages.modegisement = lex_gisement.code AND lex_gisement.champ::text = 'PIEZOMETRES.MODEGISEMENT'::text
             LEFT JOIN codes_sandre lex_etat ON aep_installations.statut = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
             LEFT JOIN codes_sandre lex_tubage ON forages_gc.naturetubage = lex_tubage.code AND lex_tubage.champ::text = 'INSTALLATIONS.NATUREEQUIPEMENT'::text
             LEFT JOIN lien_forages_aquifere ON aep_installations.codeinstallation = lien_forages_aquifere.codeinstallation AND (lien_forages_aquifere.numeroordre = 0 OR lien_forages_aquifere.numeroordre IS NULL)
             LEFT JOIN aquiferes ON lien_forages_aquifere.codeaquifere::double precision = aquiferes.codeaquifere
             LEFT JOIN codes_sandre lex_type ON inst_forages.codenature = lex_type.code AND lex_type.champ::text = 'PIEZOMETRES.CODENATURE'::text
             LEFT JOIN codes_sandre lex_typepompe ON forages_equipements.typepompe = lex_typepompe.code AND lex_typepompe.champ::text = 'INSTALLATIONS.TYPEPOMPE'::text
             LEFT JOIN codes_sandre lex_typecolonneexhaure ON forages_equipements.typecolonneexhaure = lex_typecolonneexhaure.code AND lex_typecolonneexhaure.champ::text = 'INSTALLATIONS.TYPECOLONNEEXHAURE'::text
             LEFT JOIN codes_sandre lex_naturecolonneexhaure ON forages_equipements.naturecolonneexhaure = lex_typecolonneexhaure.code AND lex_typecolonneexhaure.champ::text = 'INSTALLATIONS.NATURECOLONNEEXHAURE'::text
             LEFT JOIN codes_sandre lex_typedetectionniveau ON forages_equipements.typedetectionniveau = lex_typedetectionniveau.code AND lex_typedetectionniveau.champ::text = 'INSTALLATIONS.TYPEDETECTION'::text
             LEFT JOIN ( SELECT inst_securite.codeinstallation,
                    count(*) AS nbsystemes
                   FROM inst_securite
                  GROUP BY inst_securite.codeinstallation) systemesecurite ON aep_installations.codeinstallation = systemesecurite.codeinstallation
             LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
             LEFT JOIN inst_equipements_detail equip_antiintrusion ON aep_installations.codeinstallation = equip_antiintrusion.codeinstallation AND equip_antiintrusion.codeequipement = 39
          WHERE aep_installations.typeinstallation = 0 AND aep_installations.jobexecutionid IS NULL;;


         CREATE OR REPLACE VIEW public.v_eau17sig_poste_relevage
        AS SELECT aep_installations.identifiant,
            lex_etat.libelle AS fonctionnement,
            lex_natures_cuves.libelle AS naturecuves,
            inst_poste_relevage_gc.revetementantiacide,
            inst_poste_relevage_gc.cotealtidessusposte,
            inst_poste_relevage_gc.coteentreefileau,
            inst_poste_relevage_gc.cotefondcuve,
            inst_poste_relevage_gc.profondeur,
            inst_poste_relevage_gc.tropplein,
            inst_poste_relevage_gc.cotetropplein,
            inst_poste_relevage_gc.bassintampon,
            inst_poste_relevage_equipements.nbpompes,
            inst_poste_relevage_equipements.debitnominal,
            inst_poste_relevage_equipements.hmt,
                CASE
                    WHEN equip_brassage.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS dispositifbrassage,
                CASE
                    WHEN equip_antibelier.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS antibelier,
                CASE
                    WHEN equip_traitementh2s.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS traitementh2s,
                CASE
                    WHEN equip_mesuredebimetrique.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS mesuredebimetrique,
                CASE
                    WHEN equip_desodorisation.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS desodorisation,
                CASE
                    WHEN equip_ventousechambrevannes.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS ventousechambrevannes,
                CASE
                    WHEN equip_vanneisolement.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS vanneisolement,
                CASE
                    WHEN equip_branchementaep.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS branchementaep,
                CASE
                    WHEN equip_groupe_electrogene.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS groupeelectrogene,
                CASE
                    WHEN equip_barreantichute.codeprotection IS NOT NULL THEN true
                    ELSE false
                END AS barreantichute,
            inst_electricite_com.hastelegestion,
                CASE
                    WHEN inst_electricite_com.dispositifsecours IS NOT NULL THEN true
                    ELSE false
                END AS inverseursource,
            aep_installations.loginmaj,
            aep_installations.datemaj
           FROM aep_installations
             LEFT JOIN inst_poste_relevage_gc ON aep_installations.codeinstallation = inst_poste_relevage_gc.codeinstallation
             LEFT JOIN inst_poste_relevage_equipements ON aep_installations.codeinstallation = inst_poste_relevage_equipements.codeinstallation
             LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
             LEFT JOIN inst_securite_personnel equip_barreantichute ON aep_installations.codeinstallation = equip_barreantichute.codeinstallation AND equip_barreantichute.codeprotection = 2
             LEFT JOIN codes_sandre lex_natures_cuves ON inst_poste_relevage_gc.naturecuve = lex_natures_cuves.code AND lex_natures_cuves.champ::text = 'CUVES.MATERIAU'::text
             LEFT JOIN codes_sandre lex_etat ON aep_installations.statut = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
             LEFT JOIN inst_equipements_detail equip_brassage ON aep_installations.codeinstallation = equip_brassage.codeinstallation AND equip_brassage.codeequipement = 0
             LEFT JOIN inst_equipements_detail equip_antibelier ON aep_installations.codeinstallation = equip_antibelier.codeinstallation AND equip_antibelier.codeequipement = 1
             LEFT JOIN inst_equipements_detail equip_traitementh2s ON aep_installations.codeinstallation = equip_traitementh2s.codeinstallation AND equip_traitementh2s.codeequipement = 2
             LEFT JOIN inst_equipements_detail equip_mesuredebimetrique ON aep_installations.codeinstallation = equip_mesuredebimetrique.codeinstallation AND equip_mesuredebimetrique.codeequipement = 3
             LEFT JOIN inst_equipements_detail equip_desodorisation ON aep_installations.codeinstallation = equip_desodorisation.codeinstallation AND equip_desodorisation.codeequipement = 4
             LEFT JOIN inst_equipements_detail equip_ventousechambrevannes ON aep_installations.codeinstallation = equip_ventousechambrevannes.codeinstallation AND equip_ventousechambrevannes.codeequipement = 5
             LEFT JOIN inst_equipements_detail equip_vanneisolement ON aep_installations.codeinstallation = equip_vanneisolement.codeinstallation AND equip_vanneisolement.codeequipement = 6
             LEFT JOIN inst_equipements_detail equip_branchementaep ON aep_installations.codeinstallation = equip_branchementaep.codeinstallation AND equip_branchementaep.codeequipement = 7
             LEFT JOIN inst_equipements_detail equip_groupe_electrogene ON aep_installations.codeinstallation = equip_groupe_electrogene.codeinstallation AND equip_groupe_electrogene.codeequipement = 76
          WHERE aep_installations.typeinstallation = 9;;

         CREATE OR REPLACE VIEW public.v_eau17sig_stations_pompages
        AS SELECT aep_installations.identifiant,
            inst_st_pompage_aep.capacitenominale,
            inst_st_pompage_aep.capacitehoraire,
            lex_etat.libelle AS fonctionnement,
            inst_st_pompage_aep.batiment,
                CASE
                    WHEN groupe1.nomgroupe IS NULL THEN 0
                    ELSE 1
                END +
                CASE
                    WHEN groupe2.nomgroupe IS NULL THEN 0
                    ELSE 1
                END +
                CASE
                    WHEN groupe3.nomgroupe IS NULL THEN 0
                    ELSE 1
                END AS nbgroupes,
            groupe1.nomgroupe AS nomgroupe1,
            groupe1.debitnominal AS debitnominal1,
            groupe1.hmt AS hmt1,
            groupe1.nbpompes AS nbpompes1,
            groupe2.nomgroupe AS nomgroupe2,
            groupe2.debitnominal AS debitnominal2,
            groupe2.hmt AS hmt2,
            groupe2.nbpompes AS nbpompes2,
            groupe3.nomgroupe AS nomgroupe3,
            groupe3.debitnominal AS debitnominal3,
            groupe3.hmt AS hmt3,
            groupe3.nbpompes AS nbpompes3,
                CASE
                    WHEN equip_turbidimetre.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presenceturbidimetre,
                CASE
                    WHEN equip_chlore.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presencanalyseurchlore,
                CASE
                    WHEN equip_groupe_electrogene.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presencegroupeelectrogene,
                CASE
                    WHEN equip_antiintrusion.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS presenceantiintrusion,
            inst_electricite_com.hastelegestion,
            inst_electricite_com.transformateur,
            inst_electricite_com.demarreur,
            inst_electricite_com.variateur,
            lex_mesure_debit.libelle AS typemesuredebitmetrique,
            aep_installations.loginmaj,
            aep_installations.datemaj
           FROM aep_installations
             LEFT JOIN inst_st_pompage_aep ON aep_installations.codeinstallation = inst_st_pompage_aep.codeinstallation
             LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
             LEFT JOIN inst_equipements_electro groupe1 ON aep_installations.codeinstallation = groupe1.codeinstallation AND (groupe1.numgroupe = 1 OR groupe1.numgroupe IS NULL)
             LEFT JOIN inst_equipements_electro groupe2 ON aep_installations.codeinstallation = groupe2.codeinstallation AND (groupe2.numgroupe = 1 OR groupe2.numgroupe IS NULL)
             LEFT JOIN inst_equipements_electro groupe3 ON aep_installations.codeinstallation = groupe3.codeinstallation AND (groupe3.numgroupe = 1 OR groupe3.numgroupe IS NULL)
             LEFT JOIN codes_sandre lex_etat ON aep_installations.statut = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
             LEFT JOIN inst_equipements_detail equip_turbidimetre ON aep_installations.codeinstallation = equip_turbidimetre.codeinstallation AND equip_turbidimetre.codeequipement = 0
             LEFT JOIN inst_equipements_detail equip_chlore ON aep_installations.codeinstallation = equip_chlore.codeinstallation AND equip_chlore.codeequipement = 1
             LEFT JOIN inst_equipements_detail equip_groupe_electrogene ON aep_installations.codeinstallation = equip_groupe_electrogene.codeinstallation AND equip_groupe_electrogene.codeequipement = 76
             LEFT JOIN inst_equipements_detail equip_antiintrusion ON aep_installations.codeinstallation = equip_antiintrusion.codeinstallation AND equip_antiintrusion.codeequipement = 39
             LEFT JOIN inst_st_pompage_aep_equipements_divers ON aep_installations.codeinstallation = inst_st_pompage_aep_equipements_divers.codeinstallation
             LEFT JOIN codes_sandre lex_mesure_debit ON inst_st_pompage_aep_equipements_divers.mesuredebitmetrique = lex_mesure_debit.code AND lex_mesure_debit.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
          WHERE aep_installations.typeinstallation = 10;;

         CREATE OR REPLACE VIEW public.v_eau17sig_step
        WITH(security_barrier=false)
        AS SELECT aep_installations.identifiant,
            inst_step.capacitetraitement,
            lex_filieretraitementboues.libelle AS filieretraitementboues,
            lex_filieretraitementeauxusees.libelle AS filieretraitementeauxusees,
            lex_filiereeliminationboues.libelle AS filiereeliminationboues,
            inst_step.lagunefinition,
            lex_typerejet.libelle AS typerejet,
            inst_step.reutilisationeauusee,
            inst_step.unitecurage,
            inst_step.unitegraisse,
            inst_step.unitevidange,
            inst_step.datearrete,
            aep_installations.datemiseenservice AS datemiseenroute,
            lex_etat.libelle AS fonctionnement,
            inst_step_gc.presencebassintampon,
            inst_step_gc.volumebassintampon,
                CASE
                    WHEN installations_batiments.nbbatiments = 0 THEN false
                    WHEN installations_batiments.nbbatiments IS NULL THEN false
                    ELSE true
                END AS batiment,
            installations_batiments.surfaces,
            lex_mesureentree.libelle AS dispositifmesureentree,
            lex_mesuresortie.libelle AS dispositifmesuresortie,
                CASE
                    WHEN lex_bypass.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS bypassentree,
                CASE
                    WHEN lex_piezo.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS piezometre,
            inst_electricite_com.hastelegestion,
            inst_electricite_com.hassupervision,
            inst_electricite_com.transformateur = ANY (ARRAY['2'::bigint, '3'::bigint, '4'::bigint]) AS transformateur,
                CASE
                    WHEN equip_groupe_electrogene.codeequipement IS NOT NULL THEN true
                    ELSE false
                END AS groupelectrogene,
            inst_electricite_com.installationarmoire AS inverseursource,
            aep_installations.loginmaj,
            aep_installations.datemaj
           FROM aep_installations
             LEFT JOIN inst_step ON aep_installations.codeinstallation = inst_step.codeinstallation
             LEFT JOIN inst_step_gc ON aep_installations.codeinstallation = inst_step_gc.codeinstallation
             LEFT JOIN codes_sandre lex_filieretraitementboues ON inst_step.filieretraitementboues = lex_filieretraitementboues.code AND lex_filieretraitementboues.champ::text = 'INSTALLATIONS.FILIERETRAITEMENTEBOUES'::text
             LEFT JOIN codes_sandre lex_filieretraitementeauxusees ON inst_step.filieretraitementeauxusees = lex_filieretraitementeauxusees.code AND lex_filieretraitementeauxusees.champ::text = 'INSTALLATIONS.FILIERETRAITEMENTEAUXUSEES'::text
             LEFT JOIN codes_sandre lex_typerejet ON inst_step.typerejet = lex_typerejet.code AND lex_typerejet.champ::text = 'INSTALLATIONS.TYPEREJET'::text
             LEFT JOIN codes_sandre lex_filiereeliminationboues ON inst_step.filiereeliminationboues = lex_filiereeliminationboues.code AND lex_filiereeliminationboues.champ::text = 'INSTALLATIONS.FILIEREELIMINATIONBOUES'::text
             LEFT JOIN codes_sandre lex_etat ON aep_installations.codeetat = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
             LEFT JOIN ( SELECT inst_batiments.codeinstallation,
                    count(*) AS nbbatiments,
                    sum(inst_batiments.surfacebatiment) AS surfaces
                   FROM inst_batiments
                  WHERE inst_batiments.typebatiment = 4
                  GROUP BY inst_batiments.codeinstallation) installations_batiments ON aep_installations.codeinstallation = installations_batiments.codeinstallation
             LEFT JOIN inst_step_equipements ON aep_installations.codeinstallation = inst_step_equipements.codeinstallation
             LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
             LEFT JOIN codes_sandre lex_mesureentree ON inst_step_equipements.mesurevolumeentree = lex_mesureentree.code AND lex_mesureentree.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
             LEFT JOIN codes_sandre lex_mesuresortie ON inst_step_equipements.mesurevolumesortie = lex_mesuresortie.code AND lex_mesuresortie.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
             LEFT JOIN inst_equipements_detail lex_bypass ON aep_installations.codeinstallation = lex_bypass.codeinstallation AND lex_bypass.codeequipement = 0
             LEFT JOIN inst_equipements_detail lex_piezo ON aep_installations.codeinstallation = lex_piezo.codeinstallation AND lex_piezo.codeequipement = 1
             LEFT JOIN inst_equipements_detail equip_groupe_electrogene ON aep_installations.codeinstallation = lex_bypass.codeinstallation AND lex_bypass.codeequipement = 0
          WHERE aep_installations.typeinstallation = 2;;


        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1410',1,'Propre','Propre', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Propre' , commentaire = 'Propre', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1410',2,'Sale','Sale', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sale' , commentaire = 'Sale', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1411',0,'Inconnue ou non réalisé','Inconnue ou non réalisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue ou non réalisé' , commentaire = 'Inconnue ou non réalisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1411',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1411',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1412',0,'Inconnue ou non réalisé','Inconnue ou non réalisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue ou non réalisé' , commentaire = 'Inconnue ou non réalisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1412',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1412',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1413',0,'Inconnue ou non réalisé','Inconnue ou non réalisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue ou non réalisé' , commentaire = 'Inconnue ou non réalisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1413',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1413',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1415',1,'Absent ','Absent ', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absent ' , commentaire = 'Absent ', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1415',2,'Faible','Faible', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Faible' , commentaire = 'Faible', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1415',3,'Importante','Importante', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Importante' , commentaire = 'Importante', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1416',0,'Inconnue ou non réalisé','Inconnue ou non réalisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue ou non réalisé' , commentaire = 'Inconnue ou non réalisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1416',1,'Sans','Sans', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sans' , commentaire = 'Sans', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1416',2,'Légère','Légère', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Légère' , commentaire = 'Légère', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1416',3,'Forte','Forte', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Forte' , commentaire = 'Forte', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1422',0,'Inconnue ou non réalisé','Inconnue ou non réalisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue ou non réalisé' , commentaire = 'Inconnue ou non réalisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1422',1,'Limpide','Limpide', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Limpide' , commentaire = 'Limpide', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1422',2,'Légèrement trouble','Légèrement trouble', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Légèrement trouble' , commentaire = 'Légèrement trouble', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1422',3,'Trouble','Trouble', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Trouble' , commentaire = 'Trouble', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1423',0,'Inconnue ou non réalisé','Inconnue ou non réalisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue ou non réalisé' , commentaire = 'Inconnue ou non réalisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1423',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1423',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1424',0,'Inconnue ou non réalisé','Inconnue ou non réalisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue ou non réalisé' , commentaire = 'Inconnue ou non réalisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1424',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1424',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',1,'Ensoleillé','Ensoleillé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Ensoleillé' , commentaire = 'Ensoleillé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',2,'Faiblement nuageux','Faiblement nuageux', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Faiblement nuageux' , commentaire = 'Faiblement nuageux', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',3,'Temps humide','Temps humide', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Temps humide' , commentaire = 'Temps humide', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',4,'Pluie fine','Pluie fine', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Pluie fine' , commentaire = 'Pluie fine', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',5,'Orage - Pluie forte','Orage - Pluie forte', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Orage - Pluie forte' , commentaire = 'Orage - Pluie forte', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',6,'Neige','Neige', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Neige' , commentaire = 'Neige', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',7,'Gel','Gel', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Gel' , commentaire = 'Gel', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',8,'Fortement nuageux','Fortement nuageux', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Fortement nuageux' , commentaire = 'Fortement nuageux', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',9,'Conditions crépusculaires','Conditions crépusculaires', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Conditions crépusculaires' , commentaire = 'Conditions crépusculaires', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1425',10,'Temps sec','Temps sec', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Temps sec' , commentaire = 'Temps sec', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1426',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1426',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1427',1,'Rivière couverte (>90% d''ombrage)','Rivière couverte (>90% d''ombrage)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Rivière couverte (>90% d''ombrage)' , commentaire = 'Rivière couverte (>90% d''ombrage)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1427',2,'Rivière assez couverte (50-90% d''ombarge)','Rivière assez couverte (50-90% d''ombarge)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Rivière assez couverte (50-90% d''ombarge)' , commentaire = 'Rivière assez couverte (50-90% d''ombarge)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1427',3,'Rivière assez dégagée (10-50% d''ombrage)','Rivière assez dégagée (10-50% d''ombrage)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Rivière assez dégagée (10-50% d''ombrage)' , commentaire = 'Rivière assez dégagée (10-50% d''ombrage)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1427',4,'Rivière dégagée (<10% d''ombrage)','Rivière dégagée (<10% d''ombrage)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Rivière dégagée (<10% d''ombrage)' , commentaire = 'Rivière dégagée (<10% d''ombrage)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1428',0,'Inconnue ou non réalisé','Inconnue ou non réalisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue ou non réalisé' , commentaire = 'Inconnue ou non réalisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1428',1,'Incolore','Incolore', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Incolore' , commentaire = 'Incolore', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1428',2,'Légèrement coloré','Légèrement coloré', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Légèrement coloré' , commentaire = 'Légèrement coloré', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1428',3,'Très coloré','Très coloré', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Très coloré' , commentaire = 'Très coloré', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1724',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1724',1,'Stable','Stable', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Stable' , commentaire = 'Stable', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1724',2,'En augmentation','En augmentation', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='En augmentation' , commentaire = 'En augmentation', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1724',3,'En diminution','En diminution', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='En diminution' , commentaire = 'En diminution', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1724',4,'Irrégulier','Irrégulier', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Irrégulier' , commentaire = 'Irrégulier', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1725',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1725',1,'Etiage','Etiage', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Etiage' , commentaire = 'Etiage', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1725',2,'Moyennes eaux','Moyennes eaux', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Moyennes eaux' , commentaire = 'Moyennes eaux', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1725',3,'Hautes eaux','Hautes eaux', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Hautes eaux' , commentaire = 'Hautes eaux', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1725',1.1,'Etiage sévère','Etiage sévère', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Etiage sévère' , commentaire = 'Etiage sévère', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1725',1.2,'Etiage normal','Etiage normal', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Etiage normal' , commentaire = 'Etiage normal', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1726',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1726',1,'Pas d''eau','Pas d''eau', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Pas d''eau' , commentaire = 'Pas d''eau', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1726',2,'Trous d''eau, flaques','Trous d''eau, flaques', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Trous d''eau, flaques' , commentaire = 'Trous d''eau, flaques', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1726',3,'Basses eaux','Basses eaux', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Basses eaux' , commentaire = 'Basses eaux', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1726',4,'Moyennes eaux','Moyennes eaux', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Moyennes eaux' , commentaire = 'Moyennes eaux', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1726',5,'Lit plein ou presque','Lit plein ou presque', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lit plein ou presque' , commentaire = 'Lit plein ou presque', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1726',6,'Crue débordante','Crue débordante', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Crue débordante' , commentaire = 'Crue débordante', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',1,'Incolore','Incolore', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Incolore' , commentaire = 'Incolore', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',2,'Bleu','Bleu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Bleu' , commentaire = 'Bleu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',3,'Bleu-vert','Bleu-vert', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Bleu-vert' , commentaire = 'Bleu-vert', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',4,'Vert','Vert', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Vert' , commentaire = 'Vert', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',5,'Vert-jaune','Vert-jaune', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Vert-jaune' , commentaire = 'Vert-jaune', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',6,'Jaune','Jaune', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Jaune' , commentaire = 'Jaune', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',7,'Jaune-marron','Jaune-marron', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Jaune-marron' , commentaire = 'Jaune-marron', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',8,'Marron clair','Marron clair', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Marron clair' , commentaire = 'Marron clair', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',9,'Marron foncé','Marron foncé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Marron foncé' , commentaire = 'Marron foncé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',10,'Gris','Gris', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Gris' , commentaire = 'Gris', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',11,'Noir','Noir', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Noir' , commentaire = 'Noir', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1739',12,'Blanc','Blanc', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Blanc' , commentaire = 'Blanc', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1947',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1947',1,'Prélèvement effectué de la rive','Prélèvement effectué de la rive', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Prélèvement effectué de la rive' , commentaire = 'Prélèvement effectué de la rive', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1947',2,'Prélèvement effectué à pied dans le lit du cours d''eau','Prélèvement effectué à pied dans le lit du cours d''eau', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Prélèvement effectué à pied dans le lit du cours d''eau' , commentaire = 'Prélèvement effectué à pied dans le lit du cours d''eau', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1947',3,'Prélèvement effectué depuis un pont','Prélèvement effectué depuis un pont', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Prélèvement effectué depuis un pont' , commentaire = 'Prélèvement effectué depuis un pont', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1947',4,'Prélèvement effectué depuis une embarcation','Prélèvement effectué depuis une embarcation', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Prélèvement effectué depuis une embarcation' , commentaire = 'Prélèvement effectué depuis une embarcation', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1948',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1948',1,'en amont d''un seuil','en amont d''un seuil', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='en amont d''un seuil' , commentaire = 'en amont d''un seuil', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1948',2,'en aval d''un seuil','en aval d''un seuil', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='en aval d''un seuil' , commentaire = 'en aval d''un seuil', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1948',3,'absence de seuil','absence de seuil', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='absence de seuil' , commentaire = 'absence de seuil', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1948',4,'prélèvements situé entre deux seuils','prélèvements situé entre deux seuils', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prélèvements situé entre deux seuils' , commentaire = 'prélèvements situé entre deux seuils', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1948',5,'Prélèvement sur un seuil','Prélèvement sur un seuil', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Prélèvement sur un seuil' , commentaire = 'Prélèvement sur un seuil', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1948',6,'Un seuil à l''intérieur du point de prélèvement','Un seuil à l''intérieur du point de prélèvement', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Un seuil à l''intérieur du point de prélèvement' , commentaire = 'Un seuil à l''intérieur du point de prélèvement', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.1948',7,'Plusieurs seuils à l''intérieur du point de prélèvement','Plusieurs seuils à l''intérieur du point de prélèvement', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Plusieurs seuils à l''intérieur du point de prélèvement' , commentaire = 'Plusieurs seuils à l''intérieur du point de prélèvement', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2526',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2526',1,'Amont','Amont', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Amont' , commentaire = 'Amont', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2526',2,'Aval','Aval', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Aval' , commentaire = 'Aval', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2730',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2730',1,'en amont d''un seuil','en amont d''un seuil', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='en amont d''un seuil' , commentaire = 'en amont d''un seuil', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2730',2,'en aval d''un seuil','en aval d''un seuil', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='en aval d''un seuil' , commentaire = 'en aval d''un seuil', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2730',3,'absence de seuil','absence de seuil', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='absence de seuil' , commentaire = 'absence de seuil', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2730',4,'prélèvements situé entre deux seuils','prélèvements situé entre deux seuils', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prélèvements situé entre deux seuils' , commentaire = 'prélèvements situé entre deux seuils', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2730',5,'Prélèvement sur un seuil','Prélèvement sur un seuil', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Prélèvement sur un seuil' , commentaire = 'Prélèvement sur un seuil', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2948',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2948',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.2948',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3207',1,'Présence','Présence', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Présence' , commentaire = 'Présence', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3207',2,'Absence','Absence', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absence' , commentaire = 'Absence', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3207',3,'Occasionnelle','Occasionnelle', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Occasionnelle' , commentaire = 'Occasionnelle', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3207',4,'Abondante','Abondante', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Abondante' , commentaire = 'Abondante', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3207',5,'Non renseigné','Non renseigné', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non renseigné' , commentaire = 'Non renseigné', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',1,'Argiles','Argiles', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Argiles' , commentaire = 'Argiles', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',2,'Limons','Limons', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Limons' , commentaire = 'Limons', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',3,'Sables fins','Sables fins', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sables fins' , commentaire = 'Sables fins', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',4,'Sables grossiers','Sables grossiers', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sables grossiers' , commentaire = 'Sables grossiers', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',5,'Graviers','Graviers', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Graviers' , commentaire = 'Graviers', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',6,'Cailloux fins','Cailloux fins', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Cailloux fins' , commentaire = 'Cailloux fins', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',7,'Cailloux grossiers','Cailloux grossiers', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Cailloux grossiers' , commentaire = 'Cailloux grossiers', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',8,'Pierres fines','Pierres fines', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Pierres fines' , commentaire = 'Pierres fines', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',9,'Pierres grossieres','Pierres grossieres', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Pierres grossieres' , commentaire = 'Pierres grossieres', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',10,'Blocs','Blocs', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Blocs' , commentaire = 'Blocs', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',11,'Rochers','Rochers', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Rochers' , commentaire = 'Rochers', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3388',12,'Dalles','Dalles', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dalles' , commentaire = 'Dalles', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3390',1,'Stable','Stable', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Stable' , commentaire = 'Stable', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3390',2,'Moyennement stable','Moyennement stable', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Moyennement stable' , commentaire = 'Moyennement stable', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.3390',3,'Instable','Instable', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Instable' , commentaire = 'Instable', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5254',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5254',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5254',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5442',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5442',1,'absence de gué','absence de gué', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='absence de gué' , commentaire = 'absence de gué', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5442',2,'prélèvement en amont d un gué','prélèvement en amont d un gué', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prélèvement en amont d un gué' , commentaire = 'prélèvement en amont d un gué', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5442',3,'prélèvement en aval d un gué','prélèvement en aval d un gué', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prélèvement en aval d un gué' , commentaire = 'prélèvement en aval d un gué', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5442',4,'prélèvement situé entre deux gués','prélèvement situé entre deux gués', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prélèvement situé entre deux gués' , commentaire = 'prélèvement situé entre deux gués', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5442',5,'prélèvement de part et d autre d un gué','prélèvement de part et d autre d un gué', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prélèvement de part et d autre d un gué' , commentaire = 'prélèvement de part et d autre d un gué', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5443',1,'Pas de colmatage','Pas de colmatage', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Pas de colmatage' , commentaire = 'Pas de colmatage', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5443',2,'Sables','Sables', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sables' , commentaire = 'Sables', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5443',3,'Vases','Vases', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Vases' , commentaire = 'Vases', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5443',4,'Sédiments fins','Sédiments fins', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sédiments fins' , commentaire = 'Sédiments fins', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5443',5,'Formations biologiques','Formations biologiques', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Formations biologiques' , commentaire = 'Formations biologiques', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5443',6,'Débris végétaux grossiers','Débris végétaux grossiers', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Débris végétaux grossiers' , commentaire = 'Débris végétaux grossiers', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5443',7,'Litières','Litières', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Litières' , commentaire = 'Litières', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5443',8,'Dépôts incrustants','Dépôts incrustants', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dépôts incrustants' , commentaire = 'Dépôts incrustants', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5444',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5444',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5444',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5445',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5445',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5446',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5446',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5447',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5447',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5448',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5448',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5448',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5449',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5449',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5449',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5450',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5450',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5451',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5451',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5451',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5453',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5453',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5453',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5454',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5454',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5454',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5455',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5455',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5455',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5456',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5456',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5456',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5457',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5457',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5457',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5458',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5458',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5458',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5459',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5459',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5459',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5460',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5460',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5460',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5461',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5461',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5461',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5462',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5462',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5462',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5463',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5463',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5463',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5464',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5464',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5464',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5466',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5466',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5466',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5467',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5467',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5467',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',1,'Feuillus (seuls ou majoritaires)','Feuillus (seuls ou majoritaires)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillus (seuls ou majoritaires)' , commentaire = 'Feuillus (seuls ou majoritaires)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',2,'Résineux (seuls ou majoritaires)','Résineux (seuls ou majoritaires)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux (seuls ou majoritaires)' , commentaire = 'Résineux (seuls ou majoritaires)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',3,'zone humide','zone humide', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='zone humide' , commentaire = 'zone humide', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',4,'friche (autre que zone humide)','friche (autre que zone humide)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='friche (autre que zone humide)' , commentaire = 'friche (autre que zone humide)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',5,'prairie','prairie', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prairie' , commentaire = 'prairie', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',6,'culture','culture', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='culture' , commentaire = 'culture', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',7,'espace vert, jardin','espace vert, jardin', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='espace vert, jardin' , commentaire = 'espace vert, jardin', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',8,'canal','canal', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='canal' , commentaire = 'canal', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',9,'gravière, plan d eau','gravière, plan d eau', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='gravière, plan d eau' , commentaire = 'gravière, plan d eau', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',10,'urbanisé, imperméabilisé','urbanisé, imperméabilisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='urbanisé, imperméabilisé' , commentaire = 'urbanisé, imperméabilisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5468',11,'autre','autre', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='autre' , commentaire = 'autre', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',1,'Feuillus (seuls ou majoritaires)','Feuillus (seuls ou majoritaires)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillus (seuls ou majoritaires)' , commentaire = 'Feuillus (seuls ou majoritaires)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',2,'Résineux (seuls ou majoritaires)','Résineux (seuls ou majoritaires)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux (seuls ou majoritaires)' , commentaire = 'Résineux (seuls ou majoritaires)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',3,'zone humide','zone humide', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='zone humide' , commentaire = 'zone humide', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',4,'friche (autre que zone humide)','friche (autre que zone humide)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='friche (autre que zone humide)' , commentaire = 'friche (autre que zone humide)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',5,'prairie','prairie', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prairie' , commentaire = 'prairie', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',6,'culture','culture', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='culture' , commentaire = 'culture', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',7,'espace vert, jardin','espace vert, jardin', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='espace vert, jardin' , commentaire = 'espace vert, jardin', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',8,'canal','canal', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='canal' , commentaire = 'canal', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',9,'gravière, plan d eau','gravière, plan d eau', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='gravière, plan d eau' , commentaire = 'gravière, plan d eau', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',10,'urbanisé, imperméabilisé','urbanisé, imperméabilisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='urbanisé, imperméabilisé' , commentaire = 'urbanisé, imperméabilisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5469',11,'autre','autre', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='autre' , commentaire = 'autre', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5470',0,'inconnue','inconnue', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='inconnue' , commentaire = 'inconnue', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5470',1,'naturelle','naturelle', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='naturelle' , commentaire = 'naturelle', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5470',2,'enrochement','enrochement', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='enrochement' , commentaire = 'enrochement', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5470',3,'artificielle fermée (pierres maçonnées, béton, palplanche, planche)','artificielle fermée (pierres maçonnées, béton, palplanche, planche)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='artificielle fermée (pierres maçonnées, béton, palplanche, planche)' , commentaire = 'artificielle fermée (pierres maçonnées, béton, palplanche, planche)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5472',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5472',1,'absence de rejet','absence de rejet', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='absence de rejet' , commentaire = 'absence de rejet', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5472',2,'prélèvement en amont d un rejet','prélèvement en amont d un rejet', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prélèvement en amont d un rejet' , commentaire = 'prélèvement en amont d un rejet', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5472',3,'prélèvement en aval d un rejet','prélèvement en aval d un rejet', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prélèvement en aval d un rejet' , commentaire = 'prélèvement en aval d un rejet', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5472',4,'prélèvement situé entre deux rejets','prélèvement situé entre deux rejets', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='prélèvement situé entre deux rejets' , commentaire = 'prélèvement situé entre deux rejets', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5472',5,'rejet(s) au sein du site de prélèvement','rejet(s) au sein du site de prélèvement', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='rejet(s) au sein du site de prélèvement' , commentaire = 'rejet(s) au sein du site de prélèvement', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5473',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5473',1,'Bonne visibilité : substrats identifiables sans erreur','Bonne visibilité : substrats identifiables sans erreur', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Bonne visibilité : substrats identifiables sans erreur' , commentaire = 'Bonne visibilité : substrats identifiables sans erreur', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5473',2,'Visibilité moyenne : doute sur l''identification de certains substrats ou visibilité réduite','Visibilité moyenne : doute sur l''identification de certains substrats ou visibilité réduite', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Visibilité moyenne : doute sur l''identification de certains substrats ou visibilité réduite' , commentaire = 'Visibilité moyenne : doute sur l''identification de certains substrats ou visibilité réduite', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5473',3,'Visibilité faible:fonds justes discernables ou visibles sur une faible part de la zone concernée','Visibilité faible:fonds justes discernables ou visibles sur une faible part de la zone concernée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Visibilité faible:fonds justes discernables ou visibles sur une faible part de la zone concernée' , commentaire = 'Visibilité faible:fonds justes discernables ou visibles sur une faible part de la zone concernée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5473',4,'Fonds non visibles','Fonds non visibles', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Fonds non visibles' , commentaire = 'Fonds non visibles', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5899',0,'Inconnue','Inconnue', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue' , commentaire = 'Inconnue', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5899',1,'Absente','Absente', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absente' , commentaire = 'Absente', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5899',2,'Dense','Dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dense' , commentaire = 'Dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5899',3,'Modérée','Modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Modérée' , commentaire = 'Modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5899',4,'Lâche','Lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lâche' , commentaire = 'Lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5899',5,'Dense perchée','Dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dense perchée' , commentaire = 'Dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5899',6,'Modérée perchée','Modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Modérée perchée' , commentaire = 'Modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5899',7,'Lâche perchée','Lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lâche perchée' , commentaire = 'Lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5903',0,'Pas de branchement public plomb','Pas de branchement public plomb', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Pas de branchement public plomb' , commentaire = 'Pas de branchement public plomb', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5903',1,'Branchement public en plomb','Branchement public en plomb', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Branchement public en plomb' , commentaire = 'Branchement public en plomb', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5903',2,'Ne sait pas','Ne sait pas', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Ne sait pas' , commentaire = 'Ne sait pas', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5904',0,'Pas de canalisation intérieure en plomb','Pas de canalisation intérieure en plomb', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Pas de canalisation intérieure en plomb' , commentaire = 'Pas de canalisation intérieure en plomb', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5904',1,'Canalisation intérieure en plomb','Canalisation intérieure en plomb', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Canalisation intérieure en plomb' , commentaire = 'Canalisation intérieure en plomb', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5904',2,'Ne sait pas','Ne sait pas', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Ne sait pas' , commentaire = 'Ne sait pas', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5905',0,'Pas de dispositif intérieur de traitement de l’eau','Pas de dispositif intérieur de traitement de l’eau', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Pas de dispositif intérieur de traitement de l’eau' , commentaire = 'Pas de dispositif intérieur de traitement de l’eau', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5905',1,'Dispositif intérieur de traitement de l’eau','Dispositif intérieur de traitement de l’eau', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dispositif intérieur de traitement de l’eau' , commentaire = 'Dispositif intérieur de traitement de l’eau', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5905',2,'Ne sait pas','Ne sait pas', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Ne sait pas' , commentaire = 'Ne sait pas', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5915',1,'Lisse','Lisse', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lisse' , commentaire = 'Lisse', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5915',2,'Faiblement agitée','Faiblement agitée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Faiblement agitée' , commentaire = 'Faiblement agitée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5915',3,'Agitée','Agitée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Agitée' , commentaire = 'Agitée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5915',4,'Très agitée','Très agitée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Très agitée' , commentaire = 'Très agitée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5916',0,'NON','NON', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='NON' , commentaire = 'NON', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.5916',1,'OUI','OUI', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='OUI' , commentaire = 'OUI', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6436',0,'Inconnue','Inconnue', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue' , commentaire = 'Inconnue', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6436',1,'Absente','Absente', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absente' , commentaire = 'Absente', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6436',2,'Dense','Dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dense' , commentaire = 'Dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6436',3,'Modérée','Modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Modérée' , commentaire = 'Modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6436',4,'Lâche','Lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lâche' , commentaire = 'Lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6436',5,'Dense perchée','Dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dense perchée' , commentaire = 'Dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6436',6,'Modérée perchée','Modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Modérée perchée' , commentaire = 'Modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6436',7,'Lâche perchée','Lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lâche perchée' , commentaire = 'Lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6437',0,'Inconnue','Inconnue', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue' , commentaire = 'Inconnue', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6437',1,'Absente','Absente', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absente' , commentaire = 'Absente', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6437',2,'Dense','Dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dense' , commentaire = 'Dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6437',3,'Modérée','Modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Modérée' , commentaire = 'Modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6437',4,'Lâche','Lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lâche' , commentaire = 'Lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6437',5,'Dense perchée','Dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dense perchée' , commentaire = 'Dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6437',6,'Modérée perchée','Modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Modérée perchée' , commentaire = 'Modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6437',7,'Lâche perchée','Lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lâche perchée' , commentaire = 'Lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',0,'Inconnue','Inconnue', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue' , commentaire = 'Inconnue', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',1,'Absente','Absente', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absente' , commentaire = 'Absente', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',2,'Feuillue dense','Feuillue dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue dense' , commentaire = 'Feuillue dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',3,'Feuillue lâche','Feuillue lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue lâche' , commentaire = 'Feuillue lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',4,'Feuillue modérée','Feuillue modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue modérée' , commentaire = 'Feuillue modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',5,'Feuillue dense perchée','Feuillue dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue dense perchée' , commentaire = 'Feuillue dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',6,'Feuillue modérée perchée','Feuillue modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue modérée perchée' , commentaire = 'Feuillue modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',7,'Feuillue lâche perchée','Feuillue lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue lâche perchée' , commentaire = 'Feuillue lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',8,'Résineux dense','Résineux dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux dense' , commentaire = 'Résineux dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',9,'Résineux modérée','Résineux modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux modérée' , commentaire = 'Résineux modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',10,'Résineux lâche','Résineux lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux lâche' , commentaire = 'Résineux lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',11,'Résineux dense perchée','Résineux dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux dense perchée' , commentaire = 'Résineux dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',12,'Résineux modérée perchée','Résineux modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux modérée perchée' , commentaire = 'Résineux modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',13,'Résineux lâche perchée','Résineux lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux lâche perchée' , commentaire = 'Résineux lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',14,'Mixte dense','Mixte dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte dense' , commentaire = 'Mixte dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',15,'Mixte modérée','Mixte modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte modérée' , commentaire = 'Mixte modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',16,'Mixte lâche','Mixte lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte lâche' , commentaire = 'Mixte lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',17,'Mixte dense perchée','Mixte dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte dense perchée' , commentaire = 'Mixte dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',18,'Mixte modérée perchée','Mixte modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte modérée perchée' , commentaire = 'Mixte modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6439',19,'Mixte lâche perchée','Mixte lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte lâche perchée' , commentaire = 'Mixte lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',0,'Calme','Calme', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Calme' , commentaire = 'Calme', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',1,'Très légère brise','Très légère brise', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Très légère brise' , commentaire = 'Très légère brise', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',2,'Légère brise','Légère brise', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Légère brise' , commentaire = 'Légère brise', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',3,'Petite brise','Petite brise', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Petite brise' , commentaire = 'Petite brise', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',4,'Jolie brise','Jolie brise', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Jolie brise' , commentaire = 'Jolie brise', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',5,'Bonne brise','Bonne brise', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Bonne brise' , commentaire = 'Bonne brise', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',6,'Vent frais','Vent frais', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Vent frais' , commentaire = 'Vent frais', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',7,'Grand frais','Grand frais', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Grand frais' , commentaire = 'Grand frais', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',8,'Coup de vent','Coup de vent', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Coup de vent' , commentaire = 'Coup de vent', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',9,'Fort coup de vent','Fort coup de vent', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Fort coup de vent' , commentaire = 'Fort coup de vent', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',10,'Tempête','Tempête', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Tempête' , commentaire = 'Tempête', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',11,'Violente tempête','Violente tempête', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Violente tempête' , commentaire = 'Violente tempête', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',12,'Ouragan','Ouragan', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Ouragan' , commentaire = 'Ouragan', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6447',13,'Non précisé','Non précisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non précisé' , commentaire = 'Non précisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6458',0,'Inconnue','Inconnue', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue' , commentaire = 'Inconnue', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6458',1,'Absente','Absente', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absente' , commentaire = 'Absente', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6458',2,'Dense','Dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dense' , commentaire = 'Dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6458',3,'Modérée','Modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Modérée' , commentaire = 'Modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6458',4,'Lâche','Lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lâche' , commentaire = 'Lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6458',5,'Dense perchée','Dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dense perchée' , commentaire = 'Dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6458',6,'Modérée perchée','Modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Modérée perchée' , commentaire = 'Modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6458',7,'Lâche perchée','Lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Lâche perchée' , commentaire = 'Lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',0,'Inconnue','Inconnue', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnue' , commentaire = 'Inconnue', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',1,'Absente','Absente', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absente' , commentaire = 'Absente', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',2,'Feuillue dense','Feuillue dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue dense' , commentaire = 'Feuillue dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',3,'Feuillue lâche','Feuillue lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue lâche' , commentaire = 'Feuillue lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',4,'Feuillue modérée','Feuillue modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue modérée' , commentaire = 'Feuillue modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',5,'Feuillue dense perchée','Feuillue dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue dense perchée' , commentaire = 'Feuillue dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',6,'Feuillue modérée perchée','Feuillue modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue modérée perchée' , commentaire = 'Feuillue modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',7,'Feuillue lâche perchée','Feuillue lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Feuillue lâche perchée' , commentaire = 'Feuillue lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',8,'Résineux dense','Résineux dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux dense' , commentaire = 'Résineux dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',9,'Résineux modérée','Résineux modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux modérée' , commentaire = 'Résineux modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',10,'Résineux lâche','Résineux lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux lâche' , commentaire = 'Résineux lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',11,'Résineux dense perchée','Résineux dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux dense perchée' , commentaire = 'Résineux dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',12,'Résineux modérée perchée','Résineux modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux modérée perchée' , commentaire = 'Résineux modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',13,'Résineux lâche perchée','Résineux lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Résineux lâche perchée' , commentaire = 'Résineux lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',14,'Mixte dense','Mixte dense', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte dense' , commentaire = 'Mixte dense', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',15,'Mixte modérée','Mixte modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte modérée' , commentaire = 'Mixte modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',16,'Mixte lâche','Mixte lâche', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte lâche' , commentaire = 'Mixte lâche', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',17,'Mixte dense perchée','Mixte dense perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte dense perchée' , commentaire = 'Mixte dense perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',18,'Mixte modérée perchée','Mixte modérée perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte modérée perchée' , commentaire = 'Mixte modérée perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6459',19,'Mixte lâche perchée','Mixte lâche perchée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mixte lâche perchée' , commentaire = 'Mixte lâche perchée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6493',1,'Marée montante','Marée montante', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Marée montante' , commentaire = 'Marée montante', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6493',2,'Marée descendante','Marée descendante', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Marée descendante' , commentaire = 'Marée descendante', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6493',3,'Marée étale','Marée étale', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Marée étale' , commentaire = 'Marée étale', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6493',4,'Marée basse','Marée basse', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Marée basse' , commentaire = 'Marée basse', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6493',5,'Marée haute','Marée haute', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Marée haute' , commentaire = 'Marée haute', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6493',6,'Pas de régime de marée','Pas de régime de marée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Pas de régime de marée' , commentaire = 'Pas de régime de marée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6493',7,'Non précisée','Non précisée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non précisée' , commentaire = 'Non précisée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6493',8,'Descendante puis montante','Descendante puis montante', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Descendante puis montante' , commentaire = 'Descendante puis montante', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6493',9,'Montante puis descendante','Montante puis descendante', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Montante puis descendante' , commentaire = 'Montante puis descendante', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6498',1,'Nulle','Nulle', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Nulle' , commentaire = 'Nulle', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6498',2,'Faible','Faible', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Faible' , commentaire = 'Faible', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6498',3,'Moyenne','Moyenne', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Moyenne' , commentaire = 'Moyenne', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6498',4,'Forte','Forte', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Forte' , commentaire = 'Forte', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6499',1,'Absent','Absent', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absent' , commentaire = 'Absent', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6499',2,'Peu abondant','Peu abondant', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Peu abondant' , commentaire = 'Peu abondant', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6499',3,'Abondant','Abondant', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Abondant' , commentaire = 'Abondant', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6499',4,'Très abondant','Très abondant', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Très abondant' , commentaire = 'Très abondant', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6565',0,'vent nul','vent nul', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='vent nul' , commentaire = 'vent nul', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6565',1,'vent faible','vent faible', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='vent faible' , commentaire = 'vent faible', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6565',2,'vent moyen','vent moyen', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='vent moyen' , commentaire = 'vent moyen', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6565',3,'vent fort','vent fort', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='vent fort' , commentaire = 'vent fort', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6565',4,'Brise','Brise', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Brise' , commentaire = 'Brise', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6565',5,'Brise modérée','Brise modérée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Brise modérée' , commentaire = 'Brise modérée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6565',6,'Non renseigné','Non renseigné', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non renseigné' , commentaire = 'Non renseigné', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6566',0,'non','non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='non' , commentaire = 'non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6566',1,'oui','oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='oui' , commentaire = 'oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6987',0,'[0-25%]','[0-25%]', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='[0-25%]' , commentaire = '[0-25%]', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6987',1,']25-50%]',']25-50%]', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle =']25-50%]' , commentaire = ']25-50%]', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6987',2,']50-75%]',']50-75%]', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle =']50-75%]' , commentaire = ']50-75%]', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.6987',3,']75-100%]',']75-100%]', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle =']75-100%]' , commentaire = ']75-100%]', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7002',1,'S1 - Bryophytes','S1 - Bryophytes', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='S1 - Bryophytes' , commentaire = 'S1 - Bryophytes', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7002',2,'S2 - Hydrophytes','S2 - Hydrophytes', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='S2 - Hydrophytes' , commentaire = 'S2 - Hydrophytes', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7002',10,'S10 - Helophytes','S10 - Helophytes', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='S10 - Helophytes' , commentaire = 'S10 - Helophytes', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7002',18,'S18 - Algues','S18 - Algues', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='S18 - Algues' , commentaire = 'S18 - Algues', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7003',0,'nulle','nulle', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='nulle' , commentaire = 'nulle', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7003',1,'très faible','très faible', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='très faible' , commentaire = 'très faible', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7003',2,'faible','faible', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='faible' , commentaire = 'faible', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7003',3,'moyenne','moyenne', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='moyenne' , commentaire = 'moyenne', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7003',4,'importante','importante', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='importante' , commentaire = 'importante', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7003',5,'très importante','très importante', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='très importante' , commentaire = 'très importante', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7003',6,'Indéterminable','Indéterminable', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Indéterminable' , commentaire = 'Indéterminable', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7003',7,'Non renseignée','Non renseignée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non renseignée' , commentaire = 'Non renseignée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',0,'Non renseigné','Non renseigné', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non renseigné' , commentaire = 'Non renseigné', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',1,'Forte','Forte', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Forte' , commentaire = 'Forte', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',2,'Calme','Calme', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Calme' , commentaire = 'Calme', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',3,'Belle','Belle', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Belle' , commentaire = 'Belle', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',4,'Agitée','Agitée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Agitée' , commentaire = 'Agitée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',5,'Enorme','Enorme', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Enorme' , commentaire = 'Enorme', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',6,'Grosse','Grosse', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Grosse' , commentaire = 'Grosse', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',7,'Très grosse','Très grosse', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Très grosse' , commentaire = 'Très grosse', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',8,'Peu agitée','Peu agitée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Peu agitée' , commentaire = 'Peu agitée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',9,'Ridée','Ridée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Ridée' , commentaire = 'Ridée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7163',10,'Très forte','Très forte', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Très forte' , commentaire = 'Très forte', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7165',1,'Présence','Présence', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Présence' , commentaire = 'Présence', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7165',2,'Absence','Absence', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Absence' , commentaire = 'Absence', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7169',1,'Non renseigné','Non renseigné', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non renseigné' , commentaire = 'Non renseigné', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7169',2,'Nul','Nul', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Nul' , commentaire = 'Nul', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7169',3,'Faible','Faible', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Faible' , commentaire = 'Faible', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7169',4,'Fort','Fort', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Fort' , commentaire = 'Fort', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7169',5,'Moyen','Moyen', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Moyen' , commentaire = 'Moyen', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',1,'Non renseigné','Non renseigné', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non renseigné' , commentaire = 'Non renseigné', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',2,'Ciel clair','Ciel clair', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Ciel clair' , commentaire = 'Ciel clair', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',3,'Couvert','Couvert', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Couvert' , commentaire = 'Couvert', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',4,'Nuageux','Nuageux', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Nuageux' , commentaire = 'Nuageux', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',5,'Très couvert','Très couvert', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Très couvert' , commentaire = 'Très couvert', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',6,'0 octa','0 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='0 octa' , commentaire = '0 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',7,'1 octa','1 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='1 octa' , commentaire = '1 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',8,'2 octa','2 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='2 octa' , commentaire = '2 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',9,'3 octa','3 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='3 octa' , commentaire = '3 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',10,'4 octa','4 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='4 octa' , commentaire = '4 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',11,'5 octa','5 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='5 octa' , commentaire = '5 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',12,'6 octa','6 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='6 octa' , commentaire = '6 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',13,'7 octa','7 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='7 octa' , commentaire = '7 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',14,'8 octa','8 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='8 octa' , commentaire = '8 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7262',15,'9 octa','9 octa', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='9 octa' , commentaire = '9 octa', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',1,'Cailloutis','Cailloutis', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Cailloutis' , commentaire = 'Cailloutis', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',2,'Débris','Débris', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Débris' , commentaire = 'Débris', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',3,'Eau, flaque, mare','Eau, flaque, mare', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Eau, flaque, mare' , commentaire = 'Eau, flaque, mare', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',4,'Galets','Galets', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Galets' , commentaire = 'Galets', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',5,'Mélange de substrat dur et meuble (ex : galets et sable, roches et sables, etc.)','Mélange de substrat dur et meuble (ex : galets et sable, roches et sables, etc.)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Mélange de substrat dur et meuble (ex : galets et sable, roches et sables, etc.)' , commentaire = 'Mélange de substrat dur et meuble (ex : galets et sable, roches et sables, etc.)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',6,'Roche envasée','Roche envasée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Roche envasée' , commentaire = 'Roche envasée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',7,'Sable','Sable', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sable' , commentaire = 'Sable', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',8,'Substrat dur colonisé par des organismes (coraux, algues par ex.)','Substrat dur colonisé par des organismes (coraux, algues par ex.)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Substrat dur colonisé par des organismes (coraux, algues par ex.)' , commentaire = 'Substrat dur colonisé par des organismes (coraux, algues par ex.)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',9,'Substrat dur nu / Roche nue','Substrat dur nu / Roche nue', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Substrat dur nu / Roche nue' , commentaire = 'Substrat dur nu / Roche nue', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',10,'Vase','Vase', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Vase' , commentaire = 'Vase', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',11,'Schorres','Schorres', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Schorres' , commentaire = 'Schorres', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',12,'Roches','Roches', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Roches' , commentaire = 'Roches', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',13,'Substrat meuble','Substrat meuble', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Substrat meuble' , commentaire = 'Substrat meuble', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',14,'Corail mort en place','Corail mort en place', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Corail mort en place' , commentaire = 'Corail mort en place', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',15,'Dalle corallienne','Dalle corallienne', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Dalle corallienne' , commentaire = 'Dalle corallienne', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',16,'Blocs','Blocs', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Blocs' , commentaire = 'Blocs', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',17,'Vide d''algue','Vide d''algue', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Vide d''algue' , commentaire = 'Vide d''algue', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',18,'Substrat dur (colonisé ou non)','Substrat dur (colonisé ou non)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Substrat dur (colonisé ou non)' , commentaire = 'Substrat dur (colonisé ou non)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',19,'Non précisé','Non précisé', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non précisé' , commentaire = 'Non précisé', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',20,'Sable fin vaseux','Sable fin vaseux', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sable fin vaseux' , commentaire = 'Sable fin vaseux', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',21,'Sable grossier propre','Sable grossier propre', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sable grossier propre' , commentaire = 'Sable grossier propre', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',22,'Sable fin propre','Sable fin propre', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sable fin propre' , commentaire = 'Sable fin propre', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',23,'Récif','Récif', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Récif' , commentaire = 'Récif', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',24,'Sable noir','Sable noir', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sable noir' , commentaire = 'Sable noir', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',25,'Graviers / Cailloux','Graviers / Cailloux', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Graviers / Cailloux' , commentaire = 'Graviers / Cailloux', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',26,'Roche mère','Roche mère', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Roche mère' , commentaire = 'Roche mère', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7263',27,'Sable fin','Sable fin', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sable fin' , commentaire = 'Sable fin', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7305',1,'Une destruction physique est observée','Une destruction physique est observée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Une destruction physique est observée' , commentaire = 'Une destruction physique est observée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7305',2,'Aucune destruction physique n''est observée','Aucune destruction physique n''est observée', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Aucune destruction physique n''est observée' , commentaire = 'Aucune destruction physique n''est observée', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7343',1,'écoulement visible acceptable (1a)','écoulement visible acceptable (1a)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='écoulement visible acceptable (1a)' , commentaire = 'écoulement visible acceptable (1a)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7343',2,'écoulement visible faible (1f)','écoulement visible faible (1f)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='écoulement visible faible (1f)' , commentaire = 'écoulement visible faible (1f)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7343',3,'écoulement non visible (2)','écoulement non visible (2)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='écoulement non visible (2)' , commentaire = 'écoulement non visible (2)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7343',4,'assec (3)','assec (3)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='assec (3)' , commentaire = 'assec (3)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7343',5,'observation impossible (4)','observation impossible (4)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='observation impossible (4)' , commentaire = 'observation impossible (4)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7465',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7465',1,'Débit stable','Débit stable', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Débit stable' , commentaire = 'Débit stable', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7465',2,'Evénement hydrologique modéré','Evénement hydrologique modéré', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Evénement hydrologique modéré' , commentaire = 'Evénement hydrologique modéré', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7465',3,'Evénement hydrologique important','Evénement hydrologique important', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Evénement hydrologique important' , commentaire = 'Evénement hydrologique important', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7465',4,'Evénement hydrologique exceptionnel','Evénement hydrologique exceptionnel', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Evénement hydrologique exceptionnel' , commentaire = 'Evénement hydrologique exceptionnel', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7480',0,'Non renseigné','Non renseigné', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non renseigné' , commentaire = 'Non renseigné', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7480',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7480',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7480',3,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7621',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7621',1,'Naturelle','Naturelle', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Naturelle' , commentaire = 'Naturelle', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7621',2,'Enrochement','Enrochement', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Enrochement' , commentaire = 'Enrochement', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7621',3,'artificielle fermée (pierres maçonnées, béton, palplanche, planche)','artificielle fermée (pierres maçonnées, béton, palplanche, planche)', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='artificielle fermée (pierres maçonnées, béton, palplanche, planche)' , commentaire = 'artificielle fermée (pierres maçonnées, béton, palplanche, planche)', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7622',0,'Inconnu','Inconnu', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Inconnu' , commentaire = 'Inconnu', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7622',1,'Oui','Oui', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Oui' , commentaire = 'Oui', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.7622',2,'Non','Non', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Non' , commentaire = 'Non', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.8090',0,'Sans objet','Sans objet', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Sans objet' , commentaire = 'Sans objet', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.8090',1,'Amont','Amont', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Amont' , commentaire = 'Amont', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
        INSERT INTO codes_sandre (champ, code, libelle, commentaire, datecreation, datemodification, projet, loginmaj, datemaj)	VALUES('PARAMETRE.8090',2,'Aval','Aval', now(), now(),'SIQ','INIT_LEX_2023', now()) ON CONFLICT (champ, code) DO UPDATE SET libelle ='Aval' , commentaire = 'Aval', datemodification = now(), projet = 'SIQ', loginmaj = 'INIT_LEX_2023', datemaj = now();;
    end if;;
  end
;;
$BODY$;
--    pour rejouer le script il faut faire un isnert et rappeller la fonction
--    insert into parametres(module, identifiant, valeur) values ('script','285','1')
call doEvolution285();

# --- !Downs