/**
 * @author kbe
 * @date 19/12/2023
 * @version 1.0.0
 * @project aquadb
 * @table epci epci_communes
 */
# --- !Ups

CREATE TABLE public.epci (
	epci varchar(12) NOT NULL,
	nom varchar(100) not NULL,
    nature varchar(50) not null,
	situation int4 NULL,
	numdept varchar(3) NULL,
    region varchar(3) null,
	superficie float8 NULL,
	codepays varchar(2) NULL,
	x float4 NULL,
	y float4 NULL,
	typeprojection int4 NULL,
	email varchar(100) NULL,
	telephone varchar(20) NULL,
	population int4 NULL,
	agencebassin int8 NULL,
	jobexecutionid int8 NULL,
	loginmaj varchar(25) NULL,
	datemaj timestamptz NULL,
	kml_polygon text NULL,
	CONSTRAINT epci_pkey PRIMARY KEY (epci)
);
CREATE INDEX idx_epci_dept ON public.epci USING btree (numdept);
CREATE INDEX ind_epci ON public.epci USING btree (epci);


CREATE TABLE public.epci_communes (
	code_commune varchar(12) NOT NULL,
	epci varchar(12) NOT NULL
);


insert into codes_sandre_referentiel (champ) values ('EPCI.NATURE');
insert into  codes_sandre (champ ,code ,libelle ,mnemonique ) values ('EPCI.NATURE',1,'Communauté Urbaine' ,'CU');
insert into  codes_sandre (champ ,code ,libelle ,mnemonique ) values ('EPCI.NATURE',2,'Communauté Communaute' ,'CC');
insert into  codes_sandre (champ ,code ,libelle ,mnemonique ) values ('EPCI.NATURE',3,'Communauté d''Aglomération' ,'CA');
insert into  codes_sandre (champ ,code ,libelle ,mnemonique ) values ('EPCI.NATURE',4,'Métropole' ,'ME');
insert into  codes_sandre (champ ,code ,libelle ,mnemonique ) values ('EPCI.NATURE',5,'Métropole de Lyon' ,'METLYON');



# --- !Downs