/**
 * @author jroba
 * @date 16/01/2024
 * @version 1.0.0
 * @project Iryqua
 * @function f_par_calc_regles_ecremage
 */
# --- !Ups

create or replace function f_par_calc_ecremage(p_idExploitation bigint,
                                    p_idInstallation bigint,
                                    p_idUsagePrevi bigint,
                                    p_idSurvey bigint,
                                    p_managementCode bigint,
                                    volumeImpacted double precision,
                                    volumeImpactedLowWater double precision,
                                    volumeImpactedNotlowWater double precision)
    returns SETOF RECORD
    language plpgsql
as $$
DECLARE
    rec RECORD;;
BEGIN

    -- function to update with clients specific rules
    -- the specific rule has to be add in agri_regles_scenarios, with typeregle = ecremage
    -- for each rule, you have to return a rec like these :
       -- idregle integer,                                  --> correspond to column id in table agri_regles_scenarios
       -- v_valeurTotal_1 double precision,                 --> value of usage after applying rule
       -- v_valeurEtiage_1 double precision,                --> low water value of usage after applying rule
       -- v_valeurHorsEtiage_1 double precision,            --> not low water value of usage after applying rule
       -- v_valeurDiffTotal_1 double precision,             --> how much the value removed / added to the original value
       -- v_valeurDiffEtiage_1 double precision,            --> how much the value removed / added to the original value low water
       -- v_valeurDiffHorsEtiage_1 double precision         --> how much the value removed / added to the original value not low water

    return next rec;;
END;;
$$;;

# --- !Downs
