/**
 * @author amr
 * @date 07/03/2024
 * @version 1.0.0
 * @project hydrobio
 * @table qualitometres_operations_observation_ambiance qualitometres_operations_observation qualitometres_operations_observation_lot
 */

# --- !Ups

 alter table qualitometres_points add column distance_source float8 null;
  alter table qualitometres_points add column slope float8 null;
  alter table qualitometres_points add column temperature_air_january float8 null;
  alter table qualitometres_points add column temperature_air_july float8 null;



create  table qualitometres_operations_observation(
codequalitometres float8 not null,
codeoperation float8 not null,
code_operation_observation  varchar(100) not null,
etat_avancement_operation varchar(100) null,
objectifs_operation text null,
code_prelevement_elementaire int4 null,
type_prelevement_elementaire varchar(20) null,
duree_prelevement_elementaire int4 null,
numero_passage varchar(20) null,
type_points varchar(100) null,
nombre_points int4 null,
nombre_points_sans_poisson int4 null,
nombre_points_facies_courant int4 null,
nombre_points_facies_plat int4 null,
nombre_points_facies_profond int4 null,
nombre_points_annexes int4 null,
nombre_points_berge int4 null,
nombre_points_chenal int4 null
);
CREATE UNIQUE INDEX qualitometres_operations_observation_codequalitometres_idx
ON public.qualitometres_operations_observation (codequalitometres,codeoperation,code_operation_observation);



create table qualitometres_operations_observation_lot(
codequalitometres float8 not null,
codeoperation float8 not null,
code_operation_observation  varchar(100) not null,
code_lot int4 null,
code_type_lot int4 null,
effectif_lot int4 null,
code_taxon varchar(100) null,
taille_min_lot int4 null,
taille_max_lot int4 null,
poids_lot_mesure  int4 null,
poids_lot_estime  int4 null,
methode_estimation_poids_lot varchar(100) null,
code_individu	  int8 null,
taille_individu	  int4 null,
mesure_individu_reelle	boolean null,
poids_individu_mesure		  int4 null,
poids_individu_estime		  int4 null,
methode_estimation_poids_individu	 varchar(100) null,
sexe_individu	 varchar(10) null,
age_individu		  int4 null,
 codes_fractions_pathologies_lot varchar(100) null,
 uris_fractions_pathologies_lot	 varchar(200) null,
 importances_pathologies_lot	 varchar(20) null,
 codes_pathologies_individu	 varchar(100) null,
 codes_fractions_pathologies_individu	 varchar(100) null,
 uris_fractions_pathologies_individu	 varchar(200) null,
 importances_pathologies_individu varchar(20) null,
 code_point_prelevement_wama varchar(100) null
);

CREATE UNIQUE INDEX qualitometres_operations_observation_lot_idx
ON public.qualitometres_operations_observation_lot (codequalitometres,codeoperation,code_operation_observation,code_lot,code_taxon);

create table qualitometres_operations_observation_ambiance(
codequalitometres float8 not null,
codeoperation float8 not null,
code_operation_observation varchar(100) not null,
nom_ambiance varchar(100)   null,
longueur_ambiance float8 null,
largeur_ambiance float8 null,
profondeur_ambiance float8 null,
code_facies_ambiance  int4 null,
situation_ambiance varchar(100)  null,
localisation_ambiance varchar(100)  null,
classe_vitesse_courant_ambiance varchar(100)  null,
code_ombrage_ambiance int4  null,
code_granulo_ambiance_dominante  int4 null,
code_granulo_ambiance_accessoire  int4 null,
vegetation_ambiance varchar(100)  null,
abondance_cache_vegetation_aquatique_ambiance varchar(100)  null,
abondance_cache_embacles_ambiance varchar(100)  null,
abondance_cache_vegetation_bordure_ambiance varchar(100)  null,
abondance_cache_sous_berge_ambiance varchar(100)  null,
abondance_cache_granulo_ambiance varchar(100)  null,
observation_ambiance text   null
);
CREATE UNIQUE INDEX qualitometres_operations_observation_ambiance_idx
ON public.qualitometres_operations_observation_ambiance (codequalitometres,codeoperation,code_operation_observation);

# --- !Downs