/**
 * @author pminot
 * @date 20/03/2024
 * @version 1.0.0
 * @project reyssouze
 * @table INST_STEP INST_STEP_POINTS_REJETS
 */

# --- !Ups

alter table INST_STEP DROP COLUMN if exists codeME;
alter table INST_STEP ADD COLUMN codeME CHARACTER VARYING(22);
alter table INST_STEP DROP COLUMN if exists bassinVersant;
alter table INST_STEP ADD COLUMN bassinVersant BIGINT;
alter table INST_STEP DROP COLUMN if exists typeReseau;
alter table INST_STEP ADD COLUMN typeReseau BIGINT;
alter table INST_STEP DROP COLUMN if exists capaciteNominaleDBO5;
alter table INST_STEP ADD COLUMN capaciteNominaleDBO5 DOUBLE PRECISION;
alter table INST_STEP DROP COLUMN if exists percentile95;
alter table INST_STEP ADD COLUMN percentile95 DOUBLE PRECISION;
alter table INST_STEP DROP COLUMN if exists chargeMaximaleEntrante;
alter table INST_STEP ADD COLUMN chargeMaximaleEntrante DOUBLE PRECISION;
alter table INST_STEP DROP COLUMN if exists debitEntrant;
alter table INST_STEP ADD COLUMN debitEntrant DOUBLE PRECISION;
alter table INST_STEP DROP COLUMN if exists quantiteEpandageAgricole;
alter table INST_STEP ADD COLUMN quantiteEpandageAgricole DOUBLE PRECISION;

delete from codes_sandre where champ = 'STEP.TYPE_RESEAU';
insert into codes_sandre values ('STEP.TYPE_RESEAU',0, 'Inconnu');
insert into codes_sandre values ('STEP.TYPE_RESEAU',1, 'Unitaire');
insert into codes_sandre values ('STEP.TYPE_RESEAU',2, 'Séparatif');
insert into codes_sandre values ('STEP.TYPE_RESEAU',3, 'Mixte');

drop table if exists INST_STEP_POINTS_REJETS;
create table INST_STEP_POINTS_REJETS (
                                         codeInstallation BIGINT,
                                         codePoint BIGINT,
                                         idPoint CHARACTER VARYING(25),
                                         nomPoint TEXT,
                                         commentaires TEXT,
                                         x DOUBLE PRECISION,
                                         y DOUBLE PRECISION,
                                         typeProjection DOUBLE PRECISION,
                                         rejetPlus1500m BOOLEAN,
                                         nomZoneSensible TEXT,
                                         sensibiliteAzote BOOLEAN,
                                         dateArreteSensibiliteAzote TIMESTAMP without TIME ZONE,
                                         sensibilitePhosphore BOOLEAN,
                                         dateArreteSensibilitePhosphore TIMESTAMP without TIME ZONE);

drop table if exists INST_STEP_POINTS_SUIVI;
create table INST_STEP_POINTS_SUIVI (
                                      codeInstallation BIGINT,
                                      codeSandre BIGINT,
                                      codeinterne INTEGER,
                                      commentaire TEXT,
                                      x DOUBLE PRECISION,
                                      y DOUBLE PRECISION,
                                      typeProjection DOUBLE PRECISION
);


alter table INST_STEP_COMMUNES DROP COLUMN if exists desserteTotal;
alter table INST_STEP_COMMUNES ADD COLUMN desserteTotal BOOLEAN;
alter table INST_STEP_COMMUNES DROP COLUMN if exists nbAbonnes;
alter table INST_STEP_COMMUNES ADD COLUMN nbAbonnes BIGINT;

# --- !Downs