/**
 * @author jroba
 * @date 08/04/2024
 * @version 1.0.0
 * @project iryqua
 * @table mat_chroniques
 */

# --- !Ups

create or replace function f_calc_date_premiere_estim(p_idmat integer, p_date timestamp with time zone, nbmoisrecherche integer) returns TIMESTAMP with time zone
    language plpgsql
as
$$
DECLARE
v_dateLimit1 TIMESTAMP with time zone;;
    v_dateLimit2 TIMESTAMP with time zone;;
    v_dateResult TIMESTAMP with time zone;;

BEGIN

    v_dateLimit1 = p_date + INTERVAL '1 MONTHS';;
    v_dateLimit2 = p_date - INTERVAL '1 MONTHS' * nbmoisrecherche;;
    p_date = date_trunc('day', p_date) + INTERVAL '1 day';;
    raise notice 'f_calc_date_premiere_estim date fin: %', p_date;;

select dateMesure
into v_dateResult
from MAT_CHRONIQUES
where idmateriel = p_idmat
  and typemesure = 1
  and dateMesure < v_dateLimit1
  AND dateMesure >= p_date
ORDER BY dateMesure ASC
    LIMIT 1;;

if (v_dateResult is null) then
select dateMesure
into v_dateResult
from MAT_CHRONIQUES
where idmateriel = p_idmat
  and typemesure = 1
  and dateMesure <= p_date
  AND dateMesure > v_dateLimit2
ORDER BY dateMesure DESC
    LIMIT 1;;
end if;;

    raise notice 'f_calc_date_premiere_estim : %', v_dateResult;;

RETURN v_dateResult;;
END;;
$$;;



create or replace function f_calc_date_derniere_estim(p_idmat integer, p_date timestamp with time zone, nbmoisrecherche integer) returns TIMESTAMP with time zone
    language plpgsql
as
$$
DECLARE
v_dateLimit1 TIMESTAMP with time zone;;
    v_dateLimit2 TIMESTAMP with time zone;;
    v_dateResult TIMESTAMP with time zone;;

BEGIN

    v_dateLimit1 = p_date - INTERVAL '1 MONTHS';;
    v_dateLimit2 = p_date + INTERVAL '1 MONTHS' * nbmoisrecherche;;
    p_date = date_trunc('day', p_date) + INTERVAL '1 day';;
    raise notice 'f_calc_date_derniere_estim date fin: %', p_date;;

select dateMesure
into v_dateResult
from MAT_CHRONIQUES
where idmateriel = p_idmat
  and typemesure = 1
  and dateMesure > v_dateLimit1
  AND dateMesure <= p_date
ORDER BY dateMesure DESC
    LIMIT 1;;

if (v_dateResult is null) then
select dateMesure
into v_dateResult
from MAT_CHRONIQUES
where idmateriel = p_idmat
  and typemesure = 1
  and dateMesure >= p_date
  AND dateMesure < v_dateLimit2
ORDER BY dateMesure asc
    LIMIT 1;;
end if;;

    raise notice 'f_calc_date_derniere_estim : %', v_dateResult;;

RETURN v_dateResult;;
END;;
$$;;


# --- !Downs
