/**
 * @author sbarthon
 * @date 16/04/2024
 * @version 1.0.0
 * @project sieau
 * @table dropoldtables
 */

# --- !Ups


CREATE OR REPLACE FUNCTION public.dropOldTables()
returns INTEGER
LANGUAGE plpgsql
AS $function$
-- Suppression des tables de données v6. snif....
-- la fonction renvoie le nombre de tables supprimées et écrit dans la console le nom des tables
DECLARE
	v_res RECORD;;
	i INTEGER;;
	nbDrops INTEGER;;
BEGIN
	raise notice 'suppression analyses';;
	nbDrops := 0;;
	i := 0;;
	LOOP
		-- Récupération des tables analyses_<num>*;;
		FOR v_res IN
			SELECT table_name
			FROM information_schema.tables
			WHERE table_schema = 'public'
			AND UPPER(table_name) LIKE 'ANALYSES_' || i || '%'
		LOOP
			raise notice 'table %',v_res.table_name;;
			EXECUTE 'DROP TABLE ' || v_res.table_name;;
			nbDrops := nbDrops + 1;;
		END LOOP;;

		-- Récupération des tables qualitometres_liste_<num>*;;
		FOR v_res IN
			SELECT table_name
			FROM information_schema.tables
			WHERE table_schema = 'public'
			AND UPPER(table_name) LIKE 'QUALITOMETRES_LISTE_' || i || '%'
		LOOP
			raise notice 'table %',v_res.table_name;;
			EXECUTE 'DROP TABLE ' || v_res.table_name;;
			nbDrops := nbDrops + 1;;
		END LOOP;;

		-- Récupération des tables hydro_<num>*;;
		FOR v_res IN
			SELECT table_name
			FROM information_schema.tables
			WHERE table_schema = 'public'
			AND UPPER(table_name) LIKE 'HYDRO_' || i || '%'
		LOOP
			raise notice 'table %',v_res.table_name;;
			EXECUTE 'DROP TABLE ' || v_res.table_name;;
			nbDrops := nbDrops + 1;;
		END LOOP;;

		-- Récupération des tables pluvio_<num>*;;
		FOR v_res IN
			SELECT table_name
			FROM information_schema.tables
			WHERE table_schema = 'public'
			AND UPPER(table_name) LIKE 'PLUVIO_' || i || '%'
		LOOP
			raise notice 'table %',v_res.table_name;;
			EXECUTE 'DROP TABLE ' || v_res.table_name;;
			nbDrops := nbDrops + 1;;
		END LOOP;;

		-- Récupération des tables pz_<num>*;;
		FOR v_res IN
			SELECT table_name
			FROM information_schema.tables
			WHERE table_schema = 'public'
			AND UPPER(table_name) LIKE 'PZ_' || i || '%'
		LOOP
			raise notice 'table %',v_res.table_name;;
			EXECUTE 'DROP TABLE ' || v_res.table_name;;
			nbDrops := nbDrops + 1;;
		END LOOP;;

		-- Récupération des tables piezometre_prelevement_<num>*;;
		FOR v_res IN
			SELECT table_name
			FROM information_schema.tables
			WHERE table_schema = 'public'
			AND UPPER(table_name) LIKE 'PIEZOMETRE_PRELEVEMENT_' || i || '%'
		LOOP
			raise notice 'table %',v_res.table_name;;
			EXECUTE 'DROP TABLE ' || v_res.table_name;;
			nbDrops := nbDrops + 1;;
		END LOOP;;

		-- Récupération des tables piezometre_pompage_<num>*;;
		FOR v_res IN
			SELECT table_name
			FROM information_schema.tables
			WHERE table_schema = 'public'
			AND UPPER(table_name) LIKE 'PIEZOMETRE_POMPAGE_' || i || '%'
		LOOP
			raise notice 'table %',v_res.table_name;;
			EXECUTE 'DROP TABLE ' || v_res.table_name;;
			nbDrops := nbDrops + 1;;
		END LOOP;;

		i := i + 1;;
		EXIT WHEN i > 9;;
	END LOOP;;

	-- Suppression des tables *_BSS'
	FOR v_res IN
		SELECT table_name
		FROM information_schema.tables
		WHERE table_schema = 'public'
		AND (upper(table_name) like 'ANALYSES_BSS%'
			OR upper(table_name) like 'PZ_BSS%'
			OR upper(table_name) like 'PIEZOMETRE_POMPAGE_BSS%'
			OR upper(table_name) like 'PIEZOMETRE_PRELEVEMENT_BSS%')
	LOOP
		raise notice 'table %',v_res.table_name;;
		EXECUTE 'DROP TABLE ' || v_res.table_name;;
		nbDrops := nbDrops + 1;;
	END LOOP;;

	RETURN nbDrops;;
END;;
$function$
;

# --- !Downs