/**
 * @author sbarthon (Added by kbe)
 * @date 30/05/2024
 * @version 1.0.0
 * @project aep_captages_dossiers, aep_captages_dossiers_perimetres, aep_captages_dossiers_parcelles, aep_captages_dossiers_proprio_prives, aep_captages_dossiers_proprio_ent, aep_captages_dossiers_hyp, aep_captages_dossiers_actes
 */

# --- !Ups

drop table if exists aep_captages_dossiers;
drop table if exists aep_captages_dossiers_perimetres;
drop table if exists aep_captages_dossiers_parcelles;
drop table if exists aep_captages_dossiers_proprio_prives;
drop table if exists aep_captages_dossiers_proprio_ent;
drop table if exists aep_captages_dossiers_hyp;
drop table if exists aep_captages_dossiers_actes;

create table aep_captages_dossiers (
                                       idcaptage INTEGER,
                                       nomCaptage CHARACTER VARYING(50),
                                       identifiant CHARACTER VARYING(25),
                                       codeCommune CHARACTER VARYING(25),
                                       codeCollectivite INTEGER,
                                       codeStatut INTEGER,
                                       codeEtat INTEGER,
                                       sau REAL,
                                       sauPerimetre REAL,
                                       dateMaj TIMESTAMP WITHOUT TIME ZONE,
                                       loginmaj CHARACTER VARYING(25)
);


create table aep_captages_dossiers_perimetres (
                                                  idcaptage INTEGER,
                                                  idperimetre INTEGER,
                                                  typePerimetre INTEGER,
                                                  dateMaj TIMESTAMP WITHOUT TIME ZONE,
                                                  loginmaj CHARACTER VARYING(25)
);


create table aep_captages_dossiers_parcelles (
                                                 idcaptage INTEGER,
                                                 idperimetre INTEGER,
                                                 idparcelle INTEGER,
                                                 parcelle CHARACTER VARYING(255),
                                                 section CHARACTER VARYING(255),
                                                 surface REAL,
                                                 indemniteProprietaire boolean,
                                                 indemniteExploitant boolean,
                                                 dateMaj TIMESTAMP WITHOUT TIME ZONE,
                                                 loginmaj CHARACTER VARYING(25)
);

create table aep_captages_dossiers_proprio_prives (
                                                      idcaptage INTEGER,
                                                      idperimetre INTEGER,
                                                      idparcelle INTEGER,
                                                      idProprietaire INTEGER,
                                                      codecontact INTEGER,
                                                      nom CHARACTER VARYING(115),
                                                      prenoms CHARACTER VARYING(100),
                                                      commentaire TEXT,
                                                      datenaissance TIMESTAMP WITHOUT TIME ZONE,
                                                      lieunaissance CHARACTER VARYING(100),
                                                      adresse TEXT,
                                                      complementadresse TEXT,
                                                      codepostal CHARACTER VARYING(5),
                                                      codecommune CHARACTER VARYING(12),
                                                      nomcommuneusuel CHARACTER VARYING(100),
                                                      typePropriete INTEGER
);

create table aep_captages_dossiers_proprio_ent (
                                                   idcaptage INTEGER,
                                                   idperimetre INTEGER,
                                                   idparcelle INTEGER,
                                                   idProprietaire INTEGER,
                                                   codeIntervenant INTEGER,
                                                   nom CHARACTER VARYING(115),
                                                   commentaire TEXT,
                                                   adresse TEXT,
                                                   complementadresse TEXT,
                                                   codepostal CHARACTER VARYING(5),
                                                   codecommune CHARACTER VARYING(12),
                                                   nomcommuneusuel CHARACTER VARYING(100),
                                                   typePropriete INTEGER
);

create table aep_captages_dossiers_hyp (
                                           idHypotheque integer,
                                           idordre integer,
                                           dateActe timestamp without time zone,
                                           commentaire text,
                                           datePublication timestamp without time zone,
                                           volume character varying (100),
                                           numeroPublication character varying (100),
                                           idHypothequeSuivante integer,
                                           idReprise character varying(20)
);


create table aep_captages_dossiers_actes (
                                             idcaptage integer,
                                             idperimetre integer,
                                             idparcelle integer,
                                             typeproprietaire integer,
                                             idproprietaire integer,
                                             idhypotheque integer);

delete from codes_sandre where champ = 'PARCELLES.TYPE_PROPRIETE';

insert into codes_sandre values ('PARCELLES.TYPE_PROPRIETE', 0 , 'Propriétaire');
insert into codes_sandre values ('PARCELLES.TYPE_PROPRIETE', 1 , 'Nu-propriétaire');
insert into codes_sandre values ('PARCELLES.TYPE_PROPRIETE', 2 , 'Usufruitier');
insert into codes_sandre values ('PARCELLES.TYPE_PROPRIETE', 3 , 'Indivision');
insert into codes_sandre values ('PARCELLES.TYPE_PROPRIETE', 4 , 'Succession');
insert into codes_sandre values ('PARCELLES.TYPE_PROPRIETE', 5 , 'Autre');


# --- !Downs