/**
 * @author tpa
 * @date 10/06/2024
 * @version 1.0.0
 * @project sieau
 * @table piezometres_points
 */

# --- !Ups

-- suppression des points s'il y en a
delete from piezometres_points;
delete from pluviometres_points;
delete from stations_hydro_points;

-- ajout des points sur chaque station en fonction des données des chroniques

insert into piezometres_points (codestation, codepoint, typeid, identifiant, nom)
select points.codestation, points.codepoint, points.typeid, points.codepoint::varchar identifiant, ('Point ' || param.libelle) nom from (
    select distinct codepiezometre codestation, typeid, row_number() over (partition by codepiezometre) codepoint from chroniques_brutes group by (codepiezometre, typeid) order by codepiezometre, typeid
) points
    left join (
    select * from parametrage_data where projet = 'SIES' order by id
) param on param.id = points.typeid;

insert into stations_hydro_points (codestation, codepoint, typeid, identifiant, nom)
select points.codestation, points.codepoint, points.typeid, points.codepoint::varchar identifiant, ('Point ' || param.libelle) nom from (
    select distinct codestation codestation, typeid, row_number() over (partition by codestation) codepoint from chroniques_hydro group by (codestation, typeid) order by codestation, typeid
) points
    left join (
    select * from parametrage_data where projet = 'SIH' order by id
) param on param.id = points.typeid;



insert into pluviometres_points (codestation, codepoint, typeid, identifiant, nom)
select points.codestation, points.codepoint, points.typeid, points.codepoint::varchar identifiant, ('Point ' || param.libelle) nom from (
    select distinct codepluviometre codestation, typeid, row_number() over (partition by codepluviometre) codepoint from chroniques_pluvio group by (codepluviometre, typeid) order by codepluviometre, typeid
) points
    left join (
    select * from parametrage_data where projet = 'SIP' order by id
) param on param.id = points.typeid;

-- création de la nouvelle colonne + correction des index

--piézo
alter table chroniques_brutes
    add codepoint integer not null default 0;
drop index chroniques_brutes_codepiezometre_typeid_datemesure_idx;
create index chroniques_brutes_codepiezometre_typeid_datemesure_idx
    on chroniques_brutes (codepiezometre, typeid, datemesure);
create unique index chroniques_brutes_allkey_idx
    on chroniques_brutes (codepiezometre, typeid, datemesure, codepoint);

--piézo suppr
alter table chroniques_brutes_suppr
    add codepoint integer not null default 0;
drop index chroniques_brutes_suppr_codepiezometre_typeid_datemesure_idx;
create index chroniques_brutes_suppr_codepiezometre_typeid_datemesure_idx
    on chroniques_brutes_suppr (codepiezometre, typeid, datemesure);
create unique index chroniques_brutes_suppr_allkey_idx
    on chroniques_brutes_suppr (codepiezometre, typeid, datemesure, codepoint);

--hydro
alter table chroniques_hydro
    add codepoint integer not null default 0;
drop index chroniques_hydro_codestation_typeid_datemesure_idx;
create index chroniques_hydro_codestation_typeid_datemesure_idx
    on chroniques_hydro (codestation, typeid, datemesure);
create unique index chroniques_hydro_allkey_idx
    on chroniques_hydro (codestation, typeid, datemesure, codepoint);

--hydro suppr
alter table chroniques_hydro_suppr
    add codepoint integer not null default 0;
drop index chroniques_hydro_suppr_codestation_typeid_datemesure_idx;
create index chroniques_hydro_suppr_codestation_typeid_datemesure_idx
    on chroniques_hydro_suppr (codestation, typeid, datemesure);
create unique index chroniques_hydro_suppr_allkey_idx
    on chroniques_hydro_suppr (codestation, typeid, datemesure, codepoint);

--pluvio
alter table chroniques_pluvio
    add codepoint integer not null default 0;
drop index chroniques_pluvio_codepluviometre_typeid_datemesure_idx;
create index chroniques_pluvio_codepluviometre_typeid_datemesure_idx
    on chroniques_pluvio (codepluviometre, typeid, datemesure);
create unique index chroniques_pluvio_allkey_idx
    on chroniques_pluvio (codepluviometre, typeid, datemesure, codepoint);

--pluvio suppr
alter table chroniques_pluvio_suppr
    add codepoint integer not null default 0;
drop index chroniques_pluvio_suppr_codepluviometre_typeid_datemesure_idx;
create index chroniques_pluvio_suppr_codepluviometre_typeid_datemesure_idx
    on chroniques_pluvio_suppr (codepluviometre, typeid, datemesure);
create unique index chroniques_pluvio_suppr_allkey_idx
    on chroniques_pluvio_suppr (codepluviometre, typeid, datemesure, codepoint);

-- mise à jour des codepoint dans les chroniques
UPDATE chroniques_brutes
SET codepoint = piezometres_points.codepoint
    from piezometres_points
where chroniques_brutes.codepiezometre = piezometres_points.codestation
  and chroniques_brutes.typeid = piezometres_points.typeid;
UPDATE chroniques_brutes_suppr
SET codepoint = piezometres_points.codepoint
    from piezometres_points
where chroniques_brutes_suppr.codepiezometre = piezometres_points.codestation
  and chroniques_brutes_suppr.typeid = piezometres_points.typeid;


UPDATE chroniques_hydro
SET codepoint = stations_hydro_points.codepoint
    from stations_hydro_points
where chroniques_hydro.codestation = stations_hydro_points.codestation
  and chroniques_hydro.typeid = stations_hydro_points.typeid;
UPDATE chroniques_hydro_suppr
SET codepoint = stations_hydro_points.codepoint
    from stations_hydro_points
where chroniques_hydro_suppr.codestation = stations_hydro_points.codestation
  and chroniques_hydro_suppr.typeid = stations_hydro_points.typeid;


UPDATE chroniques_pluvio
SET codepoint = pluviometres_points.codepoint
    from pluviometres_points
where chroniques_pluvio.codepluviometre = pluviometres_points.codestation
  and chroniques_pluvio.typeid = pluviometres_points.typeid;
UPDATE chroniques_pluvio_suppr
SET codepoint = pluviometres_points.codepoint
    from pluviometres_points
where chroniques_pluvio_suppr.codepluviometre = pluviometres_points.codestation
  and chroniques_pluvio_suppr.typeid = pluviometres_points.typeid;

# --- !Downs

