/**
 * @author tpa
 * @date 04/07/2024
 * @version 1.0.0
 * @project sieau
 * @table piezometres_points
 */

# --- !Ups

alter table piezometres_points add typepoint integer default 1 not null;

alter table stations_hydro_points add typepoint integer default 1 not null;

alter table pluviometres_points add typepoint integer default 1 not null;

WITH groupbytypeid AS (
    SELECT codestation,
           codepoint,
           typeid,
           ROW_NUMBER() OVER (PARTITION BY (codestation, typeid) ORDER BY (codestation, typeid)) AS row_num
    FROM piezometres_points
)
UPDATE piezometres_points
SET typepoint = 2
    FROM groupbytypeid
WHERE piezometres_points.codestation = groupbytypeid.codestation and piezometres_points.codepoint = groupbytypeid.codepoint and piezometres_points.typeid = groupbytypeid.typeid
  AND groupbytypeid.row_num > 1;


WITH groupbytypeid AS (
    SELECT codestation,
           codepoint,
           typeid,
           ROW_NUMBER() OVER (PARTITION BY (codestation, typeid) ORDER BY (codestation, typeid)) AS row_num
    FROM stations_hydro_points
)
UPDATE stations_hydro_points
SET typepoint = 2
    FROM groupbytypeid
WHERE stations_hydro_points.codestation = groupbytypeid.codestation and stations_hydro_points.codepoint = groupbytypeid.codepoint and stations_hydro_points.typeid = groupbytypeid.typeid
  AND groupbytypeid.row_num > 1;


WITH groupbytypeid AS (
    SELECT codestation,
           codepoint,
           typeid,
           ROW_NUMBER() OVER (PARTITION BY (codestation, typeid) ORDER BY (codestation, typeid)) AS row_num
    FROM pluviometres_points
)
UPDATE pluviometres_points
SET typepoint = 2
    FROM groupbytypeid
WHERE pluviometres_points.codestation = groupbytypeid.codestation and pluviometres_points.codepoint = groupbytypeid.codepoint and pluviometres_points.typeid = groupbytypeid.typeid
  AND groupbytypeid.row_num > 1;


# --- !Downs

