/**
 * @author pminot
 * @date 23/09/2024
 * @version 1.0.0
 * @project Myliaq
 * @table chroniques_hydro, chroniques_pluvio, chroniques_brutes
 */

# --- !Ups

create or replace procedure doEvolution439()
    LANGUAGE 'plpgsql'
    as $BODY$

    declare environment int;;
    begin
        select count(valeur)
           into environment
           from parametres
        where module='script' and identifiant = '439' and valeur='1';;

        if (environment > 0 ) THEN
            drop trigger if exists trig_maj_volumes_piezo on chroniques_brutes;;
            drop FUNCTION public.maj_volumes_piezo();;

            ALTER TABLE chroniques_brutes ALTER COLUMN valeurmesure TYPE double precision USING valeurmesure::double precision;;
            ALTER TABLE chroniques_brutes ALTER COLUMN valeurngf TYPE double precision USING valeurngf::double precision;;

            ALTER TABLE chroniques_pluvio ALTER COLUMN valeurmesure TYPE double precision USING valeurmesure::double precision;;
            ALTER TABLE chroniques_pluvio ALTER COLUMN valeurmesurecorrigee TYPE double precision USING valeurmesurecorrigee::double precision;;

            ALTER TABLE chroniques_hydro ALTER COLUMN valeurmesure TYPE double precision USING valeurmesure::double precision;;
            ALTER TABLE chroniques_hydro ALTER COLUMN valeurngf TYPE double precision USING valeurngf::double precision;;

            CREATE FUNCTION public.maj_volumes_piezo()
            RETURNS trigger
            LANGUAGE 'plpgsql'
            COST 100
            VOLATILE NOT LEAKPROOF
            AS $BODY2$
            DECLARE
                vIndexPrec DOUBLE PRECISION;;
                vNbSituations INTEGER;;
            BEGIN
                IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN
                    IF NEW.typeId=-2 THEN
                        -- Vérification si équipé d'un compteur
                        SELECT count(*) INTO vNbSituations FROM mat_divers_situations INNER JOIN mat_divers ON (mat_divers_situations.id=mat_divers.id) WHERE typesite=1 AND type=1 AND mat_divers_situations.codeSite=NEW.codePiezometre;;
                        IF vNbSituations > 0 THEN
                            raise notice 'Calcul volume % - %', NEW.codepiezometre, NEW.DateMesure;;
                            -- mise à jour des volumes en fonction des index
                            SELECT valeurMesure INTO vIndexPrec FROM chroniques_brutes where codepiezometre=NEW.codepiezometre AND typeId=NEW.TypeId AND datemesure<NEW.dateMesure ORDER BY dateMesure DESC LIMIT 1;;
                            IF vIndexPrec IS NOT NULL THEN
                                IF vIndexPrec<=NEW.valeurMesure THEN
                                    IF (NEW.valeurMesure - vIndexPrec)<10000 THEN
                                        NEW.valeurMesureCorrigee=(NEW.valeurMesure - vIndexPrec);;
                                        raise notice 'Volume calculé %', NEW.valeurMesureCorrigee;;
                                    ELSE
                                        NEW.valeurMesureCorrigee=0;;
                                    END IF;;
                                ELSE
                                    NEW.valeurMesureCorrigee=0;;
                                END IF;;
                            ELSE
                                NEW.valeurMesureCorrigee=0;;
                            END IF;;
                        END IF;;
                    END IF;;
                END IF;;
                RETURN NEW;;
            END;;
            $BODY2$;;
            CREATE TRIGGER trig_maj_volumes_piezo
            BEFORE INSERT OR UPDATE OF valeurmesure
            ON public.chroniques_brutes
            FOR EACH ROW
            EXECUTE PROCEDURE public.maj_volumes_piezo();;
            else
                ALTER TABLE chroniques_brutes ALTER COLUMN valeurmesure TYPE double precision USING valeurmesure::double precision;;
                ALTER TABLE chroniques_brutes ALTER COLUMN valeurngf TYPE double precision USING valeurngf::double precision;;

                ALTER TABLE chroniques_pluvio ALTER COLUMN valeurmesure TYPE double precision USING valeurmesure::double precision;;
                ALTER TABLE chroniques_pluvio ALTER COLUMN valeurmesurecorrigee TYPE double precision USING valeurmesurecorrigee::double precision;;

                ALTER TABLE chroniques_hydro ALTER COLUMN valeurmesure TYPE double precision USING valeurmesure::double precision;;
                ALTER TABLE chroniques_hydro ALTER COLUMN valeurngf TYPE double precision USING valeurngf::double precision;;
        end if;;
    end;;
    $BODY$;;

call doEvolution439();;

# --- !Downs