/**
 * @author jroba
 * @date 30/09/2024
 * @version 1.0.0
 * @project iryqua
 * @table mat_chroniques
 */

# --- !Ups

drop function if exists f_calc_dernier_index(p_idCapteur INTEGER, p_dateDebut TIMESTAMP with time zone, nbMoisRecherche INTEGER) ;

create function f_calc_dernier_index(p_idCapteur INTEGER, p_dateDebut TIMESTAMP with time zone, nbMoisRecherche INTEGER)
    returns REAL
    language plpgsql
as $$
DECLARE
    v_dateLimit1 TIMESTAMP with time zone;;
    v_dateLimit2 TIMESTAMP with time zone;;
    v_index REAL;;

BEGIN

    v_dateLimit1 = p_dateDebut - INTERVAL '1 MONTHS';;
    v_dateLimit2 = p_dateDebut + INTERVAL '1 MONTHS' * nbmoisrecherche;;
    p_dateDebut = date_trunc('day', p_dateDebut) + INTERVAL '1 day';;
    raise notice 'f_calc_dernier_index date fin: %', p_dateDebut;;

    select mesure
    into v_index
    from MAT_CHRONIQUES
    where idmateriel = p_idCapteur
      and typemesure = 2
      and dateMesure > v_dateLimit1
      AND dateMesure <= p_dateDebut
    ORDER BY dateMesure DESC
    LIMIT 1;;

    if (v_index is null) then
        select mesure
        into v_index
        from MAT_CHRONIQUES
        where idmateriel = p_idCapteur
          and typemesure = 2
          and dateMesure >= p_dateDebut
          AND dateMesure < v_dateLimit2
        ORDER BY dateMesure asc
        LIMIT 1;;
    end if;;

    raise notice 'f_calc_dernier_index : %', v_index;;

    RETURN v_index;;
END;;
$$;;

# --- !Downs