/**
 * @author jro
 * @date 10/10/2024
 * @version 1.0.0
 * @project IRYQUA
 * @table f_calc_vol_estim_point_annee
 */

# --- !Ups

create or replace function f_calc_vol_estim_point_annee(p_idexploitation bigint, p_idinstallation bigint, p_year int) returns bigint
    language plpgsql
as $$

DECLARE
v_retour                 BIGINT;;
BEGIN
select sum(chron.mesure) totalVolumeEstim
into v_retour
from agri_exploitations_points_prelevements aepp
         left join mat_divers_situations mds_pump
                   on (mds_pump.typesite = 7 and mds_pump.codesite = aepp.codeinstallation and
                       (mds_pump.datesituation is null OR
                        mds_pump.datesituation <= to_timestamp('31/12/' || p_year, 'DD/MM/YYYY')) AND
                       (mds_pump.datefinsituation is null OR
                        mds_pump.datefinsituation >= to_timestamp('31/12/' || (p_year - 1), 'DD/MM/YYYY')))
         left join mat_divers_situations mds_counter
                   on (mds_counter.typesite = 8 and mds_counter.codesite = mds_pump.id and
                       (mds_counter.datesituation is null OR
                        mds_counter.datesituation <= to_timestamp('31/12/' || p_year, 'DD/MM/YYYY') AND
                        (mds_counter.datefinsituation is null OR
                         mds_counter.datefinsituation >= to_timestamp('31/12/' || (p_year - 1), 'DD/MM/YYYY'))))
         left join mat_chroniques chron
                   on ((chron.idmateriel in (mds_pump.id) OR chron.idmateriel in (mds_counter.id)) AND
                       chron.typemesure = 1 AND
                       chron.datemesure >= to_timestamp('31/12/' || (p_year - 1), 'DD/MM/YYYY') AND
                       chron.datemesure <= to_timestamp('31/12/' || p_year, 'DD/MM/YYYY') AND
                       chron.datemesure >= coalesce(mds_counter.datesituation, coalesce(mds_pump.datesituation, coalesce(aepp.datedebut, to_timestamp('31/12/' || (p_year - 1), 'DD/MM/YYYY')))) AND
                       chron.datemesure <= coalesce(mds_counter.datefinsituation, coalesce(mds_pump.datefinsituation, coalesce(aepp.datefin, to_timestamp('31/12/' || p_year, 'DD/MM/YYYY')))))
where aepp.codeexploitation = p_idexploitation and aepp.codeinstallation = p_idinstallation
  AND (aepp.datedebut is null OR aepp.datedebut <= to_timestamp('31/12/' || p_year, 'DD/MM/YYYY'))
  AND (aepp.datefin is null OR aepp.datefin >= to_timestamp('31/12/' || (p_year - 1), 'DD/MM/YYYY'));;

RETURN v_retour;;
END;;

$$;;

alter function f_calc_vol_estim_point_annee(bigint, bigint, int) owner to postgres;

# --- !Downs

