/**
 * @author TPA
 * @date 24/06/21
 * @version 1.0.0
 * @project SIEAU
 * @table public.chroniques_pluvio
 */

# --- !Ups

create table chroniques_pluvio
(
    codepluviometre           integer                  not null,
    typeid                    integer                  not null,
    datemesure                timestamp with time zone not null,
    valeurmesure              real                     not null,
    valeurmesurecorrigee      real,
    modemesure                integer,
    statutmesure              integer,
    qualificationmesure       integer,
    naturemesure              varchar(1),
    pointinitial              integer,
    coderesponsablevalidation integer,
    codegestionnaire          integer,
    codeproducteur            integer,
    jobexecutionid            bigint,
    datecreation              timestamp with time zone,
    datemaj                   timestamp with time zone,
    loginmaj                  varchar(25)
);

create unique index chroniques_pluvio_codepluviometre_typeid_datemesure_idx
on chroniques_pluvio (codepluviometre, typeid, datemesure);

create table chroniques_pluvio_suppr
(
    codepluviometre           integer                  not null,
    typeid                    integer                  not null,
    datemesure                timestamp with time zone not null,
    valeurmesure              real                     not null,
    valeurmesurecorrigee      real,
    modemesure                integer,
    statutmesure              integer,
    qualificationmesure       integer,
    naturemesure              varchar(1),
    pointinitial              integer,
    coderesponsablevalidation integer,
    codegestionnaire          integer,
    codeproducteur            integer,
    jobexecutionid            bigint,
    datecreation              timestamp with time zone,
    datemaj                   timestamp with time zone,
    loginmaj                  varchar(25)
);

create unique index chroniques_pluvio_suppr_codepluviometre_typeid_datemesure_idx
on chroniques_pluvio_suppr (codepluviometre, typeid, datemesure);

create table chroniques_pluvio_calcul
(
    codepluviometre integer,
    typeid         integer,
    datemesure     timestamp with time zone,
    valeurmesure   real,
    pointinitial   integer,
    datecreation   timestamp with time zone,
    idmodele       integer,
    idindicateur   integer,
    incertitudemin real,
    incertitudemax real,
    classe         integer,
    tendance       integer
);

create index ind_chroniques_pluvio_calcul
on chroniques_pluvio_calcul (codepluviometre, typeid);

# --- !Downs

drop table chroniques_pluvio;
drop table chroniques_pluvio_suppr;
drop table chroniques_pluvio_calcul;