/**
 * @author jroba
 * @date 29/10/2024
 * @version 1.0.0
 * @project IRYQUA
 * @table
 */

# --- !Ups
create or replace function f_calc_volume_repartition(p_idusageprevi bigint) returns character varying
    language plpgsql
as $$
DECLARE
v_repartition      CHARACTER VARYING(255);;
    recUsages          RECORD;;
    recEtiages         RECORD;;
    recPeriodes        RECORD;;
    v_volumeAnnuel     REAL;;
    v_calcVolume       REAL;;
    v_codeInstallation BIGINT;;
    v_idCulture        BIGINT;;
    v_enqueteId        BIGINT;;
    v_annee            INTEGER;;
    v_usageid          BIGINT;;
    v_debutEtiage      TIMESTAMP;;
    v_finEtiage        TIMESTAMP;;
    v_moisDebut        INTEGER;;
    v_moisFin          INTEGER;;
    v_usageAnnee       BOOLEAN;;
    v_periodeDefaut    BIGINT;;
    v_nbPeriodes       INTEGER;;
    v_mois01           REAL;;
    v_mois02           REAL;;
    v_mois03           REAL;;
    v_mois04           REAL;;
    v_mois05           REAL;;
    v_mois06           REAL;;
    v_mois07           REAL;;
    v_mois08           REAL;;
    v_mois09           REAL;;
    v_mois10           REAL;;
    v_mois11           REAL;;
    v_mois12           REAL;;
BEGIN

    v_volumeAnnuel := 0;;
-- Récupération de l'usage: culture ? ou autre ?
SELECT codeInstallation, volumeDemandeAnnuel, idCulture, enqueteid, idUsage, annee
INTO v_codeInstallation, v_volumeAnnuel, v_idCulture, v_enqueteId, v_usageid, v_annee
FROM agri_prel_usages_previ
         inner join agri_enquetes on (agri_prel_usages_previ.enqueteid = agri_enquetes.id)
WHERE idUsagePrevi = p_idUsagePrevi;;

raise notice 'volume: %', v_volumeAnnuel;;

    IF v_volumeAnnuel = 0 OR v_volumeAnnuel IS NULL OR v_codeInstallation IS NULL OR v_enqueteId IS NULL THEN
-- pas de volume demandé
        v_repartition := ';;;;;;;;;;;;;;';;
ELSE
        v_moisDebut := 6;;
        v_moisFin := 9;;
        v_repartition := '';;

-- Récupération du point donc des périodes d'étiage de l'UGE
SELECT dateDebutEtiage, dateFinEtiage
INTO v_debutEtiage, v_finEtiage
FROM aep_installations
         LEFT JOIN aep_uge on (aep_installations.codeuge = aep_uge.codeuge)
WHERE codeInstallation = v_codeInstallation;;

IF v_debutEtiage IS NOT NULL THEN
            v_moisDebut := EXTRACT(MONTH FROM v_debutEtiage);;
END IF;;
        IF v_finEtiage IS NOT NULL THEN
            v_moisFin := EXTRACT(MONTH FROM v_finEtiage);;
END IF;;
        raise notice 'repartition : %', v_repartition;;
        v_calcVolume := ROUND(v_volumeAnnuel / 12 * (v_moisFin - v_moisDebut));;
        v_repartition := v_repartition || v_calcVolume || ';;';;
        raise notice 'repartition : %', v_repartition;;
        v_calcVolume := ROUND(v_volumeAnnuel - v_calcVolume);;
        v_repartition := v_repartition || v_calcVolume || ';;';;
        raise notice 'repartition : %', v_repartition;;
        raise notice 'début / fin étiage : % / %', v_moisDebut, v_moisFin;;
        raise notice 'repartition etiage/hors etiage: %', v_repartition;;

        IF v_idCulture IS NOT NULL THEN
-- si culture, répartition par mois en fonction des besoins de la culture
            raise notice 'repartition culture: %', v_repartition;;
SELECT mois01,
       mois02,
       mois03,
       mois04,
       mois05,
       mois06,
       mois07,
       mois08,
       mois09,
       mois10,
       mois11,
       mois12
INTO v_mois01, v_mois02, v_mois03, v_mois04, v_mois05, v_mois06, v_mois07, v_mois08, v_mois09, v_mois10, v_mois11, v_mois12
FROM agri_cultures_ventilations
where cid = v_idCulture
  and annee <= v_annee;;

v_calcVolume := 0;;
            IF v_mois01 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois01 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Janvier
            v_calcVolume := 0;;
            IF v_mois02 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois02 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Février
            v_calcVolume := 0;;
            IF v_mois03 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois03 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Mars
            v_calcVolume := 0;;
            IF v_mois04 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois04 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Avril
            v_calcVolume := 0;;
            IF v_mois05 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois05 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Mai
            v_calcVolume := 0;;
            IF v_mois06 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois06 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Juin
            v_calcVolume := 0;;
            IF v_mois07 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois07 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Juillet
            v_calcVolume := 0;;
            IF v_mois08 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois08 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Aout
            v_calcVolume := 0;;
            IF v_mois09 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois09 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Septembre
            v_calcVolume := 0;;
            IF v_mois10 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois10 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Octobre
            v_calcVolume := 0;;
            IF v_mois11 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois11 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Novembre
            v_calcVolume := 0;;
            IF v_mois12 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois12 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Decembre
ELSE
-- si autre usage, on réparti en fonction de la ventilation souhaitée (année/période (hiver, printemps, été, automne))
SELECT true
INTO v_usageAnnee
FROM agri_prel_usages_previ_periodes
WHERE idusage = p_idUsagePrevi
  and (idperiode = 1 OR (idPeriode = 2 AND idNumeroPeriode IS NULL));;
IF v_usageAnnee THEN
-- répartition annuelle
                v_calcVolume := ROUND(v_volumeAnnuel / 12);;
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Janvier
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Fevrier
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Mars
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Avril
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Mai
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Juin
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Juillet
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Aout
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Septembre
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Octobre
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Novembre
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Decembre
                raise notice 'repartition annuel: %', v_usageAnnee;;
ELSE
-- Calcul du nombre de périodes pour ensuite répartir la demande par mois
SELECT count(idNumeroPeriode)
INTO v_nbPeriodes
FROM agri_prel_usages_previ_periodes
WHERE idusage = p_idUsagePrevi;;
v_calcVolume := ROUND(v_volumeAnnuel / (coalesce(NULLIF(v_nbPeriodes, 0), 1) * 3));;

-- TODO récupérer les périodes pour faire la répartition suivant les saisons
FOR recPeriodes IN SELECT code, agri_prel_usages_previ_periodes.idNumeroPeriode
                   FROM codes_sandre
                            left join agri_prel_usages_previ_periodes on (codes_sandre.code =
                                                                          agri_prel_usages_previ_periodes.idNumeroPeriode and
                                                                          idusage = p_idUsagePrevi)
                   WHERE champ = 'USAGES.PERIODES_DETAILS'
                   order by code ASC
                       LOOP
                        IF recPeriodes.code = 1 and recPeriodes.idNumeroPeriode IS NOT NULL THEN
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Janvier
v_repartition := v_repartition || v_calcVolume || ';;';; -- Fevrier
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Mars
                        ELSIF recPeriodes.code = 1 THEN
                            v_repartition := v_repartition || ';;';; -- Janvier
                            v_repartition := v_repartition || ';;';; -- Fevrier
                            v_repartition := v_repartition || ';;';; -- Mars
END IF;;
                        IF recPeriodes.code = 2 and recPeriodes.idNumeroPeriode IS NOT NULL THEN
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Avril
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Mai
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Juin
                        ELSIF recPeriodes.code = 2 THEN
                            v_repartition := v_repartition || ';;';; -- Avril
                            v_repartition := v_repartition || ';;';; -- Mai
                            v_repartition := v_repartition || ';;';; -- Juin
END IF;;
                        IF recPeriodes.code = 3 and recPeriodes.idNumeroPeriode IS NOT NULL THEN
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Juillet
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Aout
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Septembre
                        ELSIF recPeriodes.code = 3 THEN
                            v_repartition := v_repartition || ';;';; -- Juillet
                            v_repartition := v_repartition || ';;';; -- Aout
                            v_repartition := v_repartition || ';;';; -- Septembre
END IF;;
                        IF recPeriodes.code = 4 and recPeriodes.idNumeroPeriode IS NOT NULL THEN
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Octobre
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Novembre
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Decembre
                        ELSIF recPeriodes.code = 4 THEN
                            v_repartition := v_repartition || ';;';; -- Octobre
                            v_repartition := v_repartition || ';;';; -- Novembre
                            v_repartition := v_repartition || ';;';; -- Decembre
END IF;;
END LOOP;;

                raise notice 'repartition saison: %', v_nbPeriodes;;
END IF;;
END IF;;

END IF;;

-- retour sous la forme: <vol hors étiage>;;<vol étiage>;; <vol janv>;; ... ;;<vol dec>;;
    raise notice 'répartition: %', v_repartition;;
RETURN v_repartition;;

END;;

$$;;





-- 2e version de la fonction


create or replace function f_calc_volume_repartition(p_idusageprevi bigint, typevolume text) returns character varying
    language plpgsql
as
$$
DECLARE
v_repartition      CHARACTER VARYING(255);;
    recPeriodes        RECORD;;
    v_volumeDemande    REAL;;
    v_volumeAttribue   REAL;;
    v_volumeAutorise   REAL;;
    v_volumeAnnuel     REAL;;
    v_calcVolume       REAL;;
    v_codeInstallation BIGINT;;
    v_idCulture        BIGINT;;
    v_enqueteId        BIGINT;;
    v_annee            INTEGER;;
    v_usageid          BIGINT;;
    v_uge              BIGINT;;
    v_debutEtiage      TIMESTAMP;;
    v_finEtiage        TIMESTAMP;;
    v_moisDebut        INTEGER;;
    v_moisFin          INTEGER;;
    v_usageAnnee       BOOLEAN;;
    v_nbPeriodes       INTEGER;;
    v_mois01           REAL;;
    v_mois02           REAL;;
    v_mois03           REAL;;
    v_mois04           REAL;;
    v_mois05           REAL;;
    v_mois06           REAL;;
    v_mois07           REAL;;
    v_mois08           REAL;;
    v_mois09           REAL;;
    v_mois10           REAL;;
    v_mois11           REAL;;
    v_mois12           REAL;;
BEGIN

    v_volumeAnnuel := 0;;
-- Récupération de l'usage: culture ? ou autre ?
SELECT codeInstallation, idCulture, enqueteid, idUsage, annee
INTO v_codeInstallation, v_idCulture, v_enqueteId, v_usageid, v_annee
FROM agri_prel_usages_previ
         inner join agri_enquetes on (agri_prel_usages_previ.enqueteid = agri_enquetes.id)
WHERE idUsagePrevi = p_idUsagePrevi;;

SELECT volumedemande, volumeattribue, volumeautorise
INTO v_volumeDemande, v_volumeAttribue, v_volumeAutorise
FROM agri_prel_volumes apv
         inner join agri_enquetes on (apv.idenquete = agri_enquetes.id)
WHERE apv.idUsagePrevi = p_idUsagePrevi;;

if (typeVolume = 'requested') then
        v_volumeAnnuel := v_volumeDemande;;
    elsif (typeVolume = 'allocated') then
        v_volumeAnnuel := v_volumeAttribue;;
    elsif (typeVolume = 'authorized') then
        v_volumeAnnuel := v_volumeAutorise;;
else
        v_volumeAnnuel := v_volumeDemande;;
end if;;

    raise notice 'volume: %', v_volumeAnnuel;;

    IF v_volumeAnnuel = 0 OR v_volumeAnnuel IS NULL OR v_codeInstallation IS NULL OR v_enqueteId IS NULL THEN
-- pas de volume demandé
        v_repartition := ';;;;;;;;;;;;;;';;
ELSE
        v_moisDebut := 6;;
        v_moisFin := 9;;
        v_repartition := '';;

-- Récupération du point donc des périodes d'étiage de l'UGE
SELECT dateDebutEtiage, dateFinEtiage, coalesce(aep_installations.codesousuge, aep_installations.codeuge)
INTO v_debutEtiage, v_finEtiage, v_uge
FROM aep_installations
         LEFT JOIN aep_uge
                   on (aep_uge.codeuge = coalesce(aep_installations.codesousuge, aep_installations.codeuge))
WHERE codeInstallation = v_codeInstallation;;

IF v_debutEtiage IS NOT NULL THEN
            v_moisDebut := EXTRACT(MONTH FROM v_debutEtiage);;
END IF;;
        IF v_finEtiage IS NOT NULL THEN
            v_moisFin := EXTRACT(MONTH FROM v_finEtiage);;
END IF;;
        raise notice 'repartition : %', v_repartition;;
        v_calcVolume := ROUND(v_volumeAnnuel / 12 * (v_moisFin - v_moisDebut));;
        v_repartition := v_repartition || v_calcVolume || ';;';;
        raise notice 'repartition : %', v_repartition;;
        v_calcVolume := ROUND(v_volumeAnnuel - v_calcVolume);;
        v_repartition := v_repartition || v_calcVolume || ';;';;
        raise notice 'repartition : %', v_repartition;;
        raise notice 'repartition etiage/hors etiage: %', v_repartition;;

        IF v_idCulture IS NOT NULL THEN
-- si culture, répartition par mois en fonction des besoins de la culture
            raise notice 'repartition culture: %', v_repartition;;
SELECT mois01,
       mois02,
       mois03,
       mois04,
       mois05,
       mois06,
       mois07,
       mois08,
       mois09,
       mois10,
       mois11,
       mois12
INTO v_mois01, v_mois02, v_mois03, v_mois04, v_mois05, v_mois06, v_mois07, v_mois08, v_mois09, v_mois10, v_mois11, v_mois12
FROM agri_cultures_ventilations
where cid = v_idCulture
  and annee <= v_annee
  and (codeuge = v_uge or codeuge is null)
order by annee desc, codeuge
    limit 1;;

v_calcVolume := 0;;
            IF v_mois01 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois01 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Janvier
            v_calcVolume := 0;;
            IF v_mois02 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois02 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Février
            v_calcVolume := 0;;
            IF v_mois03 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois03 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Mars
            v_calcVolume := 0;;
            IF v_mois04 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois04 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Avril
            v_calcVolume := 0;;
            IF v_mois05 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois05 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Mai
            v_calcVolume := 0;;
            IF v_mois06 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois06 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Juin
            v_calcVolume := 0;;
            IF v_mois07 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois07 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Juillet
            v_calcVolume := 0;;
            IF v_mois08 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois08 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Aout
            v_calcVolume := 0;;
            IF v_mois09 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois09 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Septembre
            v_calcVolume := 0;;
            IF v_mois10 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois10 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Octobre
            v_calcVolume := 0;;
            IF v_mois11 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois11 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Novembre
            v_calcVolume := 0;;
            IF v_mois12 IS NOT NULL THEN
                v_calcVolume := ROUND(v_volumeAnnuel * v_mois12 / 100);;
END IF;;
            v_repartition := v_repartition || v_calcVolume || ';;';; -- Decembre
ELSE
-- si autre usage, on réparti en fonction de la ventilation souhaitée (année/période (hiver, printemps, été, automne))
SELECT true
INTO v_usageAnnee
FROM agri_prel_usages_previ_periodes
WHERE idusage = p_idUsagePrevi
  and (idperiode = 1 OR (idPeriode = 2 AND idNumeroPeriode IS NULL));;
IF v_usageAnnee THEN
-- répartition annuelle
                v_calcVolume := ROUND(v_volumeAnnuel / 12);;
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Janvier
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Fevrier
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Mars
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Avril
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Mai
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Juin
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Juillet
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Aout
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Septembre
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Octobre
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Novembre
                v_repartition := v_repartition || v_calcVolume || ';;';; -- Decembre
                raise notice 'repartition annuel: %', v_usageAnnee;;
ELSE
-- Calcul du nombre de périodes pour ensuite répartir la demande par mois
SELECT count(idNumeroPeriode)
INTO v_nbPeriodes
FROM agri_prel_usages_previ_periodes
WHERE idusage = p_idUsagePrevi;;
v_calcVolume := ROUND(v_volumeAnnuel / (coalesce(NULLIF(v_nbPeriodes, 0), 1) * 3));;

-- TODO récupérer les périodes pour faire la répartition suivant les saisons
FOR recPeriodes IN SELECT code, agri_prel_usages_previ_periodes.idNumeroPeriode
                   FROM codes_sandre
                            left join agri_prel_usages_previ_periodes on (codes_sandre.code =
                                                                          agri_prel_usages_previ_periodes.idNumeroPeriode and
                                                                          idusage = p_idUsagePrevi)
                   WHERE champ = 'USAGES.PERIODES_DETAILS'
                   order by code ASC
                       LOOP
                        IF recPeriodes.code = 1 and recPeriodes.idNumeroPeriode IS NOT NULL THEN
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Janvier
v_repartition := v_repartition || v_calcVolume || ';;';; -- Fevrier
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Mars
                        ELSIF recPeriodes.code = 1 THEN
                            v_repartition := v_repartition || ';;';; -- Janvier
                            v_repartition := v_repartition || ';;';; -- Fevrier
                            v_repartition := v_repartition || ';;';; -- Mars
END IF;;
                        IF recPeriodes.code = 2 and recPeriodes.idNumeroPeriode IS NOT NULL THEN
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Avril
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Mai
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Juin
                        ELSIF recPeriodes.code = 2 THEN
                            v_repartition := v_repartition || ';;';; -- Avril
                            v_repartition := v_repartition || ';;';; -- Mai
                            v_repartition := v_repartition || ';;';; -- Juin
END IF;;
                        IF recPeriodes.code = 3 and recPeriodes.idNumeroPeriode IS NOT NULL THEN
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Juillet
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Aout
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Septembre
                        ELSIF recPeriodes.code = 3 THEN
                            v_repartition := v_repartition || ';;';; -- Juillet
                            v_repartition := v_repartition || ';;';; -- Aout
                            v_repartition := v_repartition || ';;';; -- Septembre
END IF;;
                        IF recPeriodes.code = 4 and recPeriodes.idNumeroPeriode IS NOT NULL THEN
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Octobre
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Novembre
                            v_repartition := v_repartition || v_calcVolume || ';;';; -- Decembre
                        ELSIF recPeriodes.code = 4 THEN
                            v_repartition := v_repartition || ';;';; -- Octobre
                            v_repartition := v_repartition || ';;';; -- Novembre
                            v_repartition := v_repartition || ';;';; -- Decembre
END IF;;
END LOOP;;

                raise notice 'repartition saison: %', v_nbPeriodes;;
END IF;;
END IF;;

END IF;;

-- retour sous la forme: <vol hors étiage>;;<vol étiage>;; <vol janv>;; ... ;; <vol dec>;;
    raise notice 'répartition: %', v_repartition;;
RETURN v_repartition;;

END;;
$$;;



# --- !Downs