/**
 * @author tpa
 * @date 28/11/2024
 * @version 1.0.0
 * @project sieau
 * @table entites_hydrogeologiques
 */

# --- !Ups

WITH groupbycodesandre AS (
    select gp.* from (SELECT codeentitehydro, code_sandre,
           ROW_NUMBER() OVER (PARTITION BY code_sandre ORDER BY codeentitehydro) AS rnum
    FROM entites_hydrogeologiques) gp where gp.rnum = 1
), eh as (select * from entites_hydrogeologiques)
UPDATE lien_qualito_entite_hydro leh
SET codeentitehydro = groupbycodesandre.codeentitehydro
    FROM groupbycodesandre, eh
WHERE eh.codeentitehydro = leh.codeentitehydro and leh.codeentitehydro = groupbycodesandre.codeentitehydro and eh.code_sandre = groupbycodesandre.code_sandre;

WITH groupbycodesandre AS (
    select gp.* from (SELECT codeentitehydro, code_sandre,
                             ROW_NUMBER() OVER (PARTITION BY code_sandre ORDER BY codeentitehydro) AS rnum
                      FROM entites_hydrogeologiques) gp where gp.rnum = 1
), eh as (select * from entites_hydrogeologiques)
UPDATE lien_piezo_entite_hydro leh
SET codeentitehydro = groupbycodesandre.codeentitehydro
    FROM groupbycodesandre, eh
WHERE eh.codeentitehydro = leh.codeentitehydro and leh.codeentitehydro = groupbycodesandre.codeentitehydro and eh.code_sandre = groupbycodesandre.code_sandre;

delete from entites_hydrogeologiques where codeentitehydro in (select gp.codeentitehydro from (SELECT codeentitehydro, code_sandre,
      ROW_NUMBER() OVER (PARTITION BY code_sandre ORDER BY codeentitehydro) AS rnum
FROM entites_hydrogeologiques) gp where gp.rnum > 1);

create unique index if not exists entites_hydrogeologiques_code_sandre_uindex
    on entites_hydrogeologiques (code_sandre);

# --- !Downs
