/**
 * @author tpa
 * @date 28/11/2024
 * @version 1.0.0
 * @project sieau
 * @table qualitometres_points_operations, qualitometres_points, chroniques_analyses
 */

# --- !Ups

-- fonction de correction des doublons sur les opérations (supprime les opérations si un doublon est détecté)
create or replace function correctDoublonsOperations() returns double precision
    language plpgsql
as
$$
DECLARE
d_count double precision;;
    row_count integer;;
BEGIN
insert into journal (dateevt, titre, description) values (now(), 'Lancement de la fonction correctDoublonsOperations()', 'correctDoublonsOperations');;
-- count du nombre de doublons
select count(gp.*) from (select codequalitometre, datedebut, codeproducteur, codecampagne, supportbiologique, codepoint,
                                ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(datedebut, '1988-02-15 02:36:21'), coalesce(codeproducteur, -8000.0), coalesce(codecampagne, -8000.0), coalesce(supportbiologique, 3), coalesce(codepoint, -8000.0)) as rnum
                         from qualitometres_points_operations) gp
where rnum > 1 INTO d_count;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de doublons à supprimer : ' || d_count::text, 'correctDoublonsOperations');;

-- suppression des doublons : prelevements_echantillons
delete from prelevements_echantillons where (codequalitometre, numprelevement) in (
    select codequalitometre, numprelevement from prelevements where (codequalitometre, codeoperation) in (
        select gp.codequalitometre, gp.codeoperation from (select codequalitometre, codeoperation,
                                                                  ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(datedebut, '1988-02-15 02:36:21'), coalesce(codeproducteur, -8000.0), coalesce(codecampagne, -8000.0), coalesce(supportbiologique, 3), coalesce(codepoint, -8000.0)) as rnum
                                                           from qualitometres_points_operations) gp
        where rnum > 1));;
GET DIAGNOSTICS row_count = ROW_COUNT;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de suppressions (prelevements_echantillons) : ' || row_count::text, 'correctDoublonsOperations');;

-- suppression des doublons : chroniques_analyses
delete from chroniques_analyses where (codequalitometre, codeoperation) in (
    select gp.codequalitometre, gp.codeoperation from (select codequalitometre, codeoperation,
                                                              ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(datedebut, '1988-02-15 02:36:21'), coalesce(codeproducteur, -8000.0), coalesce(codecampagne, -8000.0), coalesce(supportbiologique, 3), coalesce(codepoint, -8000.0)) as rnum
                                                       from qualitometres_points_operations) gp
    where rnum > 1);;
GET DIAGNOSTICS row_count = ROW_COUNT;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de suppressions (chroniques_analyses) : ' || row_count::text, 'correctDoublonsOperations');;

-- suppression des doublons : prelevements
delete from prelevements where (codequalitometre, codeoperation) in (
    select gp.codequalitometre, gp.codeoperation from (select codequalitometre, codeoperation,
                                                              ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(datedebut, '1988-02-15 02:36:21'), coalesce(codeproducteur, -8000.0), coalesce(codecampagne, -8000.0), coalesce(supportbiologique, 3), coalesce(codepoint, -8000.0)) as rnum
                                                       from qualitometres_points_operations) gp
    where rnum > 1);;
GET DIAGNOSTICS row_count = ROW_COUNT;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de suppressions (prelevements) : ' || row_count::text, 'correctDoublonsOperations');;

-- suppression des doublons : qualitometres_points_operations_reseaux
delete from qualitometres_points_operations_reseaux where (codequalitometre, codeoperation) in (
    select gp.codequalitometre, gp.codeoperation from (select codequalitometre, codeoperation,
                                                              ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(datedebut, '1988-02-15 02:36:21'), coalesce(codeproducteur, -8000.0), coalesce(codecampagne, -8000.0), coalesce(supportbiologique, 3), coalesce(codepoint, -8000.0)) as rnum
                                                       from qualitometres_points_operations) gp
    where rnum > 1);;
GET DIAGNOSTICS row_count = ROW_COUNT;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de suppressions (qualitometres_points_operations_reseaux) : ' || row_count::text, 'correctDoublonsOperations');;

-- suppression des doublons : qualitometres_points_operations_env
delete from qualitometres_points_operations_env where (codequalitometre, codeoperation) in (
    select gp.codequalitometre, gp.codeoperation from (select codequalitometre, codeoperation,
                                                              ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(datedebut, '1988-02-15 02:36:21'), coalesce(codeproducteur, -8000.0), coalesce(codecampagne, -8000.0), coalesce(supportbiologique, 3), coalesce(codepoint, -8000.0)) as rnum
                                                       from qualitometres_points_operations) gp
    where rnum > 1);;
GET DIAGNOSTICS row_count = ROW_COUNT;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de suppressions (qualitometres_points_operations_env) : ' || row_count::text, 'correctDoublonsOperations');;

-- suppression des doublons : qualitometres_operations_resultats
delete from qualitometres_operations_resultats where (codequalitometre, codeoperation) in (
    select gp.codequalitometre, gp.codeoperation from (select codequalitometre, codeoperation,
                                                              ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(datedebut, '1988-02-15 02:36:21'), coalesce(codeproducteur, -8000.0), coalesce(codecampagne, -8000.0), coalesce(supportbiologique, 3), coalesce(codepoint, -8000.0)) as rnum
                                                       from qualitometres_points_operations) gp
    where rnum > 1);;
GET DIAGNOSTICS row_count = ROW_COUNT;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de suppressions (qualitometres_operations_resultats) : ' || row_count::text, 'correctDoublonsOperations');;

-- suppression des doublons : qualitometres_points_operations
delete from qualitometres_points_operations where (codequalitometre, codeoperation) in (
    select gp.codequalitometre, gp.codeoperation from (select codequalitometre, codeoperation,
                                                              ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(datedebut, '1988-02-15 02:36:21'), coalesce(codeproducteur, -8000.0), coalesce(codecampagne, -8000.0), coalesce(supportbiologique, 3), coalesce(codepoint, -8000.0)) as rnum
                                                       from qualitometres_points_operations) gp
    where rnum > 1);;
GET DIAGNOSTICS row_count = ROW_COUNT;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de suppressions (qualitometres_points_operations) : ' || row_count::text, 'correctDoublonsOperations');;

-- création de l'index
create unique index if not exists qualitometres_points_operations_uniq_idx
    on qualitometres_points_operations (codequalitometre, coalesce(datedebut, '1988-02-15 02:36:21'), coalesce(codeproducteur, -8000.0), coalesce(codecampagne, -8000.0), coalesce(supportbiologique, 3), coalesce(codepoint, -8000.0));;

insert into journal (dateevt, titre, description) values (now(), 'Fin de la fonction correctDoublonsOperations()', 'correctDoublonsOperations');;
return d_count;;
END;;
$$;;


-- fonction de correction des doublons sur les opérations (supprime les opérations si un doublon est détecté)
create or replace function correctDoublonsAnalyses() returns double precision
    language plpgsql
as
$$
DECLARE
d_count double precision;;
    row_count integer;;
BEGIN
insert into journal (dateevt, titre, description) values (now(), 'Lancement de la fonction correctDoublonsAnalyses()', 'correctDoublonsAnalyses');;
-- count du nombre de doublons
select count(gp.*) from (select codequalitometre,
                                ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(codeoperation, -8000), coalesce(codelabo, -8000.0), coalesce(codelieu, 'KWAK'), coalesce(codeparametre, 'KWAK'), coalesce(codeunite, 'KWAK'), coalesce(codefraction, 'KWAK'), coalesce(numechantillon, -8000)) as rnum
                         from chroniques_analyses) gp
where rnum > 1 INTO d_count;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de doublons à supprimer : ' || d_count::text, 'correctDoublonsAnalyses');;

-- suppression des doublons : chroniques_analyses
delete from chroniques_analyses where (numanalyse) in (select gp.numanalyse from (select numanalyse,
                                                                                         ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(codeoperation, -8000), coalesce(codelabo, -8000.0), coalesce(codelieu, 'KWAK'), coalesce(codeparametre, 'KWAK'), coalesce(codeunite, 'KWAK'), coalesce(codefraction, 'KWAK'), coalesce(numechantillon, -8000)) as rnum
                                                                                  from chroniques_analyses) gp where rnum > 1);;
GET DIAGNOSTICS row_count = ROW_COUNT;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de suppressions (chroniques_analyses) : ' || row_count::text, 'correctDoublonsAnalyses');;

-- création de l'index
create unique index if not exists chroniques_analyses_uniq_idx
    on chroniques_analyses (codequalitometre, coalesce(codeoperation, -8000), coalesce(codelabo, -8000.0), coalesce(codelieu, 'KWAK'), coalesce(codeparametre, 'KWAK'), coalesce(codeunite, 'KWAK'), coalesce(codefraction, 'KWAK'), coalesce(numechantillon, -8000));;

insert into journal (dateevt, titre, description) values (now(), 'Fin de la fonction correctDoublonsAnalyses()', 'correctDoublonsAnalyses');;
return d_count;;
END;;
$$;;


-- fonction de correction/fusion des points de prel (supprime les opérations si un doublon est détecté)
create or replace function correctDoublonsPointPrel() returns double precision
    language plpgsql
as
$$
DECLARE
my_cursor_point  REFCURSOR;;
    pointprel         RECORD;;
    v_requete     VARCHAR (2000);;
    d_count double precision;;
    row_count integer;;
BEGIN
insert into journal (dateevt, titre, description) values (now(), 'Lancement de la fonction correctDoublonsPointPrel()', 'correctDoublonsPointPrel');;
-- count du nombre de doublons
select count(gp.*) from (select codequalitometre, codepoint,
                                ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(codesupportdefaut, 3), coalesce(x, -8000.0), coalesce(y, -8000.0), coalesce(typeprojection, -8000.0), lower(coalesce(identifiant, '031')), lower(coalesce(nom, 'eau')), lower(coalesce(code, '031')), coalesce(profdebut, -8000.0), coalesce(proffin, -8000.0)) as rnum
                         from qualitometres_points) gp where rnum > 1 INTO d_count;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de doublons à supprimer : ' || d_count::text, 'correctDoublonsPointPrel');;


-- suppression temporaire de l'index sur les opérations
DROP index if exists qualitometres_points_operations_uniq_idx;;

-- on récupère tous les points de prélèvements en doublon
OPEN my_cursor_point FOR (select gp.* from (select codequalitometre, codepoint,
           ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(codesupportdefaut, 3), coalesce(x, -8000.0), coalesce(y, -8000.0), coalesce(typeprojection, -8000.0), lower(coalesce(identifiant, '031')), lower(coalesce(nom, 'eau')), lower(coalesce(code, '031')), coalesce(profdebut, -8000.0), coalesce(proffin, -8000.0)) as rnum
    from qualitometres_points) gp where rnum > 1);;

LOOP
FETCH my_cursor_point into pointprel;;
        EXIT WHEN NOT FOUND;;
        -- correction de la date de début du point de prel (prend le min de tous les doublons)
insert into journal (dateevt, titre, description) values (now(), 'correction de la date de début du point de prel, codequalitometre : ' || pointprel.codequalitometre || ', codepoint : ' || pointprel.codepoint, 'correctDoublonsPointPrel');;

v_requete := 'update qualitometres_points set datedebut = (select min(datedebut) from qualitometres_points where codequalitometre = ' || pointprel.codequalitometre  || ' group by codequalitometre) where codequalitometre = ' || pointprel.codequalitometre;;
execute v_requete;;

-- mise à jour des opérations du point pour les mettre sur celui qu'on va garder
insert into journal (dateevt, titre, description) values (now(), 'mise à jour des opérations du point pour les mettre sur celui qu on va garder, codequalitometre : ' || pointprel.codequalitometre || ', codepoint : ' || pointprel.codepoint, 'correctDoublonsPointPrel');;
v_requete := 'update qualitometres_points_operations set codepoint = (select gp.codepoint from ' ||
                     '(select codepoint, ROW_NUMBER() OVER (PARTITION BY codequalitometre, codesupportdefaut,' ||
                     'x, y, typeprojection, lower(identifiant), lower(nom), lower(code), profdebut, proffin) as rnum ' ||
                     'from qualitometres_points where codequalitometre = ' || pointprel.codequalitometre || ') gp where rnum = 1) where codequalitometre = ' || pointprel.codequalitometre  || ' and codepoint = ' || pointprel.codepoint;;
execute v_requete;;

-- suppression du point en doublon
insert into journal (dateevt, titre, description) values (now(), 'suppression du point de prel, codequalitometre : ' || pointprel.codequalitometre || ', codepoint : ' || pointprel.codepoint, 'correctDoublonsPointPrel');;
v_requete := 'delete from qualitometres_points where codequalitometre = ' || pointprel.codequalitometre || ' and codepoint = ' || pointprel.codepoint;;
execute v_requete;;
END LOOP;;
close my_cursor_point;;

-- correction des éventuels doublons sur les opérations qui on ainsi été créés
perform correctDoublonsOperations();;

    -- création de l'index
create unique index if not exists qualitometres_points_uniq_idx
    on qualitometres_points (codequalitometre, coalesce(codesupportdefaut, 3), coalesce(x, -8000.0), coalesce(y, -8000.0), coalesce(typeprojection, -8000.0), lower(coalesce(identifiant, '031')), lower(coalesce(nom, 'eau')), lower(coalesce(code, '031')), coalesce(profdebut, -8000.0), coalesce(proffin, -8000.0));;

insert into journal (dateevt, titre, description) values (now(), 'Fin de la fonction correctDoublonsPointPrel()', 'correctDoublonsPointPrel');;
RETURN d_count;;
END;;
$$;;

# --- !Downs
