/**
 * @author tpa
 * @date 17/12/2024
 * @version 1.0.0
 * @project sieau
 * @table qualitometres_points_operations, qualitometres_points, chroniques_analyses
 */

# --- !Ups

-- fonction de correction/fusion des points de prel (supprime les opérations si un doublon est détecté)
create or replace function correctDoublonsPointPrel() returns double precision
    language plpgsql
as
$$
DECLARE
my_cursor_point  REFCURSOR;;
    pointprel         RECORD;;
    v_requete     VARCHAR (2000);;
    d_count double precision;;
    row_count integer;;
BEGIN
insert into journal (dateevt, titre, description) values (now(), 'Lancement de la fonction correctDoublonsPointPrel()', 'correctDoublonsPointPrel');;
-- count du nombre de doublons
select count(gp.*) from (select codequalitometre, codepoint,
                                ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(codesupportdefaut, 3), coalesce(x, -8000.0), coalesce(y, -8000.0), coalesce(typeprojection, -8000.0), lower(coalesce(identifiant, '031')), lower(coalesce(nom, 'eau')), lower(coalesce(code, '031')), coalesce(profdebut, -8000.0), coalesce(proffin, -8000.0)) as rnum
                         from qualitometres_points) gp where rnum > 1 INTO d_count;;
insert into journal (dateevt, titre, description) values (now(), 'Nombre de doublons à supprimer : ' || d_count::text, 'correctDoublonsPointPrel');;


-- suppression temporaire de l'index sur les opérations
DROP index if exists qualitometres_points_operations_uniq_idx;;

-- on récupère tous les points de prélèvements en doublon
OPEN my_cursor_point FOR (select gp.* from (select codequalitometre, codepoint, coalesce(codesupportdefaut, 3) codesupportdefaut, coalesce(x, -8000.0) x, coalesce(y, -8000.0) y, coalesce(typeprojection, -8000.0) typeprojection, lower(coalesce(identifiant, '031')) identifiant, lower(coalesce(nom, 'eau')) nom, lower(coalesce(code, '031')) code, coalesce(profdebut, -8000.0) profdebut, coalesce(proffin, -8000.0) proffin,
                                                       ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(codesupportdefaut, 3), coalesce(x, -8000.0), coalesce(y, -8000.0), coalesce(typeprojection, -8000.0), lower(coalesce(identifiant, '031')), lower(coalesce(nom, 'eau')), lower(coalesce(code, '031')), coalesce(profdebut, -8000.0), coalesce(proffin, -8000.0)) as rnum
                                                from qualitometres_points) gp where rnum > 1);;

LOOP
FETCH my_cursor_point into pointprel;;
        EXIT WHEN NOT FOUND;;
        -- correction de la date de début du point de prel (prend le min de tous les doublons)
insert into journal (dateevt, titre, description) values (now(), 'correction de la date de début du point de prel, codequalitometre : ' || pointprel.codequalitometre || ', codepoint : ' || pointprel.codepoint, 'correctDoublonsPointPrel');;

v_requete := 'update qualitometres_points set datedebut = (select min(datedebut) from qualitometres_points where codequalitometre = ' || pointprel.codequalitometre  || ' group by codequalitometre) where codequalitometre = ' || pointprel.codequalitometre;;
execute v_requete;;

-- mise à jour des opérations du point pour les mettre sur celui qu'on va garder
insert into journal (dateevt, titre, description) values (now(), 'mise à jour des opérations du point pour les mettre sur celui qu on va garder, codequalitometre : ' || pointprel.codequalitometre || ', codepoint : ' || pointprel.codepoint, 'correctDoublonsPointPrel');;
v_requete := 'update qualitometres_points_operations set codepoint = (select gp.codepoint from ' ||
                     '(select codepoint, ROW_NUMBER() OVER (PARTITION BY codequalitometre, coalesce(codesupportdefaut, 3),' ||
                     'coalesce(x, -8000.0), coalesce(y, -8000.0), coalesce(typeprojection, -8000.0), lower(coalesce(identifiant, ''031'')), lower(coalesce(nom, ''eau'')), lower(coalesce(code, ''031'')), coalesce(profdebut, -8000.0), coalesce(proffin, -8000.0)) as rnum ' ||
                     'from qualitometres_points where codequalitometre = ' || pointprel.codequalitometre || ' and coalesce(codesupportdefaut, 3) = ' || pointprel.codesupportdefaut ||
                     ' and coalesce(x, -8000.0) = ' || pointprel.x  || ' and coalesce(y, -8000.0) = ' || pointprel.y || ' and coalesce(typeprojection, -8000.0) = ' || pointprel.typeprojection ||
                     ' and lower(coalesce(identifiant, ''031'')) = ''' || pointprel.identifiant || ''' and lower(coalesce(nom, ''eau'')) = ''' || pointprel.nom ||
                     ''' and lower(coalesce(code, ''031'')) = ''' || pointprel.code || ''' and coalesce(profdebut, -8000.0) = ' || pointprel.profdebut || ' and coalesce(proffin, -8000.0) = ' || pointprel.proffin || ') gp where rnum = 1) where codequalitometre = ' || pointprel.codequalitometre  || ' and codepoint = ' || pointprel.codepoint;;
execute v_requete;;

-- suppression du point en doublon
insert into journal (dateevt, titre, description) values (now(), 'suppression du point de prel, codequalitometre : ' || pointprel.codequalitometre || ', codepoint : ' || pointprel.codepoint, 'correctDoublonsPointPrel');;
v_requete := 'delete from qualitometres_points where codequalitometre = ' || pointprel.codequalitometre || ' and codepoint = ' || pointprel.codepoint;;
execute v_requete;;
END LOOP;;
close my_cursor_point;;

-- correction des éventuels doublons sur les opérations qui on ainsi été créés
perform correctDoublonsOperations();;

    -- création de l'index
create unique index if not exists qualitometres_points_uniq_idx
    on qualitometres_points (codequalitometre, coalesce(codesupportdefaut, 3), coalesce(x, -8000.0), coalesce(y, -8000.0), coalesce(typeprojection, -8000.0), lower(coalesce(identifiant, '031')), lower(coalesce(nom, 'eau')), lower(coalesce(code, '031')), coalesce(profdebut, -8000.0), coalesce(proffin, -8000.0));;

insert into journal (dateevt, titre, description) values (now(), 'Fin de la fonction correctDoublonsPointPrel()', 'correctDoublonsPointPrel');;
RETURN d_count;;
END;;
$$;;

# --- !Downs
