/**
 * @author pminot
 * @date 07/02/2025
 * @version 1.0.0
 * @project SEQOYA
 * @table evenements_installations, pgsse_campagnes, pgsse_campagnes_sites, pgsse_formulaires, pgsse_diagnotics
 */

# --- !Ups

-- Gestion des événements  en fonction du type de campagne: installation ou pgsse
alter table evenements_installations add typecampagne bigint;
update evenements_installations set typecampagne=0; --0: campagne installation, 1 campagne pgsse

-- creation des campagnes PGSSE
create table pgsse_campagnes (
	codecampagne BIGINT,
	idDiagnostic BIGINT,
	libelle CHARACTER VARYING(100),
	commentaire TEXT,
	dateDebut TIMESTAMP WITH TIME ZONE,
	dateFin TIMESTAMP WITH TIME ZONE,
	loginmaj CHARACTER VARYING(50),
	datemaj TIMESTAMP WITH TIME ZONE,
	statut INTEGER,
	typestation BIGINT
);

-- Gestion des installations liées aux campagnes PGSSE
create table pgsse_campagnes_sites (
	idDiagnostic BIGINT,
	codecampagne BIGINT,
	idFormulaire BIGINT,
	codesite BIGINT,
	ordrepassage INTEGER
);

-- Gestion des station et intervenants liées à une campagne PGSSE ou directement à un diagnostic
create table pgsse_formulaires (
	idFormulaire BIGINT,
	idDiagnostic BIGINT,
	typeFormulaire BIGINT,
	code BIGINT,
	codecampagne BIGINT,
	dateFormulaire TIMESTAMP WITH TIME ZONE,
	loginTechnicien TEXT,
	autreTechnicien TEXT,
	participants TEXT,
	commentaire TEXT,
	statut BIGINT,
	datemaj TIMESTAMP WITH TIME ZONE,
	loginmaj CHARACTER VARYING(50),
	codeEvenement BIGINT
);

-- pgsse_diagnotics pour état d'avancement d'un diagnosic PGSSE
create table pgsse_diagnotics (
	idDiagnostic BIGINT,
	idEnquete BIGINT, -- définition d'une enquête dans pgsse_definitions
	codeIntervenant BIGINT,
	codeSecteur BIGINT,
	codeinstallation BIGINT, -- UDI
	statut BIGINT,
	commentaire TEXT,
	datemaj TIMESTAMP WITH TIME ZONE,
	loginmaj CHARACTER VARYING(50)
);

-- Définition du formulaire
create table pgsse_definitions AS SELECT * FROM enquetes_definitions;
create table pgsse_paragraphes AS SELECT * FROM enquetes_paragraphes;
create table pgsse_paragraphes_restrictions AS SELECT * FROM enquetes_paragraphes_installations;
alter table pgsse_paragraphes_restrictions add column typeStation integer;
create table pgsse_questions AS SELECT * FROM enquetes_questions;
create table pgsse_questions_restrictions AS SELECT * FROM enquetes_questions_installations;
alter table pgsse_questions_restrictions add column typeStation integer;
create table pgsse_questions_valeurs AS SELECT * FROM enquetes_questions_valeurs;
create table pgsse_reponses AS SELECT * FROM enquetes_reponses;
create table pgsse_reponses_doc AS SELECT * FROM enquetes_reponses_doc;
create table pgsse_reponses_multiples AS SELECT * FROM enquetes_reponses_multiples;

# --- !Downs