/**
 * @author dbu
 * @date 25/03/2025
 * @version 1.0.0
 * @project qualité
 * @table codes_sandre
 */

# --- !Ups

DELETE FROM codes_sandre WHERE champ = 'SUBSTRAT';
INSERT INTO codes_sandre(champ,
                         codereference,
                         code,
                         mnemonique,
                         libelle,
                         commentaire)
VALUES ('SUBSTRAT', 274, 1, '0', 'Substrat inconnu', 'Invertébrés'),
       ('SUBSTRAT', 274, 2, 'D1', 'Bryophytes', 'Diatomées'),
       ('SUBSTRAT', 274, 3, 'D2', 'Hydrophytes', 'Diatomées'),
       ('SUBSTRAT', 274, 4, 'D3', 'Litières', 'Diatomées'),
       ('SUBSTRAT', 274, 5, 'D4', 'branchages, racines', 'Diatomées'),
       ('SUBSTRAT', 274, 6, 'D5', 'pierres, galets  ]64-256 mm]', 'Diatomées'),
       ('SUBSTRAT', 274, 7, 'D6', 'graviers ]2,5-16 mm]', 'Diatomées'),
       ('SUBSTRAT', 274, 8, 'D7', 'Hélophytes', 'Diatomées'),
       ('SUBSTRAT', 274, 9, 'D8', 'Sédiments fins, vases', 'Diatomées'),
       ('SUBSTRAT', 274, 10, 'D9', 'Sables, limons [0,1 - 2,5 mm]', 'Diatomées'),
       ('SUBSTRAT', 274, 11, 'D10', 'roches, dalles, blocs', 'Diatomées'),
       ('SUBSTRAT', 274, 12, 'D11', 'Algues', 'Diatomées'),
       ('SUBSTRAT', 274, 13, 'D12', 'marne et argile', 'Diatomées'),
       ('SUBSTRAT', 274, 14, 'D13', 'Cailloux ]16 - 64 mm]', 'Diatomées'),
       ('SUBSTRAT', 274, 15, 'D14', 'Métal', 'Diatomées'),
       ('SUBSTRAT', 274, 16, 'D15', 'Béton hors piles de pont', 'Diatomées'),
       ('SUBSTRAT', 274, 17, 'D16', 'Verre', 'Diatomées'),
       ('SUBSTRAT', 274, 18, 'D17', 'Briques', 'Diatomées'),
       ('SUBSTRAT', 274, 19, 'D18', 'Tuiles', 'Diatomées'),
       ('SUBSTRAT', 274, 20, 'D20', 'Palplanches hors bois', 'Diatomées'),
       ('SUBSTRAT', 274, 21, 'D21', 'Autres mat.artificiels', 'Diatomées'),
       ('SUBSTRAT', 274, 22, 'D22', 'Cailloux, pierre, galet ]16 - 256mm]', 'Diatomées'),
       ('SUBSTRAT', 274, 23, 'M1', 'Vases, Limon', 'Macrophytes'),
       ('SUBSTRAT', 274, 24, 'M2', 'Terre,argile,marne,tourbe', 'Macrophytes'),
       ('SUBSTRAT', 274, 25, 'M3', 'Sables, Graviers,', 'Macrophytes'),
       ('SUBSTRAT', 274, 26, 'M4', 'Cailloux, pierres, galets,', 'Macrophytes'),
       ('SUBSTRAT', 274, 27, 'M5', 'Blocs, dalles', 'Macrophytes'),
       ('SUBSTRAT', 274, 28, 'M6', 'Débris organiques', 'Macrophytes'),
       ('SUBSTRAT', 274, 29, 'M7', 'Artificiel', 'Macrophytes'),
       ('SUBSTRAT', 274, 30, 'M8', 'Racines, branchages', 'Macrophytes'),
       ('SUBSTRAT', 274, 31, 'O1', 'Limons', 'Oligochètes'),
       ('SUBSTRAT', 274, 32, 'O2', 'Sables', 'Oligochètes'),
       ('SUBSTRAT', 274, 33, 'O3', 'Graviers (2,5 << 25 mm)', 'Oligochètes'),
       ('SUBSTRAT', 274, 34, 'O4', 'Galets, pierre (25mm - 250mm)', 'Oligochètes'),
       ('SUBSTRAT', 274, 35, 'O5', 'Petits blocs (250mm - 600mm)', 'Oligochètes'),
       ('SUBSTRAT', 274, 36, 'O6', 'Gros blocs ( > 600mm)', 'Oligochètes'),
       ('SUBSTRAT', 274, 37, 'O7', 'Sédiment fin composite', 'Oligochètes'),
       ('SUBSTRAT', 274, 38, 'S1', 'Bryophytes', 'Sont considérées comme bryophytes, les hépatiques et les mousses  (Les substrats dont le code commence par S se rapportent à l''étude du support macro-invertébrés)'),
       ('SUBSTRAT', 274, 39, 'S2', 'Spermaphytes ou phanérogames immergés', 'ce substrat ne dépend pas de l’espèce mais de l’émersion ou de l’immersion à la date du prélèvement. Par exemple, la bérule pourra être considérée comme un hydrophyte si elle est entièrement immergée mais comme un hélophyte si le sommet sort de l’eau.  (Les substrats dont le code commence par S se rapportent à l''étude du support macro-invertébrés)'),
       ('SUBSTRAT', 274, 40, 'S3', 'Litières', 'ce substrat correspond aux feuilles et brindilles (par exemple diamètre environ inférieur à 5 mm) , en général issues de la végétation ligneuse, tombées au fond de l’eau et en général s’accumulant sur le fond du lit dans les zones calmes, souvent sur plusieurs cm d’épaisseur. Cette litière peut être non décomposée (feuilles solides) ou plus ou moins décomposée (feuilles se désagrégeant facilement). Une litière caractéristique a le plus souvent une couleur brun foncée, indiquant sa présence dans l’eau depuis plusieurs semaines.  (Les substrats dont le code commence par S se rapportent à l''étude du support macro-invertébrés)'),
       ('SUBSTRAT', 274, 41, 'S4', 'Branchages', 'ce substrat regroupe les petites branches (diamètre d’environ 5 mm à 2 cm) pouvant être récupérées dans le filet, ainsi que les grosses branches (diamètre supérieur à 2 cm) qu’il est plus simple de frotter en surface et de rejeter. Ce substrat peut atteindre 1/20 m2 soit par accumulation de branches s''accumulant de manière dense sur le fond du lit dans les zones calmes (souvent sur plusieurs cm d''épaisseurs), soir par la surface d''un seul tenant d''un tronc immergé. Ce qui signifie que des branches occupant la masse d''eau de manière peu dense (avec ramifications lâches par exemple) ne doivent pas être prélevés s''il n''est pas, possible de trouver des superfiicie de 1/20 m2 d''un seul tenant. Les branches prélevables peuvent être déposées sur le fond du lit mais aussi être suspendues en pleine eau (troncs ou amas plus ou moins profonds), dans des zones calmes ou des zones de courant - par exemple : amas de branches retenues entre des blocs dans un radier).  (Les substrats dont le code commence par S se rapportent à l''étude du support macro-invertébrés)'),
       ('SUBSTRAT', 274, 42, 'S5', 'Racines', 'chevenus racinaires libres dans l''eau de tous végétaux (ligneux, hélophytes …)  Invertébrés'),
       ('SUBSTRAT', 274, 43, 'S6', 'Troncs', 'Invertébrés'),
       ('SUBSTRAT', 274, 44, 'S7', 'Pierres (blocs anguleux, 25 mm <Ø < 250 mm)', 'Invertébrés'),
       ('SUBSTRAT', 274, 45, 'S8', 'Galets  (blocs roulés, 25 mm <Ø < 250 mm)', 'Invertébrés'),
       ('SUBSTRAT', 274, 46, 'S9', 'Granulats grossiers (2 mm <Ø < 25 mm)', 'la plus grande dimension visuelle de l’élément minéral est comprise entre 2 et 25 mm  Invertébrés'),
       ('SUBSTRAT', 274, 47, 'S10', 'Spermaphytes ou phanérogames émergents', 'Invertébrés'),
       ('SUBSTRAT', 274, 48, 'S11', 'Sédiments fins ± organiques ("vases" =< 0,1 mm)', 'Est considéré comme vase tout substrat dominé par une matrice fine noirâtre organo-sédimentaire, accompagnée le plus souvent d’une odeur de décomposition caractéristique, et pouvant parfois inclure un substrat secondaire : litière, limon … Souvent une vase n’est pas retenue dans le filet et ne laisse après nettoyage que peu d’éléments grossiers (<< 0,5 L). S’il reste beaucoup d’éléments grossiers (feuilles, branches …) dans le filet (> 0,5 L), il convient de voir si le substrat principal n’était pas d’une autre nature (e.g. litière).  Invertébrés'),
       ('SUBSTRAT', 274, 49, 'S12', 'Sables (strictement minéral, Ø  =< 2 mm)', 'Ils ont un aspect rigueux au toucher et ne doivent pas être confondus avec les limons.   Invertébrés'),
       ('SUBSTRAT', 274, 50, 'S13', 'Limons (minéral et organique, Ø  =< 2 mm)', 'Invertébrés'),
       ('SUBSTRAT', 274, 51, 'S14', 'Roches (substrats immergés avec protubérances, Ø > 250 mm)', 'Invertébrés'),
       ('SUBSTRAT', 274, 52, 'S15', 'Dalles (substrats immergés sans protubérances, à > 250 mm)', 'Invertébrés'),
       ('SUBSTRAT', 274, 53, 'S16', 'Sols (surfaces artificielles horizontales, Ø > 250 mm)', 'Invertébrés'),
       ('SUBSTRAT', 274, 54, 'S17', 'Parois (surfaces artificielles verticales, Ø > 250 mm)', 'Invertébrés'),
       ('SUBSTRAT', 274, 55, 'S18', 'Algues', 'ce substrat inclut les algues eucaryotes (chlorophytes, rhodophytes …) . Il peut être extrêmement variable morphologiquement : algues ressemblant à des spermaphytes comme les characées, algues filamenteuses flottant de type Spirogyra  ou pouvant ressembler à des bryophytes (Lemanea). Il est rappelé par exemple que même si les Lemanea sont en quantité importante et peuvent faire penser à des bryophytes (notamment en tant que substrat aussi hospitalier que les bryophytes), ce sont bien des algues. Attention, les algues encroûtantes sur des blocs (Hildenbrandia) sont assimilées au substrat "surface uniformes dure"  Invertébrés'),
       ('SUBSTRAT', 274, 56, 'S19', 'Marnes et argiles', 'Invertébrés'),
       ('SUBSTRAT', 274, 57, 'S20', 'Bactéries', 'Invertébrés'),
       ('SUBSTRAT', 274, 58, 'S21', 'Champignons', 'Invertébrés'),
       ('SUBSTRAT', 274, 59, 'S22', 'Cailloux', 'Invertébrés'),
       ('SUBSTRAT', 274, 60, 'S23', 'Eléments organiques grossiers (litières, branchages, racines)', 'Invertébrés'),
       ('SUBSTRAT', 274, 61, 'S24', 'Sédiments minéraux de grande taille (pierres, galets)  25 mm <Ø < 250 mm', 'La plus grande dimension visuelle de l’élément minéral est comprise entre 25 et 250 mm.  Invertébrés'),
       ('SUBSTRAT', 274, 62, 'S25', 'Sables et limons', 'Invertébrés'),
       ('SUBSTRAT', 274, 63, 'S26', 'Surfaces naturelles et artificielles (roches, dalles, sols, parois) blocs Ø > 250 mm', 'Invertébrés'),
       ('SUBSTRAT', 274, 64, 'S27', 'Algues, marne ou argile', 'Invertébrés'),
       ('SUBSTRAT', 274, 65, 'S28', 'Branchage et racines', 'Invertébrés'),
       ('SUBSTRAT', 274, 66, 'S29', 'Surfaces uniformes dures naturelles et artificielles (roches, dalles, marnes et argiles compactes)', 'ce substrat inclut les substrats de dimension supérieure à 250 mm et non facilement déplaçable (impossibilité d’échantillonner facilement la face inférieure). La norme précise que les substrats rendus uniformes par dépôt de concrétion calcaires ou enchâssés (impossibilité de retirer les pierres par exemple) sont inclus dans cette définition  Invertébrés'),
       ('SUBSTRAT', 274, 67, 'S30', 'Blocs (>250 mm) inclus dans une matrice d''éléments minéraux de grande taille (25 à 250 mm)', 'au moins une dimension est supérieure à 250 mm. Le bloc doit pouvoir être déplacé par une personne seule, c’est à dire que toutes les faces doivent pouvoir être nettoyées et la couche sous le bloc doit pouvoir être agitée conformément aux recommandations de la norme. Si le bloc est difficile à déplacer (c’est à dire que le préleveur peut difficilement le retourner et nettoyer correctement ses faces devant le filet), le substrat est considéré comme une surface uniforme dure (cf. substrat S 29).  Invertébrés'),
       ('SUBSTRAT', 274, 68, 'S31', 'Substrat non-déterminé', 'Différent de 0 (inconnu) puisque inconnu peut laisser supposer que le bancarisateur n''a pas obtenu l''information alors que non-déterminé concerne le préleveur (exemple en cas de trouble important de l''eau).'),
       ('SUBSTRAT', 274, 69, 'S32', 'Substrat artificiel', 'Substrat, mis en place par l''opérateur, constitué par un mélange de pierres et de corde enfermé dans un grillage en plastique. différent du substrat "artificiel (M7) pour les Mphytes"'),
       ('SUBSTRAT', 274, 70, 'Z1', 'Eau', 'Phytoplancton, Zooplancton'),
       ('SUBSTRAT', 274, 71, 'D', 'Dalles (dont dalles d''argile)', '>1024 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 72, 'R', 'Rochers', '>1024 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 73, 'B', 'Blocs', '256 - 1024 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 74, 'PG', 'Pierres Grossières', '128 - 256  mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 75, 'PF', 'Pierres Fines', '64 - 128 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 76, 'CG', 'Cailloux Grossiers', '32 - 64 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 77, 'CF', 'Cailloux Fins', '16 - 32 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 78, 'GG', 'Graviers Grossiers', '8 -16 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 79, 'GF', 'Gravier fins', '2 - 8 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 80, 'S', 'Sables', '0,625 - 2 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 81, 'L', 'Limons', '0,0039 - 0,0625 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 82, 'A', 'Argiles', 'diamètre < 0,0039 mm;; catégorie provenant de l''échelle granulométrique de Wentwoth'),
       ('SUBSTRAT', 274, 83, 'CR', 'Chevelu racinaire', ''),
       ('SUBSTRAT', 274, 84, 'VS', 'Végétation surplombante', ''),
       ('SUBSTRAT', 274, 85, 'DL', 'Débris ligneux grossiers / Embacle', ''),
       ('SUBSTRAT', 274, 86, 'VA', 'Végétation aquatique', ''),
       ('SUBSTRAT', 274, 87, 'PD', 'Pool détritique', 'Accumulation de matière organique particulaire grossière (feuilles mortes, écorce, autres débrits végétaux)'),
       ('SUBSTRAT', 274, 88, 'SB', 'Sous-berge', ''),
       ('SUBSTRAT', 274, 89, 'TV', 'Terre végétalisée', ''),
       ('SUBSTRAT', 274, 90, 'V', 'Vase', '');

DELETE FROM codes_sandre WHERE champ = 'PRELEVEMENTS.MATERIELS';
INSERT INTO codes_sandre(champ,
                         codereference,
                         code,
                         mnemonique,
                         libelle,
                         commentaire)
VALUES ('PRELEVEMENTS.MATERIELS', 451, 1, '0', 'Inconnu', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 2, 'D1', 'Brosse', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 3, 'D2', 'Binette', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 4, 'D3', 'Couteau ou scalpel', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 5, 'D4', 'Expression manuelle', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 6, 'D5', 'Pipette', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 7, 'D6', 'Prélèvement par agitation de végétaux dans un récipient d''eau ou d''alcool', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 8, 'M1', 'Surber', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 9, 'M2', 'Haveneau', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 10, 'M3', 'Drague circulaire', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 11, 'M4', 'Drague triangulaire', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 12, 'M5', 'Benne à fermeture automatique (Ekman, Friedinger ...)', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 13, 'M6', 'Piochon', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 14, 'M7', 'Substrat artificiel', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 15, 'P1', 'Bouteille intégratrice', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 16, 'P2', 'Bouteille Van Dorn', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 17, 'P3', 'Pompe', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 18, 'M8', 'Carottier', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 19, 'F0', 'Filet indéterminé', 'Surber ou haveneau'),
       ('PRELEVEMENTS.MATERIELS', 451, 20, 'D0', 'Drague indéterminé', 'Circulaire ou triangulaire'),
       ('PRELEVEMENTS.MATERIELS', 451, 21, 'M9', 'Râteau', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 22, 'M10', 'Grappin', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 23, 'M11', 'Bathyscope', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 24, 'PE1', 'Batterie d''accumulateurs', 'Batterie d’accumulateurs autonome associée à un dispositif de conversion '),
       ('PRELEVEMENTS.MATERIELS', 451, 25, 'PE2', 'Groupe moteur thermique-générateur de courant continu', 'Groupe moteur thermique-générateur de courant continu'),
       ('PRELEVEMENTS.MATERIELS', 451, 26, 'PE3', 'Groupe moteur thermique-générateur de courant alternatif', 'Groupe moteur thermique-générateur de courant alternatif associé à un dispositif redresseur'),
       ('PRELEVEMENTS.MATERIELS', 451, 27, 'PE4', 'Transformateur', 'Transformateur de séparation alimenté par une distribution basse tension et associé à un dispositif redresseur'),
       ('PRELEVEMENTS.MATERIELS', 451, 28, 'M12', 'Nasse', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 29, 'M13', 'Balance', ''),
       ('PRELEVEMENTS.MATERIELS', 451, 30, 'M14', 'Drague cylindro-conique', 'Matériel utilisé pour les prélèvements macro-invertébrés en grand cours d''eau. Technique de prélèvement à ajouter dans le fichier de saisie Macro-invertébrés grand cours d''eau de l''OFB.');

DELETE FROM codes_sandre WHERE champ = 'PRELEVEMENTS.STABILITE';
INSERT INTO codes_sandre(champ,
                         codereference,
                         code,
                         mnemonique,
                         libelle)
VALUES ('PRELEVEMENTS.STABILITE', 57, 0, 'Ignoré', 'Ignoré'),
       ('PRELEVEMENTS.STABILITE', 57, 1, 'Stable', 'Stable'),
       ('PRELEVEMENTS.STABILITE', 57, 2, 'Moyennement', 'Moyennement stable'),
       ('PRELEVEMENTS.STABILITE', 57, 3, 'Instable', 'Instable');

# --- !Downs
