/**
 * @author pminot
 * @date 28/03/2025
 * @version 1.0.0
 * @project pgsse
 * @table pgsse_definitions, pgsse_questions, pgsse_questions_restrictions, pgsse_paragraphes, pgsse_paragraphes_restrictions
 */

# --- !Ups

delete from pgsse_definitions;

insert into pgsse_definitions (idenquete, dateenquete, datedebut, datefin, description, statutenquete) values (1, '2025-01-01', '2025-01-01', '2030-01-01', 'PGSSE 2025-2030', 1);

delete from pgsse_questions;

insert into pgsse_questions values (1,1,2,'Parcelle est-elle accessible par tous les temps?',9,true,2,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,1,3,'Y a-t-il un point d''accès unique à la parcelle (portail accès)',9,true,3,null,true);
insert into pgsse_questions values (1,1,4,'Entretien du site satisfaisant ?',9,true,4,null,true);
insert into pgsse_questions values (1,1,5,'Les arbres sont taillés et ne menacent pas l''ouvrage? (cloture /batiment)',9,true,5,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,1,6,'Absence de stockage ou dépôt de matériel ou substances non en lien avec l''activité Aep ?',9,true,6,null,true);
insert into pgsse_questions values (1,1,7,'Absence de stockage de bouteille de chlore (vides ou pleines à l''air libre)? ',9,true,7,null,true);
insert into pgsse_questions values (1,2,11,'Existe t''il une clôture en grillage ? ',9,true,11,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,2,12,'Hauteur de la clôture ≥ 2ml sur ensemble de la parcelle ? ',9,true,12,null,true);
insert into pgsse_questions values (1,2,13,'Abord du site dégagé ne permettant pas le passage par-dessus le grillage?',9,true,13,null,true);
insert into pgsse_questions values (1,3,17,'Existe-t-il un portail sur chaque entrée ? ',9,true,17,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,3,18,'Portail(s) à lisse défensive et barreaux verticaux même hauteur que clotûre ? ',9,true,18,null,true);
insert into pgsse_questions values (1,3,19,'Portail(s) doté d''articulations de préférence non dégondables, avec butée de sol et gache de sécurité ? ',9,true,19,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,3,20,'Portail(s) avec espace libre entre barreaux ≤ 11 cm ? ',9,true,20,null,true);
insert into pgsse_questions values (1,3,21,'Panneau d''interdiction d''accès au public normatif visible ? ',9,true,21,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,3,22,'Le portail est-il vérouillable ? ',9,true,22,null,true);
insert into pgsse_questions values (1,3,23,'Verrouillage par un système fiable (barrilet à clé sécurisé, badge, digicode) - hors pass ? ',9,true,23,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,3,24,'Si utilisation clefs , sont elles différentes de celles pour accès batiment - ouvrages ? ',9,true,24,null,true);
insert into pgsse_questions values (1,3,25,'Absence de coffret à clés ?',9,true,25,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,4,29,'Existe-t-il une porte d''accès renforcée au batiment ? ',9,true,29,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,4,30,'Existe-t-il une trappe d''accès renforcée au batiment ? ',9,true,30,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,4,31,'Panneau d''interdiction d''accès au public normatif visible ?',9,true,31,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,4,32,'la porte est-elle verrouillable ? ',9,true,32,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,4,33,'Verrouillage par un système fiable (barrilet à clé sécurisé, badge, digicode) - hors pass ? ',9,true,33,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,4,34,'Si utilisation clefs , sont elles différentes de celles pour accès parcelle - ouvrages ? ',9,true,34,null,true);
insert into pgsse_questions values (1,4,35,'connaissance du nombre de jeux d''accès et attribution ? ',9,true,35,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,4,36,'Absence de coffret à clés ?',9,true,36,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,4,37,'Fenetres renforcées par un système fiable (barreaux verticaux scellés et/ou horizontaux ou grille en metal déployé, barreaux aux fenetres ≤ 11 cm,vitrage résistant effraction)',9,true,37,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,4,38,'Existent-ils des protections efficaces des ventilations ? (renforcement et protection)',9,true,38,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,5,42,'Existence d''un système anti-intrusion (par contacteur sur porte ou détection volumétrique intérieur batiment)',9,true,42,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,5,43,'Existence caméra de vidéosurveillance?',9,true,43,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,5,44,'Existence alarme sonore en cas detection intrusion ? ',9,true,44,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,5,45,'Existence d''un dispositif anti intrusion reliée au dispositif d''astreinte 24h/24 ?',9,true,45,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,5,46,'Absence tentatives intrusion dans les 2 dernières années ',9,true,46,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,6,50,'Existence trappes ou capots empechant l''introduction de substances, éléments ? ',9,true,50,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,6,51,'Verrouillage trappes et capots ? ',9,true,51,null,true);
insert into pgsse_questions values (1,6,52,'Verrouillage par un système fiable (hors pass et clefs "triangle") ? ',9,true,52,null,true);
insert into pgsse_questions values (1,6,53,'Existence d''un système de blocage de la trappe ouverte ? ',9,true,53,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,6,54,'Existence d''un système de barre antichutes ? ',9,true,54,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,6,55,'Si utilisation clefs , sont elles différentes de celles pour accès parcelle - batiment ? ',9,true,55,null,true);
insert into pgsse_questions values (1,6,56,'Existence d''un dispositif anti intrusion /trappes d''accès reliée au dispositif d''astreinte 24h/24 ?',9,true,56,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,7,60,'Existence d''un deuxième dispositif d''accès à l''eau (sas, 2ème porte, trappe sécurisée) ? ',9,true,60,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,7,61,'Verrouillage par un système fiable (hors pass et clefs "triangle") ? ',9,true,61,null,true);
insert into pgsse_questions values (1,7,62,'Si utilisation clefs , sont elles différentes de celles pour accès parcelle - batiment ? ',9,true,62,null,true);
insert into pgsse_questions values (1,7,63,'Existence d''un dispositif anti intrusion /trappes d''accès reliée au dispositif d''astreinte 24h/24 ?',9,true,63,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,7,64,'Existence alerte si rupture communication dispositifs détection et de mesure ? ',9,true,64,null,true);
insert into pgsse_questions values (1,8,69,'Les Grilles de ventilation sont elles sécurisées et renforcées ? (source et puits)',9,true,69,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,8,70,'Etat des aérations ne permettant pas l''intrusion de feuilles, insectes ou animaux ? (sources et puits)',9,true,70,null,true);
insert into pgsse_questions values (1,8,71,'Existence de système d''anti intrusion via le trop plein (insectes ou animaux) ? (sources et puits)',9,true,71,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,8,72,'Existence dispositif anti retour sur le trop plein ? (source)',9,true,72,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,8,73,'Bon état du génie civil de l''ouvrage (absence fissurations, trous, fourreaux non bouchés , racines, …) ? (source et puits)',9,true,73,null,true);
insert into pgsse_questions values (1,8,74,'Isolation de la tête /eaux de ruissellement ? (forage)',9,true,74,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,8,75,'Pompage sécurisé par plusieurs pompes en parallèle ? (Pour tous)',9,true,75,null,true);
insert into pgsse_questions values (1,8,76,'si une seule pompe, existence d''une pompe de secours approvisionnée et adaptée à l''installation à secourir ? (pour tous)',9,true,76,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,8,77,'Existence d''un dispositif de suivi du niveau (piézométrique, débit) ? ',9,true,77,null,true);
insert into pgsse_questions values (1,9,81,'Bon état du génie civil de l''ouvrage (absence fissurations, trous, fourreaux non bouchés , racines, …) ? ',9,true,81,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,9,82,'Les grilles de ventilations préservent-elles de l''accès au batiment ? (insectes, animaux, …)',9,true,82,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,9,83,'L''étanchéité du bâtiment est-elle correcte ?',9,true,83,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,9,84,'Absence de mousses , moississures (aération satisfaisante) ? ',9,true,84,null,true);
insert into pgsse_questions values (1,9,85,'Batiment hors gel ? ',9,true,85,null,true);
insert into pgsse_questions values (1,9,86,'L''état des revetements intérieurs est il satisfaisant ? ',9,true,86,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,9,87,'Le nettoyage du bâtiment est-il satisfaisant ?',9,true,87,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,9,88,'Existence d''un système d''évacuation des eaux de pluie ? (réservoir)',9,true,88,null,true);
insert into pgsse_questions values (1,9,90,'Mise en place d''un dispostif anti-insecte volant (moustiquaire, lampe UV,…)',9,true,90,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,10,94,'Existence fermeture par clef de l''armoire électrique ? ',9,true,94,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,10,95,'Une coupure électrique entraîne t-elle une alerte/alarme?',9,true,95,null,true);
insert into pgsse_questions values (1,10,96,'Existe-t-il un inverseur de source ?',9,true,96,null,true);
insert into pgsse_questions values (1,10,97,'Existe-t-il un groupe électrogène de secours sur site pour alimenter l''ensemble de l''installation ?',9,true,97,null,true);
insert into pgsse_questions values (1,10,98,'Existe-t-il un groupe électrogène de secours mobile pour alimenter l''ensemble de l''installation ?',9,true,98,null,true);
insert into pgsse_questions values (1,10,99,'Démarrage régulier des groupes électrogène réalisé ?',9,true,99,null,true);
insert into pgsse_questions values (1,10,100,'Intégrité de l''armoire electrique assurée (rongeurs, reptiles, ….) ? ',9,true,100,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,10,101,'Existence protection incendie autonome des armoires electriques ?',9,true,101,null,true);
insert into pgsse_questions values (1,10,102,'Contrôle interne régulier des installations electriques (hors contrôle reglementaire) ? ',9,true,102,null,true);
insert into pgsse_questions values (1,10,103,'Existence d''un parafoudre dans l''armoire electrique ?',9,true,103,null,true);
insert into pgsse_questions values (1,10,104,'Almimentation de secours permet un fonctionnement en mode normal ? ',9,true,104,null,true);
insert into pgsse_questions values (1,11,108,'Existence outil de supervision (automate) ? ',9,true,108,null,true);
insert into pgsse_questions values (1,11,109,'Ensemble des données d''exploitation gérés par l''automate? ',9,true,109,null,true);
insert into pgsse_questions values (1,11,110,'Ensemble des commandes pilotés par l''automate ? ',9,true,110,null,true);
insert into pgsse_questions values (1,11,111,'Possibilité de fonctionnement en mode manuel en cas de problème sur automates ? ',9,true,111,null,true);
insert into pgsse_questions values (1,11,112,'Accessibilité de l''automate de gestion à distance ? (agents en astreinte)',9,true,112,null,true);
insert into pgsse_questions values (1,11,113,'Sécurisation par onduleur des équipements ? ',9,true,113,null,true);
insert into pgsse_questions values (1,12,117,'Existence d''un outil de télégestion (remontée des alarmes ;; dépassement, …) ? ',9,true,117,null,true);
insert into pgsse_questions values (1,12,118,'Type de liaison (radio, ligne pilote, ADSL, GSM, RTC) ? ',9,true,118,null,true);
insert into pgsse_questions values (1,12,119,'Existence sécurité (chemins redondants) sur les équipements de télésurveillance ? ',9,true,119,null,true);
insert into pgsse_questions values (1,12,120,'Alimentation par réseau électrique ?',9,true,120,null,true);
insert into pgsse_questions values (1,12,121,'Existence d''un dispositif d''alimentation de secours ? (batterie, panneau solaire) ',9,true,121,null,true);
insert into pgsse_questions values (1,12,122,'Existence tests réguliers sur le fonctionnement de la télésurveillance ? ',9,true,122,null,true);
insert into pgsse_questions values (1,13,126,'Absence antenne sur un ouvrage ?  (si antenne présente = NON)',9,true,126,null,true);
insert into pgsse_questions values (1,13,127,'Présence effective de l''exploitant durant toute la durée des interventions ? ',9,true,127,null,true);
insert into pgsse_questions values (1,13,128,'Installation du local antenniste à l''extérieur du réservoir ? ',9,true,128,null,true);
insert into pgsse_questions values (1,13,129,'Installation de tous les équipements (antennes, cables) à l''extérieur des ouvrages ? ',9,true,129,null,true);
insert into pgsse_questions values (1,13,130,'Si possibilité accès à l''eau , existance dispositif de protection eau (sécurité étanche plateforme accès dôme) ? ',9,true,130,null,true);
insert into pgsse_questions values (1,13,131,'Intervention par nacelle ou sous surveillance de l''exploitant ? ',9,true,131,null,true);
insert into pgsse_questions values (1,14,135,'Existence d''un manuel et de consignes écrites d''exploitation sur site ? (accessible aux agents)',9,true,135,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,14,136,'Existence cahier de vie sur site avec consignation systématique des observations, reglages effectués ? ',9,true,136,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,14,137,'Conservation des données de suivi sur site de plus d''un mois ?',9,true,137,null,true);
insert into pgsse_questions values (1,15,141,'Absence de stockage de produits chimiques à risque non nécessaires à l''exploitation de l''ouvrage (produits pétroliers, peinture, phytosanitaires,...) ? ',9,true,141,null,true);
insert into pgsse_questions values (1,15,142,'Absence de stockage de produits chimiques à risque nécessaires à l''exploitation de l''ouvrage (chlore, réactifs, carburants, …) ? ',9,true,142,null,true);
insert into pgsse_questions values (1,15,143,'Stockage des produits chimiques sur rétention individualisée ? ',9,true,143,null,true);
insert into pgsse_questions values (1,15,144,'Eloignement des produits non compatibles ? ',9,true,144,null,true);
insert into pgsse_questions values (1,15,145,'Absence d''accès au site par les fournisseurs en dehors de la présence de l''exploitant ?',9,true,145,null,true);
insert into pgsse_questions values (1,15,146,'Tous les locaux/cuves/armoires de stockage des réactifs sont-ils cadenassés ?',9,true,146,null,true);
insert into pgsse_questions values (1,15,147,'Tous les locaux de stockage des réactifs sont-ils équipés d''un capteur anti-intrusion ?',9,true,147,null,true);
insert into pgsse_questions values (1,15,148,'Disponibilité des fiches produits des réactifs sur site ? ',9,true,148,null,true);
insert into pgsse_questions values (1,15,149,'Existence incidents de disponibillité des réactifs sur site (stock, date de péremption) ? ',9,true,149,null,true);
insert into pgsse_questions values (1,16,153,'Bon état du génie civil de l''ouvrage (absence fissurations, trous, fourreaux non bouchés , racines, …) ? ',9,true,153,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,16,154,'Limitation de l''éclairement dans les cuves pour éviter la prolifération des algues?',9,true,154,null,true);
insert into pgsse_questions values (1,16,155,'Vidange, nettoyage, désinfection et rinçage annuel ? (fréquence)',9,true,155,null,true);
insert into pgsse_questions values (1,16,156,'Dimensionnement du réservoir adapté au besoin (temps de séjour) ? ',9,true,156,null,true);
insert into pgsse_questions values (1,16,157,'Absence de flottants, ou de matières en suspension ? ',9,true,157,null,true);
insert into pgsse_questions values (1,16,158,'Le revetement intérieur est il en bon état apparent ?',9,true,158,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,16,159,'La cuve/bâche est-elle étanche ?',9,true,159,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,16,160,'Absence de mélane d''eau dans la cuve ? ',9,true,160,'ENQUETE.ETAT',true);
insert into pgsse_questions values (1,17,164,'Existe-t-il une étude d''analyse des risques de l''unité de traitement ? ',9,true,164,null,true);
insert into pgsse_questions values (1,17,165,'Le traitement permet il de traiter la totalité du débit d''exploitation ? ',9,true,165,null,true);
insert into pgsse_questions values (1,17,166,'Existe-t-il une analyse en continu du taux de chlore ?',9,true,166,null,true);
insert into pgsse_questions values (1,17,167,'Y a-t-il une coupure automatique du pompage en cas de défaut chlore ? ',9,true,167,null,true);
insert into pgsse_questions values (1,17,168,'Existe-t-il une analyse en continu de la turbidité ?',9,true,168,null,true);
insert into pgsse_questions values (1,17,169,'Y a-t-il une coupure automatique du pompage en cas de défaut sur la turbidité ? ',9,true,169,null,true);
insert into pgsse_questions values (1,17,170,'Existe-t-il une analyse en continu sur d''autres paramètres ?',9,true,170,null,true);
insert into pgsse_questions values (1,17,171,'Y a-t-il une coupure automatique du pompage en cas de défaut sur ces autres paramètres ? ',9,true,171,null,true);
insert into pgsse_questions values (1,9,89,'État du système d''évacuation vers le trop plein ? Si non, Evacuation du pluvial par l''extérieur du bâtiment ?',9,true,89,null,true);
insert into pgsse_questions values (1,7,65,'Mise en marche et arrêt de la détection anti-intrusion par clef magnétique ou badge ?',9,true,65,null,true);
insert into pgsse_questions values (1,20,201,'Les chambres de vannes sont-elles inacessibles ?',9,true,201,null,true);
insert into pgsse_questions values (1,20,202,'Quelle est le niveau d''exploitation prenventif des equipements de reseau ',9,true,202,'PGSSE.NIVEAU_EXPLOITATION',true);
insert into pgsse_questions values (1,20,203,'Les poteaux incendies sont équipés de capots de protection',9,true,203,null,true);
insert into pgsse_questions values (1,20,204,'Présence de capteurs permettant d''alerter et/ou repérer une fuite sur le réseau',9,true,204,null,true);
insert into pgsse_questions values (1,20,205,'Suivi du débit et de la pression en continu par télésurveillance',9,true,205,null,true);
insert into pgsse_questions values (1,20,206,'Un plan de purge existe-t-il ?',9,true,206,null,true);
insert into pgsse_questions values (1,20,207,'Si oui est il respecté ?',9,true,207,null,true);
insert into pgsse_questions values (1,20,208,'Pression dans le réseau  comprise entre 3 et 6 bars ?',9,true,208,null,true);
insert into pgsse_questions values (1,21,210,'Les bornes de puisages sont équipés de clapets anti-retours ?',9,true,210,null,true);
insert into pgsse_questions values (1,21,211,'Absence de connexion croisée involontaire (eaux usées, pluviales)',9,true,211,null,true);
insert into pgsse_questions values (1,21,212,'Les clapets antipollution existent-t-ils sur les branchements ',9,true,212,null,true);
insert into pgsse_questions values (1,21,213,'Les disconnecteurs sont ils verifiés ',9,true,213,null,true);
insert into pgsse_questions values (1,21,214,'Absence de connexion croisée involontaire (forage privé)',9,true,214,null,true);
insert into pgsse_questions values (1,21,215,'Les clapets antipollution existent-t-ils sur les branchements ',9,true,215,null,true);
insert into pgsse_questions values (1,21,216,'Les disconnecteurs sont ils verifiés ',9,true,216,null,true);
insert into pgsse_questions values (1,21,217,'Traitement cathodique contre la corrosion des canalisations en acier ?',9,true,217,null,true);
insert into pgsse_questions values (1,21,218,'Sécurisation des secteurs vulnérables de distribution par un maillage de securisation ?',9,true,218,null,true);
insert into pgsse_questions values (1,21,219,'Les canalisations en PVC ont-elles été posées après 1980 ? Si non, le temps de contact est-il inférieur à 4j ?',9,true,219,null,true);
insert into pgsse_questions values (1,21,220,'Y a-t-il un PPI pour les supprimer?',9,true,220,null,true);
insert into pgsse_questions values (1,21,221,'Presence de canalisations en amiante ?',9,true,221,null,true);
insert into pgsse_questions values (1,21,224,'Y-a-t-il des problèmes de double conduite generant des stagnations?',9,true,224,null,true);
insert into pgsse_questions values (1,21,226,'Y a-t-il une modelisation de l''ensemble du reseau? ',9,true,226,null,true);
insert into pgsse_questions values (1,21,228,'Absence de lixivation de produits chimiques provenant des matériaux de conduites (soudures, pâtes à joints)?',9,true,228,null,true);
insert into pgsse_questions values (1,22,230,'Procédure garantissant la qualité sanitaire de l''eau quand travaux neufs (stockage, protection opercules,…)?',9,true,230,null,true);
insert into pgsse_questions values (1,22,231,'Procédure de désinfection des réseaux neufs incorporés selon exigences de l''ARS?',9,true,231,null,true);
insert into pgsse_questions values (1,23,233,'Ouvrage renseignement sur la fréquence des passages ?',9,true,233,null,true);
insert into pgsse_questions values (1,21,223,'Y a-t-il des problèmes d''équilibre calco carbonique ?',9,true,223,null,true);
insert into pgsse_questions values (1,21,225,'Y a-t-il des problèmes de temps contact ?',9,true,225,null,true);
insert into pgsse_questions values (1,21,227,'Y a-t-il des problèmes de temps de sejour ?',9,true,227,null,true);
insert into pgsse_questions values (1,23,235,'Reservoirs fréquence et durée de vidange et désinfection satisfaisante?',9,true,235,null,true);
insert into pgsse_questions values (1,23,236,'Présence d''un fichier sanitaire sur l''usine regroupant la qualité de l''eau, la maintenance des installations et les anomalies observées ?',9,true,236,null,true);
insert into pgsse_questions values (1,23,239,'Agent d''exploitation disposant d''une habilitation électrique à jour ?',9,true,239,null,true);
insert into pgsse_questions values (1,23,240,'Agent d''exploitation disposant d''une autorisation de travail en hauteur ?',9,true,240,null,true);
insert into pgsse_questions values (1,23,241,'Agent d''exploitation disposant d''une habilitation chlore ?',9,true,241,null,true);
insert into pgsse_questions values (1,23,242,'Plan de localisation des vannes de sectionnement avec conditions d''accès ?',9,true,242,null,true);
insert into pgsse_questions values (1,23,243,'les ballons antibelier > 4 b sont ils verifiés ?',9,true,243,null,true);
insert into pgsse_questions values (1,23,245,'Existence d''un audit metier regulier ?',9,true,245,null,true);
insert into pgsse_questions values (1,24,251,'Si antenne sur reservoir sur tour, procédure d''intervention ?',9,true,251,null,true);
insert into pgsse_questions values (1,24,252,'Rapport annuel de l''exploitant mettant en avant les risques sanitaires?',9,true,252,null,true);
insert into pgsse_questions values (1,24,253,'Présence d''un contrat assurant la sécurité sanitaire des interventions avec chaque intervenant ?',9,true,253,null,true);
insert into pgsse_questions values (1,24,254,'Une procedure nouvel arrivant existe-t-elle?',9,true,254,null,true);
insert into pgsse_questions values (1,24,255,'Connaissance des délais de fourniture des réactifs ?',9,true,255,null,true);
insert into pgsse_questions values (1,24,257,'Les intervenants sont ils formés à l''analyse des risques?',9,true,257,null,true);
insert into pgsse_questions values (1,24,258,'Protocole spécifique avec les pompiers pour l''usage des poteaux incendies ?',9,true,258,null,true);
insert into pgsse_questions values (1,24,259,'Réalisation des plans de prevention pour chaque intervention',9,true,259,null,true);
insert into pgsse_questions values (1,24,260,'Identification et liste des abonnés sensibles et prioritaires (EHPAD,...)',9,true,260,null,true);
insert into pgsse_questions values (1,24,262,'Existe-t-il un service d''astreinte ?',9,true,262,null,true);
insert into pgsse_questions values (1,24,263,'Les délais de mobilisation en cas d''accident ou perturbation de la fourniture en eau sont ils satisfaisants ?',9,true,263,null,true);
insert into pgsse_questions values (1,24,264,'Existe-t-il un reglement de service ?',9,true,264,null,true);
insert into pgsse_questions values (1,24,266,'Existe-t-il des procédures d’alerte ?',9,true,266,null,true);
insert into pgsse_questions values (1,24,267,'Existe-t-il des procédures de crise ?',9,true,267,null,true);
insert into pgsse_questions values (1,24,268,'Existe-t-il des procédures rgpd ?',9,true,268,null,true);
insert into pgsse_questions values (1,24,269,'Existe-t-il des procédures cyber ataque ?',9,true,269,null,true);
insert into pgsse_questions values (1,25,280,'Si travaux, procédure d''intervention des entreprises extérieures ? (plan de prévention) ',9,true,280,null,true);
insert into pgsse_questions values (1,25,281,'Réalisation d''un diagnostic des ouvrages ?',9,true,281,null,true);
insert into pgsse_questions values (1,26,283,'Y a-t-il des equipement HT propriéte de la collectivité ?',9,true,283,null,true);
insert into pgsse_questions values (1,27,285,'La zone est-elle concernée par des pollutions diffuses ?',9,true,285,null,true);
insert into pgsse_questions values (1,27,286,'Si oui, une démarche est-elle enclenchée ? (délimitation de l''AAC, animation, ZSCE…)',9,true,286,null,true);
insert into pgsse_questions values (1,27,287,'La zone est-elle en dérogation pour des problèmes de qualité ?',9,true,287,null,true);
insert into pgsse_questions values (1,27,288,'Le niveau d''avancement des pp est-il connu ?',9,true,288,null,true);
insert into pgsse_questions values (1,27,289,'L''équilibre besoin-ressource est-il assuré toute l''année ?',9,true,289,null,true);
insert into pgsse_questions values (1,27,290,'Les arrêtés d''exploitation sont-ils respectés toute l''année ?',9,true,290,null,true);
insert into pgsse_questions values (1,24,278,'Existe-t-il des synoptiques suffisants et mis à jour ? ',9,true,278,null,true);
insert into pgsse_questions values (1,23,234,'La fréquence est-elle satifaisante ? ',9,true,234,null,true);
insert into pgsse_questions values (1,23,237,'Les armoires électriques sont-elles contrôlées périodiquement ?',9,true,237,null,true);
insert into pgsse_questions values (1,23,238,'Quel est le niveau d''exploitation préventif des equipements électro?',9,true,238,'PGSSE.NIVEAU_EXPLOITATION',true);
insert into pgsse_questions values (1,23,244,'Y a t-il une gestion de la métrologie suffisante ?',9,true,244,null,true);
insert into pgsse_questions values (1,23,246,'Si oui toutes les specialités sont-elles auditées ?',9,true,246,null,true);
insert into pgsse_questions values (1,23,247,'Y a-t-il des temps de contacts suffisants avec les produits de désinfection? ',9,true,247,null,true);
insert into pgsse_questions values (1,23,249,'Y a-t-il des problèmes de temps de séjour ? ',9,true,249,null,true);
insert into pgsse_questions values (1,24,256,'Analyse des risques réalisée entre la ressource et le robinet du consommateur – étude de vulnerabilité',9,true,256,null,true);
insert into pgsse_questions values (1,24,261,'Si oui cette liste est-elle mise à jour régulierement ? ',9,true,261,null,true);
insert into pgsse_questions values (1,24,265,'Si oui comporte-t-il des articles sur le respect sanitaire de l''eau? ',9,true,265,null,true);
insert into pgsse_questions values (1,24,270,'Les réseaux sont-ils tous reperés dans le sig ?',9,true,270,null,true);
insert into pgsse_questions values (1,24,271,'Sont-ils en classe A ?',9,true,271,null,true);
insert into pgsse_questions values (1,24,272,'Existe-t-il des moyens de communication classique vers les usagers ?',9,true,272,null,true);
insert into pgsse_questions values (1,24,273,'Existe-t-il des moyens de communication d''urgence vers les usagers ? ',9,true,273,null,true);
insert into pgsse_questions values (1,24,274,'Existe-t-il des moments d''echanges avec le sdiss ?',9,true,274,null,true);
insert into pgsse_questions values (1,24,275,'Existe-t-il des moments d''echanges avec l''ars ?',9,true,275,null,true);
insert into pgsse_questions values (1,24,276,'Existe-t-il des moments d''echanges avec la ddt ?',9,true,276,null,true);
insert into pgsse_questions values (1,24,277,'Existe-t-il des moments d''echanges avec les autres PRPDE voisin ?',9,true,277,null,true);
insert into pgsse_questions values (1,27,284,'Le secteur est-il concerné par des problèmes quantitatifs ?',9,true,284,null,true);
insert into pgsse_questions values (1,21,222,'Si oui les agents sont-ils formés et en nombre suffisant 24/24 ?',9,true,222,null,true);
insert into pgsse_questions values (1,23,248,'L''exploitation respecte t''elle les temps de séjour min et max de l''eau dans les ouvrages ?',9,true,248,null,true);
insert into pgsse_questions values (1,27,291,'Le secteur est-il concerné par des problèmes qualitatifs ?',9,true,284,null,true);


delete from pgsse_questions_restrictions;

insert into pgsse_questions_restrictions values (1,27,284,0,7);
insert into pgsse_questions_restrictions values (1,27,285,0,7);
insert into pgsse_questions_restrictions values (1,27,286,0,7);
insert into pgsse_questions_restrictions values (1,27,287,0,7);
insert into pgsse_questions_restrictions values (1,27,288,0,7);
insert into pgsse_questions_restrictions values (1,27,289,0,7);
insert into pgsse_questions_restrictions values (1,27,290,0,7);
insert into pgsse_questions_restrictions values (1,27,291,0,7);
insert into pgsse_questions_restrictions values (1,27,291,8,7);
insert into pgsse_questions_restrictions values (1,10,95,12,7);
insert into pgsse_questions_restrictions values (1,14,136,8,7);
insert into pgsse_questions_restrictions values (1,6,55,1,7);
insert into pgsse_questions_restrictions values (1,13,127,4,7);
insert into pgsse_questions_restrictions values (1,10,102,2,7);
insert into pgsse_questions_restrictions values (1,7,65,0,7);
insert into pgsse_questions_restrictions values (1,8,69,4,7);
insert into pgsse_questions_restrictions values (1,10,101,8,7);
insert into pgsse_questions_restrictions values (1,9,88,11,7);
insert into pgsse_questions_restrictions values (1,10,99,1,7);
insert into pgsse_questions_restrictions values (1,14,135,10,7);
insert into pgsse_questions_restrictions values (1,12,120,10,7);
insert into pgsse_questions_restrictions values (1,12,117,10,7);
insert into pgsse_questions_restrictions values (1,15,147,11,7);
insert into pgsse_questions_restrictions values (1,15,145,10,7);
insert into pgsse_questions_restrictions values (1,12,122,14,7);
insert into pgsse_questions_restrictions values (1,2,12,10,7);
insert into pgsse_questions_restrictions values (1,13,129,10,7);
insert into pgsse_questions_restrictions values (1,6,54,10,7);
insert into pgsse_questions_restrictions values (1,10,96,8,7);
insert into pgsse_questions_restrictions values (1,3,18,14,7);
insert into pgsse_questions_restrictions values (1,3,18,0,7);
insert into pgsse_questions_restrictions values (1,3,21,8,7);
insert into pgsse_questions_restrictions values (1,7,64,1,7);
insert into pgsse_questions_restrictions values (1,13,128,10,7);
insert into pgsse_questions_restrictions values (1,10,100,11,7);
insert into pgsse_questions_restrictions values (1,17,167,2,7);
insert into pgsse_questions_restrictions values (1,10,99,14,7);
insert into pgsse_questions_restrictions values (1,13,129,14,7);
insert into pgsse_questions_restrictions values (1,8,75,14,7);
insert into pgsse_questions_restrictions values (1,27,284,8,7);
insert into pgsse_questions_restrictions values (1,27,285,8,7);
insert into pgsse_questions_restrictions values (1,27,286,8,7);
insert into pgsse_questions_restrictions values (1,27,287,8,7);
insert into pgsse_questions_restrictions values (1,27,288,8,7);
insert into pgsse_questions_restrictions values (1,27,289,8,7);
insert into pgsse_questions_restrictions values (1,27,290,8,7);
insert into pgsse_questions_restrictions values (1,23,233,null,8);
insert into pgsse_questions_restrictions values (1,23,234,null,8);
insert into pgsse_questions_restrictions values (1,23,235,null,8);
insert into pgsse_questions_restrictions values (1,23,236,null,8);
insert into pgsse_questions_restrictions values (1,23,237,null,8);
insert into pgsse_questions_restrictions values (1,23,238,null,8);
insert into pgsse_questions_restrictions values (1,23,239,null,8);
insert into pgsse_questions_restrictions values (1,23,240,null,8);
insert into pgsse_questions_restrictions values (1,23,241,null,8);
insert into pgsse_questions_restrictions values (1,23,242,null,8);
insert into pgsse_questions_restrictions values (1,23,243,null,8);
insert into pgsse_questions_restrictions values (1,23,244,null,8);
insert into pgsse_questions_restrictions values (1,23,245,null,8);
insert into pgsse_questions_restrictions values (1,23,246,null,8);
insert into pgsse_questions_restrictions values (1,23,247,null,8);
insert into pgsse_questions_restrictions values (1,23,248,null,8);
insert into pgsse_questions_restrictions values (1,23,249,null,8);
insert into pgsse_questions_restrictions values (1,24,251,null,8);
insert into pgsse_questions_restrictions values (1,24,252,null,8);
insert into pgsse_questions_restrictions values (1,24,253,null,8);
insert into pgsse_questions_restrictions values (1,24,254,null,8);
insert into pgsse_questions_restrictions values (1,24,255,null,8);
insert into pgsse_questions_restrictions values (1,24,256,null,8);
insert into pgsse_questions_restrictions values (1,24,257,null,8);
insert into pgsse_questions_restrictions values (1,24,258,null,8);
insert into pgsse_questions_restrictions values (1,24,259,null,8);
insert into pgsse_questions_restrictions values (1,24,260,null,8);
insert into pgsse_questions_restrictions values (1,24,261,null,8);
insert into pgsse_questions_restrictions values (1,24,262,null,8);
insert into pgsse_questions_restrictions values (1,24,263,null,8);
insert into pgsse_questions_restrictions values (1,24,264,null,8);
insert into pgsse_questions_restrictions values (1,24,265,null,8);
insert into pgsse_questions_restrictions values (1,24,266,null,8);
insert into pgsse_questions_restrictions values (1,24,267,null,8);
insert into pgsse_questions_restrictions values (1,24,268,null,8);
insert into pgsse_questions_restrictions values (1,24,269,null,8);
insert into pgsse_questions_restrictions values (1,24,270,null,8);
insert into pgsse_questions_restrictions values (1,24,271,null,8);
insert into pgsse_questions_restrictions values (1,24,272,null,8);
insert into pgsse_questions_restrictions values (1,24,273,null,8);
insert into pgsse_questions_restrictions values (1,24,274,null,8);
insert into pgsse_questions_restrictions values (1,24,275,null,8);
insert into pgsse_questions_restrictions values (1,24,276,null,8);
insert into pgsse_questions_restrictions values (1,24,277,null,8);
insert into pgsse_questions_restrictions values (1,24,278,null,8);
insert into pgsse_questions_restrictions values (1,25,280,null,8);
insert into pgsse_questions_restrictions values (1,25,281,null,8);
insert into pgsse_questions_restrictions values (1,26,283,null,8);
insert into pgsse_questions_restrictions values (1,1,5,2,7);
insert into pgsse_questions_restrictions values (1,8,77,11,7);
insert into pgsse_questions_restrictions values (1,3,25,11,7);
insert into pgsse_questions_restrictions values (1,17,168,10,7);
insert into pgsse_questions_restrictions values (1,17,166,8,7);
insert into pgsse_questions_restrictions values (1,9,85,1,7);
insert into pgsse_questions_restrictions values (1,5,42,0,7);
insert into pgsse_questions_restrictions values (1,13,131,11,7);
insert into pgsse_questions_restrictions values (1,5,45,1,7);
insert into pgsse_questions_restrictions values (1,10,95,4,7);
insert into pgsse_questions_restrictions values (1,15,146,8,7);
insert into pgsse_questions_restrictions values (1,6,56,1,7);
insert into pgsse_questions_restrictions values (1,10,97,10,7);
insert into pgsse_questions_restrictions values (1,11,112,14,7);
insert into pgsse_questions_restrictions values (1,4,32,14,7);
insert into pgsse_questions_restrictions values (1,8,69,8,7);
insert into pgsse_questions_restrictions values (1,16,157,8,7);
insert into pgsse_questions_restrictions values (1,16,154,1,7);
insert into pgsse_questions_restrictions values (1,15,146,1,7);
insert into pgsse_questions_restrictions values (1,15,141,12,7);
insert into pgsse_questions_restrictions values (1,11,111,0,7);
insert into pgsse_questions_restrictions values (1,8,69,0,7);
insert into pgsse_questions_restrictions values (1,1,7,14,7);
insert into pgsse_questions_restrictions values (1,1,2,1,7);
insert into pgsse_questions_restrictions values (1,15,144,0,7);
insert into pgsse_questions_restrictions values (1,12,120,14,7);
insert into pgsse_questions_restrictions values (1,11,112,11,7);
insert into pgsse_questions_restrictions values (1,6,53,8,7);
insert into pgsse_questions_restrictions values (1,4,34,1,7);
insert into pgsse_questions_restrictions values (1,10,101,12,7);
insert into pgsse_questions_restrictions values (1,3,19,0,7);
insert into pgsse_questions_restrictions values (1,1,2,0,7);
insert into pgsse_questions_restrictions values (1,14,135,4,7);
insert into pgsse_questions_restrictions values (1,4,29,0,7);
insert into pgsse_questions_restrictions values (1,1,3,1,7);
insert into pgsse_questions_restrictions values (1,11,108,4,7);
insert into pgsse_questions_restrictions values (1,4,31,0,7);
insert into pgsse_questions_restrictions values (1,8,72,2,7);
insert into pgsse_questions_restrictions values (1,5,46,0,7);
insert into pgsse_questions_restrictions values (1,1,3,10,7);
insert into pgsse_questions_restrictions values (1,6,53,0,7);
insert into pgsse_questions_restrictions values (1,12,120,8,7);
insert into pgsse_questions_restrictions values (1,12,117,1,7);
insert into pgsse_questions_restrictions values (1,17,171,10,7);
insert into pgsse_questions_restrictions values (1,3,18,12,7);
insert into pgsse_questions_restrictions values (1,9,88,12,7);
insert into pgsse_questions_restrictions values (1,17,168,12,7);
insert into pgsse_questions_restrictions values (1,9,87,8,7);
insert into pgsse_questions_restrictions values (1,3,22,14,7);
insert into pgsse_questions_restrictions values (1,17,166,1,7);
insert into pgsse_questions_restrictions values (1,13,129,0,7);
insert into pgsse_questions_restrictions values (1,6,54,4,7);
insert into pgsse_questions_restrictions values (1,8,74,11,7);
insert into pgsse_questions_restrictions values (1,4,29,14,7);
insert into pgsse_questions_restrictions values (1,10,100,1,7);
insert into pgsse_questions_restrictions values (1,4,32,10,7);
insert into pgsse_questions_restrictions values (1,12,119,11,7);
insert into pgsse_questions_restrictions values (1,9,87,14,7);
insert into pgsse_questions_restrictions values (1,12,122,0,7);
insert into pgsse_questions_restrictions values (1,5,42,4,7);
insert into pgsse_questions_restrictions values (1,9,90,12,7);
insert into pgsse_questions_restrictions values (1,4,33,8,7);
insert into pgsse_questions_restrictions values (1,3,20,11,7);
insert into pgsse_questions_restrictions values (1,17,170,11,7);
insert into pgsse_questions_restrictions values (1,1,6,2,7);
insert into pgsse_questions_restrictions values (1,9,88,14,7);
insert into pgsse_questions_restrictions values (1,16,155,4,7);
insert into pgsse_questions_restrictions values (1,6,56,4,7);
insert into pgsse_questions_restrictions values (1,5,43,4,7);
insert into pgsse_questions_restrictions values (1,17,164,0,7);
insert into pgsse_questions_restrictions values (1,10,94,2,7);
insert into pgsse_questions_restrictions values (1,9,85,12,7);
insert into pgsse_questions_restrictions values (1,8,69,2,7);
insert into pgsse_questions_restrictions values (1,12,119,10,7);
insert into pgsse_questions_restrictions values (1,9,81,2,7);
insert into pgsse_questions_restrictions values (1,13,131,1,7);
insert into pgsse_questions_restrictions values (1,3,20,8,7);
insert into pgsse_questions_restrictions values (1,9,89,8,7);
insert into pgsse_questions_restrictions values (1,7,63,4,7);
insert into pgsse_questions_restrictions values (1,9,88,4,7);
insert into pgsse_questions_restrictions values (1,4,35,4,7);
insert into pgsse_questions_restrictions values (1,7,62,2,7);
insert into pgsse_questions_restrictions values (1,12,118,0,7);
insert into pgsse_questions_restrictions values (1,14,136,0,7);
insert into pgsse_questions_restrictions values (1,8,77,0,7);
insert into pgsse_questions_restrictions values (1,8,70,8,7);
insert into pgsse_questions_restrictions values (1,8,73,4,7);
insert into pgsse_questions_restrictions values (1,6,51,2,7);
insert into pgsse_questions_restrictions values (1,1,5,10,7);
insert into pgsse_questions_restrictions values (1,9,88,8,7);
insert into pgsse_questions_restrictions values (1,6,56,11,7);
insert into pgsse_questions_restrictions values (1,17,166,10,7);
insert into pgsse_questions_restrictions values (1,16,156,4,7);
insert into pgsse_questions_restrictions values (1,13,130,8,7);
insert into pgsse_questions_restrictions values (1,6,50,4,7);
insert into pgsse_questions_restrictions values (1,11,110,11,7);
insert into pgsse_questions_restrictions values (1,7,65,4,7);
insert into pgsse_questions_restrictions values (1,3,17,4,7);
insert into pgsse_questions_restrictions values (1,4,35,10,7);
insert into pgsse_questions_restrictions values (1,17,164,4,7);
insert into pgsse_questions_restrictions values (1,10,94,0,7);
insert into pgsse_questions_restrictions values (1,13,127,1,7);
insert into pgsse_questions_restrictions values (1,3,22,10,7);
insert into pgsse_questions_restrictions values (1,4,31,14,7);
insert into pgsse_questions_restrictions values (1,4,32,4,7);
insert into pgsse_questions_restrictions values (1,3,18,1,7);
insert into pgsse_questions_restrictions values (1,5,42,1,7);
insert into pgsse_questions_restrictions values (1,17,164,14,7);
insert into pgsse_questions_restrictions values (1,2,11,11,7);
insert into pgsse_questions_restrictions values (1,10,104,11,7);
insert into pgsse_questions_restrictions values (1,16,156,2,7);
insert into pgsse_questions_restrictions values (1,17,167,10,7);
insert into pgsse_questions_restrictions values (1,14,137,8,7);
insert into pgsse_questions_restrictions values (1,11,110,2,7);
insert into pgsse_questions_restrictions values (1,7,60,14,7);
insert into pgsse_questions_restrictions values (1,3,19,1,7);
insert into pgsse_questions_restrictions values (1,4,33,12,7);
insert into pgsse_questions_restrictions values (1,6,52,14,7);
insert into pgsse_questions_restrictions values (1,2,13,14,7);
insert into pgsse_questions_restrictions values (1,4,38,10,7);
insert into pgsse_questions_restrictions values (1,16,153,11,7);
insert into pgsse_questions_restrictions values (1,15,146,10,7);
insert into pgsse_questions_restrictions values (1,3,23,1,7);
insert into pgsse_questions_restrictions values (1,9,89,0,7);
insert into pgsse_questions_restrictions values (1,2,13,4,7);
insert into pgsse_questions_restrictions values (1,17,169,2,7);
insert into pgsse_questions_restrictions values (1,4,31,2,7);
insert into pgsse_questions_restrictions values (1,8,69,11,7);
insert into pgsse_questions_restrictions values (1,1,5,12,7);
insert into pgsse_questions_restrictions values (1,9,90,11,7);
insert into pgsse_questions_restrictions values (1,1,3,12,7);
insert into pgsse_questions_restrictions values (1,4,31,12,7);
insert into pgsse_questions_restrictions values (1,7,62,14,7);
insert into pgsse_questions_restrictions values (1,4,38,4,7);
insert into pgsse_questions_restrictions values (1,13,130,14,7);
insert into pgsse_questions_restrictions values (1,14,136,1,7);
insert into pgsse_questions_restrictions values (1,17,167,1,7);
insert into pgsse_questions_restrictions values (1,15,148,2,7);
insert into pgsse_questions_restrictions values (1,16,154,8,7);
insert into pgsse_questions_restrictions values (1,11,108,1,7);
insert into pgsse_questions_restrictions values (1,9,88,0,7);
insert into pgsse_questions_restrictions values (1,10,99,10,7);
insert into pgsse_questions_restrictions values (1,10,97,14,7);
insert into pgsse_questions_restrictions values (1,6,50,0,7);
insert into pgsse_questions_restrictions values (1,3,25,8,7);
insert into pgsse_questions_restrictions values (1,6,54,11,7);
insert into pgsse_questions_restrictions values (1,2,13,2,7);
insert into pgsse_questions_restrictions values (1,10,96,10,7);
insert into pgsse_questions_restrictions values (1,10,102,12,7);
insert into pgsse_questions_restrictions values (1,13,126,1,7);
insert into pgsse_questions_restrictions values (1,6,54,14,7);
insert into pgsse_questions_restrictions values (1,8,76,11,7);
insert into pgsse_questions_restrictions values (1,6,52,8,7);
insert into pgsse_questions_restrictions values (1,16,158,1,7);
insert into pgsse_questions_restrictions values (1,16,156,14,7);
insert into pgsse_questions_restrictions values (1,3,23,12,7);
insert into pgsse_questions_restrictions values (1,15,148,0,7);
insert into pgsse_questions_restrictions values (1,8,76,8,7);
insert into pgsse_questions_restrictions values (1,10,95,2,7);
insert into pgsse_questions_restrictions values (1,7,63,2,7);
insert into pgsse_questions_restrictions values (1,12,117,11,7);
insert into pgsse_questions_restrictions values (1,4,36,2,7);
insert into pgsse_questions_restrictions values (1,13,128,1,7);
insert into pgsse_questions_restrictions values (1,6,55,12,7);
insert into pgsse_questions_restrictions values (1,1,3,4,7);
insert into pgsse_questions_restrictions values (1,1,3,14,7);
insert into pgsse_questions_restrictions values (1,13,130,11,7);
insert into pgsse_questions_restrictions values (1,8,69,14,7);
insert into pgsse_questions_restrictions values (1,11,111,14,7);
insert into pgsse_questions_restrictions values (1,13,130,4,7);
insert into pgsse_questions_restrictions values (1,9,83,12,7);
insert into pgsse_questions_restrictions values (1,12,120,4,7);
insert into pgsse_questions_restrictions values (1,5,45,11,7);
insert into pgsse_questions_restrictions values (1,13,129,12,7);
insert into pgsse_questions_restrictions values (1,1,7,10,7);
insert into pgsse_questions_restrictions values (1,13,127,8,7);
insert into pgsse_questions_restrictions values (1,8,70,14,7);
insert into pgsse_questions_restrictions values (1,15,144,4,7);
insert into pgsse_questions_restrictions values (1,13,130,12,7);
insert into pgsse_questions_restrictions values (1,13,128,2,7);
insert into pgsse_questions_restrictions values (1,10,98,1,7);
insert into pgsse_questions_restrictions values (1,10,101,10,7);
insert into pgsse_questions_restrictions values (1,4,37,14,7);
insert into pgsse_questions_restrictions values (1,8,72,4,7);
insert into pgsse_questions_restrictions values (1,17,164,11,7);
insert into pgsse_questions_restrictions values (1,8,69,10,7);
insert into pgsse_questions_restrictions values (1,8,73,1,7);
insert into pgsse_questions_restrictions values (1,11,111,2,7);
insert into pgsse_questions_restrictions values (1,9,86,8,7);
insert into pgsse_questions_restrictions values (1,4,35,14,7);
insert into pgsse_questions_restrictions values (1,3,19,4,7);
insert into pgsse_questions_restrictions values (1,3,17,1,7);
insert into pgsse_questions_restrictions values (1,8,77,4,7);
insert into pgsse_questions_restrictions values (1,10,100,12,7);
insert into pgsse_questions_restrictions values (1,9,88,1,7);
insert into pgsse_questions_restrictions values (1,10,94,11,7);
insert into pgsse_questions_restrictions values (1,4,37,2,7);
insert into pgsse_questions_restrictions values (1,16,159,12,7);
insert into pgsse_questions_restrictions values (1,10,100,14,7);
insert into pgsse_questions_restrictions values (1,13,130,10,7);
insert into pgsse_questions_restrictions values (1,3,20,10,7);
insert into pgsse_questions_restrictions values (1,6,52,10,7);
insert into pgsse_questions_restrictions values (1,17,168,1,7);
insert into pgsse_questions_restrictions values (1,2,11,4,7);
insert into pgsse_questions_restrictions values (1,14,137,4,7);
insert into pgsse_questions_restrictions values (1,17,170,2,7);
insert into pgsse_questions_restrictions values (1,3,20,0,7);
insert into pgsse_questions_restrictions values (1,11,112,10,7);
insert into pgsse_questions_restrictions values (1,1,7,8,7);
insert into pgsse_questions_restrictions values (1,14,135,1,7);
insert into pgsse_questions_restrictions values (1,8,73,0,7);
insert into pgsse_questions_restrictions values (1,15,145,8,7);
insert into pgsse_questions_restrictions values (1,7,64,12,7);
insert into pgsse_questions_restrictions values (1,11,111,10,7);
insert into pgsse_questions_restrictions values (1,13,131,12,7);
insert into pgsse_questions_restrictions values (1,10,99,2,7);
insert into pgsse_questions_restrictions values (1,17,167,8,7);
insert into pgsse_questions_restrictions values (1,16,155,12,7);
insert into pgsse_questions_restrictions values (1,11,109,0,7);
insert into pgsse_questions_restrictions values (1,7,62,0,7);
insert into pgsse_questions_restrictions values (1,8,70,1,7);
insert into pgsse_questions_restrictions values (1,15,143,1,7);
insert into pgsse_questions_restrictions values (1,5,44,1,7);
insert into pgsse_questions_restrictions values (1,5,46,1,7);
insert into pgsse_questions_restrictions values (1,2,13,8,7);
insert into pgsse_questions_restrictions values (1,16,157,4,7);
insert into pgsse_questions_restrictions values (1,13,126,10,7);
insert into pgsse_questions_restrictions values (1,3,23,0,7);
insert into pgsse_questions_restrictions values (1,11,110,10,7);
insert into pgsse_questions_restrictions values (1,3,24,0,7);
insert into pgsse_questions_restrictions values (1,17,165,11,7);
insert into pgsse_questions_restrictions values (1,3,20,12,7);
insert into pgsse_questions_restrictions values (1,5,42,8,7);
insert into pgsse_questions_restrictions values (1,16,160,4,7);
insert into pgsse_questions_restrictions values (1,3,23,8,7);
insert into pgsse_questions_restrictions values (1,4,36,0,7);
insert into pgsse_questions_restrictions values (1,9,89,2,7);
insert into pgsse_questions_restrictions values (1,14,136,2,7);
insert into pgsse_questions_restrictions values (1,5,45,10,7);
insert into pgsse_questions_restrictions values (1,4,36,8,7);
insert into pgsse_questions_restrictions values (1,10,102,8,7);
insert into pgsse_questions_restrictions values (1,11,109,12,7);
insert into pgsse_questions_restrictions values (1,16,158,2,7);
insert into pgsse_questions_restrictions values (1,1,4,14,7);
insert into pgsse_questions_restrictions values (1,16,154,2,7);
insert into pgsse_questions_restrictions values (1,15,143,0,7);
insert into pgsse_questions_restrictions values (1,4,34,12,7);
insert into pgsse_questions_restrictions values (1,10,104,8,7);
insert into pgsse_questions_restrictions values (1,6,52,4,7);
insert into pgsse_questions_restrictions values (1,17,171,14,7);
insert into pgsse_questions_restrictions values (1,3,21,0,7);
insert into pgsse_questions_restrictions values (1,9,84,10,7);
insert into pgsse_questions_restrictions values (1,15,148,14,7);
insert into pgsse_questions_restrictions values (1,9,81,10,7);
insert into pgsse_questions_restrictions values (1,3,20,14,7);
insert into pgsse_questions_restrictions values (1,17,164,1,7);
insert into pgsse_questions_restrictions values (1,7,65,11,7);
insert into pgsse_questions_restrictions values (1,4,31,4,7);
insert into pgsse_questions_restrictions values (1,10,103,1,7);
insert into pgsse_questions_restrictions values (1,4,32,8,7);
insert into pgsse_questions_restrictions values (1,3,21,2,7);
insert into pgsse_questions_restrictions values (1,5,43,11,7);
insert into pgsse_questions_restrictions values (1,6,51,8,7);
insert into pgsse_questions_restrictions values (1,17,170,0,7);
insert into pgsse_questions_restrictions values (1,5,46,4,7);
insert into pgsse_questions_restrictions values (1,14,136,10,7);
insert into pgsse_questions_restrictions values (1,7,65,1,7);
insert into pgsse_questions_restrictions values (1,5,44,10,7);
insert into pgsse_questions_restrictions values (1,4,38,12,7);
insert into pgsse_questions_restrictions values (1,5,43,12,7);
insert into pgsse_questions_restrictions values (1,8,74,8,7);
insert into pgsse_questions_restrictions values (1,9,85,11,7);
insert into pgsse_questions_restrictions values (1,4,35,11,7);
insert into pgsse_questions_restrictions values (1,17,168,11,7);
insert into pgsse_questions_restrictions values (1,2,12,1,7);
insert into pgsse_questions_restrictions values (1,2,12,0,7);
insert into pgsse_questions_restrictions values (1,8,72,0,7);
insert into pgsse_questions_restrictions values (1,6,56,2,7);
insert into pgsse_questions_restrictions values (1,3,21,11,7);
insert into pgsse_questions_restrictions values (1,8,71,1,7);
insert into pgsse_questions_restrictions values (1,11,112,2,7);
insert into pgsse_questions_restrictions values (1,8,70,12,7);
insert into pgsse_questions_restrictions values (1,5,45,0,7);
insert into pgsse_questions_restrictions values (1,4,38,8,7);
insert into pgsse_questions_restrictions values (1,4,34,4,7);
insert into pgsse_questions_restrictions values (1,8,75,11,7);
insert into pgsse_questions_restrictions values (1,7,64,10,7);
insert into pgsse_questions_restrictions values (1,9,90,14,7);
insert into pgsse_questions_restrictions values (1,3,24,8,7);
insert into pgsse_questions_restrictions values (1,2,12,4,7);
insert into pgsse_questions_restrictions values (1,12,122,2,7);
insert into pgsse_questions_restrictions values (1,15,142,8,7);
insert into pgsse_questions_restrictions values (1,8,75,4,7);
insert into pgsse_questions_restrictions values (1,7,61,1,7);
insert into pgsse_questions_restrictions values (1,9,86,11,7);
insert into pgsse_questions_restrictions values (1,12,121,4,7);
insert into pgsse_questions_restrictions values (1,3,20,2,7);
insert into pgsse_questions_restrictions values (1,17,164,12,7);
insert into pgsse_questions_restrictions values (1,9,81,4,7);
insert into pgsse_questions_restrictions values (1,16,157,2,7);
insert into pgsse_questions_restrictions values (1,3,17,14,7);
insert into pgsse_questions_restrictions values (1,15,147,10,7);
insert into pgsse_questions_restrictions values (1,11,108,10,7);
insert into pgsse_questions_restrictions values (1,10,96,12,7);
insert into pgsse_questions_restrictions values (1,13,131,8,7);
insert into pgsse_questions_restrictions values (1,10,101,4,7);
insert into pgsse_questions_restrictions values (1,17,170,1,7);
insert into pgsse_questions_restrictions values (1,9,82,12,7);
insert into pgsse_questions_restrictions values (1,1,3,2,7);
insert into pgsse_questions_restrictions values (1,12,121,0,7);
insert into pgsse_questions_restrictions values (1,12,119,0,7);
insert into pgsse_questions_restrictions values (1,14,137,14,7);
insert into pgsse_questions_restrictions values (1,7,60,1,7);
insert into pgsse_questions_restrictions values (1,1,7,12,7);
insert into pgsse_questions_restrictions values (1,12,121,1,7);
insert into pgsse_questions_restrictions values (1,15,146,14,7);
insert into pgsse_questions_restrictions values (1,7,63,1,7);
insert into pgsse_questions_restrictions values (1,10,96,2,7);
insert into pgsse_questions_restrictions values (1,10,99,11,7);
insert into pgsse_questions_restrictions values (1,7,62,1,7);
insert into pgsse_questions_restrictions values (1,6,50,14,7);
insert into pgsse_questions_restrictions values (1,10,100,4,7);
insert into pgsse_questions_restrictions values (1,15,143,4,7);
insert into pgsse_questions_restrictions values (1,16,159,0,7);
insert into pgsse_questions_restrictions values (1,8,74,0,7);
insert into pgsse_questions_restrictions values (1,2,13,1,7);
insert into pgsse_questions_restrictions values (1,5,44,8,7);
insert into pgsse_questions_restrictions values (1,15,142,12,7);
insert into pgsse_questions_restrictions values (1,13,131,10,7);
insert into pgsse_questions_restrictions values (1,1,4,8,7);
insert into pgsse_questions_restrictions values (1,4,30,1,7);
insert into pgsse_questions_restrictions values (1,2,11,0,7);
insert into pgsse_questions_restrictions values (1,3,24,2,7);
insert into pgsse_questions_restrictions values (1,3,19,14,7);
insert into pgsse_questions_restrictions values (1,15,143,11,7);
insert into pgsse_questions_restrictions values (1,10,98,0,7);
insert into pgsse_questions_restrictions values (1,13,127,14,7);
insert into pgsse_questions_restrictions values (1,9,84,0,7);
insert into pgsse_questions_restrictions values (1,3,22,11,7);
insert into pgsse_questions_restrictions values (1,17,165,10,7);
insert into pgsse_questions_restrictions values (1,10,103,4,7);
insert into pgsse_questions_restrictions values (1,16,153,12,7);
insert into pgsse_questions_restrictions values (1,13,129,11,7);
insert into pgsse_questions_restrictions values (1,9,84,12,7);
insert into pgsse_questions_restrictions values (1,10,94,14,7);
insert into pgsse_questions_restrictions values (1,15,141,1,7);
insert into pgsse_questions_restrictions values (1,9,84,2,7);
insert into pgsse_questions_restrictions values (1,9,88,2,7);
insert into pgsse_questions_restrictions values (1,7,62,8,7);
insert into pgsse_questions_restrictions values (1,3,20,1,7);
insert into pgsse_questions_restrictions values (1,4,37,10,7);
insert into pgsse_questions_restrictions values (1,13,126,2,7);
insert into pgsse_questions_restrictions values (1,4,37,8,7);
insert into pgsse_questions_restrictions values (1,2,13,11,7);
insert into pgsse_questions_restrictions values (1,17,168,0,7);
insert into pgsse_questions_restrictions values (1,17,170,8,7);
insert into pgsse_questions_restrictions values (1,9,81,1,7);
insert into pgsse_questions_restrictions values (1,4,31,8,7);
insert into pgsse_questions_restrictions values (1,15,148,8,7);
insert into pgsse_questions_restrictions values (1,9,86,14,7);
insert into pgsse_questions_restrictions values (1,10,101,0,7);
insert into pgsse_questions_restrictions values (1,14,137,2,7);
insert into pgsse_questions_restrictions values (1,15,147,0,7);
insert into pgsse_questions_restrictions values (1,4,38,2,7);
insert into pgsse_questions_restrictions values (1,9,83,1,7);
insert into pgsse_questions_restrictions values (1,6,50,8,7);
insert into pgsse_questions_restrictions values (1,9,82,2,7);
insert into pgsse_questions_restrictions values (1,7,64,11,7);
insert into pgsse_questions_restrictions values (1,10,97,11,7);
insert into pgsse_questions_restrictions values (1,11,108,8,7);
insert into pgsse_questions_restrictions values (1,17,171,2,7);
insert into pgsse_questions_restrictions values (1,12,118,1,7);
insert into pgsse_questions_restrictions values (1,4,33,0,7);
insert into pgsse_questions_restrictions values (1,15,141,0,7);
insert into pgsse_questions_restrictions values (1,1,4,1,7);
insert into pgsse_questions_restrictions values (1,10,98,10,7);
insert into pgsse_questions_restrictions values (1,11,113,8,7);
insert into pgsse_questions_restrictions values (1,16,155,10,7);
insert into pgsse_questions_restrictions values (1,8,74,4,7);
insert into pgsse_questions_restrictions values (1,1,5,1,7);
insert into pgsse_questions_restrictions values (1,4,37,11,7);
insert into pgsse_questions_restrictions values (1,10,101,1,7);
insert into pgsse_questions_restrictions values (1,6,55,10,7);
insert into pgsse_questions_restrictions values (1,3,17,8,7);
insert into pgsse_questions_restrictions values (1,6,54,8,7);
insert into pgsse_questions_restrictions values (1,8,69,1,7);
insert into pgsse_questions_restrictions values (1,8,72,10,7);
insert into pgsse_questions_restrictions values (1,15,149,10,7);
insert into pgsse_questions_restrictions values (1,9,84,8,7);
insert into pgsse_questions_restrictions values (1,12,122,11,7);
insert into pgsse_questions_restrictions values (1,17,165,2,7);
insert into pgsse_questions_restrictions values (1,1,6,0,7);
insert into pgsse_questions_restrictions values (1,11,112,0,7);
insert into pgsse_questions_restrictions values (1,15,142,11,7);
insert into pgsse_questions_restrictions values (1,17,166,2,7);
insert into pgsse_questions_restrictions values (1,8,75,0,7);
insert into pgsse_questions_restrictions values (1,10,95,14,7);
insert into pgsse_questions_restrictions values (1,6,53,2,7);
insert into pgsse_questions_restrictions values (1,1,5,4,7);
insert into pgsse_questions_restrictions values (1,3,22,2,7);
insert into pgsse_questions_restrictions values (1,3,19,11,7);
insert into pgsse_questions_restrictions values (1,3,23,4,7);
insert into pgsse_questions_restrictions values (1,4,29,1,7);
insert into pgsse_questions_restrictions values (1,14,137,12,7);
insert into pgsse_questions_restrictions values (1,1,4,12,7);
insert into pgsse_questions_restrictions values (1,17,170,12,7);
insert into pgsse_questions_restrictions values (1,11,108,12,7);
insert into pgsse_questions_restrictions values (1,6,52,11,7);
insert into pgsse_questions_restrictions values (1,4,29,2,7);
insert into pgsse_questions_restrictions values (1,9,85,4,7);
insert into pgsse_questions_restrictions values (1,7,61,2,7);
insert into pgsse_questions_restrictions values (1,10,99,4,7);
insert into pgsse_questions_restrictions values (1,3,25,1,7);
insert into pgsse_questions_restrictions values (1,15,142,1,7);
insert into pgsse_questions_restrictions values (1,9,82,14,7);
insert into pgsse_questions_restrictions values (1,12,119,1,7);
insert into pgsse_questions_restrictions values (1,8,76,2,7);
insert into pgsse_questions_restrictions values (1,10,102,11,7);
insert into pgsse_questions_restrictions values (1,6,50,1,7);
insert into pgsse_questions_restrictions values (1,13,129,2,7);
insert into pgsse_questions_restrictions values (1,12,118,10,7);
insert into pgsse_questions_restrictions values (1,9,89,14,7);
insert into pgsse_questions_restrictions values (1,10,98,14,7);
insert into pgsse_questions_restrictions values (1,12,117,4,7);
insert into pgsse_questions_restrictions values (1,15,145,1,7);
insert into pgsse_questions_restrictions values (1,13,131,4,7);
insert into pgsse_questions_restrictions values (1,12,121,11,7);
insert into pgsse_questions_restrictions values (1,4,29,11,7);
insert into pgsse_questions_restrictions values (1,11,108,14,7);
insert into pgsse_questions_restrictions values (1,11,110,1,7);
insert into pgsse_questions_restrictions values (1,15,149,8,7);
insert into pgsse_questions_restrictions values (1,8,76,12,7);
insert into pgsse_questions_restrictions values (1,17,164,2,7);
insert into pgsse_questions_restrictions values (1,17,167,12,7);
insert into pgsse_questions_restrictions values (1,15,146,11,7);
insert into pgsse_questions_restrictions values (1,9,83,11,7);
insert into pgsse_questions_restrictions values (1,1,5,0,7);
insert into pgsse_questions_restrictions values (1,16,158,0,7);
insert into pgsse_questions_restrictions values (1,3,24,12,7);
insert into pgsse_questions_restrictions values (1,1,2,10,7);
insert into pgsse_questions_restrictions values (1,14,136,12,7);
insert into pgsse_questions_restrictions values (1,16,153,1,7);
insert into pgsse_questions_restrictions values (1,6,51,0,7);
insert into pgsse_questions_restrictions values (1,10,100,2,7);
insert into pgsse_questions_restrictions values (1,7,62,10,7);
insert into pgsse_questions_restrictions values (1,8,69,12,7);
insert into pgsse_questions_restrictions values (1,15,149,2,7);
insert into pgsse_questions_restrictions values (1,1,4,2,7);
insert into pgsse_questions_restrictions values (1,16,156,1,7);
insert into pgsse_questions_restrictions values (1,3,19,2,7);
insert into pgsse_questions_restrictions values (1,15,141,4,7);
insert into pgsse_questions_restrictions values (1,5,44,0,7);
insert into pgsse_questions_restrictions values (1,14,136,4,7);
insert into pgsse_questions_restrictions values (1,11,109,10,7);
insert into pgsse_questions_restrictions values (1,7,65,8,7);
insert into pgsse_questions_restrictions values (1,4,30,14,7);
insert into pgsse_questions_restrictions values (1,17,165,1,7);
insert into pgsse_questions_restrictions values (1,8,76,4,7);
insert into pgsse_questions_restrictions values (1,9,83,8,7);
insert into pgsse_questions_restrictions values (1,11,113,14,7);
insert into pgsse_questions_restrictions values (1,4,37,12,7);
insert into pgsse_questions_restrictions values (1,17,165,12,7);
insert into pgsse_questions_restrictions values (1,4,36,12,7);
insert into pgsse_questions_restrictions values (1,11,110,0,7);
insert into pgsse_questions_restrictions values (1,7,61,4,7);
insert into pgsse_questions_restrictions values (1,8,75,10,7);
insert into pgsse_questions_restrictions values (1,9,81,12,7);
insert into pgsse_questions_restrictions values (1,2,12,12,7);
insert into pgsse_questions_restrictions values (1,10,98,4,7);
insert into pgsse_questions_restrictions values (1,10,104,14,7);
insert into pgsse_questions_restrictions values (1,17,171,8,7);
insert into pgsse_questions_restrictions values (1,10,97,8,7);
insert into pgsse_questions_restrictions values (1,5,46,10,7);
insert into pgsse_questions_restrictions values (1,4,31,1,7);
insert into pgsse_questions_restrictions values (1,12,119,2,7);
insert into pgsse_questions_restrictions values (1,9,89,10,7);
insert into pgsse_questions_restrictions values (1,12,118,8,7);
insert into pgsse_questions_restrictions values (1,11,111,8,7);
insert into pgsse_questions_restrictions values (1,4,29,12,7);
insert into pgsse_questions_restrictions values (1,15,141,8,7);
insert into pgsse_questions_restrictions values (1,15,149,1,7);
insert into pgsse_questions_restrictions values (1,16,155,2,7);
insert into pgsse_questions_restrictions values (1,8,72,12,7);
insert into pgsse_questions_restrictions values (1,5,45,4,7);
insert into pgsse_questions_restrictions values (1,17,171,0,7);
insert into pgsse_questions_restrictions values (1,13,131,0,7);
insert into pgsse_questions_restrictions values (1,16,155,1,7);
insert into pgsse_questions_restrictions values (1,16,154,10,7);
insert into pgsse_questions_restrictions values (1,4,38,11,7);
insert into pgsse_questions_restrictions values (1,8,73,2,7);
insert into pgsse_questions_restrictions values (1,11,108,11,7);
insert into pgsse_questions_restrictions values (1,17,169,8,7);
insert into pgsse_questions_restrictions values (1,9,90,4,7);
insert into pgsse_questions_restrictions values (1,15,143,14,7);
insert into pgsse_questions_restrictions values (1,9,85,2,7);
insert into pgsse_questions_restrictions values (1,15,147,12,7);
insert into pgsse_questions_restrictions values (1,16,155,0,7);
insert into pgsse_questions_restrictions values (1,1,2,2,7);
insert into pgsse_questions_restrictions values (1,17,170,4,7);
insert into pgsse_questions_restrictions values (1,15,148,10,7);
insert into pgsse_questions_restrictions values (1,16,154,12,7);
insert into pgsse_questions_restrictions values (1,15,147,4,7);
insert into pgsse_questions_restrictions values (1,7,60,4,7);
insert into pgsse_questions_restrictions values (1,14,136,14,7);
insert into pgsse_questions_restrictions values (1,1,6,11,7);
insert into pgsse_questions_restrictions values (1,8,76,10,7);
insert into pgsse_questions_restrictions values (1,12,122,1,7);
insert into pgsse_questions_restrictions values (1,12,118,2,7);
insert into pgsse_questions_restrictions values (1,5,45,2,7);
insert into pgsse_questions_restrictions values (1,10,104,0,7);
insert into pgsse_questions_restrictions values (1,7,63,10,7);
insert into pgsse_questions_restrictions values (1,5,45,8,7);
insert into pgsse_questions_restrictions values (1,9,82,11,7);
insert into pgsse_questions_restrictions values (1,1,7,0,7);
insert into pgsse_questions_restrictions values (1,3,18,4,7);
insert into pgsse_questions_restrictions values (1,1,7,4,7);
insert into pgsse_questions_restrictions values (1,15,149,12,7);
insert into pgsse_questions_restrictions values (1,16,159,8,7);
insert into pgsse_questions_restrictions values (1,10,96,0,7);
insert into pgsse_questions_restrictions values (1,8,76,1,7);
insert into pgsse_questions_restrictions values (1,11,113,12,7);
insert into pgsse_questions_restrictions values (1,1,6,14,7);
insert into pgsse_questions_restrictions values (1,3,24,1,7);
insert into pgsse_questions_restrictions values (1,11,109,2,7);
insert into pgsse_questions_restrictions values (1,4,35,8,7);
insert into pgsse_questions_restrictions values (1,8,77,8,7);
insert into pgsse_questions_restrictions values (1,5,43,8,7);
insert into pgsse_questions_restrictions values (1,5,42,14,7);
insert into pgsse_questions_restrictions values (1,9,87,2,7);
insert into pgsse_questions_restrictions values (1,3,21,4,7);
insert into pgsse_questions_restrictions values (1,13,129,8,7);
insert into pgsse_questions_restrictions values (1,12,122,8,7);
insert into pgsse_questions_restrictions values (1,9,87,0,7);
insert into pgsse_questions_restrictions values (1,2,12,8,7);
insert into pgsse_questions_restrictions values (1,9,81,0,7);
insert into pgsse_questions_restrictions values (1,7,62,11,7);
insert into pgsse_questions_restrictions values (1,17,169,0,7);
insert into pgsse_questions_restrictions values (1,1,6,4,7);
insert into pgsse_questions_restrictions values (1,7,63,8,7);
insert into pgsse_questions_restrictions values (1,13,128,12,7);
insert into pgsse_questions_restrictions values (1,11,109,11,7);
insert into pgsse_questions_restrictions values (1,10,98,8,7);
insert into pgsse_questions_restrictions values (1,13,126,4,7);
insert into pgsse_questions_restrictions values (1,4,30,2,7);
insert into pgsse_questions_restrictions values (1,1,4,0,7);
insert into pgsse_questions_restrictions values (1,1,2,14,7);
insert into pgsse_questions_restrictions values (1,17,169,12,7);
insert into pgsse_questions_restrictions values (1,6,56,10,7);
insert into pgsse_questions_restrictions values (1,3,17,10,7);
insert into pgsse_questions_restrictions values (1,8,74,2,7);
insert into pgsse_questions_restrictions values (1,13,130,0,7);
insert into pgsse_questions_restrictions values (1,11,110,12,7);
insert into pgsse_questions_restrictions values (1,6,54,2,7);
insert into pgsse_questions_restrictions values (1,6,53,4,7);
insert into pgsse_questions_restrictions values (1,9,82,0,7);
insert into pgsse_questions_restrictions values (1,15,142,2,7);
insert into pgsse_questions_restrictions values (1,12,122,12,7);
insert into pgsse_questions_restrictions values (1,16,159,4,7);
insert into pgsse_questions_restrictions values (1,6,50,2,7);
insert into pgsse_questions_restrictions values (1,15,143,8,7);
insert into pgsse_questions_restrictions values (1,7,61,8,7);
insert into pgsse_questions_restrictions values (1,16,156,12,7);
insert into pgsse_questions_restrictions values (1,4,32,11,7);
insert into pgsse_questions_restrictions values (1,8,73,8,7);
insert into pgsse_questions_restrictions values (1,17,169,4,7);
insert into pgsse_questions_restrictions values (1,9,87,1,7);
insert into pgsse_questions_restrictions values (1,13,127,0,7);
insert into pgsse_questions_restrictions values (1,13,128,0,7);
insert into pgsse_questions_restrictions values (1,1,6,8,7);
insert into pgsse_questions_restrictions values (1,9,82,1,7);
insert into pgsse_questions_restrictions values (1,15,144,8,7);
insert into pgsse_questions_restrictions values (1,11,113,4,7);
insert into pgsse_questions_restrictions values (1,1,2,4,7);
insert into pgsse_questions_restrictions values (1,3,25,0,7);
insert into pgsse_questions_restrictions values (1,5,42,11,7);
insert into pgsse_questions_restrictions values (1,9,84,14,7);
insert into pgsse_questions_restrictions values (1,7,60,8,7);
insert into pgsse_questions_restrictions values (1,15,141,14,7);
insert into pgsse_questions_restrictions values (1,11,113,10,7);
insert into pgsse_questions_restrictions values (1,9,84,1,7);
insert into pgsse_questions_restrictions values (1,17,166,12,7);
insert into pgsse_questions_restrictions values (1,4,38,0,7);
insert into pgsse_questions_restrictions values (1,6,53,1,7);
insert into pgsse_questions_restrictions values (1,17,164,10,7);
insert into pgsse_questions_restrictions values (1,14,137,11,7);
insert into pgsse_questions_restrictions values (1,16,155,8,7);
insert into pgsse_questions_restrictions values (1,17,166,14,7);
insert into pgsse_questions_restrictions values (1,16,153,2,7);
insert into pgsse_questions_restrictions values (1,17,164,8,7);
insert into pgsse_questions_restrictions values (1,4,34,0,7);
insert into pgsse_questions_restrictions values (1,16,153,8,7);
insert into pgsse_questions_restrictions values (1,4,35,1,7);
insert into pgsse_questions_restrictions values (1,4,30,10,7);
insert into pgsse_questions_restrictions values (1,16,153,10,7);
insert into pgsse_questions_restrictions values (1,10,98,12,7);
insert into pgsse_questions_restrictions values (1,11,111,11,7);
insert into pgsse_questions_restrictions values (1,15,142,4,7);
insert into pgsse_questions_restrictions values (1,4,36,4,7);
insert into pgsse_questions_restrictions values (1,6,56,12,7);
insert into pgsse_questions_restrictions values (1,3,25,4,7);
insert into pgsse_questions_restrictions values (1,6,53,10,7);
insert into pgsse_questions_restrictions values (1,16,155,11,7);
insert into pgsse_questions_restrictions values (1,14,135,2,7);
insert into pgsse_questions_restrictions values (1,13,127,11,7);
insert into pgsse_questions_restrictions values (1,8,70,10,7);
insert into pgsse_questions_restrictions values (1,4,32,12,7);
insert into pgsse_questions_restrictions values (1,4,31,11,7);
insert into pgsse_questions_restrictions values (1,10,103,2,7);
insert into pgsse_questions_restrictions values (1,7,61,0,7);
insert into pgsse_questions_restrictions values (1,12,118,12,7);
insert into pgsse_questions_restrictions values (1,3,17,0,7);
insert into pgsse_questions_restrictions values (1,7,60,2,7);
insert into pgsse_questions_restrictions values (1,6,50,10,7);
insert into pgsse_questions_restrictions values (1,6,54,1,7);
insert into pgsse_questions_restrictions values (1,12,117,0,7);
insert into pgsse_questions_restrictions values (1,4,29,10,7);
insert into pgsse_questions_restrictions values (1,4,32,2,7);
insert into pgsse_questions_restrictions values (1,12,119,8,7);
insert into pgsse_questions_restrictions values (1,3,19,12,7);
insert into pgsse_questions_restrictions values (1,10,98,11,7);
insert into pgsse_questions_restrictions values (1,15,146,4,7);
insert into pgsse_questions_restrictions values (1,16,160,12,7);
insert into pgsse_questions_restrictions values (1,1,7,11,7);
insert into pgsse_questions_restrictions values (1,10,99,12,7);
insert into pgsse_questions_restrictions values (1,10,94,4,7);
insert into pgsse_questions_restrictions values (1,4,30,0,7);
insert into pgsse_questions_restrictions values (1,4,38,1,7);
insert into pgsse_questions_restrictions values (1,10,103,12,7);
insert into pgsse_questions_restrictions values (1,3,25,12,7);
insert into pgsse_questions_restrictions values (1,9,90,0,7);
insert into pgsse_questions_restrictions values (1,3,17,11,7);
insert into pgsse_questions_restrictions values (1,6,54,0,7);
insert into pgsse_questions_restrictions values (1,15,148,11,7);
insert into pgsse_questions_restrictions values (1,4,37,1,7);
insert into pgsse_questions_restrictions values (1,15,145,12,7);
insert into pgsse_questions_restrictions values (1,5,46,2,7);
insert into pgsse_questions_restrictions values (1,17,169,1,7);
insert into pgsse_questions_restrictions values (1,7,64,8,7);
insert into pgsse_questions_restrictions values (1,12,121,14,7);
insert into pgsse_questions_restrictions values (1,12,121,2,7);
insert into pgsse_questions_restrictions values (1,8,75,2,7);
insert into pgsse_questions_restrictions values (1,5,44,2,7);
insert into pgsse_questions_restrictions values (1,6,53,12,7);
insert into pgsse_questions_restrictions values (1,7,65,12,7);
insert into pgsse_questions_restrictions values (1,4,30,4,7);
insert into pgsse_questions_restrictions values (1,3,18,10,7);
insert into pgsse_questions_restrictions values (1,10,97,12,7);
insert into pgsse_questions_restrictions values (1,15,149,4,7);
insert into pgsse_questions_restrictions values (1,7,64,14,7);
insert into pgsse_questions_restrictions values (1,5,44,12,7);
insert into pgsse_questions_restrictions values (1,10,102,14,7);
insert into pgsse_questions_restrictions values (1,1,5,14,7);
insert into pgsse_questions_restrictions values (1,15,149,14,7);
insert into pgsse_questions_restrictions values (1,3,21,10,7);
insert into pgsse_questions_restrictions values (1,10,99,0,7);
insert into pgsse_questions_restrictions values (1,15,143,10,7);
insert into pgsse_questions_restrictions values (1,4,33,1,7);
insert into pgsse_questions_restrictions values (1,10,100,8,7);
insert into pgsse_questions_restrictions values (1,8,73,10,7);
insert into pgsse_questions_restrictions values (1,10,96,11,7);
insert into pgsse_questions_restrictions values (1,17,168,2,7);
insert into pgsse_questions_restrictions values (1,13,128,14,7);
insert into pgsse_questions_restrictions values (1,4,36,14,7);
insert into pgsse_questions_restrictions values (1,7,61,14,7);
insert into pgsse_questions_restrictions values (1,9,87,10,7);
insert into pgsse_questions_restrictions values (1,7,64,0,7);
insert into pgsse_questions_restrictions values (1,7,65,14,7);
insert into pgsse_questions_restrictions values (1,13,128,11,7);
insert into pgsse_questions_restrictions values (1,9,90,2,7);
insert into pgsse_questions_restrictions values (1,17,171,11,7);
insert into pgsse_questions_restrictions values (1,11,108,0,7);
insert into pgsse_questions_restrictions values (1,2,11,1,7);
insert into pgsse_questions_restrictions values (1,1,6,1,7);
insert into pgsse_questions_restrictions values (1,16,154,0,7);
insert into pgsse_questions_restrictions values (1,4,35,0,7);
insert into pgsse_questions_restrictions values (1,16,154,14,7);
insert into pgsse_questions_restrictions values (1,16,154,4,7);
insert into pgsse_questions_restrictions values (1,16,158,14,7);
insert into pgsse_questions_restrictions values (1,3,17,2,7);
insert into pgsse_questions_restrictions values (1,8,71,4,7);
insert into pgsse_questions_restrictions values (1,4,34,8,7);
insert into pgsse_questions_restrictions values (1,12,119,14,7);
insert into pgsse_questions_restrictions values (1,8,74,14,7);
insert into pgsse_questions_restrictions values (1,17,167,0,7);
insert into pgsse_questions_restrictions values (1,5,46,14,7);
insert into pgsse_questions_restrictions values (1,1,4,11,7);
insert into pgsse_questions_restrictions values (1,4,34,11,7);
insert into pgsse_questions_restrictions values (1,10,104,10,7);
insert into pgsse_questions_restrictions values (1,9,86,12,7);
insert into pgsse_questions_restrictions values (1,10,103,11,7);
insert into pgsse_questions_restrictions values (1,1,7,1,7);
insert into pgsse_questions_restrictions values (1,2,12,11,7);
insert into pgsse_questions_restrictions values (1,7,60,11,7);
insert into pgsse_questions_restrictions values (1,12,118,4,7);
insert into pgsse_questions_restrictions values (1,9,86,4,7);
insert into pgsse_questions_restrictions values (1,8,77,10,7);
insert into pgsse_questions_restrictions values (1,8,77,14,7);
insert into pgsse_questions_restrictions values (1,5,46,12,7);
insert into pgsse_questions_restrictions values (1,9,86,10,7);
insert into pgsse_questions_restrictions values (1,9,81,14,7);
insert into pgsse_questions_restrictions values (1,16,157,0,7);
insert into pgsse_questions_restrictions values (1,5,43,0,7);
insert into pgsse_questions_restrictions values (1,8,71,14,7);
insert into pgsse_questions_restrictions values (1,8,75,8,7);
insert into pgsse_questions_restrictions values (1,16,157,14,7);
insert into pgsse_questions_restrictions values (1,16,158,10,7);
insert into pgsse_questions_restrictions values (1,8,77,2,7);
insert into pgsse_questions_restrictions values (1,16,157,11,7);
insert into pgsse_questions_restrictions values (1,10,98,2,7);
insert into pgsse_questions_restrictions values (1,3,21,1,7);
insert into pgsse_questions_restrictions values (1,11,110,14,7);
insert into pgsse_questions_restrictions values (1,4,34,10,7);
insert into pgsse_questions_restrictions values (1,14,137,1,7);
insert into pgsse_questions_restrictions values (1,2,11,8,7);
insert into pgsse_questions_restrictions values (1,4,30,8,7);
insert into pgsse_questions_restrictions values (1,10,104,12,7);
insert into pgsse_questions_restrictions values (1,5,43,14,7);
insert into pgsse_questions_restrictions values (1,10,104,2,7);
insert into pgsse_questions_restrictions values (1,5,44,14,7);
insert into pgsse_questions_restrictions values (1,5,42,10,7);
insert into pgsse_questions_restrictions values (1,6,50,12,7);
insert into pgsse_questions_restrictions values (1,8,71,10,7);
insert into pgsse_questions_restrictions values (1,6,56,14,7);
insert into pgsse_questions_restrictions values (1,6,51,11,7);
insert into pgsse_questions_restrictions values (1,10,97,0,7);
insert into pgsse_questions_restrictions values (1,16,156,8,7);
insert into pgsse_questions_restrictions values (1,6,56,8,7);
insert into pgsse_questions_restrictions values (1,17,170,10,7);
insert into pgsse_questions_restrictions values (1,8,71,2,7);
insert into pgsse_questions_restrictions values (1,1,3,8,7);
insert into pgsse_questions_restrictions values (1,4,33,4,7);
insert into pgsse_questions_restrictions values (1,4,36,1,7);
insert into pgsse_questions_restrictions values (1,3,19,10,7);
insert into pgsse_questions_restrictions values (1,3,24,4,7);
insert into pgsse_questions_restrictions values (1,9,83,2,7);
insert into pgsse_questions_restrictions values (1,4,35,2,7);
insert into pgsse_questions_restrictions values (1,12,118,14,7);
insert into pgsse_questions_restrictions values (1,7,62,4,7);
insert into pgsse_questions_restrictions values (1,13,130,1,7);
insert into pgsse_questions_restrictions values (1,9,85,8,7);
insert into pgsse_questions_restrictions values (1,16,157,1,7);
insert into pgsse_questions_restrictions values (1,10,94,10,7);
insert into pgsse_questions_restrictions values (1,2,11,10,7);
insert into pgsse_questions_restrictions values (1,11,110,8,7);
insert into pgsse_questions_restrictions values (1,6,55,14,7);
insert into pgsse_questions_restrictions values (1,10,97,1,7);
insert into pgsse_questions_restrictions values (1,5,45,12,7);
insert into pgsse_questions_restrictions values (1,15,143,2,7);
insert into pgsse_questions_restrictions values (1,13,131,2,7);
insert into pgsse_questions_restrictions values (1,17,165,0,7);
insert into pgsse_questions_restrictions values (1,17,167,4,7);
insert into pgsse_questions_restrictions values (1,9,83,10,7);
insert into pgsse_questions_restrictions values (1,9,84,11,7);
insert into pgsse_questions_restrictions values (1,4,33,2,7);
insert into pgsse_questions_restrictions values (1,5,42,2,7);
insert into pgsse_questions_restrictions values (1,9,83,14,7);
insert into pgsse_questions_restrictions values (1,11,113,1,7);
insert into pgsse_questions_restrictions values (1,14,135,14,7);
insert into pgsse_questions_restrictions values (1,8,72,14,7);
insert into pgsse_questions_restrictions values (1,17,165,4,7);
insert into pgsse_questions_restrictions values (1,4,34,2,7);
insert into pgsse_questions_restrictions values (1,6,53,11,7);
insert into pgsse_questions_restrictions values (1,6,51,1,7);
insert into pgsse_questions_restrictions values (1,17,169,14,7);
insert into pgsse_questions_restrictions values (1,8,72,1,7);
insert into pgsse_questions_restrictions values (1,13,126,14,7);
insert into pgsse_questions_restrictions values (1,2,12,2,7);
insert into pgsse_questions_restrictions values (1,3,20,4,7);
insert into pgsse_questions_restrictions values (1,3,18,8,7);
insert into pgsse_questions_restrictions values (1,17,165,14,7);
insert into pgsse_questions_restrictions values (1,17,167,11,7);
insert into pgsse_questions_restrictions values (1,10,100,0,7);
insert into pgsse_questions_restrictions values (1,16,160,14,7);
insert into pgsse_questions_restrictions values (1,14,137,0,7);
insert into pgsse_questions_restrictions values (1,6,51,4,7);
insert into pgsse_questions_restrictions values (1,3,25,2,7);
insert into pgsse_questions_restrictions values (1,11,112,12,7);
insert into pgsse_questions_restrictions values (1,9,86,0,7);
insert into pgsse_questions_restrictions values (1,4,33,10,7);
insert into pgsse_questions_restrictions values (1,10,97,4,7);
insert into pgsse_questions_restrictions values (1,15,148,12,7);
insert into pgsse_questions_restrictions values (1,15,145,14,7);
insert into pgsse_questions_restrictions values (1,1,5,8,7);
insert into pgsse_questions_restrictions values (1,16,159,1,7);
insert into pgsse_questions_restrictions values (1,16,160,10,7);
insert into pgsse_questions_restrictions values (1,2,13,0,7);
insert into pgsse_questions_restrictions values (1,8,70,4,7);
insert into pgsse_questions_restrictions values (1,17,166,4,7);
insert into pgsse_questions_restrictions values (1,5,43,10,7);
insert into pgsse_questions_restrictions values (1,4,31,10,7);
insert into pgsse_questions_restrictions values (1,5,42,12,7);
insert into pgsse_questions_restrictions values (1,10,103,8,7);
insert into pgsse_questions_restrictions values (1,1,7,2,7);
insert into pgsse_questions_restrictions values (1,5,43,2,7);
insert into pgsse_questions_restrictions values (1,3,23,11,7);
insert into pgsse_questions_restrictions values (1,14,135,12,7);
insert into pgsse_questions_restrictions values (1,10,102,4,7);
insert into pgsse_questions_restrictions values (1,17,168,14,7);
insert into pgsse_questions_restrictions values (1,15,144,1,7);
insert into pgsse_questions_restrictions values (1,10,95,11,7);
insert into pgsse_questions_restrictions values (1,3,17,12,7);
insert into pgsse_questions_restrictions values (1,2,13,12,7);
insert into pgsse_questions_restrictions values (1,11,111,4,7);
insert into pgsse_questions_restrictions values (1,12,117,8,7);
insert into pgsse_questions_restrictions values (1,16,159,11,7);
insert into pgsse_questions_restrictions values (1,8,71,11,7);
insert into pgsse_questions_restrictions values (1,8,77,1,7);
insert into pgsse_questions_restrictions values (1,17,168,8,7);
insert into pgsse_questions_restrictions values (1,15,144,14,7);
insert into pgsse_questions_restrictions values (1,7,61,11,7);
insert into pgsse_questions_restrictions values (1,3,18,2,7);
insert into pgsse_questions_restrictions values (1,4,32,0,7);
insert into pgsse_questions_restrictions values (1,10,94,1,7);
insert into pgsse_questions_restrictions values (1,6,51,12,7);
insert into pgsse_questions_restrictions values (1,9,84,4,7);
insert into pgsse_questions_restrictions values (1,8,73,14,7);
insert into pgsse_questions_restrictions values (1,4,33,11,7);
insert into pgsse_questions_restrictions values (1,11,108,2,7);
insert into pgsse_questions_restrictions values (1,3,23,2,7);
insert into pgsse_questions_restrictions values (1,6,55,11,7);
insert into pgsse_questions_restrictions values (1,10,96,4,7);
insert into pgsse_questions_restrictions values (1,1,2,11,7);
insert into pgsse_questions_restrictions values (1,16,157,10,7);
insert into pgsse_questions_restrictions values (1,4,30,12,7);
insert into pgsse_questions_restrictions values (1,16,160,0,7);
insert into pgsse_questions_restrictions values (1,14,136,11,7);
insert into pgsse_questions_restrictions values (1,7,63,11,7);
insert into pgsse_questions_restrictions values (1,3,22,1,7);
insert into pgsse_questions_restrictions values (1,12,120,0,7);
insert into pgsse_questions_restrictions values (1,16,156,11,7);
insert into pgsse_questions_restrictions values (1,11,111,1,7);
insert into pgsse_questions_restrictions values (1,11,113,2,7);
insert into pgsse_questions_restrictions values (1,10,94,12,7);
insert into pgsse_questions_restrictions values (1,9,87,12,7);
insert into pgsse_questions_restrictions values (1,7,63,14,7);
insert into pgsse_questions_restrictions values (1,6,52,2,7);
insert into pgsse_questions_restrictions values (1,15,147,8,7);
insert into pgsse_questions_restrictions values (1,9,85,0,7);
insert into pgsse_questions_restrictions values (1,4,29,4,7);
insert into pgsse_questions_restrictions values (1,7,64,4,7);
insert into pgsse_questions_restrictions values (1,13,126,11,7);
insert into pgsse_questions_restrictions values (1,2,11,2,7);
insert into pgsse_questions_restrictions values (1,9,87,4,7);
insert into pgsse_questions_restrictions values (1,7,60,12,7);
insert into pgsse_questions_restrictions values (1,15,141,11,7);
insert into pgsse_questions_restrictions values (1,17,169,10,7);
insert into pgsse_questions_restrictions values (1,12,120,2,7);
insert into pgsse_questions_restrictions values (1,15,142,10,7);
insert into pgsse_questions_restrictions values (1,13,131,14,7);
insert into pgsse_questions_restrictions values (1,13,126,8,7);
insert into pgsse_questions_restrictions values (1,15,142,14,7);
insert into pgsse_questions_restrictions values (1,7,61,10,7);
insert into pgsse_questions_restrictions values (1,8,70,11,7);
insert into pgsse_questions_restrictions values (1,16,156,0,7);
insert into pgsse_questions_restrictions values (1,16,153,0,7);
insert into pgsse_questions_restrictions values (1,3,22,12,7);
insert into pgsse_questions_restrictions values (1,11,113,11,7);
insert into pgsse_questions_restrictions values (1,7,62,12,7);
insert into pgsse_questions_restrictions values (1,15,141,10,7);
insert into pgsse_questions_restrictions values (1,10,103,14,7);
insert into pgsse_questions_restrictions values (1,16,160,11,7);
insert into pgsse_questions_restrictions values (1,17,168,4,7);
insert into pgsse_questions_restrictions values (1,15,148,1,7);
insert into pgsse_questions_restrictions values (1,1,4,10,7);
insert into pgsse_questions_restrictions values (1,15,144,2,7);
insert into pgsse_questions_restrictions values (1,14,137,10,7);
insert into pgsse_questions_restrictions values (1,16,160,8,7);
insert into pgsse_questions_restrictions values (1,8,70,2,7);
insert into pgsse_questions_restrictions values (1,7,63,12,7);
insert into pgsse_questions_restrictions values (1,5,46,11,7);
insert into pgsse_questions_restrictions values (1,15,147,2,7);
insert into pgsse_questions_restrictions values (1,8,76,14,7);
insert into pgsse_questions_restrictions values (1,12,117,14,7);
insert into pgsse_questions_restrictions values (1,15,144,10,7);
insert into pgsse_questions_restrictions values (1,15,149,11,7);
insert into pgsse_questions_restrictions values (1,12,119,4,7);
insert into pgsse_questions_restrictions values (1,11,113,0,7);
insert into pgsse_questions_restrictions values (1,13,129,1,7);
insert into pgsse_questions_restrictions values (1,2,12,14,7);
insert into pgsse_questions_restrictions values (1,11,109,14,7);
insert into pgsse_questions_restrictions values (1,9,82,4,7);
insert into pgsse_questions_restrictions values (1,13,130,2,7);
insert into pgsse_questions_restrictions values (1,15,145,0,7);
insert into pgsse_questions_restrictions values (1,15,143,12,7);
insert into pgsse_questions_restrictions values (1,7,65,2,7);
insert into pgsse_questions_restrictions values (1,9,82,8,7);
insert into pgsse_questions_restrictions values (1,10,101,2,7);
insert into pgsse_questions_restrictions values (1,10,95,0,7);
insert into pgsse_questions_restrictions values (1,10,99,8,7);
insert into pgsse_questions_restrictions values (1,10,102,1,7);
insert into pgsse_questions_restrictions values (1,5,44,4,7);
insert into pgsse_questions_restrictions values (1,17,170,14,7);
insert into pgsse_questions_restrictions values (1,16,154,11,7);
insert into pgsse_questions_restrictions values (1,6,52,1,7);
insert into pgsse_questions_restrictions values (1,10,97,2,7);
insert into pgsse_questions_restrictions values (1,12,120,12,7);
insert into pgsse_questions_restrictions values (1,17,169,11,7);
insert into pgsse_questions_restrictions values (1,4,35,12,7);
insert into pgsse_questions_restrictions values (1,12,121,8,7);
insert into pgsse_questions_restrictions values (1,1,2,12,7);
insert into pgsse_questions_restrictions values (1,6,55,4,7);
insert into pgsse_questions_restrictions values (1,16,160,2,7);
insert into pgsse_questions_restrictions values (1,6,51,10,7);
insert into pgsse_questions_restrictions values (1,16,156,10,7);
insert into pgsse_questions_restrictions values (1,6,56,0,7);
insert into pgsse_questions_restrictions values (1,10,95,8,7);
insert into pgsse_questions_restrictions values (1,9,81,11,7);
insert into pgsse_questions_restrictions values (1,8,71,0,7);
insert into pgsse_questions_restrictions values (1,8,73,12,7);
insert into pgsse_questions_restrictions values (1,5,45,14,7);
insert into pgsse_questions_restrictions values (1,15,144,12,7);
insert into pgsse_questions_restrictions values (1,9,83,0,7);
insert into pgsse_questions_restrictions values (1,1,3,0,7);
insert into pgsse_questions_restrictions values (1,16,158,11,7);
insert into pgsse_questions_restrictions values (1,1,5,11,7);
insert into pgsse_questions_restrictions values (1,9,86,2,7);
insert into pgsse_questions_restrictions values (1,16,160,1,7);
insert into pgsse_questions_restrictions values (1,17,165,8,7);
insert into pgsse_questions_restrictions values (1,4,32,1,7);
insert into pgsse_questions_restrictions values (1,3,25,10,7);
insert into pgsse_questions_restrictions values (1,10,104,4,7);
insert into pgsse_questions_restrictions values (1,3,24,11,7);
insert into pgsse_questions_restrictions values (1,4,37,4,7);
insert into pgsse_questions_restrictions values (1,9,86,1,7);
insert into pgsse_questions_restrictions values (1,8,70,0,7);
insert into pgsse_questions_restrictions values (1,1,3,11,7);
insert into pgsse_questions_restrictions values (1,9,90,1,7);
insert into pgsse_questions_restrictions values (1,9,85,10,7);
insert into pgsse_questions_restrictions values (1,11,109,8,7);
insert into pgsse_questions_restrictions values (1,15,141,2,7);
insert into pgsse_questions_restrictions values (1,15,146,2,7);
insert into pgsse_questions_restrictions values (1,15,148,4,7);
insert into pgsse_questions_restrictions values (1,9,88,10,7);
insert into pgsse_questions_restrictions values (1,6,55,2,7);
insert into pgsse_questions_restrictions values (1,8,77,12,7);
insert into pgsse_questions_restrictions values (1,3,21,14,7);
insert into pgsse_questions_restrictions values (1,5,43,1,7);
insert into pgsse_questions_restrictions values (1,13,127,12,7);
insert into pgsse_questions_restrictions values (1,7,60,10,7);
insert into pgsse_questions_restrictions values (1,7,65,10,7);
insert into pgsse_questions_restrictions values (1,8,72,8,7);
insert into pgsse_questions_restrictions values (1,6,53,14,7);
insert into pgsse_questions_restrictions values (1,13,127,2,7);
insert into pgsse_questions_restrictions values (1,15,145,2,7);
insert into pgsse_questions_restrictions values (1,3,24,10,7);
insert into pgsse_questions_restrictions values (1,9,81,8,7);
insert into pgsse_questions_restrictions values (1,12,119,12,7);
insert into pgsse_questions_restrictions values (1,10,103,0,7);
insert into pgsse_questions_restrictions values (1,9,89,1,7);
insert into pgsse_questions_restrictions values (1,11,112,1,7);
insert into pgsse_questions_restrictions values (1,10,103,10,7);
insert into pgsse_questions_restrictions values (1,15,147,1,7);
insert into pgsse_questions_restrictions values (1,6,54,12,7);
insert into pgsse_questions_restrictions values (1,11,111,12,7);
insert into pgsse_questions_restrictions values (1,4,30,11,7);
insert into pgsse_questions_restrictions values (1,3,21,12,7);
insert into pgsse_questions_restrictions values (1,5,44,11,7);
insert into pgsse_questions_restrictions values (1,7,63,0,7);
insert into pgsse_questions_restrictions values (1,3,19,8,7);
insert into pgsse_questions_restrictions values (1,4,37,0,7);
insert into pgsse_questions_restrictions values (1,10,95,1,7);
insert into pgsse_questions_restrictions values (1,6,52,0,7);
insert into pgsse_questions_restrictions values (1,8,75,12,7);
insert into pgsse_questions_restrictions values (1,17,166,11,7);
insert into pgsse_questions_restrictions values (1,3,25,14,7);
insert into pgsse_questions_restrictions values (1,9,90,8,7);
insert into pgsse_questions_restrictions values (1,17,167,14,7);
insert into pgsse_questions_restrictions values (1,15,144,11,7);
insert into pgsse_questions_restrictions values (1,9,83,4,7);
insert into pgsse_questions_restrictions values (1,12,117,2,7);
insert into pgsse_questions_restrictions values (1,2,11,12,7);
insert into pgsse_questions_restrictions values (1,3,23,14,7);
insert into pgsse_questions_restrictions values (1,10,95,10,7);
insert into pgsse_questions_restrictions values (1,13,129,4,7);
insert into pgsse_questions_restrictions values (1,15,142,0,7);
insert into pgsse_questions_restrictions values (1,6,50,11,7);
insert into pgsse_questions_restrictions values (1,10,96,14,7);
insert into pgsse_questions_restrictions values (1,13,126,0,7);
insert into pgsse_questions_restrictions values (1,5,46,8,7);
insert into pgsse_questions_restrictions values (1,11,110,4,7);
insert into pgsse_questions_restrictions values (1,3,23,10,7);
insert into pgsse_questions_restrictions values (1,12,117,12,7);
insert into pgsse_questions_restrictions values (1,7,64,2,7);
insert into pgsse_questions_restrictions values (1,8,74,12,7);
insert into pgsse_questions_restrictions values (1,10,104,1,7);
insert into pgsse_questions_restrictions values (1,8,75,1,7);
insert into pgsse_questions_restrictions values (1,11,112,8,7);
insert into pgsse_questions_restrictions values (1,6,55,8,7);
insert into pgsse_questions_restrictions values (1,10,102,0,7);
insert into pgsse_questions_restrictions values (1,9,89,4,7);
insert into pgsse_questions_restrictions values (1,11,109,1,7);
insert into pgsse_questions_restrictions values (1,8,73,11,7);
insert into pgsse_questions_restrictions values (1,15,146,12,7);
insert into pgsse_questions_restrictions values (1,10,96,1,7);
insert into pgsse_questions_restrictions values (1,12,120,1,7);
insert into pgsse_questions_restrictions values (1,10,100,10,7);
insert into pgsse_questions_restrictions values (1,16,158,4,7);
insert into pgsse_questions_restrictions values (1,12,121,12,7);
insert into pgsse_questions_restrictions values (1,7,60,0,7);
insert into pgsse_questions_restrictions values (1,16,153,14,7);
insert into pgsse_questions_restrictions values (1,16,159,10,7);
insert into pgsse_questions_restrictions values (1,8,72,11,7);
insert into pgsse_questions_restrictions values (1,3,22,0,7);
insert into pgsse_questions_restrictions values (1,9,87,11,7);
insert into pgsse_questions_restrictions values (1,1,4,4,7);
insert into pgsse_questions_restrictions values (1,3,24,14,7);
insert into pgsse_questions_restrictions values (1,6,55,0,7);
insert into pgsse_questions_restrictions values (1,16,158,8,7);
insert into pgsse_questions_restrictions values (1,13,128,8,7);
insert into pgsse_questions_restrictions values (1,9,85,14,7);
insert into pgsse_questions_restrictions values (1,16,158,12,7);
insert into pgsse_questions_restrictions values (1,16,153,4,7);
insert into pgsse_questions_restrictions values (1,4,38,14,7);
insert into pgsse_questions_restrictions values (1,4,36,10,7);
insert into pgsse_questions_restrictions values (1,15,147,14,7);
insert into pgsse_questions_restrictions values (1,15,145,11,7);
insert into pgsse_questions_restrictions values (1,16,159,2,7);
insert into pgsse_questions_restrictions values (1,8,71,8,7);
insert into pgsse_questions_restrictions values (1,16,159,14,7);
insert into pgsse_questions_restrictions values (1,12,121,10,7);
insert into pgsse_questions_restrictions values (1,4,34,14,7);
insert into pgsse_questions_restrictions values (1,1,2,8,7);
insert into pgsse_questions_restrictions values (1,6,51,14,7);
insert into pgsse_questions_restrictions values (1,4,36,11,7);
insert into pgsse_questions_restrictions values (1,14,135,11,7);
insert into pgsse_questions_restrictions values (1,10,102,10,7);
insert into pgsse_questions_restrictions values (1,17,166,0,7);
insert into pgsse_questions_restrictions values (1,9,89,11,7);
insert into pgsse_questions_restrictions values (1,17,171,1,7);
insert into pgsse_questions_restrictions values (1,8,76,0,7);
insert into pgsse_questions_restrictions values (1,3,22,4,7);
insert into pgsse_questions_restrictions values (1,12,120,11,7);
insert into pgsse_questions_restrictions values (1,15,145,4,7);
insert into pgsse_questions_restrictions values (1,4,33,14,7);
insert into pgsse_questions_restrictions values (1,7,61,12,7);
insert into pgsse_questions_restrictions values (1,13,126,12,7);
insert into pgsse_questions_restrictions values (1,17,171,4,7);
insert into pgsse_questions_restrictions values (1,8,71,12,7);
insert into pgsse_questions_restrictions values (1,12,118,11,7);
insert into pgsse_questions_restrictions values (1,16,155,14,7);
insert into pgsse_questions_restrictions values (1,6,52,12,7);
insert into pgsse_questions_restrictions values (1,9,89,12,7);
insert into pgsse_questions_restrictions values (1,11,112,4,7);
insert into pgsse_questions_restrictions values (1,9,90,10,7);
insert into pgsse_questions_restrictions values (1,2,11,14,7);
insert into pgsse_questions_restrictions values (1,15,149,0,7);
insert into pgsse_questions_restrictions values (1,13,128,4,7);
insert into pgsse_questions_restrictions values (1,2,13,10,7);
insert into pgsse_questions_restrictions values (1,1,6,10,7);
insert into pgsse_questions_restrictions values (1,9,82,10,7);
insert into pgsse_questions_restrictions values (1,4,29,8,7);
insert into pgsse_questions_restrictions values (1,1,6,12,7);
insert into pgsse_questions_restrictions values (1,10,101,11,7);
insert into pgsse_questions_restrictions values (1,16,157,12,7);
insert into pgsse_questions_restrictions values (1,3,18,11,7);
insert into pgsse_questions_restrictions values (1,12,122,10,7);
insert into pgsse_questions_restrictions values (1,8,74,10,7);
insert into pgsse_questions_restrictions values (1,8,74,1,7);
insert into pgsse_questions_restrictions values (1,10,101,14,7);
insert into pgsse_questions_restrictions values (1,14,135,8,7);
insert into pgsse_questions_restrictions values (1,10,94,8,7);
insert into pgsse_questions_restrictions values (1,12,122,4,7);
insert into pgsse_questions_restrictions values (1,13,127,10,7);
insert into pgsse_questions_restrictions values (1,17,171,12,7);
insert into pgsse_questions_restrictions values (1,3,22,8,7);
insert into pgsse_questions_restrictions values (1,11,109,4,7);
insert into pgsse_questions_restrictions values (1,15,146,0,7);
insert into pgsse_questions_restrictions values (1,14,135,0,7);
insert into pgsse_questions_restrictions values (1,20,201,23,7);
insert into pgsse_questions_restrictions values (1,20,202,23,7);
insert into pgsse_questions_restrictions values (1,20,203,23,7);
insert into pgsse_questions_restrictions values (1,20,204,23,7);
insert into pgsse_questions_restrictions values (1,20,205,23,7);
insert into pgsse_questions_restrictions values (1,20,206,23,7);
insert into pgsse_questions_restrictions values (1,20,207,23,7);
insert into pgsse_questions_restrictions values (1,20,208,23,7);
insert into pgsse_questions_restrictions values (1,21,210,23,7);
insert into pgsse_questions_restrictions values (1,21,211,23,7);
insert into pgsse_questions_restrictions values (1,21,212,23,7);
insert into pgsse_questions_restrictions values (1,21,213,23,7);
insert into pgsse_questions_restrictions values (1,21,214,23,7);
insert into pgsse_questions_restrictions values (1,21,215,23,7);
insert into pgsse_questions_restrictions values (1,21,216,23,7);
insert into pgsse_questions_restrictions values (1,21,217,23,7);
insert into pgsse_questions_restrictions values (1,21,218,23,7);
insert into pgsse_questions_restrictions values (1,21,219,23,7);
insert into pgsse_questions_restrictions values (1,21,220,23,7);
insert into pgsse_questions_restrictions values (1,21,221,23,7);
insert into pgsse_questions_restrictions values (1,21,222,23,7);
insert into pgsse_questions_restrictions values (1,21,223,23,7);
insert into pgsse_questions_restrictions values (1,21,224,23,7);
insert into pgsse_questions_restrictions values (1,21,225,23,7);
insert into pgsse_questions_restrictions values (1,21,226,23,7);
insert into pgsse_questions_restrictions values (1,21,227,23,7);
insert into pgsse_questions_restrictions values (1,21,228,23,7);
insert into pgsse_questions_restrictions values (1,22,230,23,7);
insert into pgsse_questions_restrictions values (1,22,231,23,7);
insert into pgsse_questions_restrictions values (1,10,95,16,7);
insert into pgsse_questions_restrictions values (1,15,141,16,7);
insert into pgsse_questions_restrictions values (1,10,101,16,7);
insert into pgsse_questions_restrictions values (1,3,18,16,7);
insert into pgsse_questions_restrictions values (1,9,88,16,7);
insert into pgsse_questions_restrictions values (1,17,168,16,7);
insert into pgsse_questions_restrictions values (1,9,90,16,7);
insert into pgsse_questions_restrictions values (1,9,85,16,7);
insert into pgsse_questions_restrictions values (1,4,33,16,7);
insert into pgsse_questions_restrictions values (1,1,5,16,7);
insert into pgsse_questions_restrictions values (1,1,3,16,7);
insert into pgsse_questions_restrictions values (1,4,31,16,7);
insert into pgsse_questions_restrictions values (1,10,102,16,7);
insert into pgsse_questions_restrictions values (1,3,23,16,7);
insert into pgsse_questions_restrictions values (1,6,55,16,7);
insert into pgsse_questions_restrictions values (1,9,83,16,7);
insert into pgsse_questions_restrictions values (1,13,129,16,7);
insert into pgsse_questions_restrictions values (1,13,130,16,7);
insert into pgsse_questions_restrictions values (1,10,100,16,7);
insert into pgsse_questions_restrictions values (1,16,159,16,7);
insert into pgsse_questions_restrictions values (1,7,64,16,7);
insert into pgsse_questions_restrictions values (1,13,131,16,7);
insert into pgsse_questions_restrictions values (1,16,155,16,7);
insert into pgsse_questions_restrictions values (1,3,20,16,7);
insert into pgsse_questions_restrictions values (1,11,109,16,7);
insert into pgsse_questions_restrictions values (1,4,34,16,7);
insert into pgsse_questions_restrictions values (1,4,38,16,7);
insert into pgsse_questions_restrictions values (1,5,43,16,7);
insert into pgsse_questions_restrictions values (1,8,70,16,7);
insert into pgsse_questions_restrictions values (1,17,164,16,7);
insert into pgsse_questions_restrictions values (1,10,96,16,7);
insert into pgsse_questions_restrictions values (1,9,82,16,7);
insert into pgsse_questions_restrictions values (1,1,7,16,7);
insert into pgsse_questions_restrictions values (1,15,142,16,7);
insert into pgsse_questions_restrictions values (1,16,153,16,7);
insert into pgsse_questions_restrictions values (1,9,84,16,7);
insert into pgsse_questions_restrictions values (1,14,137,16,7);
insert into pgsse_questions_restrictions values (1,1,4,16,7);
insert into pgsse_questions_restrictions values (1,17,170,16,7);
insert into pgsse_questions_restrictions values (1,11,108,16,7);
insert into pgsse_questions_restrictions values (1,8,76,16,7);
insert into pgsse_questions_restrictions values (1,17,167,16,7);
insert into pgsse_questions_restrictions values (1,3,24,16,7);
insert into pgsse_questions_restrictions values (1,14,136,16,7);
insert into pgsse_questions_restrictions values (1,8,69,16,7);
insert into pgsse_questions_restrictions values (1,4,37,16,7);
insert into pgsse_questions_restrictions values (1,17,165,16,7);
insert into pgsse_questions_restrictions values (1,4,36,16,7);
insert into pgsse_questions_restrictions values (1,9,81,16,7);
insert into pgsse_questions_restrictions values (1,2,12,16,7);
insert into pgsse_questions_restrictions values (1,4,29,16,7);
insert into pgsse_questions_restrictions values (1,8,72,16,7);
insert into pgsse_questions_restrictions values (1,15,147,16,7);
insert into pgsse_questions_restrictions values (1,16,154,16,7);
insert into pgsse_questions_restrictions values (1,15,149,16,7);
insert into pgsse_questions_restrictions values (1,11,113,16,7);
insert into pgsse_questions_restrictions values (1,13,128,16,7);
insert into pgsse_questions_restrictions values (1,17,169,16,7);
insert into pgsse_questions_restrictions values (1,11,110,16,7);
insert into pgsse_questions_restrictions values (1,12,122,16,7);
insert into pgsse_questions_restrictions values (1,16,156,16,7);
insert into pgsse_questions_restrictions values (1,17,166,16,7);
insert into pgsse_questions_restrictions values (1,10,98,16,7);
insert into pgsse_questions_restrictions values (1,6,56,16,7);
insert into pgsse_questions_restrictions values (1,4,32,16,7);
insert into pgsse_questions_restrictions values (1,12,118,16,7);
insert into pgsse_questions_restrictions values (1,3,19,16,7);
insert into pgsse_questions_restrictions values (1,16,160,16,7);
insert into pgsse_questions_restrictions values (1,10,99,16,7);
insert into pgsse_questions_restrictions values (1,10,103,16,7);
insert into pgsse_questions_restrictions values (1,3,25,16,7);
insert into pgsse_questions_restrictions values (1,15,145,16,7);
insert into pgsse_questions_restrictions values (1,6,53,16,7);
insert into pgsse_questions_restrictions values (1,7,65,16,7);
insert into pgsse_questions_restrictions values (1,10,97,16,7);
insert into pgsse_questions_restrictions values (1,5,44,16,7);
insert into pgsse_questions_restrictions values (1,9,86,16,7);
insert into pgsse_questions_restrictions values (1,5,46,16,7);
insert into pgsse_questions_restrictions values (1,10,104,16,7);
insert into pgsse_questions_restrictions values (1,6,50,16,7);
insert into pgsse_questions_restrictions values (1,5,45,16,7);
insert into pgsse_questions_restrictions values (1,11,112,16,7);
insert into pgsse_questions_restrictions values (1,15,148,16,7);
insert into pgsse_questions_restrictions values (1,5,42,16,7);
insert into pgsse_questions_restrictions values (1,14,135,16,7);
insert into pgsse_questions_restrictions values (1,3,17,16,7);
insert into pgsse_questions_restrictions values (1,2,13,16,7);
insert into pgsse_questions_restrictions values (1,6,51,16,7);
insert into pgsse_questions_restrictions values (1,4,30,16,7);
insert into pgsse_questions_restrictions values (1,10,94,16,7);
insert into pgsse_questions_restrictions values (1,9,87,16,7);
insert into pgsse_questions_restrictions values (1,7,60,16,7);
insert into pgsse_questions_restrictions values (1,3,22,16,7);
insert into pgsse_questions_restrictions values (1,7,62,16,7);
insert into pgsse_questions_restrictions values (1,7,63,16,7);
insert into pgsse_questions_restrictions values (1,15,143,16,7);
insert into pgsse_questions_restrictions values (1,12,120,16,7);
insert into pgsse_questions_restrictions values (1,4,35,16,7);
insert into pgsse_questions_restrictions values (1,1,2,16,7);
insert into pgsse_questions_restrictions values (1,8,73,16,7);
insert into pgsse_questions_restrictions values (1,15,144,16,7);
insert into pgsse_questions_restrictions values (1,8,77,16,7);
insert into pgsse_questions_restrictions values (1,13,127,16,7);
insert into pgsse_questions_restrictions values (1,12,119,16,7);
insert into pgsse_questions_restrictions values (1,6,54,16,7);
insert into pgsse_questions_restrictions values (1,11,111,16,7);
insert into pgsse_questions_restrictions values (1,3,21,16,7);
insert into pgsse_questions_restrictions values (1,8,75,16,7);
insert into pgsse_questions_restrictions values (1,2,11,16,7);
insert into pgsse_questions_restrictions values (1,12,117,16,7);
insert into pgsse_questions_restrictions values (1,8,74,16,7);
insert into pgsse_questions_restrictions values (1,15,146,16,7);
insert into pgsse_questions_restrictions values (1,12,121,16,7);
insert into pgsse_questions_restrictions values (1,16,158,16,7);
insert into pgsse_questions_restrictions values (1,7,61,16,7);
insert into pgsse_questions_restrictions values (1,13,126,16,7);
insert into pgsse_questions_restrictions values (1,8,71,16,7);
insert into pgsse_questions_restrictions values (1,6,52,16,7);
insert into pgsse_questions_restrictions values (1,9,89,16,7);
insert into pgsse_questions_restrictions values (1,1,6,16,7);
insert into pgsse_questions_restrictions values (1,16,157,16,7);
insert into pgsse_questions_restrictions values (1,17,171,16,7);


delete from pgsse_paragraphes;

insert into pgsse_paragraphes values (1,1,'PARCELLE ',1);
insert into pgsse_paragraphes values (1,2,'CLOTURE - PARCELLE ',2);
insert into pgsse_paragraphes values (1,3,'PORTAIL - ACCES PARCELLE',3);
insert into pgsse_paragraphes values (1,4,'ACCES BATIMENT - PORTE ET FENETRES ',4);
insert into pgsse_paragraphes values (1,5,'SECURITE - ACCES BATIMENT ',5);
insert into pgsse_paragraphes values (1,6,'SECURITE - ACCES EAU HORS BATIMENT',6);
insert into pgsse_paragraphes values (1,7,'SECURITE - ACCES EAU DANS BATIMENT ',7);
insert into pgsse_paragraphes values (1,8,'POINT DE PRELEVEMENT SOURCE ET PUITS/FORAGE/PRISE D''EAU',8);
insert into pgsse_paragraphes values (1,9,'BATIMENT ',9);
insert into pgsse_paragraphes values (1,10,'SECURITE ELECTRIQUE ',10);
insert into pgsse_paragraphes values (1,11,'AUTOMATE DE GESTION ',11);
insert into pgsse_paragraphes values (1,12,'TELEGESTION ',12);
insert into pgsse_paragraphes values (1,13,'ANTENNES RELAIS',13);
insert into pgsse_paragraphes values (1,14,'EXPLOITATION SUR SITE ',14);
insert into pgsse_paragraphes values (1,15,'STOCKAGE MATERIEL, PRODUITS CHIMIQUES , REACTIFS',15);
insert into pgsse_paragraphes values (1,16,'STOCKAGE EAU TRAITEE',16);
insert into pgsse_paragraphes values (1,17,'TRAITEMENT ',17);
insert into pgsse_paragraphes values (1,20,'EXPLOITATION',20);
insert into pgsse_paragraphes values (1,21,'PATRIMOINE ',21);
insert into pgsse_paragraphes values (1,22,'TRAVAUX ',22);
insert into pgsse_paragraphes values (1,23,'EXPLOITATION',23);
insert into pgsse_paragraphes values (1,24,'ORGANISATION ADMINISTRATIVE',24);
insert into pgsse_paragraphes values (1,25,'ORGANISATION TRAVAUX',25);
insert into pgsse_paragraphes values (1,26,'PATRIMOINE ',26);
insert into pgsse_paragraphes values (1,27,'RESSOURCE',27);


delete from pgsse_paragraphes_restrictions;

insert into pgsse_paragraphes_restrictions values (1,27,0,7);
insert into pgsse_paragraphes_restrictions values (1,5,2,7);
insert into pgsse_paragraphes_restrictions values (1,14,1,7);
insert into pgsse_paragraphes_restrictions values (1,13,11,7);
insert into pgsse_paragraphes_restrictions values (1,5,10,7);
insert into pgsse_paragraphes_restrictions values (1,14,8,7);
insert into pgsse_paragraphes_restrictions values (1,17,12,7);
insert into pgsse_paragraphes_restrictions values (1,2,11,7);
insert into pgsse_paragraphes_restrictions values (1,3,2,7);
insert into pgsse_paragraphes_restrictions values (1,4,14,7);
insert into pgsse_paragraphes_restrictions values (1,16,10,7);
insert into pgsse_paragraphes_restrictions values (1,12,12,7);
insert into pgsse_paragraphes_restrictions values (1,13,0,7);
insert into pgsse_paragraphes_restrictions values (1,12,8,7);
insert into pgsse_paragraphes_restrictions values (1,6,1,7);
insert into pgsse_paragraphes_restrictions values (1,8,12,7);
insert into pgsse_paragraphes_restrictions values (1,4,12,7);
insert into pgsse_paragraphes_restrictions values (1,3,0,7);
insert into pgsse_paragraphes_restrictions values (1,17,2,7);
insert into pgsse_paragraphes_restrictions values (1,1,14,7);
insert into pgsse_paragraphes_restrictions values (1,15,2,7);
insert into pgsse_paragraphes_restrictions values (1,12,10,7);
insert into pgsse_paragraphes_restrictions values (1,14,12,7);
insert into pgsse_paragraphes_restrictions values (1,8,8,7);
insert into pgsse_paragraphes_restrictions values (1,15,12,7);
insert into pgsse_paragraphes_restrictions values (1,4,10,7);
insert into pgsse_paragraphes_restrictions values (1,2,0,7);
insert into pgsse_paragraphes_restrictions values (1,14,11,7);
insert into pgsse_paragraphes_restrictions values (1,11,11,7);
insert into pgsse_paragraphes_restrictions values (1,9,8,7);
insert into pgsse_paragraphes_restrictions values (1,1,11,7);
insert into pgsse_paragraphes_restrictions values (1,4,1,7);
insert into pgsse_paragraphes_restrictions values (1,16,14,7);
insert into pgsse_paragraphes_restrictions values (1,11,12,7);
insert into pgsse_paragraphes_restrictions values (1,1,0,7);
insert into pgsse_paragraphes_restrictions values (1,1,8,7);
insert into pgsse_paragraphes_restrictions values (1,9,12,7);
insert into pgsse_paragraphes_restrictions values (1,10,2,7);
insert into pgsse_paragraphes_restrictions values (1,7,11,7);
insert into pgsse_paragraphes_restrictions values (1,2,4,7);
insert into pgsse_paragraphes_restrictions values (1,3,8,7);
insert into pgsse_paragraphes_restrictions values (1,14,10,7);
insert into pgsse_paragraphes_restrictions values (1,5,14,7);
insert into pgsse_paragraphes_restrictions values (1,13,2,7);
insert into pgsse_paragraphes_restrictions values (1,11,8,7);
insert into pgsse_paragraphes_restrictions values (1,17,0,7);
insert into pgsse_paragraphes_restrictions values (1,6,4,7);
insert into pgsse_paragraphes_restrictions values (1,8,14,7);
insert into pgsse_paragraphes_restrictions values (1,3,14,7);
insert into pgsse_paragraphes_restrictions values (1,15,14,7);
insert into pgsse_paragraphes_restrictions values (1,10,4,7);
insert into pgsse_paragraphes_restrictions values (1,16,0,7);
insert into pgsse_paragraphes_restrictions values (1,7,12,7);
insert into pgsse_paragraphes_restrictions values (1,6,0,7);
insert into pgsse_paragraphes_restrictions values (1,17,1,7);
insert into pgsse_paragraphes_restrictions values (1,17,11,7);
insert into pgsse_paragraphes_restrictions values (1,9,14,7);
insert into pgsse_paragraphes_restrictions values (1,4,8,7);
insert into pgsse_paragraphes_restrictions values (1,7,0,7);
insert into pgsse_paragraphes_restrictions values (1,11,4,7);
insert into pgsse_paragraphes_restrictions values (1,3,12,7);
insert into pgsse_paragraphes_restrictions values (1,6,10,7);
insert into pgsse_paragraphes_restrictions values (1,14,2,7);
insert into pgsse_paragraphes_restrictions values (1,1,4,7);
insert into pgsse_paragraphes_restrictions values (1,9,1,7);
insert into pgsse_paragraphes_restrictions values (1,16,2,7);
insert into pgsse_paragraphes_restrictions values (1,17,10,7);
insert into pgsse_paragraphes_restrictions values (1,13,10,7);
insert into pgsse_paragraphes_restrictions values (1,2,12,7);
insert into pgsse_paragraphes_restrictions values (1,10,1,7);
insert into pgsse_paragraphes_restrictions values (1,6,8,7);
insert into pgsse_paragraphes_restrictions values (1,13,14,7);
insert into pgsse_paragraphes_restrictions values (1,16,4,7);
insert into pgsse_paragraphes_restrictions values (1,16,1,7);
insert into pgsse_paragraphes_restrictions values (1,11,2,7);
insert into pgsse_paragraphes_restrictions values (1,2,10,7);
insert into pgsse_paragraphes_restrictions values (1,12,4,7);
insert into pgsse_paragraphes_restrictions values (1,4,2,7);
insert into pgsse_paragraphes_restrictions values (1,11,10,7);
insert into pgsse_paragraphes_restrictions values (1,15,1,7);
insert into pgsse_paragraphes_restrictions values (1,13,1,7);
insert into pgsse_paragraphes_restrictions values (1,7,8,7);
insert into pgsse_paragraphes_restrictions values (1,8,4,7);
insert into pgsse_paragraphes_restrictions values (1,10,10,7);
insert into pgsse_paragraphes_restrictions values (1,3,1,7);
insert into pgsse_paragraphes_restrictions values (1,10,0,7);
insert into pgsse_paragraphes_restrictions values (1,5,12,7);
insert into pgsse_paragraphes_restrictions values (1,8,0,7);
insert into pgsse_paragraphes_restrictions values (1,6,2,7);
insert into pgsse_paragraphes_restrictions values (1,11,0,7);
insert into pgsse_paragraphes_restrictions values (1,3,10,7);
insert into pgsse_paragraphes_restrictions values (1,5,8,7);
insert into pgsse_paragraphes_restrictions values (1,1,1,7);
insert into pgsse_paragraphes_restrictions values (1,9,0,7);
insert into pgsse_paragraphes_restrictions values (1,15,11,7);
insert into pgsse_paragraphes_restrictions values (1,5,4,7);
insert into pgsse_paragraphes_restrictions values (1,2,1,7);
insert into pgsse_paragraphes_restrictions values (1,13,4,7);
insert into pgsse_paragraphes_restrictions values (1,7,1,7);
insert into pgsse_paragraphes_restrictions values (1,7,2,7);
insert into pgsse_paragraphes_restrictions values (1,12,1,7);
insert into pgsse_paragraphes_restrictions values (1,15,10,7);
insert into pgsse_paragraphes_restrictions values (1,16,8,7);
insert into pgsse_paragraphes_restrictions values (1,15,8,7);
insert into pgsse_paragraphes_restrictions values (1,12,14,7);
insert into pgsse_paragraphes_restrictions values (1,14,0,7);
insert into pgsse_paragraphes_restrictions values (1,8,10,7);
insert into pgsse_paragraphes_restrictions values (1,17,8,7);
insert into pgsse_paragraphes_restrictions values (1,3,4,7);
insert into pgsse_paragraphes_restrictions values (1,5,11,7);
insert into pgsse_paragraphes_restrictions values (1,4,11,7);
insert into pgsse_paragraphes_restrictions values (1,9,2,7);
insert into pgsse_paragraphes_restrictions values (1,11,14,7);
insert into pgsse_paragraphes_restrictions values (1,16,11,7);
insert into pgsse_paragraphes_restrictions values (1,10,8,7);
insert into pgsse_paragraphes_restrictions values (1,12,2,7);
insert into pgsse_paragraphes_restrictions values (1,15,0,7);
insert into pgsse_paragraphes_restrictions values (1,9,10,7);
insert into pgsse_paragraphes_restrictions values (1,7,4,7);
insert into pgsse_paragraphes_restrictions values (1,1,10,7);
insert into pgsse_paragraphes_restrictions values (1,8,2,7);
insert into pgsse_paragraphes_restrictions values (1,6,12,7);
insert into pgsse_paragraphes_restrictions values (1,17,4,7);
insert into pgsse_paragraphes_restrictions values (1,14,4,7);
insert into pgsse_paragraphes_restrictions values (1,12,11,7);
insert into pgsse_paragraphes_restrictions values (1,3,11,7);
insert into pgsse_paragraphes_restrictions values (1,5,1,7);
insert into pgsse_paragraphes_restrictions values (1,16,12,7);
insert into pgsse_paragraphes_restrictions values (1,8,1,7);
insert into pgsse_paragraphes_restrictions values (1,1,2,7);
insert into pgsse_paragraphes_restrictions values (1,5,0,7);
insert into pgsse_paragraphes_restrictions values (1,4,0,7);
insert into pgsse_paragraphes_restrictions values (1,7,14,7);
insert into pgsse_paragraphes_restrictions values (1,14,14,7);
insert into pgsse_paragraphes_restrictions values (1,6,14,7);
insert into pgsse_paragraphes_restrictions values (1,10,12,7);
insert into pgsse_paragraphes_restrictions values (1,10,14,7);
insert into pgsse_paragraphes_restrictions values (1,7,10,7);
insert into pgsse_paragraphes_restrictions values (1,9,11,7);
insert into pgsse_paragraphes_restrictions values (1,2,8,7);
insert into pgsse_paragraphes_restrictions values (1,2,2,7);
insert into pgsse_paragraphes_restrictions values (1,12,0,7);
insert into pgsse_paragraphes_restrictions values (1,11,1,7);
insert into pgsse_paragraphes_restrictions values (1,13,12,7);
insert into pgsse_paragraphes_restrictions values (1,4,4,7);
insert into pgsse_paragraphes_restrictions values (1,8,11,7);
insert into pgsse_paragraphes_restrictions values (1,1,12,7);
insert into pgsse_paragraphes_restrictions values (1,9,4,7);
insert into pgsse_paragraphes_restrictions values (1,10,11,7);
insert into pgsse_paragraphes_restrictions values (1,6,11,7);
insert into pgsse_paragraphes_restrictions values (1,2,14,7);
insert into pgsse_paragraphes_restrictions values (1,15,4,7);
insert into pgsse_paragraphes_restrictions values (1,13,8,7);
insert into pgsse_paragraphes_restrictions values (1,17,14,7);
insert into pgsse_paragraphes_restrictions values (1,20,23,7);
insert into pgsse_paragraphes_restrictions values (1,21,23,7);
insert into pgsse_paragraphes_restrictions values (1,22,23,7);
insert into pgsse_paragraphes_restrictions values (1,23,null,8);
insert into pgsse_paragraphes_restrictions values (1,24,null,8);
insert into pgsse_paragraphes_restrictions values (1,25,null,8);
insert into pgsse_paragraphes_restrictions values (1,26,null,8);
insert into pgsse_paragraphes_restrictions values (1,27,8,7);
insert into pgsse_paragraphes_restrictions values (1,17,16,7);
insert into pgsse_paragraphes_restrictions values (1,12,16,7);
insert into pgsse_paragraphes_restrictions values (1,8,16,7);
insert into pgsse_paragraphes_restrictions values (1,4,16,7);
insert into pgsse_paragraphes_restrictions values (1,14,16,7);
insert into pgsse_paragraphes_restrictions values (1,15,16,7);
insert into pgsse_paragraphes_restrictions values (1,11,16,7);
insert into pgsse_paragraphes_restrictions values (1,9,16,7);
insert into pgsse_paragraphes_restrictions values (1,7,16,7);
insert into pgsse_paragraphes_restrictions values (1,3,16,7);
insert into pgsse_paragraphes_restrictions values (1,2,16,7);
insert into pgsse_paragraphes_restrictions values (1,5,16,7);
insert into pgsse_paragraphes_restrictions values (1,6,16,7);
insert into pgsse_paragraphes_restrictions values (1,16,16,7);
insert into pgsse_paragraphes_restrictions values (1,10,16,7);
insert into pgsse_paragraphes_restrictions values (1,13,16,7);
insert into pgsse_paragraphes_restrictions values (1,1,16,7);


# --- !Downs