/**
 * @author dbu
 * @date 10/04/2025
 * @version 1.0.0
 * @project qualité
 * @table qualitometres_recherches
 */

# --- !Ups

DROP TABLE IF EXISTS qualitometres_recherches;
CREATE TABLE qualitometres_recherches
(
    id            BIGINT PRIMARY KEY,
    titre         TEXT  NOT NULL,
    typerecherche INT   NOT NULL,
    filtre_json   JSONB NOT NULL,
    login         TEXT                     DEFAULT NULL,
    loginmaj      VARCHAR(50)              DEFAULT NULL,
    datemaj       TIMESTAMP WITH TIME ZONE DEFAULT NULL
);

DROP SEQUENCE IF EXISTS seq_qualitometres_superpositions;
CREATE SEQUENCE seq_qualitometres_superpositions;

INSERT INTO qualitometres_recherches (id, titre, typerecherche, filtre_json, login, loginmaj, datemaj)
SELECT
    nextval('seq_qualitometres_superpositions'),
    titre,
    typedonnees,
    (SELECT coalesce(jsonb_object_agg(key, value), '{}'::jsonb)
     FROM (
              SELECT 'startDate' AS key, to_jsonb((extract(epoch from to_timestamp(datedebut, 'DD/MM/YYYY')) * 1000)::bigint) AS value WHERE datedebut IS NOT NULL AND datedebut != ''
              UNION ALL SELECT 'endDate', to_jsonb((extract(epoch from to_timestamp(datefin, 'DD/MM/YYYY')) * 1000)::bigint) WHERE datefin IS NOT NULL AND datefin != ''
              UNION ALL SELECT 'parameters', jsonb_build_array(parametre::TEXT) WHERE parametre IS NOT NULL
              UNION ALL SELECT 'units', jsonb_build_array(unite::TEXT) WHERE unite IS NOT NULL
              UNION ALL SELECT 'threshold', to_jsonb(seuil::INT) WHERE seuil IS NOT NULL
              UNION ALL SELECT 'selection', to_jsonb(selection) WHERE selection IS NOT NULL
              UNION ALL SELECT 'statut', to_jsonb(statut::TEXT) WHERE statut IS NOT NULL
              UNION ALL SELECT 'qualification', to_jsonb(qualification::TEXT) WHERE qualification IS NOT NULL
              UNION ALL SELECT 'support', to_jsonb(support::TEXT) WHERE support IS NOT NULL
              UNION ALL SELECT 'producers', jsonb_build_array(producteur) WHERE producteur IS NOT NULL
              UNION ALL SELECT 'laboratories', jsonb_build_array(codelabo) WHERE codelabo IS NOT NULL
              UNION ALL SELECT 'qualitometerIds', jsonb_build_array(codequalitometre) WHERE codequalitometre IS NOT NULL
              UNION ALL SELECT 'network', to_jsonb(codereseau) WHERE codereseau IS NOT NULL
          ) t
     WHERE value IS NOT NULL) as filtre,
    loginmaj,
    loginmaj,
    datemaj
FROM qualitometres_superpositions WHERE typedonnees IS NOT NULL;

DROP SEQUENCE IF EXISTS seq_qualitometres_superpositions;

# --- !Downs
