/**
 * @author TPA (demandé par sbarthon)
 * @date 29/06/21
 * @version 1.0.0
 * @project SIEAU
 */

# --- !Ups

CREATE TABLE public.communes_cp
(
  codecommune character varying(12),
  codepostal character varying(12)
);
CREATE UNIQUE INDEX pk_communes_cp ON COMMUNES_CP (codecommune, codepostal);

CREATE TABLE public.contacts_groupes
(
  codegroupe bigint,
  nomgroupe character varying(100),
  loginmaj character varying(25),
  datemaj timestamp with time zone
);
CREATE UNIQUE INDEX pk_contacts_groupes ON CONTACTS_GROUPES (codeGroupe);

CREATE TABLE public.contacts_groupes_liens
(
  codegroupe bigint,
  codecontact bigint
);
CREATE UNIQUE INDEX pk_contacts_groupes_liens ON CONTACTS_GROUPES_LIENS (codeGroupe, codeContact);

CREATE TABLE public.stations_contacts
(
  codestation bigint,
  typestation bigint,
  codegroupe bigint,
  codecontact bigint
);

CREATE TABLE public.inst_st_pompage_gc_batiments
(
  codeinstallation bigint,
  indicebatiment integer,
  typebatiment bigint,
  surfacebatiment real,
  commentaires text
);

ALTER TABLE PAYS ADD COLUMN niveauRGPD bigint;
DELETE FROM CODES_SANDRE where champ='PAYS.RGPD';
INSERT INTO CODES_SANDRE_REFERENTIEL VALUES('PAYS.RGPD',null,null);
INSERT INTO CODES_SANDRE ( Champ, Code, Libelle, mnemonique, Commentaire) VALUES ('PAYS.RGPD',1,'Pas de loi',null,'Pas de loi');
INSERT INTO CODES_SANDRE ( Champ, Code, Libelle, mnemonique, Commentaire) VALUES ('PAYS.RGPD',2,'Avec législation',null,'Avec législation');
INSERT INTO CODES_SANDRE ( Champ, Code, Libelle, mnemonique, Commentaire) VALUES ('PAYS.RGPD',3,'Autorité indépendante et loi(s)',null,'Autorité indépendante et loi(s)');
INSERT INTO CODES_SANDRE ( Champ, Code, Libelle, mnemonique, Commentaire) VALUES ('PAYS.RGPD',4,'Pays en adéquation partielle avec l''UE',null,'Pays en adéquation partielle avec l''UE');
INSERT INTO CODES_SANDRE ( Champ, Code, Libelle, mnemonique, Commentaire) VALUES ('PAYS.RGPD',5,'Pays adéquat avec l''UE',null,'Pays adéquat avec l''UE');
INSERT INTO CODES_SANDRE ( Champ, Code, Libelle, mnemonique, Commentaire) VALUES ('PAYS.RGPD',6,'Pays membre de l''UE',null,'Pays membre de l''UE');

# --- !Downs

drop table communes_cp;
drop table contacts_groupes;
drop table contacts_groupes_liens;
drop table stations_contacts;
drop table inst_st_pompage_gc_batiments;
ALTER TABLE PAYS DROP COLUMN niveauRGPD;