/**
 * @author pminot
 * @date 21/05/2025
 * @version 1.0.0
 * @project myliaq
 * @table analyses_seuils_web
 */

# --- !Ups

--création de la table
drop table if exists analyses_seuils_web;
create table analyses_seuils_web as select * from analyses_seuils;

-- ajout des nouvelles colonnes
alter table analyses_seuils_web rename column typeseuil to codeseuil;
alter table analyses_seuils_web add column typeseuil bigint;
alter table analyses_seuils_web add column affichage bigint;
alter table analyses_seuils_web add column discriminant bigint;

-- set valeur par défaut
update analyses_seuils_web set typeseuil = 1, affichage = 1, discriminant = 1;

-- décroissant
update analyses_seuils_web set affichage = 2 where seuil1 is not null and seuil2 is not null and seuil1 > seuil2;

-- PH et conductivité
update analyses_seuils_web asw set typeseuil = 3
	where ((asw.codeparametre = '1302' or asw.codeparametre = '6488') and asw.seuil1 < 7 and asw.seuil2 > 7 and asw.seuil3 is null and asw.seuil4 is null)
		or ((asw.codeparametre = '1304' or asw.codeparametre = '1303') and asw.seuil1 < 500 and asw.seuil2 > 500 and asw.seuil3 is null and asw.seuil4 is null);

# --- !Downs


