/**
 * @author tpa
 * @date 15/07/2025
 * @version 1.0.0
 * @project myliaq
 * @table qualitometres_listes
 */

# --- !Ups

WITH lignes_ordonnees AS (
    select ctid from (
         SELECT ctid, ROW_NUMBER() OVER (
             PARTITION BY codequalitometre, codeoperation, codetaxon
             ORDER BY codeliste -- ou un autre critère de priorité
             ) AS rn
         FROM qualitometres_listes
     ) as cr where rn > 1
)
DELETE FROM qualitometres_listes
WHERE ctid IN (
    SELECT ctid
    FROM lignes_ordonnees
);

create unique index qualitometres_listes__codetaxon_uindex
    on public.qualitometres_listes (codequalitometre, codeoperation, codetaxon);

# --- !Downs