/**
 * @author pmi
 * @date 21/07/2025
 * @version 1.0.0
 * @project myliaq
 * @table codes_sandre, pgsse_documents, pgsse_activites
 */

# --- !Ups

delete from codes_sandre where champ like 'PGSSE.DOCUMENTS';

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 1, 'Rapport Annuel sur le Prix et la Qualité du Service *');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 2, 'Descriptif détaillé des réseaux* : plan du réseau');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 3, 'Descriptif détaillé des réseaux* : inventaire des réseaux');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 4, 'Descriptif détaillé des ouvrages');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 5, 'Schéma de distribution d''eau (zonage)*');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 6, 'Plan d''actions de réduction des pertes');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 7, 'Schéma Directeur d''Eau Potable');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 8, 'Modélisation du réseau');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 9, 'Arrêtés préfectoraux d''autorisation*');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 10, 'Rapports d''hydrogéologue*');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 11, 'Analyses du contrôle sanitaire d l''ARS*');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 12, 'Rapport d''inspection de l''ARS');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 13, 'Carnet sanitaire*');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 14, 'Arrêté de dérogation');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 15, 'Etude de vulnérabilité des installations*');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 16, 'Contrat de délégation ou de prestation de services');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 17, 'Convention d''achats ou de vente d''eau en gros');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 18, 'Conventions avec des usagers extérieurs (antennistes)');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 19, 'Règlement de service*');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 20, 'Registre des plaintes des usagers');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 21, 'Certifications : ISO 14001, ISO 9001, ISO 22000 et OHSAS 18001');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 22, 'Document d''urbanisme (carte communale, PLU, PLUi)');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 23, 'Plan Communal de Sauvegarde');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 24, 'Schéma Départemental d''Eau Potable');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 25, 'Plan ORSEC : Plans de Secours Spécialisés Eau potable et');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 26, 'Pollution des eaux intérieures');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.DOCUMENTS', 27, 'Plan de Prévention des Risques Naturels et Technologiques');

delete from codes_sandre where champ like 'PGSSE.ACTIVITES%';

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 1, 'Exploitation des unités de production et de traitement');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 2, 'Entretien des réservoirs');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 3, 'Entretien des stations de pompage');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 4, 'Entretien et exploitation du réseau');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 5, 'Branchements');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 6, 'Gestion patrimoniale');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 7, 'Etudes et travaux neufs');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 8, 'Maintenance du matériel et des équipements');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 9, 'Gestion des abonnés');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 10, 'Gestion financière du service');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES', 11, 'Administration générale');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.1', 1, 'Surveillance et exploitation courante');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.1', 2, 'Suivi de la qualité de l''eau');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.1', 3, 'Maintenance électromécanique');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.1', 4, 'Dépannage');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.2', 1, 'Surveillance et exploitation courante');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.2', 2, 'Entretien courant');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.2', 3, 'Nettoyage');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.3', 1, 'Surveillance');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.3', 2, 'Maintenance électromécanique');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.3', 3, 'Dépannage');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.4', 1, 'Suivi de la qualité de l''eau');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.4', 2, 'Entretien courant');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.4', 3, 'Recherche de fuites');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.4', 4, 'Réparation');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.4', 5, 'Disfonctionnements');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.5', 1, 'Réalisation des branchements neufs');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.5', 2, 'Entretien réparation');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.5', 3, 'Renouvellement des compteurs');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.6', 1, 'Données patrimoniales');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.6', 2, 'Cartographie - SIG');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.6', 3, 'Programmation du renouvellement');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.7', 1, 'Etudes générales');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.7', 2, 'Maîtrise d''ouvrage');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.7', 3, 'Maîtrise d''œuvre');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.7', 4, 'Programmation des travaux');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.7', 5, 'Réalisation des études');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.7', 6, 'Réalisation des travaux');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.7', 7, 'Suivi et contrôle des travaux');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.8', 1, 'Fournitures et pièces détachées');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.8', 2, 'Suivi des sous-traitants');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.8', 3, 'Véhicules');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.9', 1, 'Fichier/logiciel abonnés');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.9', 2, 'Relève');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.9', 3, 'Facturation');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.9', 4, 'Réclamations/dégrèvements');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.9', 5, 'Information du public');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.10', 1, 'Etablissement et suivi du budget');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.10', 2, 'Comptabilité du service');

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.11', 1, 'Pilotage quotidien du personnel');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.11', 2, 'Gestion du personnel');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.11', 3, 'Gestion de la formation');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.11', 4, 'RPQS');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('PGSSE.ACTIVITES.11', 5, 'Relation avec les partenaires (Agence del''Eau, ARS,…)');

delete from codes_sandre where champ like 'CODE.PERTINENCE';

INSERT INTO codes_sandre (champ, code, libelle) VALUES ('CODE.PERTINENCE', 1, 'Inconnu');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('CODE.PERTINENCE', 2, 'Pertinent');
INSERT INTO codes_sandre (champ, code, libelle) VALUES ('CODE.PERTINENCE', 3, 'Non pertinent');

drop table if exists pgsse_documents;

create table pgsse_documents(
    idDiagnostic bigint,
    lexique bigint,
    autreNomDocument varchar(100),
    existant boolean,
    datedocument timestamp without time zone,
    pertinence bigint,
    datemaj timestamp without time zone,
    loginmaj varchar(50),
    commentaire text
);

drop table if exists pgsse_activites;

create table pgsse_activites(
    idDiagnostic bigint,
    category integer,
    lexique bigint,
    autreNomDocument varchar(100),
    regie boolean,
    delegation boolean,
    datemaj timestamp without time zone,
    loginmaj varchar(50),
    commentaire text
);

# --- !Downs