/**
 * @author dbu
 * @date 08/09/2025
 * @version 1.0.0
 * @project SIEau
 * @table analyses_parametres, analyses_fractions, analyses_unites, analyses_supports
 */

# --- !Ups

UPDATE analyses_parametres
SET actif = CASE
                WHEN actif = '1' THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM campagnes_parametres
                             WHERE codeparametre = analyses_parametres.code) THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM campagnes_planif_parametres
                             WHERE codeparametre = analyses_parametres.code) THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM chroniques_analyses
                             WHERE codeparametre = analyses_parametres.code) THEN '1'
                ELSE '0'
    END;


UPDATE analyses_fractions
SET actif = CASE
                WHEN actif = '1' THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM campagnes_parametres
                             WHERE codefraction = analyses_fractions.code) THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM campagnes_planif_parametres
                             WHERE codefraction = analyses_fractions.code) THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM chroniques_analyses
                             WHERE codefraction = analyses_fractions.code) THEN '1'
                ELSE '0'
    END;


UPDATE analyses_unites
SET actif = CASE
                WHEN actif = '1' THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM campagnes_parametres
                             WHERE codeunite = analyses_unites.code) THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM campagnes_planif_parametres
                             WHERE codeunite = analyses_unites.code) THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM chroniques_analyses
                             WHERE codeunite = analyses_unites.code) THEN '1'
                ELSE '0'
    END;


UPDATE analyses_supports
SET actif = CASE
                WHEN actif = '1' THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM campagnes_parametres
                             WHERE codesupport = analyses_supports.code) THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM campagnes_planif_parametres
                             WHERE codesupport = analyses_supports.code) THEN '1'
                WHEN EXISTS (SELECT 1
                             FROM qualitometres_points_operations
                             WHERE supportbiologique::text = analyses_supports.code) THEN '1'
                ELSE '0'
    END;

# --- !Downs
