/**
 * @author jroba
 * @date 03/10/2025
 * @version 1.0.0
 * @project SIEau
 * @table pluviometres
 */

# --- !Ups

drop view if exists mat_sites;
alter table pluviometres alter column identifiant type varchar(20) using identifiant::varchar(20);

create view mat_sites(typesite, codesite, identifiant, nom, commune, libelle) as
SELECT 1 AS typesite,
       piezometres.codepiezometre AS codesite,
       CASE piezometres.designation IS NULL
           WHEN true THEN piezometres.codebss::text
           ELSE (piezometres.codebss::text || '/'::text) || piezometres.designation::text
           END AS identifiant,
       piezometres.nom,
       communes.nom AS commune,
       'Piezo'::text AS libelle
FROM piezometres
         LEFT JOIN communes ON piezometres.codecommune::text = communes.codecommune::text
UNION
SELECT 2 AS typesite,
       pluviometres.codepluviometre AS codesite,
       pluviometres.identifiant,
       pluviometres.nom,
       communes.nom AS commune,
       'Pluvio'::text AS libelle
FROM pluviometres
         LEFT JOIN communes ON pluviometres.codecommune::text = communes.codecommune::text
UNION
SELECT 3 AS typesite,
       qualitometres.codequalitometre AS codesite,
       qualitometres.codebss AS identifiant,
       qualitometres.nom,
       communes.nom AS commune,
       'Qualito'::text AS libelle
FROM qualitometres
         LEFT JOIN communes ON qualitometres.codecommune::text = communes.codecommune::text
UNION
SELECT 4 AS typesite,
       stations_hydro.codestation AS codesite,
       stations_hydro.codehydro AS identifiant,
       stations_hydro.nom,
       communes.nom AS commune,
       'Station hydro'::text AS libelle
FROM stations_hydro
         LEFT JOIN communes ON stations_hydro.codecommune::text = communes.codecommune::text
UNION
SELECT 5 AS typesite,
       mat_centrales.idcentrale AS codesite,
       mat_centrales.noserie AS identifiant,
       mat_centrales_types.libelle AS nom,
       NULL::character varying AS commune,
       'Centrales'::text AS libelle
FROM mat_centrales
    LEFT JOIN mat_centrales_types ON mat_centrales.type = mat_centrales_types.typecentrale
UNION
SELECT 6 AS typesite,
       mat_capteurs.idcapteur AS codesite,
       mat_capteurs.noserie AS identifiant,
       mat_capteurs_types.libelle AS nom,
       NULL::character varying AS commune,
       'Capteurs'::text AS libelle
FROM mat_capteurs
    LEFT JOIN mat_capteurs_types ON mat_capteurs.type = mat_capteurs_types.typecapteur
UNION
SELECT 7 AS typesite,
       mat_equipements.idequipement AS codesite,
       mat_equipements.noserie AS identifiant,
       mat_equipements_types.libelle AS nom,
       NULL::character varying AS commune,
       'Equipements'::text AS libelle
FROM mat_equipements
    LEFT JOIN mat_equipements_types ON mat_equipements.typeequipement = mat_equipements_types.typeequipement
UNION
SELECT 8 AS typesite,
       mat_divers.id AS codesite,
       mat_divers.noserie AS identifiant,
       mat_divers_types.libelle AS nom,
       NULL::character varying AS commune,
       'Divers'::text AS libelle
FROM mat_divers
    LEFT JOIN mat_divers_types ON mat_divers.type = mat_divers_types.typedivers;

# --- !Downs
