/**
 * @author pminot
 * @date 08/10/2025
 * @version 1.0.0
 * @project SIEau
 * @table pgsse_questions
 */

# --- !Ups

delete from pgsse_dangers;
drop table if exists pgsse_dangers;

create table pgsse_dangers(
    idDanger bigint,
    idDiagnostic bigint,
    structure bigint,
    typeFamille bigint, -- elementUnique + id, ressources, installations, reseaux, intervenants, lexique type de famille + id
    etape bigint,
    typeDanger bigint,
    categories character varying(25), -- chaîne de plusieurs code d'un lexique sandre
    typestation bigint,
    codeElement bigint,
    groupeDanger bigint,
    precision text,
    frequence bigint,
    gravite bigint,
    groupeRisque text,
    miseEnOeuvre text,
    mesureSurPlace boolean,
    moyenSuivi text,
    freqSurveillance text,
    intervenantSurveillance text,
    actionCorrective text,
    detectabilite bigint
);

insert into parametres(module, identifiant, valeur) values ('SIEAU','PGSSE_LOW_DANGER','50');
insert into parametres(module, identifiant, valeur) values ('SIEAU','PGSSE_HIGH_DANGER','100');

delete from codes_sandre where champ like ('PGSSE.STRUCTURE');
delete from codes_sandre where champ like ('PGSSE.FAMILLE%');
delete from codes_sandre where champ like ('PGSSE.ETAPE%');
delete from codes_sandre where champ like ('PGSSE.TYPE_DANGER');
delete from codes_sandre where champ like ('PGSSE.GROUP_DANGER');
delete from codes_sandre where champ like ('PGSSE.FREQUENCE');
delete from codes_sandre where champ like ('PGSSE.GRAVITE');
delete from codes_sandre where champ like ('PGSSE.CATEGORIE');
delete from codes_sandre where champ like ('PGSSE.DETECTABILITE');

insert into codes_sandre values ('PGSSE.STRUCTURE',1,'RESSOURCES - EAU BRUTE');
insert into codes_sandre values ('PGSSE.STRUCTURE',2,'TRAITEMENT');
insert into codes_sandre values ('PGSSE.STRUCTURE',3,'STOCKAGE');
insert into codes_sandre values ('PGSSE.STRUCTURE',4,'FEEDER / ADDUCTION');
insert into codes_sandre values ('PGSSE.STRUCTURE',5,'RESEAU');

insert into codes_sandre values ('PGSSE.FAMILLE.1',1,'Toutes les ressources');
insert into codes_sandre values ('PGSSE.FAMILLE.1',2,'Eau de surface');
insert into codes_sandre values ('PGSSE.FAMILLE.1',3,'Eau souterraine');
insert into codes_sandre values ('PGSSE.FAMILLE.1',4,'Action des Tiers');
insert into codes_sandre values ('PGSSE.FAMILLE.1',5,'Evénements Exceptionnels');
insert into codes_sandre values ('PGSSE.FAMILLE.2',1,'Toute la chaîne de traitement');
insert into codes_sandre values ('PGSSE.FAMILLE.2',2,'Floculation, Coagulation, Décantation, CAP, micro-sable');
insert into codes_sandre values ('PGSSE.FAMILLE.2',3,'Filtration CAG et/ou FAS');
insert into codes_sandre values ('PGSSE.FAMILLE.2',4,'Désinfection par rayonnement UV');
insert into codes_sandre values ('PGSSE.FAMILLE.2',5,'Ultrafiltration');
insert into codes_sandre values ('PGSSE.FAMILLE.2',6,'Désinfection');
insert into codes_sandre values ('PGSSE.FAMILLE.2',7,'Bâche d''eau de lavage');
insert into codes_sandre values ('PGSSE.FAMILLE.2',8,'Bâche d''eau sale');
insert into codes_sandre values ('PGSSE.FAMILLE.2',9,'Action des Tiers');
insert into codes_sandre values ('PGSSE.FAMILLE.2',10,' Equipements communs de l''unité de traitement');
insert into codes_sandre values ('PGSSE.FAMILLE.2',11,' Evénements Exceptionnels');
insert into codes_sandre values ('PGSSE.FAMILLE.2',12,' Refoulement');
insert into codes_sandre values ('PGSSE.FAMILLE.3',1,'Tous les réservoirs');
insert into codes_sandre values ('PGSSE.FAMILLE.3',2,'Réservoirs');
insert into codes_sandre values ('PGSSE.FAMILLE.3',3,'Refoulement');
insert into codes_sandre values ('PGSSE.FAMILLE.3',4,'Action des Tiers');
insert into codes_sandre values ('PGSSE.FAMILLE.3',5,'Evénements Exceptionnels');
insert into codes_sandre values ('PGSSE.FAMILLE.4',1,'Tout le réseau d''adduction');
insert into codes_sandre values ('PGSSE.FAMILLE.4',2,'Environnement');
insert into codes_sandre values ('PGSSE.FAMILLE.4',3,'Action des Tiers');
insert into codes_sandre values ('PGSSE.FAMILLE.4',4,'Evénements Exceptionnels');
insert into codes_sandre values ('PGSSE.FAMILLE.4',5,'Exploitation');
insert into codes_sandre values ('PGSSE.FAMILLE.4',6,'Equipements et accessoires');
insert into codes_sandre values ('PGSSE.FAMILLE.4',7,'Surpression');
insert into codes_sandre values ('PGSSE.FAMILLE.5',1,'Tout le réseau de distribution');
insert into codes_sandre values ('PGSSE.FAMILLE.5',2,'Environnement');
insert into codes_sandre values ('PGSSE.FAMILLE.5',3,'Action des Tiers');
insert into codes_sandre values ('PGSSE.FAMILLE.5',4,'Evénements Exceptionnels');
insert into codes_sandre values ('PGSSE.FAMILLE.5',5,'Exploitation');
insert into codes_sandre values ('PGSSE.FAMILLE.5',6,'Equipements et accessoires');
insert into codes_sandre values ('PGSSE.FAMILLE.5',7,'Surpression');

insert into codes_sandre values ('PGSSE.ETAPE.1.1',1,'Continuité de service - rupture de l''alimentation en eau brute');
insert into codes_sandre values ('PGSSE.ETAPE.1.1',2,'Intrusion - Accès à l''eau (actes de malveillance)');
insert into codes_sandre values ('PGSSE.ETAPE.1.1',3,'Interventions et travaux sur le site (personnel interne, exploitant)');
insert into codes_sandre values ('PGSSE.ETAPE.1.2',1,'Aire d''alimentation / Bassin versant');
insert into codes_sandre values ('PGSSE.ETAPE.1.2',2,'Périmètre rapproché / Périmètre éloigné');
insert into codes_sandre values ('PGSSE.ETAPE.1.2',3,'Périmètre immédiat');
insert into codes_sandre values ('PGSSE.ETAPE.1.2',4,'Ouvrage de prélèvement (prise, pompes, etc.)');
insert into codes_sandre values ('PGSSE.ETAPE.1.3',1,'Aire d''alimentation / Bassin versant');
insert into codes_sandre values ('PGSSE.ETAPE.1.3',2,'Périmètre rapproché / Périmètre éloigné');
insert into codes_sandre values ('PGSSE.ETAPE.1.3',3,'Périmètre immédiat');
insert into codes_sandre values ('PGSSE.ETAPE.1.3',4,'Ouvrage de prélèvement (forage, pompes, etc.)');
insert into codes_sandre values ('PGSSE.ETAPE.1.4',1,'Interventions et travaux sur le site (Présence personnes extérieures)');
insert into codes_sandre values ('PGSSE.ETAPE.1.5',1,'Evénements climatiques (séisme, gel exceptionnel, inondations, tempête, ..)');
insert into codes_sandre values ('PGSSE.ETAPE.1.5',2,'Accident industriel (chimique, nucléaire, etc.)');
insert into codes_sandre values ('PGSSE.ETAPE.2.1',1,'Continuité de service - rupture de la production');
insert into codes_sandre values ('PGSSE.ETAPE.2.1',2,'Actes de malveillance (Intrusion, Accès à l''eau)');
insert into codes_sandre values ('PGSSE.ETAPE.2.1',3,'Interventions et travaux sur le site (personnel interne, exploitant)');
insert into codes_sandre values ('PGSSE.ETAPE.2.2',1,'Floculation, Coagulation, Décantation, CAP, micro-sable');
insert into codes_sandre values ('PGSSE.ETAPE.2.2',2,'Analyseurs et Sondes de mesure');
insert into codes_sandre values ('PGSSE.ETAPE.2.3',1,'Filtration CAG et/ou FAS');
insert into codes_sandre values ('PGSSE.ETAPE.2.3',2,'Analyseurs et Sondes de mesure');
insert into codes_sandre values ('PGSSE.ETAPE.2.4',1,'Désinfection par rayonnement UV');
insert into codes_sandre values ('PGSSE.ETAPE.2.4',2,'Analyseurs et Sondes de mesure');
insert into codes_sandre values ('PGSSE.ETAPE.2.5',1,'Ultrafiltration');
insert into codes_sandre values ('PGSSE.ETAPE.2.6',1,'Chloration (javel, chlore gazeux)');
insert into codes_sandre values ('PGSSE.ETAPE.2.6',2,'Analyseurs et Sondes de mesure');
insert into codes_sandre values ('PGSSE.ETAPE.2.7',1,'Bâche d''eau de lavage');
insert into codes_sandre values ('PGSSE.ETAPE.2.8',1,'Bâche d''eau sale');
insert into codes_sandre values ('PGSSE.ETAPE.2.9',1,'Interventions et travaux sur le site (Présence personnes extérieures)');
insert into codes_sandre values ('PGSSE.ETAPE.2.10',1,'Automatisme');
insert into codes_sandre values ('PGSSE.ETAPE.2.10',2,' Batteries Onduleurs');
insert into codes_sandre values ('PGSSE.ETAPE.2.10',3,' Groupes électrogènes');
insert into codes_sandre values ('PGSSE.ETAPE.2.10',4,' Poste de télégestion / Supervision');
insert into codes_sandre values ('PGSSE.ETAPE.2.10',5,' Surpresseurs / Compresseurs');
insert into codes_sandre values ('PGSSE.ETAPE.2.10',6,' Transformateurs');
insert into codes_sandre values ('PGSSE.ETAPE.2.10',7,' Equipements et accessoires hydrauliques');
insert into codes_sandre values ('PGSSE.ETAPE.2.11',1,' Evénements climatiques (séisme, gel exceptionnel, inondations, tempête, ..)');
insert into codes_sandre values ('PGSSE.ETAPE.2.11',2,' Accident industriel (chimique, nucléaire, etc.) ou de circulation');
insert into codes_sandre values ('PGSSE.ETAPE.2.11',3,' Incendie');
insert into codes_sandre values ('PGSSE.ETAPE.2.12',1,' Refoulement');
insert into codes_sandre values ('PGSSE.ETAPE.3.1',1,'Continuité de service - rupture de la distribution');
insert into codes_sandre values ('PGSSE.ETAPE.3.1',2,'Actes de malveillance (Intrusion, Accès à l''eau)');
insert into codes_sandre values ('PGSSE.ETAPE.3.1',3,'Interventions et travaux sur le site (personnel interne, exploitant)');
insert into codes_sandre values ('PGSSE.ETAPE.3.2',1,'Réservoirs');
insert into codes_sandre values ('PGSSE.ETAPE.3.2',2,'Analyseurs et Sondes de mesure');
insert into codes_sandre values ('PGSSE.ETAPE.3.3',1,'Refoulement');
insert into codes_sandre values ('PGSSE.ETAPE.3.4',1,'Interventions et travaux sur le site (Présence personnes extérieures)');
insert into codes_sandre values ('PGSSE.ETAPE.3.5',1,'Evénements climatiques (séisme, gel exceptionnel, inondations, tempête, ..)');
insert into codes_sandre values ('PGSSE.ETAPE.3.5',2,'Accident industriel (chimique, nucléaire, etc.) ou de circulation');
insert into codes_sandre values ('PGSSE.ETAPE.3.5',3,'Incendie');
insert into codes_sandre values ('PGSSE.ETAPE.4.1',1,'Continuité de service - rupture de l''adduction');
insert into codes_sandre values ('PGSSE.ETAPE.4.1',2,'Actes de malveillance (Intrusion, Accès à l''eau)');
insert into codes_sandre values ('PGSSE.ETAPE.4.1',3,'Interventions et travaux sur le site (personnel interne, exploitant)');
insert into codes_sandre values ('PGSSE.ETAPE.4.2',1,'Criticité physique');
insert into codes_sandre values ('PGSSE.ETAPE.4.2',2,'Pédologie');
insert into codes_sandre values ('PGSSE.ETAPE.4.2',3,'Industries présentes / Agriculture');
insert into codes_sandre values ('PGSSE.ETAPE.4.2',4,'Réseaux d''eaux usées');
insert into codes_sandre values ('PGSSE.ETAPE.4.2',5,'Rivière / Cours d''eau');
insert into codes_sandre values ('PGSSE.ETAPE.4.2',6,'Transport / Circulation');
insert into codes_sandre values ('PGSSE.ETAPE.4.3',1,'Interventions et travaux sur le site (Présence personnes extérieures)');
insert into codes_sandre values ('PGSSE.ETAPE.4.4',1,'Evénements climatiques (séisme, gel exceptionnel, fortes chaleurs, inondations, tempête, ..)');
insert into codes_sandre values ('PGSSE.ETAPE.4.4',2,'Accident industriel (chimique, nucléaire, etc.) ou de circulation');
insert into codes_sandre values ('PGSSE.ETAPE.4.4',3,'Incendie');
insert into codes_sandre values ('PGSSE.ETAPE.4.5',1,'Interconnexion - Achat et/ou Vente d''eau');
insert into codes_sandre values ('PGSSE.ETAPE.4.5',2,'Travaux');
insert into codes_sandre values ('PGSSE.ETAPE.4.5',3,'Temps de séjour');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',1,'Comptage (débitmètre)');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',2,'Canalisations');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',3,'Matériaux / Revêtement intérieur');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',4,'Clapet anti-retour / Disconnecteur');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',5,'Vidanges');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',6,'Hydrants (PI ou BI)');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',7,'Stabilisateur de pression aval');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',8,'Vannes');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',9,'Vannes de sectorisation et équipements associés');
insert into codes_sandre values ('PGSSE.ETAPE.4.6',10,'Ventouses');
insert into codes_sandre values ('PGSSE.ETAPE.4.7',1,'Surpression');
insert into codes_sandre values ('PGSSE.ETAPE.5.1',1,'Continuité de service - rupture de la distribution');
insert into codes_sandre values ('PGSSE.ETAPE.5.1',2,'Actes de malveillance (Intrusion, Accès à l''eau)');
insert into codes_sandre values ('PGSSE.ETAPE.5.1',3,'Interventions et travaux sur le site (personnel interne, exploitant)');
insert into codes_sandre values ('PGSSE.ETAPE.5.2',1,'Criticité physique');
insert into codes_sandre values ('PGSSE.ETAPE.5.2',2,'Pédologie');
insert into codes_sandre values ('PGSSE.ETAPE.5.2',3,'Industries présentes / Agriculture');
insert into codes_sandre values ('PGSSE.ETAPE.5.2',4,'Réseaux d''eaux usées');
insert into codes_sandre values ('PGSSE.ETAPE.5.2',5,'Rivière / Cours d''eau');
insert into codes_sandre values ('PGSSE.ETAPE.5.2',6,'Transport / Circulation');
insert into codes_sandre values ('PGSSE.ETAPE.5.3',1,'Interventions et travaux sur le site (Présence personnes extérieures)');
insert into codes_sandre values ('PGSSE.ETAPE.5.3',2,'Réseau privé (lotissement, particuliers, industriels, puits privés, réserves d''eau, etc.)');
insert into codes_sandre values ('PGSSE.ETAPE.5.4',1,'Evénements climatiques (séisme, gel exceptionnel, fortes chaleurs, inondations, tempête, ..)');
insert into codes_sandre values ('PGSSE.ETAPE.5.4',2,'Accident industriel (chimique, nucléaire, etc.) ou de circulation');
insert into codes_sandre values ('PGSSE.ETAPE.5.4',3,'Incendie');
insert into codes_sandre values ('PGSSE.ETAPE.5.5',1,'Interconnexion - Achat et/ou Vente d''eau');
insert into codes_sandre values ('PGSSE.ETAPE.5.5',2,'Travaux');
insert into codes_sandre values ('PGSSE.ETAPE.5.5',3,'Temps de séjour');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',1,'Branchements (inc. les compteurs)');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',2,'Canalisations');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',3,'Matériaux / Revêtement intérieur');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',4,'Clapet anti-retour / Disconnecteur');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',5,'Vidanges');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',6,'Hydrants (PI ou BI)');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',7,'Stabilisateur de pression aval');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',8,'Vannes');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',9,'Vannes de sectorisation et équipements associés');
insert into codes_sandre values ('PGSSE.ETAPE.5.6',10,' Ventouses');
insert into codes_sandre values ('PGSSE.ETAPE.5.7',1,'Surpression');

insert into codes_sandre values ('PGSSE.TYPE_DANGER',1,'Continuite de service','Continuité de service - rupture de l''alimentation en eau brute, manque d''eau', null,null,null,null,null,'CS');
insert into codes_sandre values ('PGSSE.TYPE_DANGER',2,'Dégradation microbiologique','Dégradation de la qualité microbiologique de l''eau', null,null,null,null,null,'M');
insert into codes_sandre values ('PGSSE.TYPE_DANGER',3,'Dégration microbiologique ou physico-chimique','Dégradation microbiologique et/ou physico-chimique de l''eau par l''introduction d''éléments externes', null,null,null,null,null,'M/PC');
insert into codes_sandre values ('PGSSE.TYPE_DANGER',4,'Dégradation physico-chimique','Dégradation de la qualité physico-chimique de l''eau', null,null,null,null,null,'PC');

insert into codes_sandre values ('PGSSE.GROUP_DANGER',1, 'Humain (défaillance due à l''opérateur, mauvaise méthode, actions des tiers, etc.)');
insert into codes_sandre values ('PGSSE.GROUP_DANGER',2, 'Matériel (équipements, matériel, etc.)');
insert into codes_sandre values ('PGSSE.GROUP_DANGER',3, 'Technique (qualité, analyses, etc.)');
insert into codes_sandre values ('PGSSE.GROUP_DANGER',4, 'Rupture de service');

insert into codes_sandre values ('PGSSE.FREQUENCE',0, 'Jamais arrivé');
insert into codes_sandre values ('PGSSE.FREQUENCE',1, '> 10 ans - Exceptionnel');
insert into codes_sandre values ('PGSSE.FREQUENCE',2, 'De 5 à 10 ans - Accidentel');
insert into codes_sandre values ('PGSSE.FREQUENCE',3, 'De 1 à 5 ans - Occasionnel ou ponctuel');
insert into codes_sandre values ('PGSSE.FREQUENCE',4, 'Plusieurs fois par an - Régulier');
insert into codes_sandre values ('PGSSE.FREQUENCE',5, 'Plusieurs fois par mois ou tous les mois - Récurrent');

insert into codes_sandre values ('PGSSE.GRAVITE', 10, 'Gravité 10');
insert into codes_sandre values ('PGSSE.GRAVITE', 20, 'Gravité 20');
insert into codes_sandre values ('PGSSE.GRAVITE', 30, 'Gravité 30');
insert into codes_sandre values ('PGSSE.GRAVITE', 40, 'Gravité 40');

insert into codes_sandre values ('PGSSE.CATEGORIE', 0, 'Milieu');
insert into codes_sandre values ('PGSSE.CATEGORIE', 1, 'Matériel');
insert into codes_sandre values ('PGSSE.CATEGORIE', 2, 'Méthode');
insert into codes_sandre values ('PGSSE.CATEGORIE', 3, 'Matière première');
insert into codes_sandre values ('PGSSE.CATEGORIE', 4, 'Main d''oeuvre');

insert into codes_sandre values ('PGSSE.DETECTABILITE', 1, 'Moyen de surveillance absent');
insert into codes_sandre values ('PGSSE.DETECTABILITE', 2, 'Moyen de surveillance insuffisant');
insert into codes_sandre values ('PGSSE.DETECTABILITE', 5, 'Moyen de surveillance approprié en place');

# --- !Downs
