/**
 * @author dbu
 * @date 16/10/2025
 * @version 1.0.0
 * @project SIEau
 * @table campagnes_planif, campagnes_parametres, campagnes_planif_parametres, campagnes_sites, campagnes_planif_stations
 */

# --- !Ups

-- CREATE BACKUP
CREATE TABLE IF NOT EXISTS campagnes_planif_backup AS
SELECT * FROM campagnes_planif;

CREATE TABLE IF NOT EXISTS campagnes_parametres_backup AS
SELECT * FROM campagnes_parametres;

CREATE TABLE IF NOT EXISTS campagnes_sites_backup AS
SELECT * FROM campagnes_sites;

CREATE TABLE IF NOT EXISTS campagnes_planif_parametres_backup AS
SELECT * FROM campagnes_planif_parametres;

CREATE TABLE IF NOT EXISTS campagnes_planif_stations_backup AS
SELECT * FROM campagnes_planif_stations;




-- LOAD BACKUP
-- DROP TABLE IF EXISTS campagnes_planif;
-- CREATE TABLE campagnes_planif AS
-- SELECT * FROM campagnes_planif_backup;

-- DROP TABLE IF EXISTS campagnes_planif_parametres;
-- CREATE TABLE campagnes_planif_parametres AS
-- SELECT * FROM campagnes_planif_parametres_backup;

-- DROP TABLE IF EXISTS campagnes_planif_stations;
-- CREATE TABLE campagnes_planif_stations AS
-- SELECT * FROM campagnes_planif_stations_backup;

-- DROP TABLE IF EXISTS campagnes_sites;
-- CREATE TABLE campagnes_sites AS
-- SELECT * FROM campagnes_sites_backup;

-- DROP TABLE IF EXISTS campagnes_parametres;
-- CREATE TABLE campagnes_parametres AS
-- SELECT * FROM campagnes_parametres_backup;




-- CLEAN LOST DATA
DELETE FROM campagnes_planif
WHERE codecampagne NOT IN (SELECT codecampagne FROM campagnes);

DELETE FROM campagnes_planif_stations cps
WHERE cps.planifid NOT IN (SELECT id FROM campagnes_planif);

DELETE FROM campagnes_planif_parametres cpp
WHERE cpp.planifid NOT IN (SELECT id FROM campagnes_planif);

DELETE FROM campagnes_sites
WHERE codecampagne NOT IN (SELECT codecampagne FROM campagnes)
   OR (typestation = 3 AND codesite NOT IN (SELECT codequalitometre FROM qualitometres));

DELETE FROM campagnes_parametres
WHERE codecampagne NOT IN (SELECT codecampagne FROM campagnes);




-- UPDATE PARAMETER TABLE
ALTER TABLE campagnes_parametres DROP COLUMN IF EXISTS id CASCADE;
ALTER TABLE campagnes_parametres ADD COLUMN id BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY;
ALTER TABLE campagnes_planif_parametres DROP COLUMN IF EXISTS campagnesparametreid;
ALTER TABLE campagnes_planif_parametres ADD COLUMN campagnesparametreid BIGINT;

ALTER TABLE campagnes_planif_parametres
    ADD CONSTRAINT fk_campagnes_parametres
        FOREIGN KEY (campagnesparametreid) REFERENCES campagnes_parametres(id);

INSERT INTO campagnes_parametres (
    codecampagne,
    codeparametre,
    codeunite,
    codelieu,
    codefraction,
    codesupport,
    frequence
)
SELECT DISTINCT
    cp.codecampagne,
    cpp.codeparametre,
    cpp.codeunite,
    cpp.codelieu,
    cpp.codefraction,
    cpp.codesupport,
    NULL as frequence
FROM campagnes_planif_parametres cpp
         INNER JOIN campagnes_planif cp ON cpp.planifid = cp.id
         LEFT JOIN campagnes_parametres cpar
                   ON cpp.codeparametre = cpar.codeparametre
                       AND cpp.codeunite IS NOT DISTINCT FROM cpar.codeunite
                       AND cpp.codefraction IS NOT DISTINCT FROM cpar.codefraction
                       AND cpp.codesupport IS NOT DISTINCT FROM cpar.codesupport
                       AND cpp.codelieu IS NOT DISTINCT FROM cpar.codelieu
                       AND cp.codecampagne = cpar.codecampagne
WHERE cpar.codeparametre IS NULL;

UPDATE campagnes_planif_parametres
SET campagnesparametreid = cpar.id
    FROM campagnes_parametres cpar
         INNER JOIN campagnes_planif cp ON cp.codecampagne = cpar.codecampagne
WHERE campagnes_planif_parametres.planifid = cp.id
  AND campagnes_planif_parametres.codeparametre = cpar.codeparametre
  AND campagnes_planif_parametres.codeunite IS NOT DISTINCT FROM cpar.codeunite
  AND campagnes_planif_parametres.codefraction IS NOT DISTINCT FROM cpar.codefraction
  AND campagnes_planif_parametres.codesupport IS NOT DISTINCT FROM cpar.codesupport
  AND campagnes_planif_parametres.codelieu IS NOT DISTINCT FROM cpar.codelieu
  AND campagnes_planif_parametres.campagnesparametreid IS NULL;

ALTER TABLE campagnes_planif_parametres
    ALTER COLUMN campagnesparametreid SET NOT NULL;

ALTER TABLE campagnes_planif_parametres DROP COLUMN IF EXISTS codeparametre;
ALTER TABLE campagnes_planif_parametres DROP COLUMN IF EXISTS codeunite;
ALTER TABLE campagnes_planif_parametres DROP COLUMN IF EXISTS codefraction;
ALTER TABLE campagnes_planif_parametres DROP COLUMN IF EXISTS codesupport;
ALTER TABLE campagnes_planif_parametres DROP COLUMN IF EXISTS codelieu;




-- UPDATE STATION TABLE
ALTER TABLE campagnes_sites DROP COLUMN IF EXISTS id CASCADE;
ALTER TABLE campagnes_sites ADD COLUMN id BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY;
ALTER TABLE campagnes_planif_stations DROP COLUMN IF EXISTS campagnesiteid;
ALTER TABLE campagnes_planif_stations ADD COLUMN campagnesiteid BIGINT;

ALTER TABLE campagnes_planif_stations
    ADD CONSTRAINT fk_campagnes_sites
        FOREIGN KEY (campagnesiteid) REFERENCES campagnes_sites(id);

INSERT INTO campagnes_sites (
    codecampagne,
    codesite,
    ordrepassage,
    datepassage,
    acces,
    telcontact,
    afaire,
    typestation,
    codification,
    pointprelevement
)
SELECT cp.codecampagne,
       cps.codesite,
       NULL as ordrepassage,
       NULL as datepassage,
       NULL as acces,
       NULL as telcontact,
       NULL as afaire,
       '3' as typestation,
       NULL as codification,
       NULL as pointprelevement
FROM campagnes_planif_stations cps
         INNER JOIN campagnes_planif cp ON cps.planifid = cp.id
         LEFT JOIN campagnes_sites cs ON cps.codesite = cs.codesite AND cp.codecampagne = cs.codecampagne AND cs.typestation = '3'
WHERE cs.codesite IS NULL;

UPDATE campagnes_planif_stations
SET campagnesiteid = cs.id
    FROM campagnes_sites cs
         INNER JOIN campagnes_planif cp ON cp.codecampagne = cs.codecampagne
WHERE campagnes_planif_stations.planifid = cp.id
  AND campagnes_planif_stations.codesite = cs.codesite
  AND campagnes_planif_stations.campagnesiteid IS NULL;

ALTER TABLE campagnes_planif_stations
    ALTER COLUMN campagnesiteid SET NOT NULL;

ALTER TABLE campagnes_planif_stations DROP COLUMN IF EXISTS codesite;




-- UPDATE PLANNING TABLE
ALTER TABLE campagnes_planif DROP COLUMN IF EXISTS oldid;
ALTER TABLE campagnes_planif RENAME COLUMN id TO oldid;
ALTER TABLE campagnes_planif ADD COLUMN id BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY;

UPDATE campagnes_planif_stations
SET planifid = cp.id
    FROM campagnes_planif cp
WHERE campagnes_planif_stations.planifid = cp.oldid;

UPDATE campagnes_planif_parametres
SET planifid = cp.id
    FROM campagnes_planif cp
WHERE campagnes_planif_parametres.planifid = cp.oldid;

ALTER TABLE campagnes_planif DROP COLUMN IF EXISTS oldid;

# --- !Downs