/**
 * @author jroba
 * @date 02/12/2025
 * @version 1.0.0
 * @project SIEau
 * @table *
 */

# --- !Ups

ALTER TABLE ades_listes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE aep_captages_dossiers ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE aep_captages_dossiers_evenements ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE aep_captages_dossiers_parcelles ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE aep_captages_dossiers_perimetres ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);

drop view if exists eau17sig_reservoirs;
drop view if exists v_eau17sig_captages;
drop view if exists v_eau17sig_poste_relevage;
drop view if exists v_eau17sig_reservoirs;
drop view if exists v_eau17sig_stations_pompages;
drop view if exists v_eau17sig_step;
ALTER TABLE aep_installations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
create view eau17sig_reservoirs
            (identifiant, nbcuves, naturecuves, revetementcuve, moderemplissage, presenceturbidimetre,
             presencanalyseurchlore, colonneseche, fontaine, typedetectionniveau, typemesuredebitmetrique,
             presencebypass, presencerobinetflotteur, loginmaj, datemaj)
as
SELECT aep_installations.identifiant,
       inst_reservoir_gc.nbcuves,
       lex_natures_cuves.libelle AS naturecuves,
       lex_revetements_cuves.libelle AS revetementcuve,
       lex_mode_rempl_cuves.libelle AS moderemplissage,
       CASE equip_turbidimetre.codeequipement
           WHEN 0 THEN true
           ELSE false
           END AS presenceturbidimetre,
       CASE equip_chlore.codeequipement
           WHEN 0 THEN true
           ELSE false
           END AS presencanalyseurchlore,
       CASE equip_colonne_seche.codeprotection
           WHEN 0 THEN true
           ELSE false
           END AS colonneseche,
       CASE equip_fontaine.codeequipement
           WHEN 0 THEN true
           ELSE false
           END AS fontaine,
       lex_detection_niveau.libelle AS typedetectionniveau,
       lex_mesure_debit.libelle AS typemesuredebitmetrique,
       CASE equip_bypass.codeequipement
           WHEN 0 THEN true
           ELSE false
           END AS presencebypass,
       CASE equip_robinetflotteur.codeequipement
           WHEN 0 THEN true
           ELSE false
           END AS presencerobinetflotteur,
       aep_installations.loginmaj,
       aep_installations.datemaj
FROM aep_installations
         LEFT JOIN inst_reservoir_gc ON aep_installations.codeinstallation = inst_reservoir_gc.codeinstallation
         LEFT JOIN codes_sandre lex_natures_cuves ON inst_reservoir_gc.naturecuve = lex_natures_cuves.code AND lex_natures_cuves.champ::text = 'CUVES.MATERIAU'::text
         LEFT JOIN codes_sandre lex_revetements_cuves ON inst_reservoir_gc.revetementcuve = lex_revetements_cuves.code AND lex_revetements_cuves.champ::text = 'INSTALLATIONS.REVETEMENTCUVE'::text
         LEFT JOIN codes_sandre lex_mode_rempl_cuves ON inst_reservoir_gc.moderemplissage = lex_mode_rempl_cuves.code AND lex_mode_rempl_cuves.champ::text = 'INSTALLATIONS.MODEREMPLISSAGE'::text
         LEFT JOIN inst_equipements_detail equip_turbidimetre ON aep_installations.codeinstallation = equip_turbidimetre.codeinstallation AND equip_turbidimetre.codeequipement = 0
         LEFT JOIN inst_equipements_detail equip_chlore ON aep_installations.codeinstallation = equip_chlore.codeinstallation AND equip_chlore.codeequipement = 1
         LEFT JOIN inst_equipements_detail equip_fontaine ON aep_installations.codeinstallation = equip_fontaine.codeinstallation AND equip_fontaine.codeequipement = 3
         LEFT JOIN inst_securite_personnel equip_colonne_seche ON aep_installations.codeinstallation = equip_colonne_seche.codeinstallation AND equip_colonne_seche.codeprotection = 4
         LEFT JOIN inst_reservoir_equipements ON aep_installations.codeinstallation = inst_reservoir_equipements.codeinstallation
         LEFT JOIN codes_sandre lex_detection_niveau ON inst_reservoir_equipements.typedetectionniveau = lex_detection_niveau.code AND lex_detection_niveau.champ::text = 'INSTALLATIONS.TYPEDETECTION'::text
         LEFT JOIN codes_sandre lex_mesure_debit ON inst_reservoir_equipements.mesuredebitmetrique = lex_mesure_debit.code AND lex_mesure_debit.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
         LEFT JOIN inst_equipements_detail equip_bypass ON aep_installations.codeinstallation = equip_bypass.codeinstallation AND equip_bypass.codeequipement = 4
         LEFT JOIN inst_equipements_detail equip_robinetflotteur ON aep_installations.codeinstallation = equip_robinetflotteur.codeinstallation AND equip_robinetflotteur.codeequipement = 5
WHERE aep_installations.typeinstallation = 12;
create view v_eau17sig_captages
            (identifiant, libelle, nappe, modegisement, datedesaffectation, fonctionnement, profondeurforage,
             diametreinternetubage, epaisseurtubage, naturetubage, profondeurtubage, ouvragecrepine, profpompe,
             cotebride, coterepere, margelleprotection, capotage, teteetanche, derniereinspection, debitnominal, hmt,
             typepompe, diametreexterieurcolonneexhaure, typecolonneexhaure, naturecolonneexhaure, typedetectionniveau,
             profondeursonde, ventouse, mesuredebimetrique, clapetantiretour, presenceantiintrusion, nbsystemes,
             hastelegestion, loginmaj, datemaj)
as
SELECT aep_installations.identifiant,
       lex_type.libelle,
       aquiferes.libelle AS nappe,
       lex_gisement.libelle AS modegisement,
       aep_installations.datefin AS datedesaffectation,
       lex_etat.libelle AS fonctionnement,
       forages_gc.profondeurforage,
       forages_gc.diametreinternetubage,
       forages_gc.epaisseurtubage,
       lex_tubage.libelle AS naturetubage,
       forages_gc.profondeurtubage,
       forages_gc.ouvragecrepine,
       inst_forages.profpompe,
       forages_gc.cotebride,
       forages_gc.coterepere,
       forages_gc.margelleprotection,
       forages_gc.capotage,
       forages_gc.teteetanche,
       forages_gc.derniereinspection,
       forages_equipements.debitnominal,
       forages_equipements.hmt,
       lex_typepompe.libelle AS typepompe,
       forages_equipements.diametreexterieurcolonneexhaure,
       lex_typecolonneexhaure.libelle AS typecolonneexhaure,
       lex_naturecolonneexhaure.libelle AS naturecolonneexhaure,
       lex_typedetectionniveau.libelle AS typedetectionniveau,
       forages_gc.profondeursonde,
       CASE
           WHEN equip_ventouse.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS ventouse,
       CASE
           WHEN equip_mesuredebit.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS mesuredebimetrique,
       CASE
           WHEN equip_clapet.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS clapetantiretour,
       CASE
           WHEN equip_antiintrusion.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presenceantiintrusion,
       systemesecurite.nbsystemes,
       inst_electricite_com.hastelegestion,
       aep_installations.loginmaj,
       aep_installations.datemaj
FROM aep_installations
         LEFT JOIN inst_forages ON aep_installations.codeinstallation = inst_forages.codeinstallation
         LEFT JOIN forages_gc ON aep_installations.codeinstallation = forages_gc.codeinstallation
         LEFT JOIN forages_equipements ON aep_installations.codeinstallation = forages_equipements.codeinstallation
         LEFT JOIN inst_equipements_detail equip_ventouse ON aep_installations.codeinstallation = equip_ventouse.codeinstallation AND (equip_ventouse.codeequipement = 0 OR equip_ventouse.codeequipement IS NULL)
         LEFT JOIN inst_equipements_detail equip_mesuredebit ON aep_installations.codeinstallation = equip_mesuredebit.codeinstallation AND (equip_mesuredebit.codeequipement = 1 OR equip_mesuredebit.codeequipement IS NULL)
         LEFT JOIN inst_equipements_detail equip_clapet ON aep_installations.codeinstallation = equip_clapet.codeinstallation AND (equip_clapet.codeequipement = 2 OR equip_clapet.codeequipement IS NULL)
         LEFT JOIN codes_sandre lex_gisement ON inst_forages.modegisement = lex_gisement.code AND lex_gisement.champ::text = 'PIEZOMETRES.MODEGISEMENT'::text
         LEFT JOIN codes_sandre lex_etat ON aep_installations.statut = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
         LEFT JOIN codes_sandre lex_tubage ON forages_gc.naturetubage = lex_tubage.code AND lex_tubage.champ::text = 'INSTALLATIONS.NATUREEQUIPEMENT'::text
         LEFT JOIN lien_forages_aquifere ON aep_installations.codeinstallation = lien_forages_aquifere.codeinstallation AND (lien_forages_aquifere.numeroordre = 0 OR lien_forages_aquifere.numeroordre IS NULL)
         LEFT JOIN aquiferes ON lien_forages_aquifere.codeaquifere::double precision = aquiferes.codeaquifere
         LEFT JOIN codes_sandre lex_type ON inst_forages.codenature = lex_type.code AND lex_type.champ::text = 'PIEZOMETRES.CODENATURE'::text
         LEFT JOIN codes_sandre lex_typepompe ON forages_equipements.typepompe = lex_typepompe.code AND lex_typepompe.champ::text = 'INSTALLATIONS.TYPEPOMPE'::text
         LEFT JOIN codes_sandre lex_typecolonneexhaure ON forages_equipements.typecolonneexhaure = lex_typecolonneexhaure.code AND lex_typecolonneexhaure.champ::text = 'INSTALLATIONS.TYPECOLONNEEXHAURE'::text
         LEFT JOIN codes_sandre lex_naturecolonneexhaure ON forages_equipements.naturecolonneexhaure = lex_typecolonneexhaure.code AND lex_typecolonneexhaure.champ::text = 'INSTALLATIONS.NATURECOLONNEEXHAURE'::text
         LEFT JOIN codes_sandre lex_typedetectionniveau ON forages_equipements.typedetectionniveau = lex_typedetectionniveau.code AND lex_typedetectionniveau.champ::text = 'INSTALLATIONS.TYPEDETECTION'::text
         LEFT JOIN ( SELECT inst_securite.codeinstallation,
                            count(*) AS nbsystemes
                     FROM inst_securite
                     GROUP BY inst_securite.codeinstallation) systemesecurite ON aep_installations.codeinstallation = systemesecurite.codeinstallation
         LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
         LEFT JOIN inst_equipements_detail equip_antiintrusion ON aep_installations.codeinstallation = equip_antiintrusion.codeinstallation AND equip_antiintrusion.codeequipement = 39
WHERE aep_installations.typeinstallation = 0 AND aep_installations.jobexecutionid IS NULL;
create view v_eau17sig_poste_relevage
            (identifiant, fonctionnement, naturecuves, revetementantiacide, cotealtidessusposte, coteentreefileau,
             cotefondcuve, profondeur, tropplein, cotetropplein, bassintampon, nbpompes, debitnominal, hmt,
             dispositifbrassage, antibelier, traitementh2s, mesuredebimetrique, desodorisation, ventousechambrevannes,
             vanneisolement, branchementaep, groupeelectrogene, barreantichute, hastelegestion, inverseursource,
             loginmaj, datemaj)
as
SELECT aep_installations.identifiant,
       lex_etat.libelle AS fonctionnement,
       lex_natures_cuves.libelle AS naturecuves,
       inst_poste_relevage_gc.revetementantiacide,
       inst_poste_relevage_gc.cotealtidessusposte,
       inst_poste_relevage_gc.coteentreefileau,
       inst_poste_relevage_gc.cotefondcuve,
       inst_poste_relevage_gc.profondeur,
       inst_poste_relevage_gc.tropplein,
       inst_poste_relevage_gc.cotetropplein,
       inst_poste_relevage_gc.bassintampon,
       inst_poste_relevage_equipements.nbpompes,
       inst_poste_relevage_equipements.debitnominal,
       inst_poste_relevage_equipements.hmt,
       CASE
           WHEN equip_brassage.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS dispositifbrassage,
       CASE
           WHEN equip_antibelier.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS antibelier,
       CASE
           WHEN equip_traitementh2s.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS traitementh2s,
       CASE
           WHEN equip_mesuredebimetrique.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS mesuredebimetrique,
       CASE
           WHEN equip_desodorisation.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS desodorisation,
       CASE
           WHEN equip_ventousechambrevannes.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS ventousechambrevannes,
       CASE
           WHEN equip_vanneisolement.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS vanneisolement,
       CASE
           WHEN equip_branchementaep.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS branchementaep,
       CASE
           WHEN equip_groupe_electrogene.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS groupeelectrogene,
       CASE
           WHEN equip_barreantichute.codeprotection IS NOT NULL THEN true
           ELSE false
           END AS barreantichute,
       inst_electricite_com.hastelegestion,
       CASE
           WHEN inst_electricite_com.dispositifsecours IS NOT NULL THEN true
           ELSE false
           END AS inverseursource,
       aep_installations.loginmaj,
       aep_installations.datemaj
FROM aep_installations
         LEFT JOIN inst_poste_relevage_gc ON aep_installations.codeinstallation = inst_poste_relevage_gc.codeinstallation
         LEFT JOIN inst_poste_relevage_equipements ON aep_installations.codeinstallation = inst_poste_relevage_equipements.codeinstallation
         LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
         LEFT JOIN inst_securite_personnel equip_barreantichute ON aep_installations.codeinstallation = equip_barreantichute.codeinstallation AND equip_barreantichute.codeprotection = 2
         LEFT JOIN codes_sandre lex_natures_cuves ON inst_poste_relevage_gc.naturecuve = lex_natures_cuves.code AND lex_natures_cuves.champ::text = 'CUVES.MATERIAU'::text
         LEFT JOIN codes_sandre lex_etat ON aep_installations.statut = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
         LEFT JOIN inst_equipements_detail equip_brassage ON aep_installations.codeinstallation = equip_brassage.codeinstallation AND equip_brassage.codeequipement = 0
         LEFT JOIN inst_equipements_detail equip_antibelier ON aep_installations.codeinstallation = equip_antibelier.codeinstallation AND equip_antibelier.codeequipement = 1
         LEFT JOIN inst_equipements_detail equip_traitementh2s ON aep_installations.codeinstallation = equip_traitementh2s.codeinstallation AND equip_traitementh2s.codeequipement = 2
         LEFT JOIN inst_equipements_detail equip_mesuredebimetrique ON aep_installations.codeinstallation = equip_mesuredebimetrique.codeinstallation AND equip_mesuredebimetrique.codeequipement = 3
         LEFT JOIN inst_equipements_detail equip_desodorisation ON aep_installations.codeinstallation = equip_desodorisation.codeinstallation AND equip_desodorisation.codeequipement = 4
         LEFT JOIN inst_equipements_detail equip_ventousechambrevannes ON aep_installations.codeinstallation = equip_ventousechambrevannes.codeinstallation AND equip_ventousechambrevannes.codeequipement = 5
         LEFT JOIN inst_equipements_detail equip_vanneisolement ON aep_installations.codeinstallation = equip_vanneisolement.codeinstallation AND equip_vanneisolement.codeequipement = 6
         LEFT JOIN inst_equipements_detail equip_branchementaep ON aep_installations.codeinstallation = equip_branchementaep.codeinstallation AND equip_branchementaep.codeequipement = 7
         LEFT JOIN inst_equipements_detail equip_groupe_electrogene ON aep_installations.codeinstallation = equip_groupe_electrogene.codeinstallation AND equip_groupe_electrogene.codeequipement = 76
WHERE aep_installations.typeinstallation = 9;
create view v_eau17sig_reservoirs
            (identifiant, fonctionnement, nbcuves, naturecuves, revetementcuve, moderemplissage, presenceturbidimetre,
             presencanalyseurchlore, colonneseche, fontaine, typedetectionniveau, typemesuredebitmetrique,
             presencebypass, presencerobinetflotteur, presenceantiintrusion, hastelegestion, loginmaj, datemaj)
as
SELECT aep_installations.identifiant,
       lex_etat.libelle AS fonctionnement,
       inst_reservoir_gc.nbcuves,
       lex_natures_cuves.libelle AS naturecuves,
       lex_revetements_cuves.libelle AS revetementcuve,
       lex_mode_rempl_cuves.libelle AS moderemplissage,
       CASE
           WHEN equip_turbidimetre.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presenceturbidimetre,
       CASE
           WHEN equip_chlore.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presencanalyseurchlore,
       CASE
           WHEN equip_colonne_seche.codeprotection IS NOT NULL THEN true
           ELSE false
           END AS colonneseche,
       CASE
           WHEN equip_fontaine.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS fontaine,
       lex_detection_niveau.libelle AS typedetectionniveau,
       lex_mesure_debit.libelle AS typemesuredebitmetrique,
       CASE
           WHEN equip_bypass.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presencebypass,
       CASE
           WHEN equip_robinetflotteur.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presencerobinetflotteur,
       CASE
           WHEN equip_antiintrusion.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presenceantiintrusion,
       inst_electricite_com.hastelegestion,
       aep_installations.loginmaj,
       aep_installations.datemaj
FROM aep_installations
         LEFT JOIN inst_reservoir_gc ON aep_installations.codeinstallation = inst_reservoir_gc.codeinstallation
         LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
         LEFT JOIN codes_sandre lex_etat ON aep_installations.statut = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
         LEFT JOIN codes_sandre lex_natures_cuves ON inst_reservoir_gc.naturecuve = lex_natures_cuves.code AND lex_natures_cuves.champ::text = 'CUVES.MATERIAU'::text
         LEFT JOIN codes_sandre lex_revetements_cuves ON inst_reservoir_gc.revetementcuve = lex_revetements_cuves.code AND lex_revetements_cuves.champ::text = 'INSTALLATIONS.REVETEMENTCUVE'::text
         LEFT JOIN codes_sandre lex_mode_rempl_cuves ON inst_reservoir_gc.moderemplissage = lex_mode_rempl_cuves.code AND lex_mode_rempl_cuves.champ::text = 'INSTALLATIONS.MODEREMPLISSAGE'::text
         LEFT JOIN inst_equipements_detail equip_turbidimetre ON aep_installations.codeinstallation = equip_turbidimetre.codeinstallation AND equip_turbidimetre.codeequipement = 0
         LEFT JOIN inst_equipements_detail equip_chlore ON aep_installations.codeinstallation = equip_chlore.codeinstallation AND equip_chlore.codeequipement = 1
         LEFT JOIN inst_equipements_detail equip_fontaine ON aep_installations.codeinstallation = equip_fontaine.codeinstallation AND equip_fontaine.codeequipement = 3
         LEFT JOIN inst_equipements_detail equip_antiintrusion ON aep_installations.codeinstallation = equip_antiintrusion.codeinstallation AND equip_antiintrusion.codeequipement = 39
         LEFT JOIN inst_securite_personnel equip_colonne_seche ON aep_installations.codeinstallation = equip_colonne_seche.codeinstallation AND equip_colonne_seche.codeprotection = 4
         LEFT JOIN inst_reservoir_equipements ON aep_installations.codeinstallation = inst_reservoir_equipements.codeinstallation
         LEFT JOIN codes_sandre lex_detection_niveau ON inst_reservoir_equipements.typedetectionniveau = lex_detection_niveau.code AND lex_detection_niveau.champ::text = 'INSTALLATIONS.TYPEDETECTION'::text
         LEFT JOIN codes_sandre lex_mesure_debit ON inst_reservoir_equipements.mesuredebitmetrique = lex_mesure_debit.code AND lex_mesure_debit.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
         LEFT JOIN inst_equipements_detail equip_bypass ON aep_installations.codeinstallation = equip_bypass.codeinstallation AND equip_bypass.codeequipement = 4
         LEFT JOIN inst_equipements_detail equip_robinetflotteur ON aep_installations.codeinstallation = equip_robinetflotteur.codeinstallation AND equip_robinetflotteur.codeequipement = 5
WHERE aep_installations.typeinstallation = 12;
create view v_eau17sig_stations_pompages
            (identifiant, capacitenominale, capacitehoraire, fonctionnement, batiment, nbgroupes, nomgroupe1,
             debitnominal1, hmt1, nbpompes1, nomgroupe2, debitnominal2, hmt2, nbpompes2, nomgroupe3, debitnominal3,
             hmt3, nbpompes3, presenceturbidimetre, presencanalyseurchlore, presencegroupeelectrogene,
             presenceantiintrusion, hastelegestion, transformateur, demarreur, variateur, typemesuredebitmetrique,
             loginmaj, datemaj)
as
SELECT aep_installations.identifiant,
       inst_st_pompage_aep.capacitenominale,
       inst_st_pompage_aep.capacitehoraire,
       lex_etat.libelle AS fonctionnement,
       inst_st_pompage_aep.batiment,
       CASE
           WHEN groupe1.nomgroupe IS NULL THEN 0
           ELSE 1
           END +
       CASE
           WHEN groupe2.nomgroupe IS NULL THEN 0
           ELSE 1
           END +
       CASE
           WHEN groupe3.nomgroupe IS NULL THEN 0
           ELSE 1
           END AS nbgroupes,
       groupe1.nomgroupe AS nomgroupe1,
       groupe1.debitnominal AS debitnominal1,
       groupe1.hmt AS hmt1,
       groupe1.nbpompes AS nbpompes1,
       groupe2.nomgroupe AS nomgroupe2,
       groupe2.debitnominal AS debitnominal2,
       groupe2.hmt AS hmt2,
       groupe2.nbpompes AS nbpompes2,
       groupe3.nomgroupe AS nomgroupe3,
       groupe3.debitnominal AS debitnominal3,
       groupe3.hmt AS hmt3,
       groupe3.nbpompes AS nbpompes3,
       CASE
           WHEN equip_turbidimetre.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presenceturbidimetre,
       CASE
           WHEN equip_chlore.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presencanalyseurchlore,
       CASE
           WHEN equip_groupe_electrogene.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presencegroupeelectrogene,
       CASE
           WHEN equip_antiintrusion.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS presenceantiintrusion,
       inst_electricite_com.hastelegestion,
       inst_electricite_com.transformateur,
       inst_electricite_com.demarreur,
       inst_electricite_com.variateur,
       lex_mesure_debit.libelle AS typemesuredebitmetrique,
       aep_installations.loginmaj,
       aep_installations.datemaj
FROM aep_installations
         LEFT JOIN inst_st_pompage_aep ON aep_installations.codeinstallation = inst_st_pompage_aep.codeinstallation
         LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
         LEFT JOIN inst_equipements_electro groupe1 ON aep_installations.codeinstallation = groupe1.codeinstallation AND (groupe1.numgroupe = 1 OR groupe1.numgroupe IS NULL)
         LEFT JOIN inst_equipements_electro groupe2 ON aep_installations.codeinstallation = groupe2.codeinstallation AND (groupe2.numgroupe = 1 OR groupe2.numgroupe IS NULL)
         LEFT JOIN inst_equipements_electro groupe3 ON aep_installations.codeinstallation = groupe3.codeinstallation AND (groupe3.numgroupe = 1 OR groupe3.numgroupe IS NULL)
         LEFT JOIN codes_sandre lex_etat ON aep_installations.statut = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
         LEFT JOIN inst_equipements_detail equip_turbidimetre ON aep_installations.codeinstallation = equip_turbidimetre.codeinstallation AND equip_turbidimetre.codeequipement = 0
         LEFT JOIN inst_equipements_detail equip_chlore ON aep_installations.codeinstallation = equip_chlore.codeinstallation AND equip_chlore.codeequipement = 1
         LEFT JOIN inst_equipements_detail equip_groupe_electrogene ON aep_installations.codeinstallation = equip_groupe_electrogene.codeinstallation AND equip_groupe_electrogene.codeequipement = 76
         LEFT JOIN inst_equipements_detail equip_antiintrusion ON aep_installations.codeinstallation = equip_antiintrusion.codeinstallation AND equip_antiintrusion.codeequipement = 39
         LEFT JOIN inst_st_pompage_aep_equipements_divers ON aep_installations.codeinstallation = inst_st_pompage_aep_equipements_divers.codeinstallation
         LEFT JOIN codes_sandre lex_mesure_debit ON inst_st_pompage_aep_equipements_divers.mesuredebitmetrique = lex_mesure_debit.code AND lex_mesure_debit.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
WHERE aep_installations.typeinstallation = 10;
create view v_eau17sig_step
            (identifiant, capacitetraitement, filieretraitementboues, filieretraitementeauxusees,
             filiereeliminationboues, lagunefinition, typerejet, reutilisationeauusee, unitecurage, unitegraisse,
             unitevidange, datearrete, datemiseenroute, fonctionnement, presencebassintampon, volumebassintampon,
             batiment, surfaces, dispositifmesureentree, dispositifmesuresortie, bypassentree, piezometre,
             hastelegestion, hassupervision, transformateur, groupelectrogene, inverseursource, loginmaj, datemaj)
as
SELECT aep_installations.identifiant,
       inst_step.capacitetraitement,
       lex_filieretraitementboues.libelle AS filieretraitementboues,
       lex_filieretraitementeauxusees.libelle AS filieretraitementeauxusees,
       lex_filiereeliminationboues.libelle AS filiereeliminationboues,
       inst_step.lagunefinition,
       lex_typerejet.libelle AS typerejet,
       inst_step.reutilisationeauusee,
       inst_step.unitecurage,
       inst_step.unitegraisse,
       inst_step.unitevidange,
       inst_step.datearrete,
       aep_installations.datemiseenservice AS datemiseenroute,
       lex_etat.libelle AS fonctionnement,
       inst_step_gc.presencebassintampon,
       inst_step_gc.volumebassintampon,
       CASE
           WHEN installations_batiments.nbbatiments = 0 THEN false
           WHEN installations_batiments.nbbatiments IS NULL THEN false
           ELSE true
           END AS batiment,
       installations_batiments.surfaces,
       lex_mesureentree.libelle AS dispositifmesureentree,
       lex_mesuresortie.libelle AS dispositifmesuresortie,
       CASE
           WHEN lex_bypass.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS bypassentree,
       CASE
           WHEN lex_piezo.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS piezometre,
       inst_electricite_com.hastelegestion,
       inst_electricite_com.hassupervision,
       inst_electricite_com.transformateur = ANY (ARRAY['2'::bigint, '3'::bigint, '4'::bigint]) AS transformateur,
       CASE
           WHEN equip_groupe_electrogene.codeequipement IS NOT NULL THEN true
           ELSE false
           END AS groupelectrogene,
       inst_electricite_com.installationarmoire AS inverseursource,
       aep_installations.loginmaj,
       aep_installations.datemaj
FROM aep_installations
         LEFT JOIN inst_step ON aep_installations.codeinstallation = inst_step.codeinstallation
         LEFT JOIN inst_step_gc ON aep_installations.codeinstallation = inst_step_gc.codeinstallation
         LEFT JOIN codes_sandre lex_filieretraitementboues ON inst_step.filieretraitementboues = lex_filieretraitementboues.code AND lex_filieretraitementboues.champ::text = 'INSTALLATIONS.FILIERETRAITEMENTEBOUES'::text
         LEFT JOIN codes_sandre lex_filieretraitementeauxusees ON inst_step.filieretraitementeauxusees = lex_filieretraitementeauxusees.code AND lex_filieretraitementeauxusees.champ::text = 'INSTALLATIONS.FILIERETRAITEMENTEAUXUSEES'::text
         LEFT JOIN codes_sandre lex_typerejet ON inst_step.typerejet = lex_typerejet.code AND lex_typerejet.champ::text = 'INSTALLATIONS.TYPEREJET'::text
         LEFT JOIN codes_sandre lex_filiereeliminationboues ON inst_step.filiereeliminationboues = lex_filiereeliminationboues.code AND lex_filiereeliminationboues.champ::text = 'INSTALLATIONS.FILIEREELIMINATIONBOUES'::text
         LEFT JOIN codes_sandre lex_etat ON aep_installations.codeetat = lex_etat.code AND lex_etat.champ::text = 'CODE_ETAT'::text
         LEFT JOIN ( SELECT inst_batiments.codeinstallation,
                            count(*) AS nbbatiments,
                            sum(inst_batiments.surfacebatiment) AS surfaces
                     FROM inst_batiments
                     WHERE inst_batiments.typebatiment = 4
                     GROUP BY inst_batiments.codeinstallation) installations_batiments ON aep_installations.codeinstallation = installations_batiments.codeinstallation
         LEFT JOIN inst_step_equipements ON aep_installations.codeinstallation = inst_step_equipements.codeinstallation
         LEFT JOIN inst_electricite_com ON aep_installations.codeinstallation = inst_electricite_com.codeinstallation
         LEFT JOIN codes_sandre lex_mesureentree ON inst_step_equipements.mesurevolumeentree = lex_mesureentree.code AND lex_mesureentree.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
         LEFT JOIN codes_sandre lex_mesuresortie ON inst_step_equipements.mesurevolumesortie = lex_mesuresortie.code AND lex_mesuresortie.champ::text = 'INSTALLATIONS.MESUREDEBIT'::text
         LEFT JOIN inst_equipements_detail lex_bypass ON aep_installations.codeinstallation = lex_bypass.codeinstallation AND lex_bypass.codeequipement = 0
         LEFT JOIN inst_equipements_detail lex_piezo ON aep_installations.codeinstallation = lex_piezo.codeinstallation AND lex_piezo.codeequipement = 1
         LEFT JOIN inst_equipements_detail equip_groupe_electrogene ON aep_installations.codeinstallation = lex_bypass.codeinstallation AND lex_bypass.codeequipement = 0
WHERE aep_installations.typeinstallation = 2;


ALTER TABLE aep_installations_types_droits ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE aep_udi ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE aep_udi_compteurs ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE aep_udi_compteurs_types ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE aep_uge_restrictions ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE aep_unites_prod_liens ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_compta_services ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_cultures ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_cultures_familles ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_cultures_ventilations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_declarations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_declarations_intervenants_installations_maj ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_declarations_intervenants_roles_maj ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_declarations_journal ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_declarations_reservoirs_periodes_maj ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_enquetes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_enquetes_parametres ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_exploitations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_exploitations_compta ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_parcelles ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_pars ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_pars_scenarios ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_prel_reservoirs_periodes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_prel_usages_previ ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_regles_scenarios ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_retenues_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_secteurs_secheresse_restrictions ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_tour_eau_plages ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_usages ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_usages_adm_mode_irrigation ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_usages_adm_prof_sol ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_usages_adm_sollicitation ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_usages_adm_type_sol ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE agri_usages_modes_irrigation ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE analyses_selections_droits ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE analyses_seuils_droits ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE analyses_seuils_titres ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE campagnes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques_brutes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques_brutes_suppr ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques_hydro ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques_hydro_suppr ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques_pluvio ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques_pluvio_suppr ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques_pred ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques_pred_hydro ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE chroniques_pred_pluvio ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE cms ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE cms_abonnes ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE cms_categories ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE cms_documents ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE cms_droits ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE cms_envois ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE cms_favoris ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE cms_journal ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE cms_modeles ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE cms_parametres ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE cms_valeurs_stations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE cms_valeurs_stations_evenements ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE codes_sandre ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE codes_sandre_referentiel ALTER COLUMN usermaj TYPE varchar(100) USING usermaj::varchar(100);
ALTER TABLE communes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE contacts ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE contacts_groupes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE enquetes_definitions ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE epci ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements_agri_enquetes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements_agri_exploitations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements_agri_pars ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements_hydro ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements_installations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements_pluvio ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements_qualito ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements_udi ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evenements_unites_prod ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evt_diagnostic_piezo ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evt_interventions ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evt_problemes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE evt_solutions ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE export_tmp ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE hydro_carte_situation ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE hydro_observations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE iaeau_apprentissage ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE inst_equipements_detail ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE inst_visites ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE inst_visites_inst_maj ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE intervenants ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE intervenants_groupes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE lien_inst_autorisations_suivis ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE log_notifications ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE mat_abonnements ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_abonnements_situations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_batteries ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_batteries_situations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_batteries_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_capteurs ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_capteurs_situations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_capteurs_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_centrales ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_centrales_situations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_centrales_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_chroniques ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_divers ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_divers_situations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_divers_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_equipements ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_equipements_situations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_equipements_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_evenements ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_evenements_type ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_modems_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_parametrages ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_parametrages_regles ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_sim ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_sim_abonnements ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_sim_situations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_sim_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_telecom ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_telecom_situations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_telecom_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE mat_types ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE parametres ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE pgsse_activites ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE pgsse_campagnes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE pgsse_definitions ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE pgsse_diagnotics ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE pgsse_documents ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE pgsse_formulaires ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE piezo_carte_situation ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE piezometres ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE piezometres_alertes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE piezometres_modeles ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE piezometres_superpositions ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE piezometres_superpositions ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE pluvio_carte_situation ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE pluviometres ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE pluviometres_modeles ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE qualito_carte_situation ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE qualitometres ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE qualitometres_demandes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE qualitometres_points_operations ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE qualitometres_recherches ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE qualitometres_recherches ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE qualitometres_superpositions ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE referentiels_historique ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE reseaux ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE ressources ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE station_hydro_modeles ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE stations_alertes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE stations_hydro ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE stations_surveillance ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE statistiques_actions ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE statistiques_carto ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE statistiques_cms ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE statistiques_consultations ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE statistiques_documents ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE statistiques_photos ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE statistiques_stations ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE statistiques_usages ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE statistiques_utilisateurs ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE utilisateurs_carto ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs_cultures ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs_favoris ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs_habilitations ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs_listes ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE utilisateurs_listes_droits ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs_messages ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs_messages ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE utilisateurs_messages_dest ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs_messages_doc ALTER COLUMN loginmaj TYPE varchar(100) USING loginmaj::varchar(100);
ALTER TABLE utilisateurs_parametres ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs_stations ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);
ALTER TABLE utilisateurs_vues ALTER COLUMN login TYPE varchar(100) USING login::varchar(100);

# --- !Downs