/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import java.time.ZonedDateTime;
import org.playframework.cachecontrol.Cache;
import org.playframework.cachecontrol.CacheDirectives$OnlyIfCached$;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.ResponseSelectionAction;
import org.playframework.cachecontrol.ResponseSelectionActions;
import org.playframework.cachecontrol.ResponseSelectionCalculator$;
import org.playframework.cachecontrol.StoredResponse;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005i4Aa\u0004\t\u0001/!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003C\u0001\u0011E1\tC\u0004K\u0001\t\u0007I\u0011A&\t\r=\u0003\u0001\u0015!\u0003M\u0011\u0015\u0001\u0006\u0001\"\u0005R\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015Q\u0007\u0001\"\u0005l\u000f\u0015i\u0007\u0003#\u0001o\r\u0015y\u0001\u0003#\u0001p\u0011\u0015\u00193\u0002\"\u0001q\u0011\u001d\t8B1A\u0005\nIDa!_\u0006!\u0002\u0013\u0019(a\u0007*fgB|gn]3TK2,7\r^5p]\u000e\u000bGnY;mCR|'O\u0003\u0002\u0012%\u0005a1-Y2iK\u000e|g\u000e\u001e:pY*\u00111\u0003F\u0001\u000ea2\f\u0017P\u001a:b[\u0016<xN]6\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0019\u0017m\u00195f!\t\u0001\u0013%D\u0001\u0011\u0013\t\u0011\u0003CA\u0003DC\u000eDW-\u0001\u0004=S:LGO\u0010\u000b\u0003K\u0019\u0002\"\u0001\t\u0001\t\u000by\u0011\u0001\u0019A\u0010\u0002\u001dM,G.Z2u%\u0016\u001c\bo\u001c8tKR\u0019\u0011\u0006L\u0019\u0011\u0005\u0001R\u0013BA\u0016\u0011\u0005]\u0011Vm\u001d9p]N,7+\u001a7fGRLwN\\!di&|g\u000eC\u0003.\u0007\u0001\u0007a&A\u0004sKF,Xm\u001d;\u0011\u0005\u0001z\u0013B\u0001\u0019\u0011\u00051\u0019\u0015m\u00195f%\u0016\fX/Z:u\u0011\u0015\u00114\u00011\u00014\u0003%\u0011Xm\u001d9p]N,7\u000fE\u00025y}r!!\u000e\u001e\u000f\u0005YJT\"A\u001c\u000b\u0005a2\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\tY$$A\u0004qC\u000e\\\u0017mZ3\n\u0005ur$aA*fc*\u00111H\u0007\t\u0003A\u0001K!!\u0011\t\u0003\u001dM#xN]3e%\u0016\u001c\bo\u001c8tK\u0006\tRO]5B]\u0012lU\r\u001e5pI6\u000bGo\u00195\u0015\u0007\u0011;\u0005\n\u0005\u0002\u001a\u000b&\u0011aI\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015iC\u00011\u0001/\u0011\u0015IE\u00011\u0001@\u0003!\u0011Xm\u001d9p]N,\u0017AE7pgR\u0014VmY3oi>\u0013H-\u001a:j]\u001e,\u0012\u0001\u0014\t\u0004i5{\u0014B\u0001(?\u0005!y%\u000fZ3sS:<\u0017aE7pgR\u0014VmY3oi>\u0013H-\u001a:j]\u001e\u0004\u0013\u0001\u00064j]\u0012l\u0015\r^2iS:<'+Z:q_:\u001cX\rF\u0002S9v\u00032!G*V\u0013\t!&D\u0001\u0004PaRLwN\u001c\t\u0003-fs!\u0001I,\n\u0005a\u0003\u0012\u0001\u0007*fgB|gn]3TK2,7\r^5p]\u0006\u001bG/[8og&\u0011!l\u0017\u0002\u0011'\u0016dWm\u0019;fIJ+7\u000f]8og\u0016T!\u0001\u0017\t\t\u000b5:\u0001\u0019\u0001\u0018\t\u000bI:\u0001\u0019A\u001a\u0002\rQ|G)\u0019;f)\t\u0001\u0007\u000e\u0005\u0002bM6\t!M\u0003\u0002dI\u0006!A/[7f\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\u001bi{g.\u001a3ECR,G+[7f\u0011\u0015I\u0007\u00021\u0001@\u0003\u0005\u0011\u0018\u0001\u00068p-\u0006d\u0017\u000e\u001a*fgB|gn]3G_VtG\r\u0006\u0002*Y\")Q&\u0003a\u0001]\u0005Y\"+Z:q_:\u001cXmU3mK\u000e$\u0018n\u001c8DC2\u001cW\u000f\\1u_J\u0004\"\u0001I\u0006\u0014\u0005-AB#\u00018\u0002\r1|wmZ3s+\u0005\u0019\bC\u0001;x\u001b\u0005)(B\u0001<\u0015\u0003\u0015\u0019HN\u001a\u001bk\u0013\tAXO\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0001")
public class ResponseSelectionCalculator {
    private final Cache cache;
    private final Ordering<StoredResponse> mostRecentOrdering;

    public ResponseSelectionAction selectResponse(CacheRequest request, Seq<StoredResponse> responses) {
        return (ResponseSelectionAction)this.findMatchingResponse(request, responses).getOrElse((Function0 & Serializable)() -> this.noValidResponseFound(request));
    }

    public boolean uriAndMethodMatch(CacheRequest request, StoredResponse response) {
        return request.uri().equals(response.uri()) && request.method().equals(response.requestMethod());
    }

    public Ordering<StoredResponse> mostRecentOrdering() {
        return this.mostRecentOrdering;
    }

    public Option<ResponseSelectionActions.SelectedResponse> findMatchingResponse(CacheRequest request, Seq<StoredResponse> responses) {
        ResponseSelectionCalculator$.MODULE$.org$playframework$cachecontrol$ResponseSelectionCalculator$$logger().trace("findMatchingResponse: request = " + request + ", responses = " + responses);
        Seq matchingResponses = (Seq)((IterableOps)responses.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.uriAndMethodMatch(request, x$1)))).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.cache.containsMatchingHeaders(request.headers(), r.nominatedHeaders())));
        if (matchingResponses.isEmpty()) {
            return None$.MODULE$;
        }
        StoredResponse mostRecentResponse = (StoredResponse)((IterableOps)matchingResponses.sorted(this.mostRecentOrdering())).head();
        int mostRecentIndex = responses.indexOf((Object)mostRecentResponse);
        return new Some((Object)new ResponseSelectionActions.SelectedResponse(mostRecentResponse, mostRecentIndex));
    }

    public ZonedDateTime toDate(StoredResponse r) {
        return HttpDate$.MODULE$.parse((String)((IterableOps)r.headers().apply((Object)HeaderNames$.MODULE$.Date())).head());
    }

    public ResponseSelectionAction noValidResponseFound(CacheRequest request) {
        ResponseSelectionCalculator$.MODULE$.org$playframework$cachecontrol$ResponseSelectionCalculator$$logger().trace("noValidResponseFound: request = " + request);
        if (request.directives().contains((Object)CacheDirectives$OnlyIfCached$.MODULE$)) {
            return new ResponseSelectionActions.GatewayTimeout("Response not found and request contains only-if-cached");
        }
        return new ResponseSelectionActions.ForwardToOrigin("Valid response not found for request");
    }

    public ResponseSelectionCalculator(Cache cache) {
        this.cache = cache;
        this.mostRecentOrdering = new Ordering<StoredResponse>(this){
            private final /* synthetic */ ResponseSelectionCalculator $outer;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<StoredResponse> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public boolean isReverseOf(Ordering<?> other) {
                return Ordering.isReverseOf$((Ordering)this, other);
            }

            public <U> Ordering<U> on(Function1<U, StoredResponse> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering<StoredResponse> orElse(Ordering<StoredResponse> other) {
                return Ordering.orElse$((Ordering)this, other);
            }

            public <S> Ordering<StoredResponse> orElseBy(Function1<StoredResponse, S> f, Ordering<S> ord) {
                return Ordering.orElseBy$((Ordering)this, f, ord);
            }

            public Ordering.OrderingOps mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(StoredResponse r1, StoredResponse r2) {
                return this.$outer.toDate(r2).compareTo(this.$outer.toDate(r1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }
}

