/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.utils;

import fr.aquasys.utils.EnvsUtil$;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.joda.time.DateTime;
import play.api.http.Status$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class WSUtil$ {
    public static final WSUtil$ MODULE$ = new WSUtil$();
    private static final ExecutionContext context = ExecutionContext$.MODULE$.global();
    private static final String SECRET_KEY_BACK = "iINEdt1XR85VipuOyqEGhXEbdJI-ZQ19k_o9MI0y3eZN2lp9_oeRaYY7Wo24sDqKSX3IM9ASGmdGPmkTd9jo1QTy4b7P9Ze5_jow55FfXMiINEdt1XR85VipRLSOkT6kSpzs2x-jbLDiz9iFVzkd81YKxMgPA7VfZeQUm4n-mOmnWMaVX30zGFU4L3oPBctYKkl4dYfqYWqRNfrgPJVi5DGFjywgxx0ASEiJHtV72paI3fDR2XwlSkyhhmY-ICjCRmsJN4fX1pdoL8a18-aQrvyu4j0Os6dVPYIoPvvY0SAZtWYKHfM15g7A3HD4cVREf9cUsprCRK93wb52fd4df5";

    public ExecutionContext context() {
        return context;
    }

    public Seq<Tuple2<String, String>> getAqua6BoHeaders() {
        String instance = EnvsUtil$.MODULE$.getEnv("APPLICATION_NAME");
        String now = new DateTime().toString("yyyy/MM/dd HH:mm:ss");
        String token = this.calculateAqua6BOToken(instance, now);
        return new .colon.colon((Object)new Tuple2((Object)"Authorization", (Object)"boooolshit"), (List)new .colon.colon((Object)new Tuple2((Object)"token", (Object)token), (List)new .colon.colon((Object)new Tuple2((Object)"Module", (Object)"back"), (List)new .colon.colon((Object)new Tuple2((Object)"Date", (Object)now), (List)new .colon.colon((Object)new Tuple2((Object)"Request-Date", (Object)now), (List)new .colon.colon((Object)new Tuple2((Object)"Instance", (Object)EnvsUtil$.MODULE$.getEnv("APPLICATION_NAME")), (List)new .colon.colon((Object)new Tuple2((Object)"Customer", (Object)EnvsUtil$.MODULE$.getEnv("APPLICATION_NAME")), (List)Nil$.MODULE$)))))));
    }

    public <T> Future<Option<T>> response(Future<WSResponse> future, Reads<T> reads) {
        return future.map((Function1 & Serializable)response -> {
            int n = response.status();
            if (Status$.MODULE$.OK() == n ? true : Status$.MODULE$.PARTIAL_CONTENT() == n) {
                JsResult jsResult = response.json().validate(reads);
                if (jsResult instanceof JsSuccess) {
                    JsSuccess jsSuccess = (JsSuccess)jsResult;
                    return new Some(jsSuccess.value());
                }
                if (jsResult instanceof JsError) {
                    JsError jsError = (JsError)jsResult;
                    Predef$.MODULE$.println((Object)new StringBuilder(27).append("Error while parsing Json : ").append(jsError.toString()).toString());
                    return None$.MODULE$;
                }
                throw new MatchError((Object)jsResult);
            }
            return None$.MODULE$;
        }, this.context());
    }

    public <T> Option<T> responseOpt(Future<WSResponse> future, String url, Reads<T> reads) {
        WSResponse r = (WSResponse)Await$.MODULE$.result(future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).minutes());
        int n = r.status();
        if (Status$.MODULE$.OK() == n ? true : Status$.MODULE$.PARTIAL_CONTENT() == n) {
            JsResult jsResult = r.json().validate(reads);
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                return new Some(jsSuccess.value());
            }
            if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Predef$.MODULE$.println((Object)jsError.toString());
                return None$.MODULE$;
            }
            throw new MatchError((Object)jsResult);
        }
        if (404 == n) {
            return None$.MODULE$;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(40).append("Unexpected response received with url : ").append(url).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(r.status()).append(" : ").append(r.statusText()).toString());
        return None$.MODULE$;
    }

    public <T> Future<Object> responseBool(Future<WSResponse> future) {
        return future.map((Function1 & Serializable)response -> BoxesRunTime.boxToBoolean((boolean)WSUtil$.$anonfun$responseBool$1(response)), this.context());
    }

    public <T> Future<Either<T, Exception>> responseWithReads(Future<WSResponse> future, Reads<T> reads) {
        return future.map((Function1 & Serializable)response -> {
            int n = response.status();
            if (Status$.MODULE$.OK() == n) {
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> response.json());
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    JsValue json = (JsValue)success.value();
                    JsResult jsResult = json.validate(reads);
                    if (jsResult instanceof JsSuccess) {
                        JsSuccess jsSuccess = (JsSuccess)jsResult;
                        return new Left(jsSuccess.value());
                    }
                    if (jsResult instanceof JsError) {
                        JsError jsError = (JsError)jsResult;
                        return new Right((Object)new Exception(jsError.toString()));
                    }
                    throw new MatchError((Object)jsResult);
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    return new Right((Object)new Exception(e));
                }
                throw new MatchError((Object)try_);
            }
            return new Right((Object)new Exception(new StringBuilder(2).append(response.status()).append(": ").append(response.statusText()).toString()));
        }, this.context());
    }

    public <T> Future<Option<T>> simpleGet(String url, Reads<T> reads, WSClient ws) {
        return this.response((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).minutes()).get(), reads);
    }

    public <T> Future<Option<T>> getWithAuth(String url, Reads<T> reads, WSClient ws) {
        return this.response((Future<WSResponse>)ws.url(url).withHttpHeaders(this.getAqua6BoHeaders()).withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).minutes()).get(), reads);
    }

    public <T> Future<Either<T, Exception>> getWithAuthWithReads(String url, Reads<T> reads, WSClient ws) {
        return this.responseWithReads((Future<WSResponse>)ws.url(url).withHttpHeaders(this.getAqua6BoHeaders()).withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).minutes()).get(), reads);
    }

    public String getAsString(String url, WSClient ws) {
        return ((WSResponse)Await$.MODULE$.result((Awaitable)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).minutes()).get(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).minutes())).body();
    }

    public <T> Option<T> postAqua6BO(String url, String body, Reads<T> reads, WSClient ws) {
        return this.responseOpt((Future<WSResponse>)ws.url(url).withHttpHeaders(this.getAqua6BoHeaders()).withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).minutes()).post((Object)body, play.api.libs.ws.package$.MODULE$.writeableOf_String()), url, reads);
    }

    public String calculateAqua6BOToken(String instance, String date) {
        String string;
        try {
            String hashStr;
            String passPhrase = new StringBuilder(2).append(instance).append("_").append(date).append("_").append(this.SECRET_KEY_BACK()).toString();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = messageDigest.digest(passPhrase.getBytes(StandardCharsets.UTF_8));
            BigInteger noHash = new BigInteger(1, hashBytes);
            string = hashStr = noHash.toString(16);
        }
        catch (Exception e) {
            System.out.println(e);
            string = "";
        }
        return string;
    }

    private String SECRET_KEY_BACK() {
        return SECRET_KEY_BACK;
    }

    public static final /* synthetic */ boolean $anonfun$responseBool$1(WSResponse response) {
        int n = response.status();
        return Status$.MODULE$.OK() == n ? true : Status$.MODULE$.PARTIAL_CONTENT() == n;
    }

    private WSUtil$() {
    }
}

