/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import domain.JobReadInput$;
import fr.aquasys.daeau.job.itf.JobExecutionDao;
import fr.aquasys.daeau.job.model.JobExecution$;
import fr.aquasys.daeau.job.model.JobExecutionOutput$;
import fr.aquasys.daeau.job.model.JobFilter$;
import fr.aquasys.daeau.quality.domain.input.UserInput;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import rpc.UserDao;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\u0006\f\u00019A\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006YA\u0006\u0005\tI\u0001\u0011\t\u0011)A\u0006K!AQ\u0006\u0001B\u0001B\u0003-a\u0006C\u00035\u0001\u0011\u0005Q\u0007C\u0004F\u0001\t\u0007I\u0011\u0001$\t\r}\u0003\u0001\u0015!\u0003H\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017\u0011aCS8c\u000bb,7-\u001e;j_:\u001cuN\u001c;s_2dWM\u001d\u0006\u0002\u0019\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g\u0003=QwNY#yK\u000e,H/[8o\t\u0006|\u0007CA\f#\u001b\u0005A\"BA\r\u001b\u0003\rIGO\u001a\u0006\u00037q\t1A[8c\u0015\tib$A\u0003eC\u0016\fWO\u0003\u0002 A\u00059\u0011-];bgf\u001c(\"A\u0011\u0002\u0005\u0019\u0014\u0018BA\u0012\u0019\u0005=QuNY#yK\u000e,H/[8o\t\u0006|\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA!\u001e;jY*\u0011!FH\u0001\te\u0006\u0014'-\u001b;nc&\u0011Af\n\u0002\b\u0019><W\u000b^5m\u0003\u001d)8/\u001a:EC>\u0004\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0004eB\u001c\u0017BA\u001a1\u0005\u001d)6/\u001a:EC>\fa\u0001P5oSRtD#\u0001\u001c\u0015\t]J$h\u000f\t\u0003q\u0001i\u0011a\u0003\u0005\u0006+\u0011\u0001\u001dA\u0006\u0005\u0006I\u0011\u0001\u001d!\n\u0005\u0006[\u0011\u0001\u001dA\f\u0015\u0003\tu\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\r%t'.Z2u\u0015\u0005\u0011\u0015!\u00026bm\u0006D\u0018B\u0001#@\u0005\u0019IeN[3di\u00069!n\u001c2SK\u0006$W#A$\u0011\u0007!\u000b6+D\u0001J\u0015\tQ5*\u0001\u0003kg>t'B\u0001'N\u0003\u0011a\u0017NY:\u000b\u00059{\u0015aA1qS*\t\u0001+\u0001\u0003qY\u0006L\u0018B\u0001*J\u0005\u0015\u0011V-\u00193t!\u0011\u0001BKV-\n\u0005U\u000b\"A\u0002+va2,'\u0007\u0005\u0002\u0011/&\u0011\u0001,\u0005\u0002\u0005\u0019>tw\rE\u0002\u00115rK!aW\t\u0003\r=\u0003H/[8o!\t\u0001R,\u0003\u0002_#\t\u0019\u0011J\u001c;\u0002\u0011)|'MU3bI\u0002\nQbZ3u\u000bb,7-\u001e;j_:\u001cH#\u00022nejd\bCA2k\u001d\t!\u0007\u000e\u0005\u0002f#5\taM\u0003\u0002h\u001b\u00051AH]8pizJ!![\t\u0002\rA\u0013X\rZ3g\u0013\tYGN\u0001\u0004TiJLgn\u001a\u0006\u0003SFAQA\\\u0004A\u0002=\fq!\\3tg\u0006<W\r\u0005\u0002Ia&\u0011\u0011/\u0013\u0002\b\u0015N4\u0016\r\\;f\u0011\u0015\u0019x\u00011\u0001u\u0003\u001dAW-\u00193feN\u0004BaY;co&\u0011a\u000f\u001c\u0002\u0004\u001b\u0006\u0004\bC\u0001\ty\u0013\tI\u0018CA\u0002B]fDQa_\u0004A\u0002\t\fa!\\8ek2,\u0007\"B?\b\u0001\u0004\u0011\u0017\u0001B;tKJ\fAcZ3u%Vtg.\u001b8h\u000bb,7-\u001e;j_:\u001cH#\u00032\u0002\u0002\u0005\r\u0011QAA\u0004\u0011\u0015q\u0007\u00021\u0001p\u0011\u0015\u0019\b\u00021\u0001u\u0011\u0015Y\b\u00021\u0001c\u0011\u0015i\b\u00021\u0001c\u0003]9W\r^!mYF+\u0018\r\\5us\u0016CXmY;uS>t7\u000fF\u0005c\u0003\u001b\ty!!\u0005\u0002\u0014!)a.\u0003a\u0001_\")1/\u0003a\u0001i\")10\u0003a\u0001E\")Q0\u0003a\u0001E\"\u001a\u0001!a\u0006\u0011\u0007y\nI\"C\u0002\u0002\u001c}\u0012\u0011bU5oO2,Go\u001c8")
public class JobExecutionController {
    private final JobExecutionDao jobExecutionDao;
    private final LogUtil logUtil;
    private final UserDao userDao;
    private final Reads<Tuple2<Object, Option<Object>>> jobRead;

    public Reads<Tuple2<Object, Option<Object>>> jobRead() {
        return this.jobRead;
    }

    public String getExecutions(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.jobRead()).fold((Function1 & Serializable)e -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(44).append("Error validate Json to get job executions :\n").append(JsError$.MODULE$.toJson(e).toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long jobId = tuple2._1$mcJ$sp();
            Option limit = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)jobId), (Object)limit);
            long jobId2 = tuple22._1$mcJ$sp();
            Option limit2 = (Option)tuple22._2();
            return Json$.MODULE$.toJson((Object)$this.jobExecutionDao.getByJobId(jobId2, limit2, $this.jobExecutionDao.getByJobId$default$3()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)JobExecution$.MODULE$.reads())).toString();
        });
    }

    public String getRunningExecutions(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(JobReadInput$.MODULE$.defaultReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(33).append("Error validate Json to get job :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)reads -> {
            Tuple2 tuple2 = reads;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long jobId = tuple2._1$mcJ$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)jobId), (Object)user);
            long jobId2 = tuple22._1$mcJ$sp();
            String user2 = (String)tuple22._2();
            UserInput authorization = $this.userDao.get(user2);
            Option option = authorization.error();
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)403), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return Json$.MODULE$.toJson((Object)$this.jobExecutionDao.getRunningExecutions(jobId2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)JobExecution$.MODULE$.reads())).toString();
        });
    }

    public String getAllQualityExecutions(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)JobFilter$.MODULE$.format()).fold((Function1 & Serializable)err -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate Json to get quality execution :\n").append(JsError$.MODULE$.toJson(err).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)jobFilter -> Json$.MODULE$.toJson((Object)$this.jobExecutionDao.getAllQualityExecutions(jobFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)JobExecutionOutput$.MODULE$.format())).toString());
    }

    @Inject
    public JobExecutionController(JobExecutionDao jobExecutionDao, LogUtil logUtil, UserDao userDao) {
        this.jobExecutionDao = jobExecutionDao;
        this.logUtil = logUtil;
        this.userDao = userDao;
        this.jobRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("jobId").read((Reads)Reads$.MODULE$.LongReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("limit").readNullable((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

