/*
 * Decompiled with CFR 0.152.
 */
package job;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import domain.JobParameter$;
import fr.aquasys.daeau.job.itf.JobExecutionDao;
import fr.aquasys.daeau.job.model.Job;
import fr.aquasys.daeau.job.model.JobExecution;
import fr.aquasys.daeau.job.model.JobExecution$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import play.api.libs.json.JsObject;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.ScheduledJobs$;

public final class AbstractFormat$
implements Producer {
    public static final AbstractFormat$ MODULE$ = new AbstractFormat$();
    private static final ExecutionContextExecutor ec;
    private static DateTime lastExecution;
    private static LogUtil logsUtil;
    private static volatile boolean bitmap$0;

    static {
        Producer.$init$((Producer)MODULE$);
        ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newFixedThreadPool(1));
        lastExecution = new DateTime();
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        AbstractFormat$ abstractFormat$ = this;
        synchronized (abstractFormat$) {
            if (!bitmap$0) {
                logsUtil = Producer.logsUtil$((Producer)this);
                bitmap$0 = true;
            }
        }
        return logsUtil;
    }

    public LogUtil logsUtil() {
        if (!bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return logsUtil;
    }

    public ExecutionContextExecutor ec() {
        return ec;
    }

    private DateTime lastExecution() {
        return lastExecution;
    }

    private void lastExecution_$eq(DateTime x$1) {
        lastExecution = x$1;
    }

    public Option<Object> execute(Job job, boolean force, JobExecutionDao jobExecutionDao, LogUtil logutil) {
        while (true) {
            DateTime now = new DateTime();
            if (force || now.getMillis() > this.lastExecution().plusSeconds(2).getMillis()) {
                if (now.getMillis() < this.lastExecution().plusSeconds(2).plusMillis(200).getMillis()) {
                    ScheduledJobs$.MODULE$.resetCron(job, jobExecutionDao, logutil);
                    return None$.MODULE$;
                }
                Seq lastExec = jobExecutionDao.getByJobId(job.id(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                if (lastExec.nonEmpty() && ((JobExecution)lastExec.head()).statusCode().isEmpty()) {
                    Option execId = jobExecutionDao.insert(new JobExecution(0L, now, job.id(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)9))));
                    return execId;
                }
                Option option = job.parameters();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String parameters = (String)some.value();
                    return (Option)Json$.MODULE$.parse(parameters).validate(JobParameter$.MODULE$.reads()).fold((Function1 & Serializable)e -> {
                        logutil.error(new StringBuilder(41).append("Error to parse Json parameters for job ").append(job.id()).append(", ").append(e.toString()).toString(), logutil.error$default$2());
                        return None$.MODULE$;
                    }, (Function1 & Serializable)jobParameter -> {
                        Option option = jobExecutionDao.insert(new JobExecution(0L, now, job.id(), JobExecution$.MODULE$.$lessinit$greater$default$4(), JobExecution$.MODULE$.$lessinit$greater$default$5()));
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            long jobExecutionId = BoxesRunTime.unboxToLong((Object)some.value());
                            MODULE$.lastExecution_$eq(now);
                            logutil.info(new StringBuilder(36).append("launch job ").append(job.id()).append(", execution ").append(jobExecutionId).append(", routingKey ").append(jobParameter.routingKey()).toString(), logutil.info$default$2());
                            MODULE$.sendTopic(jobParameter.routingKey(), ((JsObject)Json$.MODULE$.toJson(jobParameter, JobParameter$.MODULE$.writes()).as((Reads)Reads$.MODULE$.JsObjectReads())).$plus$plus(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jobExecutionId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)jobExecutionId), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)job.login(), Writes$.MODULE$.OptionWrites((Writes)Writes$.MODULE$.StringWrites()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jobId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)job.id()), (Writes)Writes$.MODULE$.LongWrites()))}))).toString());
                            return new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
                        }
                        if (None$.MODULE$.equals(option)) {
                            logutil.error(new StringBuilder(34).append("Error to insert execution for job ").append(job.id()).toString(), logutil.error$default$2());
                            return None$.MODULE$;
                        }
                        throw new MatchError((Object)option);
                    });
                }
                throw new MatchError((Object)option);
            }
            Thread.sleep(3000L);
        }
    }

    public boolean execute$default$2() {
        return false;
    }

    private AbstractFormat$() {
    }
}

