/*
 * Decompiled with CFR 0.152.
 */
package supervision;

import anorm.package;
import fr.aquasys.daeau.job.itf.JobDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.FileUtil$;
import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.joda.time.ReadablePartial;
import play.api.db.Database;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;
import supervision.model.FullDirectory;
import supervision.model.JobExecutionSupervision;
import supervision.model.JobExecutionSupervision$;
import supervision.model.JobSupervisionResult;
import supervision.model.JobSupervisionResult$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001B\t\u0013\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006Y!\b\u0005\tS\u0001\u0011\t\u0011)A\u0006U!AA\u0007\u0001B\u0001B\u0003-Q\u0007C\u0003@\u0001\u0011\u0005\u0001\tC\u0004Q\u0001\t\u0007I\u0011A)\t\ru\u0003\u0001\u0015!\u0003S\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u00151\b\u0001\"\u0001x\u0011%\t\u0019\u0002\u0001b\u0001\n\u0003\t)\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\f\u0011%\t9\u0003\u0001b\u0001\n\u0003\t)\u0002\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\f\u0011%\tY\u0003\u0001b\u0001\n\u0003\t)\u0002\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\f\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u0016\u0001\t\u0003\t9F\u0001\rK_\n\u001cV\u000f]3sm&\u001c\u0018n\u001c8D_:$(o\u001c7mKJT\u0011aE\u0001\fgV\u0004XM\u001d<jg&|gn\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-A\u0004m_\u001e,F/\u001b7\u0011\u0005y9S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001B;uS2T!AI\u0012\u0002\u0011I\f'MY5u[FT!\u0001J\u0013\u0002\u000f\u0005\fX/Y:zg*\ta%\u0001\u0002ge&\u0011\u0001f\b\u0002\b\u0019><W\u000b^5m\u0003\u0019QuN\u0019#b_B\u00111FM\u0007\u0002Y)\u0011QFL\u0001\u0004SR4'BA\u00181\u0003\rQwN\u0019\u0006\u0003c\r\nQ\u0001Z1fCVL!a\r\u0017\u0003\r){'\rR1p\u0003!!\u0017\r^1cCN,\u0007C\u0001\u001c>\u001b\u00059$B\u0001\u001d:\u0003\t!'M\u0003\u0002;w\u0005\u0019\u0011\r]5\u000b\u0003q\nA\u0001\u001d7bs&\u0011ah\u000e\u0002\t\t\u0006$\u0018MY1tK\u00061A(\u001b8jiz\"\u0012!\u0011\u000b\u0005\u0005\u0012+e\t\u0005\u0002D\u00015\t!\u0003C\u0003\u001d\t\u0001\u000fQ\u0004C\u0003*\t\u0001\u000f!\u0006C\u00035\t\u0001\u000fQ\u0007\u000b\u0002\u0005\u0011B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0007S:TWm\u0019;\u000b\u00035\u000bQA[1wCbL!a\u0014&\u0003\r%s'.Z2u\u0003\u001d1G\u000f\u001d*p_R,\u0012A\u0015\t\u0003'js!\u0001\u0016-\u0011\u0005UCR\"\u0001,\u000b\u0005]#\u0012A\u0002\u001fs_>$h(\u0003\u0002Z1\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI\u0006$\u0001\u0005giB\u0014vn\u001c;!\u000399W\r^*va\u0016\u0014h/[:j_:$RA\u00151keRDQ!Y\u0004A\u0002\t\fq!\\3tg\u0006<W\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006!!n]8o\u0015\t9\u0017(\u0001\u0003mS\n\u001c\u0018BA5e\u0005\u001dQ5OV1mk\u0016DQa[\u0004A\u00021\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003T[J{\u0017B\u00018]\u0005\ri\u0015\r\u001d\t\u0003/AL!!\u001d\r\u0003\u0007\u0005s\u0017\u0010C\u0003t\u000f\u0001\u0007!+\u0001\u0004n_\u0012,H.\u001a\u0005\u0006k\u001e\u0001\rAU\u0001\u0005kN,'/\u0001\bdQ\u0016\u001c7\u000eR5sK\u000e$xN]=\u0015\u0007a\fy\u0001\u0005\u0003z}\u0006\raB\u0001>}\u001d\t)60C\u0001\u001a\u0013\ti\b$A\u0004qC\u000e\\\u0017mZ3\n\u0007}\f\tAA\u0002TKFT!! \r\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003\u0013\u0003\u0015iw\u000eZ3m\u0013\u0011\ti!a\u0002\u0003\u001b\u0019+H\u000e\u001c#je\u0016\u001cGo\u001c:z\u0011\u0019\t\t\u0002\u0003a\u0001%\u00069A-\u001b:QCRD\u0017\u0001\u00059biR,'O\\(oK\nKx+Z3l+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\u0005RBAA\u000e\u0015\u0011\ti\"a\b\u0002\u00115\fGo\u00195j]\u001eT!\u0001\t\r\n\t\u0005\r\u00121\u0004\u0002\u0006%\u0016<W\r_\u0001\u0012a\u0006$H/\u001a:o\u001f:,')_,fK.\u0004\u0013a\u00049biR,'O\\(oK\nKH)Y=\u0002!A\fG\u000f^3s]>sWMQ=ECf\u0004\u0013a\u00049biR,'O\\'vYRL\u0007\u000f\\3\u0002!A\fG\u000f^3s]6+H\u000e^5qY\u0016\u0004\u0013AE2iK\u000e\\G*Y:u\u000bb,7-\u001e;j_:$b!a\r\u0002:\u0005u\u0002cA\f\u00026%\u0019\u0011q\u0007\r\u0003\u000f\t{w\u000e\\3b]\"1\u00111H\bA\u0002I\u000bAa\u0019:p]\"9\u0011qH\bA\u0002\u0005\u0005\u0013\u0001\u00037bgR,\u00050Z2\u0011\t\u0005\r\u0013\u0011K\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005!A/[7f\u0015\u0011\tY%!\u0014\u0002\t)|G-\u0019\u0006\u0003\u0003\u001f\n1a\u001c:h\u0013\u0011\t\u0019&!\u0012\u0003\u0011\u0011\u000bG/\u001a+j[\u0016\f\u0001cZ3u\u001b>t\u0017\u000e^8sK\u0012TuNY:\u0015\u0005\u0005e\u0003\u0003B=\u007f\u00037\u0002B!!\u0002\u0002^%!\u0011qLA\u0004\u0005]QuNY#yK\u000e,H/[8o'V\u0004XM\u001d<jg&|g\u000e")
public class JobSupervisionController {
    private final JobDao JobDao;
    private final Database database;
    private final String ftpRoot;
    private final Regex patternOneByWeek;
    private final Regex patternOneByDay;
    private final Regex patternMultiple;

    public String ftpRoot() {
        return this.ftpRoot;
    }

    public String getSupervision(JsValue message, Map<String, Object> headers, String module, String user) {
        Seq<JobExecutionSupervision> jobs = this.getMonitoredJobs();
        Seq jobsWithCron = (Seq)((IterableOps)jobs.map((Function1 & Serializable)j -> {
            if (j.cron().isDefined()) {
                return j;
            }
            Option x$1 = j.cron().orElse((Function0 & Serializable)() -> $this.JobDao.find(BoxesRunTime.unboxToLong((Object)$this.JobDao.getChain((long)j.id()).head())).flatMap((Function1 & Serializable)x$1 -> x$1.cron()));
            int x$2 = j.copy$default$1();
            Option<String> x$3 = j.copy$default$2();
            Option<String> x$4 = j.copy$default$3();
            DateTime x$5 = j.copy$default$5();
            Option<Object> x$6 = j.copy$default$6();
            Option<Object> x$7 = j.copy$default$7();
            return j.copy(x$2, x$3, x$4, (Option<String>)x$1, x$5, x$6, x$7);
        })).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JobSupervisionController.$anonfun$getSupervision$4(x$2)));
        Seq notLaunched = (Seq)jobsWithCron.filter((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)JobSupervisionController.$anonfun$getSupervision$5(this, j)));
        Seq tooLong = (Seq)jobsWithCron.filter((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)JobSupervisionController.$anonfun$getSupervision$8(j)));
        JobSupervisionResult res = new JobSupervisionResult(jobsWithCron.length(), (Seq<JobExecutionSupervision>)notLaunched, (Seq<JobExecutionSupervision>)((Seq)jobsWithCron.filter((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)JobSupervisionController.$anonfun$getSupervision$9(j)))), (Seq<JobExecutionSupervision>)tooLong, (Seq<FullDirectory>)((Seq)((IterableOps)this.checkDirectory(FileUtil$.MODULE$.toPath(new StringBuilder(5).append(this.ftpRoot()).append("/DATA").toString())).$plus$plus(this.checkDirectory(FileUtil$.MODULE$.toPath(new StringBuilder(6).append(this.ftpRoot()).append("/_DATA").toString())))).$plus$plus(this.checkDirectory(FileUtil$.MODULE$.toPath(new StringBuilder(7).append(this.ftpRoot()).append("/EXPORT").toString())))));
        return Json$.MODULE$.toJson((Object)res, JobSupervisionResult$.MODULE$.format()).toString();
    }

    public Seq<FullDirectory> checkDirectory(String dirPath) {
        Tuple2 tuple2 = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])new File(dirPath).listFiles())).partition((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDirectory()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq dirs = (Seq)tuple2._1();
        Seq files = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dirs, (Object)files);
        Seq dirs2 = (Seq)tuple22._1();
        Seq files2 = (Seq)tuple22._2();
        .colon.colon thisDir = files2.length() > 10000 ? new .colon.colon((Object)new FullDirectory(dirPath.replace(this.ftpRoot(), ""), files2.length()), (List)Nil$.MODULE$) : (Seq)Nil$.MODULE$;
        return (Seq)thisDir.$plus$plus((IterableOnce)dirs2.flatMap((Function1 & Serializable)dir -> this.checkDirectory(dir.getAbsolutePath())));
    }

    public Regex patternOneByWeek() {
        return this.patternOneByWeek;
    }

    public Regex patternOneByDay() {
        return this.patternOneByDay;
    }

    public Regex patternMultiple() {
        return this.patternMultiple;
    }

    public boolean checkLastExecution(String cron, DateTime lastExec) {
        Option option;
        Option option2;
        Option option3;
        String string = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(cron), 2)), 2);
        if (string != null && !(option3 = this.patternOneByWeek().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(3) == 0) {
            String minute = (String)((LinearSeqOps)option3.get()).apply(0);
            String hour = (String)((LinearSeqOps)option3.get()).apply(1);
            String day = (String)((LinearSeqOps)option3.get()).apply(2);
            DateTime dayOfThisWeek = new DateTime().withDayOfWeek(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(day.replace("0", "7"))));
            DateTime shouldExecAt = (dayOfThisWeek.getMillis() > new DateTime().getMillis() ? dayOfThisWeek.minusDays(7) : dayOfThisWeek).withTime(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(hour)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(minute)), 0, 0);
            return lastExec.getMillis() >= shouldExecAt.getMillis();
        }
        if (string != null && !(option2 = this.patternOneByDay().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0) {
            String minute = (String)((LinearSeqOps)option2.get()).apply(0);
            String hour = (String)((LinearSeqOps)option2.get()).apply(1);
            DateTime newHour = new DateTime().withTime(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(hour)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(minute)), 0, 0);
            DateTime shouldExecAt = newHour.getMillis() > new DateTime().getMillis() ? newHour.minusDays(1) : newHour;
            return lastExec.getMillis() >= shouldExecAt.getMillis();
        }
        if (string != null && !(option = this.patternMultiple().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String byMin = (String)((LinearSeqOps)option.get()).apply(0);
            DateTime shouldExecAt = new DateTime().withMinuteOfHour(new DateTime().getMinuteOfHour() - new DateTime().getMinuteOfHour() % StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(byMin))).withSecondOfMinute(0).withMillisOfSecond(0);
            return lastExec.getMillis() >= shouldExecAt.getMillis();
        }
        return true;
    }

    public Seq<JobExecutionSupervision> getMonitoredJobs() {
        return (Seq)this.database.withConnection((Function1 & Serializable)c -> (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n             select j.id, j.nom, j.job_type, j.planification, execs.exec, execs.codestatut, execs.duration from jobs j\n                left join (\n                select id, execution_timestamp exec, job_id, duration, codestatut from jobs_execution where id in (\n                    select max(id) id from jobs_execution group by job_id\n                )\n            ) execs on execs.job_id = j.id\n                where exec is not null and (planification notnull or j.id in (select jobnextid from jobs where jobnextid notnull));\n             "}))), (Seq)Nil$.MODULE$).as(JobExecutionSupervision$.MODULE$.parser().$times(), c));
    }

    public static final /* synthetic */ boolean $anonfun$getSupervision$4(JobExecutionSupervision x$2) {
        return x$2.cron().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getSupervision$5(JobSupervisionController $this, JobExecutionSupervision j) {
        Option option = j.cron().orElse((Function0 & Serializable)() -> $this.JobDao.find(BoxesRunTime.unboxToLong((Object)$this.JobDao.getChain((long)j.id()).head())).flatMap((Function1 & Serializable)x$3 -> x$3.cron()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String cron = (String)some.value();
            return !$this.checkLastExecution(cron, j.lastExecution());
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$getSupervision$8(JobExecutionSupervision j) {
        if (j.status().isEmpty()) {
            int duration = Hours.hoursBetween((ReadablePartial)j.lastExecution().toLocalDateTime(), (ReadablePartial)new DateTime().toLocalDateTime()).getHours();
            return duration >= 2;
        }
        if (j.duration().isDefined()) {
            return BoxesRunTime.unboxToLong((Object)j.duration().get()) > 7200L;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getSupervision$9(JobExecutionSupervision j) {
        return package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 5, 6})).contains(j.status().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
    }

    @Inject
    public JobSupervisionController(LogUtil logUtil, JobDao JobDao2, Database database) {
        this.JobDao = JobDao2;
        this.database = database;
        this.ftpRoot = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"UPLOAD_DIRECTORY", (Function0 & Serializable)() -> {
            throw new Exception("UPLOAD_DIRECTORY is not in env");
        });
        this.patternOneByWeek = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+) (\\d+) \\* \\* (\\d+)"));
        this.patternOneByDay = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+) (\\d+) \\* \\* \\*"));
        this.patternMultiple = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\*\\/(\\d+) \\* \\* \\* \\*"));
    }
}

