/*
 * Decompiled with CFR 0.152.
 */
package play.filters.gzip;

import com.typesafe.config.ConfigMemorySize;
import java.io.Serializable;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.http.MediaType;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.filters.gzip.GzipFilterConfig;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple5;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class GzipFilterConfig$
implements Serializable {
    public static final GzipFilterConfig$ MODULE$ = new GzipFilterConfig$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());

    public int $lessinit$greater$default$1() {
        return 8192;
    }

    public int $lessinit$greater$default$2() {
        return 102400;
    }

    public int $lessinit$greater$default$3() {
        return 0;
    }

    public Function2<RequestHeader, Result, Object> $lessinit$greater$default$4() {
        return (Function2 & Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)GzipFilterConfig$.$anonfun$$lessinit$greater$default$4$2(x$7, x$8));
    }

    public int $lessinit$greater$default$5() {
        return -1;
    }

    private Logger logger() {
        return logger;
    }

    public GzipFilterConfig fromConfiguration(Configuration conf) {
        Configuration config = (Configuration)conf.get("play.filters.gzip", ConfigLoader$.MODULE$.configurationLoader());
        Seq whiteList = GzipFilterConfig$.parseConfigMediaTypes$1(config, "contentType.whiteList");
        Seq blackList = GzipFilterConfig$.parseConfigMediaTypes$1(config, "contentType.blackList");
        return new GzipFilterConfig((int)((ConfigMemorySize)config.get("bufferSize", ConfigLoader$.MODULE$.bytesLoader())).toBytes(), (int)((ConfigMemorySize)config.get("chunkedThreshold", ConfigLoader$.MODULE$.bytesLoader())).toBytes(), (int)((ConfigMemorySize)config.get("threshold", ConfigLoader$.MODULE$.bytesLoader())).toBytes(), (Function2<RequestHeader, Result, Object>)(Function2 & Serializable)(x$11, res) -> BoxesRunTime.boxToBoolean((boolean)GzipFilterConfig$.$anonfun$fromConfiguration$6(whiteList, blackList, x$11, res)), BoxesRunTime.unboxToInt((Object)config.get("compressionLevel", ConfigLoader$.MODULE$.intLoader())));
    }

    public GzipFilterConfig apply(int bufferSize, int chunkedThreshold, int threshold, Function2<RequestHeader, Result, Object> shouldGzip, int compressionLevel) {
        return new GzipFilterConfig(bufferSize, chunkedThreshold, threshold, shouldGzip, compressionLevel);
    }

    public int apply$default$1() {
        return 8192;
    }

    public int apply$default$2() {
        return 102400;
    }

    public int apply$default$3() {
        return 0;
    }

    public Function2<RequestHeader, Result, Object> apply$default$4() {
        return (Function2 & Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)GzipFilterConfig$.$anonfun$apply$default$4$1(x$7, x$8));
    }

    public int apply$default$5() {
        return -1;
    }

    public Option<Tuple5<Object, Object, Object, Function2<RequestHeader, Result, Object>, Object>> unapply(GzipFilterConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)x$0.bufferSize()), (Object)BoxesRunTime.boxToInteger((int)x$0.chunkedThreshold()), (Object)BoxesRunTime.boxToInteger((int)x$0.threshold()), x$0.shouldGzip(), (Object)BoxesRunTime.boxToInteger((int)x$0.compressionLevel())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GzipFilterConfig$.class);
    }

    public static final /* synthetic */ boolean $anonfun$$lessinit$greater$default$4$2(RequestHeader x$7, Result x$8) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$fromConfiguration$4(MediaType x0$2) {
        MediaType mediaType = x0$2;
        if (mediaType != null) {
            String string = mediaType.mediaType();
            String string2 = mediaType.mediaSubType();
            if ("*".equals(string) && "*".equals(string2)) {
                MODULE$.logger().warn((Function0 & Serializable)() -> "Wildcard MediaTypes don't make much sense in a whitelist (too permissive) or blacklist (too restrictive), and are not recommended. ", MarkerContext$.MODULE$.NoMarker());
                return;
            }
        }
    }

    private static final Seq parseConfigMediaTypes$1(Configuration config, String key) {
        Seq mediaTypes = (Seq)((IterableOps)config.get(key, ConfigLoader$.MODULE$.seqStringLoader())).flatMap((Function1 & Serializable)x0$1 -> {
            Option option;
            String string = x0$1;
            if ("*".equals(string)) {
                MODULE$.logger().warn((Function0 & Serializable)() -> "Support for '*' wildcards may be removed in future versions of play, as they don't conform to the specification for MediaType strings. Use */* instead.", MarkerContext$.MODULE$.NoMarker());
                return new Some((Object)new MediaType("*", "*", (Seq)package$.MODULE$.Seq().empty()));
            }
            if (string != null && !(option = MediaType.parse$.MODULE$.unapply(string)).isEmpty()) {
                MediaType mediaType = (MediaType)option.get();
                return new Some((Object)mediaType);
            }
            MODULE$.logger().error((Function0 & Serializable)() -> "Failed to parse the configured MediaType mask '" + string + "'", MarkerContext$.MODULE$.NoMarker());
            return None$.MODULE$;
        });
        mediaTypes.foreach((Function1 & Serializable)x0$2 -> {
            GzipFilterConfig$.$anonfun$fromConfiguration$4(x0$2);
            return BoxedUnit.UNIT;
        });
        return mediaTypes;
    }

    private static final boolean capturedByMask$1(String value, String mask) {
        String string = mask;
        String string2 = "*";
        return !(string == null ? string2 != null : !string.equals(string2)) || value.equalsIgnoreCase(mask);
    }

    private static final boolean matches$1(MediaType outgoing, MediaType mask) {
        return GzipFilterConfig$.capturedByMask$1(outgoing.mediaType(), mask.mediaType()) && GzipFilterConfig$.capturedByMask$1(outgoing.mediaSubType(), mask.mediaSubType());
    }

    public static final /* synthetic */ boolean $anonfun$fromConfiguration$7(MediaType outgoing$1, MediaType mask) {
        return !GzipFilterConfig$.matches$1(outgoing$1, mask);
    }

    public static final /* synthetic */ boolean $anonfun$fromConfiguration$6(Seq whiteList$1, Seq blackList$1, RequestHeader x$11, Result res) {
        Option option;
        Some some;
        String string;
        if (whiteList$1.isEmpty()) {
            Option option2;
            Some some2;
            String string2;
            if (blackList$1.isEmpty()) {
                return true;
            }
            Option option3 = res.body().contentType();
            if (option3 instanceof Some && (string2 = (String)(some2 = (Some)option3).value()) != null && !(option2 = MediaType.parse$.MODULE$.unapply(string2)).isEmpty()) {
                MediaType outgoing = (MediaType)option2.get();
                return blackList$1.forall((Function1 & Serializable)mask -> BoxesRunTime.boxToBoolean((boolean)GzipFilterConfig$.$anonfun$fromConfiguration$7(outgoing, mask)));
            }
            return true;
        }
        Option option4 = res.body().contentType();
        if (option4 instanceof Some && (string = (String)(some = (Some)option4).value()) != null && !(option = MediaType.parse$.MODULE$.unapply(string)).isEmpty()) {
            MediaType outgoing = (MediaType)option.get();
            return whiteList$1.exists((Function1 & Serializable)mask -> BoxesRunTime.boxToBoolean((boolean)GzipFilterConfig$.matches$1(outgoing, mask)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$4$1(RequestHeader x$7, Result x$8) {
        return true;
    }

    private GzipFilterConfig$() {
    }
}

