/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import dao.itf.LayerDao;
import domain.Layer;
import domain.Layer$;
import domain.LayerType$;
import domain.ThemeLayer;
import domain.ThemeLayer$;
import domain.input.ThemeInput$;
import domain.kml.KmlStationsCity;
import domain.kml.KmlStationsCity$;
import domain.kml.WatershedStation;
import domain.kml.WatershedStation$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import utils.LayersUtils$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001\u0002\f\u0018\u0001iA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)Q\b\u0001C\u0001}!9A\n\u0001b\u0001\n\u0003i\u0005B\u00023\u0001A\u0003%a\nC\u0004f\u0001\t\u0007I\u0011A'\t\r\u0019\u0004\u0001\u0015!\u0003O\u0011\u001d9\u0007A1A\u0005\u0002!Da!\u001c\u0001!\u0002\u0013I\u0007\"\u00028\u0001\t\u0003y\u0007bBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!!\u001f\u0001\t\u0003\tYHA\bMCf,'oQ8oiJ|G\u000e\\3s\u0015\u0005A\u0012aC2p]R\u0014x\u000e\u001c7feN\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012,\u001b\u0005\u0019#B\u0001\u0013&\u0003\r\t\u0007/\u001b\u0006\u0003M\u001d\n\u0001B]1cE&$X.\u001d\u0006\u0003Q%\nq!Y9vCNL8OC\u0001+\u0003\t1'/\u0003\u0002-G\tA\u0001K]8ek\u000e,'/\u0001\u0005mCf,'\u000fR1p!\tyC'D\u00011\u0015\t\t$'A\u0002ji\u001aT\u0011aM\u0001\u0004I\u0006|\u0017BA\u001b1\u0005!a\u0015-_3s\t\u0006|\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0015\nA!\u001e;jY&\u0011A(\u000f\u0002\b\u0019><W\u000b^5m\u0003\u0019a\u0014N\\5u}Q\u0019q(\u0011\"\u0011\u0005\u0001\u0003Q\"A\f\t\u000b5\u001a\u0001\u0019\u0001\u0018\t\u000bY\u001a\u0001\u0019A\u001c)\u0005\r!\u0005CA#K\u001b\u00051%BA$I\u0003\u0019IgN[3di*\t\u0011*A\u0003kCZ\f\u00070\u0003\u0002L\r\n1\u0011J\u001c6fGR\f\u0001bY8eKJ+\u0017\rZ\u000b\u0002\u001dB\u0019qjV-\u000e\u0003AS!!\u0015*\u0002\t)\u001cxN\u001c\u0006\u0003'R\u000bA\u0001\\5cg*\u0011A%\u0016\u0006\u0002-\u0006!\u0001\u000f\\1z\u0013\tA\u0006KA\u0003SK\u0006$7\u000f\u0005\u0002[C:\u00111l\u0018\t\u00039vi\u0011!\u0018\u0006\u0003=f\ta\u0001\u0010:p_Rt\u0014B\u00011\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001l\u0012!C2pI\u0016\u0014V-\u00193!\u0003=\u0019H/\u0019;j_:\u001cu\u000eZ3SK\u0006$\u0017\u0001E:uCRLwN\\\"pI\u0016\u0014V-\u00193!\u00031!\u0018\u0010]3D_\u0012,'+Z1e+\u0005I\u0007cA(XUB!Ad[-Z\u0013\taWD\u0001\u0004UkBdWMM\u0001\u000eif\u0004XmQ8eKJ+\u0017\r\u001a\u0011\u0002\u0007\u001d,G\u000fF\u0003ZaVlx\u0010C\u0003r\u0015\u0001\u0007!/A\u0004nKN\u001c\u0018mZ3\u0011\u0005=\u001b\u0018B\u0001;Q\u0005\u001dQ5OV1mk\u0016DQA\u001e\u0006A\u0002]\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003[qfS\u0018BA=d\u0005\ri\u0015\r\u001d\t\u00039mL!\u0001`\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003\u007f\u0015\u0001\u0007\u0011,\u0001\u0004n_\u0012,H.\u001a\u0005\u0007\u0003\u0003Q\u0001\u0019A-\u0002\tU\u001cXM]\u0001\u0014S:\u001cXM\u001d;EK\u001a\fW\u000f\u001c;MCf,'o\u001d\u000b\u0003\u0003\u000f\u00012\u0001HA\u0005\u0013\r\tY!\b\u0002\u0005+:LG/\u0001\u0007hKRd\u0015-_3s\u0005fLE\rF\u0005Z\u0003#\t\u0019\"!\u0006\u0002\u0018!)\u0011\u000f\u0004a\u0001e\")a\u000f\u0004a\u0001o\")a\u0010\u0004a\u00013\"1\u0011\u0011\u0001\u0007A\u0002e\u000b\u0001cZ3u\u0019\u0006LXM]:CsRCW-\\3\u0015\u0013e\u000bi\"a\b\u0002\"\u0005\r\u0002\"B9\u000e\u0001\u0004\u0011\b\"\u0002<\u000e\u0001\u00049\b\"\u0002@\u000e\u0001\u0004I\u0006BBA\u0001\u001b\u0001\u0007\u0011,A\u0007hKRd\u0015-_3s\u0005f,&\u000f\u001c\u000b\n3\u0006%\u00121FA\u0017\u0003_AQ!\u001d\bA\u0002IDQA\u001e\bA\u0002]DQA \bA\u0002eCa!!\u0001\u000f\u0001\u0004I\u0016AD4fi2\u000b\u00170\u001a:Cs:\u000bW.\u001a\u000b\n3\u0006U\u0012qGA\u001d\u0003wAQ!]\bA\u0002IDQA^\bA\u0002]DQA`\bA\u0002eCa!!\u0001\u0010\u0001\u0004I\u0016aD4fi2\u000b\u00170\u001a:Cs2\u000b\u00170\u001a:\u0015\u0013e\u000b\t%a\u0011\u0002F\u0005\u001d\u0003\"B9\u0011\u0001\u0004\u0011\b\"\u0002<\u0011\u0001\u00049\b\"\u0002@\u0011\u0001\u0004I\u0006BBA\u0001!\u0001\u0007\u0011,\u0001\bhKRd\u0015-_3s\u0005f$\u0016\u0010]3\u0015\u0013e\u000bi%a\u0014\u0002R\u0005M\u0003\"B9\u0012\u0001\u0004\u0011\b\"\u0002<\u0012\u0001\u00049\b\"\u0002@\u0012\u0001\u0004I\u0006BBA\u0001#\u0001\u0007\u0011,A\fhKR\\U\u000e\\!oIN#\u0018\r^5p]N\u0014\u0015pQ5usRI\u0011,!\u0017\u0002\\\u0005u\u0013q\f\u0005\u0006cJ\u0001\rA\u001d\u0005\u0006mJ\u0001\ra\u001e\u0005\u0006}J\u0001\r!\u0017\u0005\u0007\u0003\u0003\u0011\u0002\u0019A-\u0002/\u001d,GoS7m\u0003:$7\u000b^1uS>t7OQ=EKB$H#C-\u0002f\u0005\u001d\u0014\u0011NA6\u0011\u0015\t8\u00031\u0001s\u0011\u001518\u00031\u0001x\u0011\u0015q8\u00031\u0001Z\u0011\u0019\t\ta\u0005a\u00013\u0006ar-\u001a;L[2\fe\u000eZ*uCRLwN\\:Cs^\u000bG/\u001a:tQ\u0016$G#C-\u0002r\u0005M\u0014QOA<\u0011\u0015\tH\u00031\u0001s\u0011\u00151H\u00031\u0001x\u0011\u0015qH\u00031\u0001Z\u0011\u0019\t\t\u0001\u0006a\u00013\u0006Qr-\u001a;L[2\fe\u000eZ*uCRLwN\\:CsN#\u0018\r^5p]RI\u0011,! \u0002\u0000\u0005\u0005\u00151\u0011\u0005\u0006cV\u0001\rA\u001d\u0005\u0006mV\u0001\ra\u001e\u0005\u0006}V\u0001\r!\u0017\u0005\u0007\u0003\u0003)\u0002\u0019A-)\u0007\u0001\t9\tE\u0002F\u0003\u0013K1!a#G\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class LayerController
implements Producer {
    private final LayerDao layerDao;
    private final LogUtil logUtil;
    private final Reads<String> codeRead;
    private final Reads<String> stationCodeRead;
    private final Reads<Tuple2<String, String>> typeCodeRead;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        LayerController layerController = this;
        synchronized (layerController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public Reads<String> codeRead() {
        return this.codeRead;
    }

    public Reads<String> stationCodeRead() {
        return this.stationCodeRead;
    }

    public Reads<Tuple2<String, String>> typeCodeRead() {
        return this.typeCodeRead;
    }

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.layerDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Layer$.MODULE$.layerWrites())).toString();
    }

    public void insertDefaultLayers() {
        this.logUtil.info("Creating default layers", this.logUtil.info$default$2());
        LayersUtils$.MODULE$.LAYERS().foreach((Function1 & Serializable)l -> BoxesRunTime.boxToInteger((int)this.layerDao.create(l)));
        this.logUtil.info("Default layers created", this.logUtil.info$default$2());
    }

    public String getLayerById(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Layer$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(17).append("Can't get layer:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> LayerController.$anonfun$getLayerById$2(this, BoxesRunTime.unboxToInt((Object)read)));
    }

    public String getLayersByTheme(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ThemeInput$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(18).append("Can't get layers:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> LayerController.$anonfun$getLayersByTheme$2(this, BoxesRunTime.unboxToInt((Object)read)));
    }

    public String getLayerByUrl(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Layer$.MODULE$.urlRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(17).append("Can't get layer:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> Json$.MODULE$.toJson($this.layerDao.getByUrl((String)read), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Layer$.MODULE$.layerWrites())).toString());
    }

    public String getLayerByName(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Layer$.MODULE$.nameRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(17).append("Can't get layer:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> Json$.MODULE$.toJson($this.layerDao.getByName((String)read), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Layer$.MODULE$.layerWrites())).toString());
    }

    public String getLayerByLayer(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Layer$.MODULE$.codeLayerRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(17).append("Can't get layer:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> Json$.MODULE$.toJson($this.layerDao.getByLayer((String)read), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Layer$.MODULE$.layerWrites())).toString());
    }

    public String getLayerByType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(LayerType$.MODULE$.typeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(17).append("Can't get layer:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> LayerController.$anonfun$getLayerByType$2(this, BoxesRunTime.unboxToInt((Object)read)));
    }

    public String getKmlAndStationsByCity(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.typeCodeRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(54).append("Error validate Json to get kml and stations by city: \n").append(error).toString(), 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String stationType = (String)tuple2._1();
            String code = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)stationType, (Object)code);
            String stationType2 = (String)tuple22._1();
            String code2 = (String)tuple22._2();
            Option<KmlStationsCity> layers = $this.layerDao.getKmlAndStationsByCity(stationType2, code2);
            return Json$.MODULE$.toJson(layers, Writes$.MODULE$.OptionWrites(KmlStationsCity$.MODULE$.format())).toString();
        });
    }

    public String getKmlAndStationsByDept(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.typeCodeRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(60).append("Error validate Json to get kml and stations by department: \n").append(error).toString(), 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String stationType = (String)tuple2._1();
            String code = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)stationType, (Object)code);
            String stationType2 = (String)tuple22._1();
            String code2 = (String)tuple22._2();
            Seq<WatershedStation> layers = $this.layerDao.getKmlAndStationsByDept(stationType2, code2);
            return Json$.MODULE$.toJson(layers, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), WatershedStation$.MODULE$.format())).toString();
        });
    }

    public String getKmlAndStationsByWatershed(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.typeCodeRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(59).append("Error validate Json to get kml and stations by watershed: \n").append(error).toString(), 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String stationType = (String)tuple2._1();
            String code = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)stationType, (Object)code);
            String stationType2 = (String)tuple22._1();
            String code2 = (String)tuple22._2();
            WatershedStation layers = $this.layerDao.getKmlAndStationsByWatershed(stationType2, code2);
            return Json$.MODULE$.toJson((Object)layers, WatershedStation$.MODULE$.format()).toString();
        });
    }

    public String getKmlAndStationsByStation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.typeCodeRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(57).append("Error validate Json to get kml and stations by station: \n").append(error).toString(), 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String stationType = (String)tuple2._1();
            String code = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)stationType, (Object)code);
            String stationType2 = (String)tuple22._1();
            String code2 = (String)tuple22._2();
            WatershedStation layers = $this.layerDao.getKmlAndStationsByStation(stationType2, code2);
            return Json$.MODULE$.toJson((Object)layers, WatershedStation$.MODULE$.format()).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$getLayerById$2(LayerController $this, int read) {
        Option<Layer> option = $this.layerDao.getById(read);
        if (option instanceof Some) {
            Some some = (Some)option;
            Layer layer = (Layer)some.value();
            return Json$.MODULE$.toJson((Object)layer, Layer$.MODULE$.layerWrites()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ String $anonfun$getLayersByTheme$2(LayerController $this, int read) {
        Seq<ThemeLayer> layers = $this.layerDao.getByThemeId(read);
        return Json$.MODULE$.toJson(layers, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ThemeLayer$.MODULE$.writes())).toString();
    }

    public static final /* synthetic */ String $anonfun$getLayerByType$2(LayerController $this, int read) {
        return Json$.MODULE$.toJson($this.layerDao.getByType(read), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Layer$.MODULE$.layerWrites())).toString();
    }

    @Inject
    public LayerController(LayerDao layerDao, LogUtil logUtil) {
        this.layerDao = layerDao;
        this.logUtil = logUtil;
        Producer.$init$((Producer)this);
        this.codeRead = JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads());
        this.stationCodeRead = JsPath$.MODULE$.$bslash("station").read((Reads)Reads$.MODULE$.StringReads());
        this.typeCodeRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("type").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

