/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import controllers.LayerController;
import dao.itf.LayerDao;
import dao.itf.LayerThemeDao;
import domain.Layer;
import domain.LayerTheme;
import domain.LayerTheme$;
import domain.output.LayerThemeOutput$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import utils.LayersUtils$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001B\b\u0011\u0001MA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015Q\b\u0001\"\u0001|\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0002\u0015\u0019\u0006LXM\u001d+iK6,7i\u001c8ue>dG.\u001a:\u000b\u0003E\t1bY8oiJ|G\u000e\\3sg\u000e\u00011c\u0001\u0001\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"a\u0007\u0013\u000e\u0003qQ!!\b\u0010\u0002\u0007\u0005\u0004\u0018N\u0003\u0002 A\u0005A!/\u00192cSRl\u0017O\u0003\u0002\"E\u00059\u0011-];bgf\u001c(\"A\u0012\u0002\u0005\u0019\u0014\u0018BA\u0013\u001d\u0005!\u0001&o\u001c3vG\u0016\u0014\u0018!\u00047bs\u0016\u0014H\u000b[3nK\u0012\u000bw\u000e\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005\u0019\u0011\u000e\u001e4\u000b\u00031\n1\u0001Z1p\u0013\tq\u0013FA\u0007MCf,'\u000f\u00165f[\u0016$\u0015m\\\u0001\tY\u0006LXM\u001d#b_B\u0011\u0001&M\u0005\u0003e%\u0012\u0001\u0002T1zKJ$\u0015m\\\u0001\bY><W\u000b^5m!\t)\u0004(D\u00017\u0015\t9d$\u0001\u0003vi&d\u0017BA\u001d7\u0005\u001daunZ+uS2\fq\u0002\\1zKJ\u001cuN\u001c;s_2dWM\u001d\t\u0003yuj\u0011\u0001E\u0005\u0003}A\u0011q\u0002T1zKJ\u001cuN\u001c;s_2dWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0005\u00135\tR#\u0011\u0005q\u0002\u0001\"\u0002\u0014\u0006\u0001\u00049\u0003\"B\u0018\u0006\u0001\u0004\u0001\u0004\"B\u001a\u0006\u0001\u0004!\u0004\"\u0002\u001e\u0006\u0001\u0004Y\u0004FA\u0003H!\tAU*D\u0001J\u0015\tQ5*\u0001\u0004j]*,7\r\u001e\u0006\u0002\u0019\u0006)!.\u0019<bq&\u0011a*\u0013\u0002\u0007\u0013:TWm\u0019;\u0002\u0007\u001d,G\u000fF\u0003R9&\f8\u000f\u0005\u0002S3:\u00111k\u0016\t\u0003)Zi\u0011!\u0016\u0006\u0003-J\ta\u0001\u0010:p_Rt\u0014B\u0001-\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a3\u0002\"B/\u0007\u0001\u0004q\u0016aB7fgN\fw-\u001a\t\u0003?\u001el\u0011\u0001\u0019\u0006\u0003C\n\fAA[:p]*\u00111\rZ\u0001\u0005Y&\u00147O\u0003\u0002\u001eK*\ta-\u0001\u0003qY\u0006L\u0018B\u00015a\u0005\u001dQ5OV1mk\u0016DQA\u001b\u0004A\u0002-\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003SYFs\u0017BA7\\\u0005\ri\u0015\r\u001d\t\u0003+=L!\u0001\u001d\f\u0003\u0007\u0005s\u0017\u0010C\u0003s\r\u0001\u0007\u0011+\u0001\u0004n_\u0012,H.\u001a\u0005\u0006i\u001a\u0001\r!U\u0001\u0005kN,'/\u0001\rj]N,'\u000f\u001e#fM\u0006,H\u000e\u001e'bs\u0016\u0014H\u000b[3nKN$\u0012a\u001e\t\u0003+aL!!\u001f\f\u0003\tUs\u0017\u000e^\u0001\u0007O\u0016$\u0018\t\u001c7\u0015\u000bEcXP`@\t\u000buC\u0001\u0019\u00010\t\u000b)D\u0001\u0019A6\t\u000bID\u0001\u0019A)\t\u000bQD\u0001\u0019A)\u0002\u0015\u001d,GOQ=UQ\u0016lW\rF\u0005R\u0003\u000b\t9!!\u0003\u0002\f!)Q,\u0003a\u0001=\")!.\u0003a\u0001W\")!/\u0003a\u0001#\")A/\u0003a\u0001#\u0006aq-\u001a;Cs2\u000b\u00170\u001a:JIRI\u0011+!\u0005\u0002\u0014\u0005U\u0011q\u0003\u0005\u0006;*\u0001\rA\u0018\u0005\u0006U*\u0001\ra\u001b\u0005\u0006e*\u0001\r!\u0015\u0005\u0006i*\u0001\r!U\u0001\tO\u0016$H*Y=feRI\u0011+!\b\u0002 \u0005\u0005\u00121\u0005\u0005\u0006;.\u0001\rA\u0018\u0005\u0006U.\u0001\ra\u001b\u0005\u0006e.\u0001\r!\u0015\u0005\u0006i.\u0001\r!U\u0001\u0011GJ,\u0017\r^3MCf,'\u000f\u00165f[\u0016$\u0012\"UA\u0015\u0003W\ti#a\f\t\u000buc\u0001\u0019\u00010\t\u000b)d\u0001\u0019A6\t\u000bId\u0001\u0019A)\t\u000bQd\u0001\u0019A)\u0002!U\u0004H-\u0019;f\u0019\u0006LXM\u001d+iK6,G#C)\u00026\u0005]\u0012\u0011HA\u001e\u0011\u0015iV\u00021\u0001_\u0011\u0015QW\u00021\u0001l\u0011\u0015\u0011X\u00021\u0001R\u0011\u0015!X\u00021\u0001R\u0003A!W\r\\3uK2\u000b\u00170\u001a:UQ\u0016lW\rF\u0005R\u0003\u0003\n\u0019%!\u0012\u0002H!)QL\u0004a\u0001=\")!N\u0004a\u0001W\")!O\u0004a\u0001#\")AO\u0004a\u0001#\"\u001a\u0001!a\u0013\u0011\u0007!\u000bi%C\u0002\u0002P%\u0013\u0011bU5oO2,Go\u001c8")
public class LayerThemeController
implements Producer {
    private final LayerThemeDao layerThemeDao;
    private final LayerDao layerDao;
    private final LogUtil logUtil;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        LayerThemeController layerThemeController = this;
        synchronized (layerThemeController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.layerThemeDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), LayerTheme$.MODULE$.layerTheme())).toString();
    }

    public void insertDefaultLayerThemes() {
        this.logUtil.info("Creating default layer-theme links", this.logUtil.info$default$2());
        LayersUtils$.MODULE$.LAYERS_LINKS().foreach((Function1 & Serializable)lt -> BoxesRunTime.boxToInteger((int)this.layerThemeDao.create(lt)));
        this.logUtil.info("Default layer-theme links created", this.logUtil.info$default$2());
    }

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        Seq layerThemes = (Seq)this.layerThemeDao.getAll().foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable)(a, lt) -> {
            Option<Layer> option = $this.layerDao.getById(lt.layerId());
            if (option instanceof Some) {
                Some some = (Some)option;
                Layer l = (Layer)some.value();
                return (Seq)a.$colon$plus((Object)LayerThemeOutput$.MODULE$.toLayerThemeOutput(l, lt.themeId()));
            }
            if (None$.MODULE$.equals(option)) {
                return a;
            }
            throw new MatchError(option);
        });
        return Json$.MODULE$.toJson((Object)layerThemes, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), LayerThemeOutput$.MODULE$.theme())).toString();
    }

    public String getByTheme(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(LayerTheme$.MODULE$.themeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(27).append("Can't get layers by theme:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> Json$.MODULE$.toJson($this.layerThemeDao.getByTheme((Option<Object>)read), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), LayerTheme$.MODULE$.layerTheme())).toString());
    }

    public String getByLayerId(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(LayerTheme$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(24).append("Can't get layers by id:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> LayerThemeController.$anonfun$getByLayerId$2(this, BoxesRunTime.unboxToInt((Object)read)));
    }

    public String getLayer(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(LayerTheme$.MODULE$.layerIdThemeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(18).append("Can't get layer :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Option<LayerTheme> option = $this.layerThemeDao.get(read._1$mcI$sp(), (Option<Object>)((Option)read._2()));
            if (option instanceof Some) {
                Some some = (Some)option;
                LayerTheme layer = (LayerTheme)some.value();
                return Json$.MODULE$.toJson((Object)layer, LayerTheme$.MODULE$.layerTheme()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        });
    }

    public String createLayerTheme(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(LayerTheme$.MODULE$.layerThemeReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            int layerId = ((LayerTheme)jsSuccess.get()).layerId();
            Option<Object> themeId = ((LayerTheme)jsSuccess.get()).themeId();
            Option<Object> order = ((LayerTheme)jsSuccess.get()).order();
            Option<LayerTheme> option = this.layerThemeDao.get(layerId, themeId);
            if (None$.MODULE$.equals(option)) {
                LayerTheme layerTheme = new LayerTheme(layerId, themeId, order);
                int n = this.layerThemeDao.create(layerTheme);
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        }
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String updateLayerTheme(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(LayerTheme$.MODULE$.layerThemeReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            int layerId = ((LayerTheme)jsSuccess.get()).layerId();
            Option<Object> themeId = ((LayerTheme)jsSuccess.get()).themeId();
            Option<Object> order = ((LayerTheme)jsSuccess.get()).order();
            Option<LayerTheme> option = this.layerThemeDao.get(layerId, themeId);
            if (option instanceof Some) {
                LayerTheme layerTheme = new LayerTheme(layerId, themeId, order);
                int n = this.layerThemeDao.update(layerTheme);
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        }
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String deleteLayerTheme(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(LayerTheme$.MODULE$.layerIdThemeRead());
        if (jsResult instanceof JsSuccess) {
            Option themeId;
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            int layerId = ((Tuple2)jsSuccess.get())._1$mcI$sp();
            Option<LayerTheme> option = this.layerThemeDao.get(layerId, (Option<Object>)(themeId = (Option)((Tuple2)jsSuccess.get())._2()));
            if (option instanceof Some) {
                Some some = (Some)option;
                LayerTheme layerThemeIds = (LayerTheme)some.value();
                int n = this.layerThemeDao.delete(layerThemeIds.layerId(), layerThemeIds.themeId());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        }
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$getByLayerId$2(LayerThemeController $this, int read) {
        return Json$.MODULE$.toJson($this.layerThemeDao.getByLayer(read), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), LayerTheme$.MODULE$.layerTheme())).toString();
    }

    @Inject
    public LayerThemeController(LayerThemeDao layerThemeDao, LayerDao layerDao, LogUtil logUtil, LayerController layerController) {
        this.layerThemeDao = layerThemeDao;
        this.layerDao = layerDao;
        this.logUtil = logUtil;
        Producer.$init$((Producer)this);
    }
}

