/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import dao.itf.LayerDao;
import dao.itf.ThemeDao;
import domain.Theme;
import domain.Theme$;
import domain.ThemeAquaDB;
import domain.ThemeAquaDB$;
import domain.ThemeLayer;
import domain.input.ThemeInput;
import domain.input.ThemeInput$;
import domain.output.ThemeOutput;
import domain.output.ThemeOutput$;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.model.User;
import fr.aquasys.daeau.user.model.UserHabilitation;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001\u0002\t\u0012\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tI\u0001\u0011\t\u0011)A\u0005K!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\"B&\u0001\t\u0003a\u0005\"B/\u0001\t\u0003q\u0006\"\u00022\u0001\t\u0003\u0019\u0007bBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u0011Q\n\u0001\u0005\u0002\u0005=#a\u0004+iK6,7i\u001c8ue>dG.\u001a:\u000b\u0003I\t1bY8oiJ|G\u000e\\3sg\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u0006AA\u000f[3nK\u0012\u000bw\u000e\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005\u0019\u0011\u000e\u001e4\u000b\u0003\u0005\n1\u0001Z1p\u0013\t\u0019cD\u0001\u0005UQ\u0016lW\rR1p\u0003!a\u0017-_3s\t\u0006|\u0007CA\u000f'\u0013\t9cD\u0001\u0005MCf,'\u000fR1p\u0003\u001dawnZ+uS2\u0004\"AK\u001a\u000e\u0003-R!\u0001L\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0003]=\n\u0001B]1cE&$X.\u001d\u0006\u0003aE\nq!Y9vCNL8OC\u00013\u0003\t1'/\u0003\u00025W\t9Aj\\4Vi&d\u0017aB;tKJ$\u0015m\u001c\t\u0003ouj\u0011\u0001\u000f\u0006\u0003?eR!AO\u001e\u0002\tU\u001cXM\u001d\u0006\u0003y=\nQ\u0001Z1fCVL!A\u0010\u001d\u0003\u000fU\u001bXM\u001d#b_\u0006\u0011qo\u001d\t\u0003\u0003&k\u0011A\u0011\u0006\u0003\u007f\rS!\u0001R#\u0002\t1L'm\u001d\u0006\u0003\r\u001e\u000b1!\u00199j\u0015\u0005A\u0015\u0001\u00029mCfL!A\u0013\"\u0003\u0011]\u001b6\t\\5f]R\fa\u0001P5oSRtDCB'P!F\u00136\u000b\u0005\u0002O\u00015\t\u0011\u0003C\u0003\u001c\r\u0001\u0007A\u0004C\u0003%\r\u0001\u0007Q\u0005C\u0003)\r\u0001\u0007\u0011\u0006C\u00036\r\u0001\u0007a\u0007C\u0003@\r\u0001\u0007\u0001\t\u000b\u0002\u0007+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0007S:TWm\u0019;\u000b\u0003i\u000bQA[1wCbL!\u0001X,\u0003\r%s'.Z2u\u0003IIgn]3si\u0006\u000bX/\u0019#C)\",W.Z:\u0015\u0003}\u0003\"A\u00061\n\u0005\u0005<\"\u0001B+oSR\f\u0011bZ3u)\",W.Z:\u0015\r\u0011|wo`A\u0002!\t)GN\u0004\u0002gUB\u0011qmF\u0007\u0002Q*\u0011\u0011nE\u0001\u0007yI|w\u000e\u001e \n\u0005-<\u0012A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a[\f\t\u000bAD\u0001\u0019A9\u0002\u000f5,7o]1hKB\u0011!/^\u0007\u0002g*\u0011AoQ\u0001\u0005UN|g.\u0003\u0002wg\n9!j\u001d,bYV,\u0007\"\u0002=\t\u0001\u0004I\u0018a\u00025fC\u0012,'o\u001d\t\u0005Kj$G0\u0003\u0002|]\n\u0019Q*\u00199\u0011\u0005Yi\u0018B\u0001@\u0018\u0005\r\te.\u001f\u0005\u0007\u0003\u0003A\u0001\u0019\u00013\u0002\r5|G-\u001e7f\u0011\u0015Q\u0004\u00021\u0001e\u0003!9W\r\u001e+iK6,G#\u00033\u0002\n\u0005-\u0011QBA\b\u0011\u0015\u0001\u0018\u00021\u0001r\u0011\u0015A\u0018\u00021\u0001z\u0011\u0019\t\t!\u0003a\u0001I\")!(\u0003a\u0001I\u00069r-\u001a;UQ\u0016lWm]!vi\"|'/\u001b>bi&|gn\u001d\u000b\nI\u0006U\u0011qCA\r\u00037AQ\u0001\u001d\u0006A\u0002EDQ\u0001\u001f\u0006A\u0002eDa!!\u0001\u000b\u0001\u0004!\u0007\"\u0002\u001e\u000b\u0001\u0004!\u0017AF4fiRCW-\\3BkRDwN]5{CRLwN\\:\u0015\u0013\u0011\f\t#a\t\u0002&\u0005\u001d\u0002\"\u00029\f\u0001\u0004\t\b\"\u0002=\f\u0001\u0004I\bBBA\u0001\u0017\u0001\u0007A\rC\u0003;\u0017\u0001\u0007A-\u0001\u000eva\u0012\fG/\u001a+iK6,7/Q;uQ>\u0014\u0018N_1uS>t7\u000fF\u0005e\u0003[\ty#!\r\u00024!)\u0001\u000f\u0004a\u0001c\")\u0001\u0010\u0004a\u0001s\"1\u0011\u0011\u0001\u0007A\u0002\u0011DQA\u000f\u0007A\u0002\u0011\f1\"\u001e9eCR,G\u000b[3nKRIA-!\u000f\u0002<\u0005u\u0012q\b\u0005\u0006a6\u0001\r!\u001d\u0005\u0006q6\u0001\r!\u001f\u0005\u0007\u0003\u0003i\u0001\u0019\u00013\t\u000bij\u0001\u0019\u00013\u0002\u0017\u0011,G.\u001a;f)\",W.\u001a\u000b\nI\u0006\u0015\u0013qIA%\u0003\u0017BQ\u0001\u001d\bA\u0002EDQ\u0001\u001f\bA\u0002eDa!!\u0001\u000f\u0001\u0004!\u0007\"\u0002\u001e\u000f\u0001\u0004!\u0017aC2sK\u0006$X\r\u00165f[\u0016$\u0012\u0002ZA)\u0003'\n)&a\u0016\t\u000bA|\u0001\u0019A9\t\u000ba|\u0001\u0019A=\t\r\u0005\u0005q\u00021\u0001e\u0011\u0015Qt\u00021\u0001eQ\r\u0001\u00111\f\t\u0004-\u0006u\u0013bAA0/\nI1+\u001b8hY\u0016$xN\u001c")
public class ThemeController {
    private final ThemeDao themeDao;
    private final LayerDao layerDao;
    private final LogUtil logUtil;
    private final UserDao userDao;
    private final WSClient ws;

    public void insertAquaDBThemes() {
        String url = "https://aquadb.fr/postgrest/aquadb_theme";
        this.logUtil.info("Calling AquaDB to get themes", this.logUtil.info$default$2());
        WSResponse response = (WSResponse)Await$.MODULE$.result((Awaitable)this.ws.url(url).withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes()).get(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes());
        int n = response.status();
        switch (n) {
            case 200: {
                this.logUtil.info("Creating AquaDB themes", this.logUtil.info$default$2());
                Seq<ThemeAquaDB> themesAquaDB = ThemeAquaDB$.MODULE$.toSeqThemeAquaDB(response.body());
                themesAquaDB.foreach((Function1 & Serializable)t -> {
                    Theme theme = Theme$.MODULE$.toTheme((ThemeAquaDB)t);
                    return $this.themeDao.createTheme(theme);
                });
                this.logUtil.info("AquaDB themes created", this.logUtil.info$default$2());
                return;
            }
        }
        this.logUtil.error(new StringBuilder(48).append("Unable to get AquaDB themes. Status : ").append(n).append(", Error : ").append(response.body()).toString(), this.logUtil.error$default$2());
    }

    public String getThemes(JsValue message, Map<String, Object> headers, String module, String user) {
        Seq<Theme> themesDB = this.themeDao.getThemes();
        return Json$.MODULE$.toJson(themesDB, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Theme$.MODULE$.theme())).toString();
    }

    public String getTheme(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Theme$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(18).append("Can't get theme :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Option option = read;
            if (option instanceof Some) {
                Some some = (Some)option;
                int id = BoxesRunTime.unboxToInt((Object)some.value());
                Option<Theme> option2 = $this.themeDao.getTheme(id);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Theme theme = (Theme)some2.value();
                    return Json$.MODULE$.toJson((Object)theme, Theme$.MODULE$.theme()).toString();
                }
                if (None$.MODULE$.equals(option2)) {
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String getThemesAuthorizations(JsValue message, Map<String, Object> headers, String module, String user2) {
        return (String)message.validate(ThemeOutput$.MODULE$.userRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(34).append("Can't get themes authorizations :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)user -> {
            .colon.colon colon2;
            if (module != null && module.equals("Observatoire")) {
                Seq userHabilitations = $this.userDao.getAllUserHabilitations(user);
                Seq userApplicativeLogins = (Seq)((IterableOps)$this.userDao.getAllApplicative().filter((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)userHabilitations.exists((Function1 & Serializable)habilitation -> BoxesRunTime.boxToBoolean((boolean)ThemeController.$anonfun$getThemesAuthorizations$4(u, habilitation)))))).map((Function1 & Serializable)u -> u.login());
                colon2 = (Seq)userApplicativeLogins.$plus$plus((IterableOnce)new .colon.colon(user, (List)Nil$.MODULE$));
            } else {
                colon2 = new .colon.colon(user, (List)Nil$.MODULE$);
            }
            .colon.colon allLogins = colon2;
            Seq<Theme> authorizedThemes = $this.themeDao.getThemesAuthorizations((Seq<String>)allLogins);
            boolean bl = authorizedThemes.isEmpty();
            if (bl) {
                Seq<Theme> themes = $this.themeDao.getThemes();
                return Json$.MODULE$.toJson(themes, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Theme$.MODULE$.theme())).toString();
            }
            if (!bl) {
                return Json$.MODULE$.toJson(authorizedThemes, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Theme$.MODULE$.theme())).toString();
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        });
    }

    public String getThemeAuthorizations(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ThemeOutput$.MODULE$.userIdRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(33).append("Can't get theme authorizations :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Option<ThemeOutput> option = $this.themeDao.getThemeAuthorizations((Option<Object>)((Option)read._1()), (String)read._2());
            if (option instanceof Some) {
                Some some = (Some)option;
                ThemeOutput themeAuth = (ThemeOutput)some.value();
                ThemeOutput themeOutput = ThemeOutput$.MODULE$.toThemeOutputInit(themeAuth);
                return Json$.MODULE$.toJson((Object)themeOutput, ThemeOutput$.MODULE$.themeOutput()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        });
    }

    public String updateThemesAuthorizations(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), ThemeInput$.MODULE$.themeReads())).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(21).append("Can't update theme :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)themes -> {
            int res = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)themes.flatMap((Function1 & Serializable)theme -> theme.id().flatMap((Function1 & Serializable)id -> this.themeDao.getTheme(BoxesRunTime.unboxToInt((Object)id))).map((Function1 & Serializable)themeToUpdate -> BoxesRunTime.boxToInteger((int)ThemeController.$anonfun$updateThemesAuthorizations$5(this, theme, themeToUpdate))))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateTheme(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ThemeInput$.MODULE$.themeLayersReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(21).append("Can't update theme :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            ThemeInput theme = (ThemeInput)read._1();
            Seq layers = (Seq)((Option)read._2()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
            Option<Object> option = theme.id();
            if (option instanceof Some) {
                Some some = (Some)option;
                int id = BoxesRunTime.unboxToInt((Object)some.value());
                Option<Theme> option2 = $this.themeDao.getTheme(id);
                if (option2 instanceof Some) {
                    Theme themeToUpdate = Theme$.MODULE$.toTheme(theme);
                    int res = $this.themeDao.updateTheme(themeToUpdate);
                    $this.layerDao.assignLayers(id, (Seq<ThemeLayer>)layers);
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                if (None$.MODULE$.equals(option2)) {
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        });
    }

    public String deleteTheme(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ThemeInput$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(21).append("Can't delete theme :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> ThemeController.$anonfun$deleteTheme$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String createTheme(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ThemeInput$.MODULE$.themeLayersReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(18).append("Can't get theme :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Option<Theme> id;
            Option<Theme> option;
            ThemeInput themeInput = (ThemeInput)read._1();
            Seq layers = (Seq)((Option)read._2()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
            Theme theme = Theme$.MODULE$.toTheme(themeInput);
            Option<Object> option2 = themeInput.id();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                int id2 = BoxesRunTime.unboxToInt((Object)some.value());
                option = $this.themeDao.getTheme(id2);
            } else {
                option = None$.MODULE$;
            }
            Option<Theme> option3 = id = option;
            if (option3 instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option3)) {
                Option<Theme> option4 = $this.themeDao.createTheme(theme);
                if (None$.MODULE$.equals(option4)) {
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    Theme theme2 = (Theme)some.value();
                    $this.layerDao.assignLayers(BoxesRunTime.unboxToInt((Object)theme2.id().get()), (Seq<ThemeLayer>)layers);
                    return Json$.MODULE$.toJson((Object)theme2, Theme$.MODULE$.theme()).toString();
                }
                throw new MatchError(option4);
            }
            throw new MatchError(option3);
        });
    }

    public static final /* synthetic */ boolean $anonfun$getThemesAuthorizations$4(User u$1, UserHabilitation habilitation) {
        return habilitation.habilitation().toLowerCase().equals(u$1.login().toLowerCase());
    }

    public static final /* synthetic */ int $anonfun$updateThemesAuthorizations$5(ThemeController $this, ThemeInput theme$1, Theme themeToUpdate) {
        if (themeToUpdate.isAquaDBTheme()) {
            return $this.themeDao.updateAuthorizedTheme(Theme$.MODULE$.toTheme(theme$1));
        }
        return $this.themeDao.updateTheme(Theme$.MODULE$.toTheme(theme$1));
    }

    public static final /* synthetic */ String $anonfun$deleteTheme$2(ThemeController $this, int id) {
        int res = $this.themeDao.deleteTheme(id);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public ThemeController(ThemeDao themeDao, LayerDao layerDao, LogUtil logUtil, UserDao userDao, WSClient ws) {
        this.themeDao = themeDao;
        this.layerDao = layerDao;
        this.logUtil = logUtil;
        this.userDao = userDao;
        this.ws = ws;
    }
}

