/*
 * Decompiled with CFR 0.152.
 */
package utils;

import domain.KMLExport;
import domain.KMLExport$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public final class KMLExportUtils$ {
    public static final KMLExportUtils$ MODULE$ = new KMLExportUtils$();

    public String getContent(LogUtil logUtil, Seq<KMLExport> stationList) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element kmlElement = document.createElement("kml");
        kmlElement.setAttribute("xmlns", "http://www.opengis.net/kml/2.2");
        document.appendChild(kmlElement);
        Element rootElement = document.createElement("Document");
        kmlElement.appendChild(rootElement);
        this.getSchema(document, rootElement);
        this.addFolder(document, rootElement, stationList);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        if (StringUtils.isNotEmpty((CharSequence)writer.getBuffer().toString())) {
            return writer.getBuffer().toString();
        }
        return "";
    }

    public Tuple2<Seq<Element>, Map<String, String>> getMarkers(Document document, Seq<KMLExport> stationList) {
        Seq markers = (Seq)((SeqOps)stationList.map((Function1 & Serializable)x$1 -> x$1.marker())).distinct();
        Map mapMarkers = ((IterableOnceOps)((IterableOps)markers.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String marker = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)marker), (Object)new StringBuilder(6).append("marker").append(idx).toString());
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Seq styles = (Seq)markers.map((Function1 & Serializable)m -> {
            Element style = document.createElement("Style");
            style.setAttribute("id", (String)mapMarkers.apply(m));
            Element iconStyle = document.createElement("IconStyle");
            Element icon = document.createElement("Icon");
            Element href = document.createElement("href");
            href.appendChild(document.createTextNode((String)m));
            icon.appendChild(href);
            iconStyle.appendChild(icon);
            style.appendChild(iconStyle);
            return style;
        });
        return new Tuple2((Object)styles, (Object)mapMarkers);
    }

    public void getSchema(Document document, Element parentElement) {
        Element rootElement = document.createElement("Schema");
        rootElement.setAttribute("name", "export KML");
        rootElement.setAttribute("id", "export KML");
        parentElement.appendChild(rootElement);
        KMLExport$.MODULE$.getAttributeNames().foreach((Function1 & Serializable)name -> {
            KMLExportUtils$.$anonfun$getSchema$1(document, rootElement, name);
            return BoxedUnit.UNIT;
        });
    }

    public void addElement(Document document, Element parentElement, String elementName, String elementAttributeName, Option<String> elementType, Option<String> elementContent) {
        Element newElement = document.createElement(elementName);
        newElement.setAttribute("name", elementAttributeName);
        if (elementType.isDefined()) {
            newElement.setAttribute("type", (String)elementType.get());
        }
        Object object = elementContent.isDefined() ? newElement.appendChild(document.createTextNode((String)elementContent.get())) : BoxedUnit.UNIT;
        parentElement.appendChild(newElement);
    }

    public void addFolder(Document document, Element parentElement, Seq<KMLExport> stationList) {
        Element folderElement = document.createElement("Folder");
        Element nameElement = document.createElement("name");
        nameElement.appendChild(document.createTextNode("export KML"));
        folderElement.appendChild(nameElement);
        Tuple2<Seq<Element>, Map<String, String>> tuple2 = this.getMarkers(document, stationList);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq styles = (Seq)tuple2._1();
        Map mapMarkers = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)styles, (Object)mapMarkers);
        Seq styles2 = (Seq)tuple22._1();
        Map mapMarkers2 = (Map)tuple22._2();
        styles2.foreach((Function1 & Serializable)s -> folderElement.appendChild((Node)s));
        stationList.foreach((Function1 & Serializable)station -> {
            KMLExportUtils$.MODULE$.addPlacemark(document, folderElement, station, (Map<String, String>)mapMarkers2);
            return BoxedUnit.UNIT;
        });
        parentElement.appendChild(folderElement);
    }

    public void addPlacemark(Document document, Element parentElement, KMLExport station, Map<String, String> mapMarkers) {
        Element placemarkElement = document.createElement("Placemark");
        Element styleUrl = document.createElement("styleUrl");
        styleUrl.appendChild(document.createTextNode(new StringBuilder(1).append("#").append(mapMarkers.apply((Object)station.marker())).toString()));
        placemarkElement.appendChild(styleUrl);
        Element placemarkNameElement = document.createElement("name");
        placemarkNameElement.appendChild(document.createTextNode(station.code()));
        placemarkElement.appendChild(placemarkNameElement);
        Element extendedDataElement = document.createElement("ExtendedData");
        Element schemaDataElement = document.createElement("SchemaData");
        schemaDataElement.setAttribute("schemaUrl", "#export KML");
        station.getValues().foreach((Function1 & Serializable)tuple -> {
            KMLExportUtils$.$anonfun$addPlacemark$1(document, schemaDataElement, tuple);
            return BoxedUnit.UNIT;
        });
        extendedDataElement.appendChild(schemaDataElement);
        placemarkElement.appendChild(extendedDataElement);
        Element pointElement = document.createElement("Point");
        Element coordinatesElement = document.createElement("coordinates");
        coordinatesElement.appendChild(document.createTextNode(new StringBuilder(1).append(Float.toString(station.x())).append(",").append(Float.toString(station.y())).toString()));
        pointElement.appendChild(coordinatesElement);
        placemarkElement.appendChild(pointElement);
        parentElement.appendChild(placemarkElement);
    }

    public static final /* synthetic */ void $anonfun$getSchema$1(Document document$2, Element rootElement$1, String name) {
        String string;
        block5: {
            String string2 = name;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 88: {
                    if (!"X".equals(string2)) break;
                    string = "float";
                    break block5;
                }
                case 89: {
                    if (!"Y".equals(string2)) break;
                    string = "float";
                    break block5;
                }
                case 23504495: {
                    if (!"Projection".equals(string2)) break;
                    string = "int";
                    break block5;
                }
            }
            string = "string";
        }
        String rowType = string;
        MODULE$.addElement(document$2, rootElement$1, "SimpleField", name, (Option<String>)new Some((Object)rowType), (Option<String>)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$addPlacemark$1(Document document$4, Element schemaDataElement$1, Tuple2 tuple) {
        Tuple2 tuple2 = tuple;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)name, (Object)value);
        String name2 = (String)tuple22._1();
        String value2 = (String)tuple22._2();
        MODULE$.addElement(document$4, schemaDataElement$1, "SimpleData", name2, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)value2));
    }

    private KMLExportUtils$() {
    }
}

