/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.LayerController;
import controllers.LayerThemeController;
import controllers.ThemeController;
import dao.itf.LayerDao;
import dao.itf.LayerThemeDao;
import dao.itf.ThemeDao;
import domain.Layer;
import domain.LayerTheme;
import domain.Theme;
import fr.aquasys.rabbitmq.util.LogUtil;
import javax.inject.Inject;
import javax.inject.Singleton;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\b\u0011\u0001MA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!Y\u0004A!A!\u0002\u0013a\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011CQa\u0012\u0001\u0005\u0002!Cqa\u0017\u0001C\u0002\u0013\u0005A\f\u0003\u0004p\u0001\u0001\u0006I!\u0018\u0005\ba\u0002\u0011\r\u0011\"\u0001r\u0011\u00191\b\u0001)A\u0005e\"9q\u000f\u0001b\u0001\n\u0003A\bBB?\u0001A\u0003%\u0011PA\bP]N#\u0018M\u001d;va6{G-\u001e7f\u0015\u0005\t\u0012!B;uS2\u001c8\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0017a\u00027pOV#\u0018\u000e\u001c\t\u00039\u0015j\u0011!\b\u0006\u0003=}\tA!\u001e;jY*\u0011\u0001%I\u0001\te\u0006\u0014'-\u001b;nc*\u0011!eI\u0001\bCF,\u0018m]=t\u0015\u0005!\u0013A\u00014s\u0013\t1SDA\u0004M_\u001e,F/\u001b7\u0002\u0011QDW-\\3EC>\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u0007%$hMC\u0001.\u0003\r!\u0017m\\\u0005\u0003_)\u0012\u0001\u0002\u00165f[\u0016$\u0015m\\\u0001\u0010i\",W.Z\"p]R\u0014x\u000e\u001c7feB\u0011!'N\u0007\u0002g)\tA'A\u0006d_:$(o\u001c7mKJ\u001c\u0018B\u0001\u001c4\u0005=!\u0006.Z7f\u0007>tGO]8mY\u0016\u0014\u0018\u0001\u00037bs\u0016\u0014H)Y8\u0011\u0005%J\u0014B\u0001\u001e+\u0005!a\u0015-_3s\t\u0006|\u0017!\u00047bs\u0016\u0014H\u000b[3nK\u0012\u000bw\u000e\u0005\u0002*{%\u0011aH\u000b\u0002\u000e\u0019\u0006LXM\u001d+iK6,G)Y8\u0002\u001f1\f\u00170\u001a:D_:$(o\u001c7mKJ\u0004\"AM!\n\u0005\t\u001b$a\u0004'bs\u0016\u00148i\u001c8ue>dG.\u001a:\u0002)1\f\u00170\u001a:UQ\u0016lWmQ8oiJ|G\u000e\\3s!\t\u0011T)\u0003\u0002Gg\t!B*Y=feRCW-\\3D_:$(o\u001c7mKJ\fa\u0001P5oSRtD\u0003C%L\u00196su\nU)\u0011\u0005)\u0003Q\"\u0001\t\t\u000biA\u0001\u0019A\u000e\t\u000b\u001dB\u0001\u0019\u0001\u0015\t\u000bAB\u0001\u0019A\u0019\t\u000b]B\u0001\u0019\u0001\u001d\t\u000bmB\u0001\u0019\u0001\u001f\t\u000b}B\u0001\u0019\u0001!\t\u000b\rC\u0001\u0019\u0001#)\u0005!\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0019IgN[3di*\t\u0001,A\u0003kCZ\f\u00070\u0003\u0002[+\n1\u0011J\u001c6fGR\fa\u0001\u001e5f[\u0016\u001cX#A/\u0011\u0007y3\u0017N\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!ME\u0001\u0007yI|w\u000e\u001e \n\u0003]I!!\u001a\f\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\u0004'\u0016\f(BA3\u0017!\tQW.D\u0001l\u0015\u0005a\u0017A\u00023p[\u0006Lg.\u0003\u0002oW\n)A\u000b[3nK\u00069A\u000f[3nKN\u0004\u0013A\u00027bs\u0016\u00148/F\u0001s!\rqfm\u001d\t\u0003URL!!^6\u0003\u000b1\u000b\u00170\u001a:\u0002\u000f1\f\u00170\u001a:tA\u0005YA.Y=feRCW-\\3t+\u0005I\bc\u00010guB\u0011!n_\u0005\u0003y.\u0014!\u0002T1zKJ$\u0006.Z7f\u00031a\u0017-_3s)\",W.Z:!Q\t\u0001q\u0010E\u0002U\u0003\u0003I1!a\u0001V\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class OnStartupModule {
    private final Seq<Theme> themes;
    private final Seq<Layer> layers;
    private final Seq<LayerTheme> layerThemes;

    public Seq<Theme> themes() {
        return this.themes;
    }

    public Seq<Layer> layers() {
        return this.layers;
    }

    public Seq<LayerTheme> layerThemes() {
        return this.layerThemes;
    }

    @Inject
    public OnStartupModule(LogUtil logUtil, ThemeDao themeDao, ThemeController themeController, LayerDao layerDao, LayerThemeDao layerThemeDao, LayerController layerController, LayerThemeController layerThemeController) {
        logUtil.info("Checking if default themes exist", logUtil.info$default$2());
        this.themes = themeDao.getThemes();
        boolean bl = this.themes().isEmpty();
        if (bl) {
            themeController.insertAquaDBThemes();
        } else if (!bl) {
            logUtil.info("Default themes already created", logUtil.info$default$2());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        logUtil.info("Checking if default layers exist", logUtil.info$default$2());
        this.layers = layerDao.getAll();
        boolean bl2 = this.layers().isEmpty();
        if (bl2) {
            layerController.insertDefaultLayers();
        } else if (!bl2) {
            logUtil.info("Default layers already created", logUtil.info$default$2());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
        }
        logUtil.info("Checking if default layer-theme links exist", logUtil.info$default$2());
        this.layerThemes = layerThemeDao.getAll();
        boolean bl3 = this.layerThemes().isEmpty();
        if (bl3) {
            layerThemeController.insertDefaultLayerThemes();
        } else if (!bl3) {
            logUtil.info("Default layer-theme links already created", logUtil.info$default$2());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl3));
        }
    }
}

