/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.utils.readFileUtil;

import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.FileUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.readFileUtil.FileData;
import fr.aquasys.utils.readFileUtil.ReadCSV;
import fr.aquasys.utils.readFileUtil.ReadFileParams;
import fr.aquasys.utils.readFileUtil.ReadXls;
import fr.aquasys.utils.readFileUtil.ReadXlsx;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\u0006\f\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tI\u0001\u0011\t\u0011)A\u0005K!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\"\u0002\u001c\u0001\t\u00039\u0004\"B$\u0001\t\u0003A\u0005\"\u0002:\u0001\t\u0003\u0019\b\"B=\u0001\t\u0003Q(AD#yG\u0016dGk\\\"T-V#\u0018\u000e\u001c\u0006\u0003\u00195\tAB]3bI\u001aKG.Z+uS2T!AD\b\u0002\u000bU$\u0018\u000e\\:\u000b\u0005A\t\u0012aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002%\u0005\u0011aM]\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VMZ\u0001\bY><W\u000b^5m!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003vi&d'BA\u0011\u0010\u0003!\u0011\u0018M\u00192ji6\f\u0018BA\u0012\u001f\u0005\u001daunZ+uS2\f!BS8c\u0019><W\u000b^5m!\t1s%D\u0001\u000e\u0013\tASB\u0001\u0006K_\ndunZ+uS2\fqAU3bIbc7\u000f\u0005\u0002,Y5\t1\"\u0003\u0002.\u0017\t9!+Z1e12\u001c\u0018\u0001\u0003*fC\u0012DFn\u001d=\u0011\u0005-\u0002\u0014BA\u0019\f\u0005!\u0011V-\u00193YYND\u0018a\u0002*fC\u0012\u001c5K\u0016\t\u0003WQJ!!N\u0006\u0003\u000fI+\u0017\rZ\"T-\u00061A(\u001b8jiz\"b\u0001O\u001d;wqj\u0004CA\u0016\u0001\u0011\u0015Yb\u00011\u0001\u001d\u0011\u0015!c\u00011\u0001&\u0011\u0015Ic\u00011\u0001+\u0011\u0015qc\u00011\u00010\u0011\u0015\u0011d\u00011\u00014Q\t1q\b\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u00061\u0011N\u001c6fGRT\u0011\u0001R\u0001\u0006U\u00064\u0018\r_\u0005\u0003\r\u0006\u0013a!\u00138kK\u000e$\u0018\u0001\u0003:fC\u00124\u0015\u000e\\3\u0015\u000b%K6\r\u001b6\u0011\u0007)\u0013VK\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011ajE\u0001\u0007yI|w\u000e\u001e \n\u0003aI!!U\f\u0002\u000fA\f7m[1hK&\u00111\u000b\u0016\u0002\u0004'\u0016\f(BA)\u0018!\rQ%K\u0016\t\u0003W]K!\u0001W\u0006\u0003\u0011\u0019KG.\u001a#bi\u0006DQAW\u0004A\u0002m\u000b\u0001BZ5mKB\u000bG\u000f\u001b\t\u00039\u0002t!!\u00180\u0011\u00051;\u0012BA0\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005};\u0002\"\u00023\b\u0001\u0004)\u0017A\u00029be\u0006l7\u000f\u0005\u0002,M&\u0011qm\u0003\u0002\u000f%\u0016\fGMR5mKB\u000b'/Y7t\u0011\u0015Iw\u00011\u0001\\\u0003-\u0019H/\u0019;j_:\u001cu\u000eZ3\t\u000b-<\u0001\u0019\u00017\u0002\u001d)|'-\u0012=fGV$\u0018n\u001c8JIB\u0019a#\\8\n\u00059<\"AB(qi&|g\u000e\u0005\u0002\u0017a&\u0011\u0011o\u0006\u0002\u0005\u0019>tw-\u0001\nsK\u0006$g)\u001b7f\rJ|WNQ1tKZ\"D\u0003B%umbDQ!\u001e\u0005A\u0002m\u000b!BY1tKZ\"D-\u0019;b\u0011\u00159\b\u00021\u0001\\\u0003!1\u0017\u000e\\3OC6,\u0007\"\u00023\t\u0001\u0004)\u0017!E4fi\u0016C8-\u001a7TQ\u0016,G\u000fT5tiR!1\u0010`A\b!\rQ%k\u0017\u0005\u0006{&\u0001\rA`\u0001\u0005M&dW\rE\u0002\u0017[~\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0002j_*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0005\r!\u0001\u0002$jY\u0016Da!^\u0005A\u0002\u0005E\u0001c\u0001\fn7\u0002")
public class ExcelToCSVUtil {
    private final JobLogUtil JobLogUtil;
    private final ReadXls ReadXls;
    private final ReadXlsx ReadXlsx;
    private final ReadCSV ReadCSV;

    public Seq<Seq<FileData>> readFile(String filePath, ReadFileParams params, String stationCode, Option<Object> jobExecutionId) {
        jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.checkExecutionAbort(je));
        File file = new File(filePath);
        if (!file.exists()) {
            throw new Exception(new StringBuilder(23).append("File does not exists : ").append(filePath).toString());
        }
        if (file.getName().toLowerCase().endsWith(".xls") || file.getName().toLowerCase().endsWith(".xlsm")) {
            Seq<Seq<FileData>> res = this.ReadXls.readXls(file.getName(), params, stationCode, jobExecutionId, (Option<String>)new Some((Object)filePath), (Option<String>)None$.MODULE$, (Option<File>)new Some((Object)file));
            return res;
        }
        if (file.getName().toLowerCase().endsWith(".xlsx")) {
            FileInputStream fis = new FileInputStream(file);
            Seq<Seq<FileData>> res = this.ReadXlsx.readXlsx(fis, file.getName(), params, stationCode, jobExecutionId);
            fis.close();
            return res;
        }
        if (((SeqOps)new .colon.colon(params.semicolonSeparator(), (List)new .colon.colon(params.commaSeparator(), (List)new .colon.colon(params.tabulationSeparator(), (List)new .colon.colon(params.spaceSeparator(), (List)new .colon.colon(params.customSeparator(), (List)Nil$.MODULE$))))).flatten(Predef$.MODULE$.$conforms())).isEmpty()) {
            throw new Exception("No separator selected to read CSV file !");
        }
        BufferedSource bufferedSource = FileUtil$.MODULE$.readFileSource(file.getAbsolutePath());
        Seq<Seq<FileData>> res = this.ReadCSV.readCSV((Source)bufferedSource, file.getName(), params, stationCode, jobExecutionId);
        bufferedSource.close();
        return res;
    }

    public Seq<Seq<FileData>> readFileFromBase64(String base64data, String fileName, ReadFileParams params) {
        if (fileName.endsWith(".xls")) {
            Seq<Seq<FileData>> res = this.ReadXls.readXls(fileName, params, "", (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)base64data), (Option<File>)None$.MODULE$);
            return res;
        }
        if (fileName.toLowerCase().endsWith(".xlsx")) {
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((String)base64data));
            Seq<Seq<FileData>> res = this.ReadXlsx.readXlsx(bais, fileName, params, "", (Option<Object>)None$.MODULE$);
            bais.close();
            return res;
        }
        Source bufferedSource = Source$.MODULE$.fromBytes(Base64.decodeBase64((String)base64data), Codec$.MODULE$.fallbackSystemCodec());
        Seq<Seq<FileData>> res = this.ReadCSV.readCSV(bufferedSource, fileName, params, "", (Option<Object>)None$.MODULE$);
        bufferedSource.close();
        return res;
    }

    public Seq<String> getExcelSheetList(Option<File> file, Option<String> base64data) {
        Workbook workbook = this.ReadXls.getWoorkbook(file, base64data);
        ListBuffer list = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Iterator it = workbook.sheetIterator();
        while (it.hasNext()) {
            list.$plus$eq((Object)((Sheet)it.next()).getSheetName());
        }
        return list.toSeq();
    }

    @Inject
    public ExcelToCSVUtil(LogUtil logUtil, JobLogUtil JobLogUtil2, ReadXls ReadXls2, ReadXlsx ReadXlsx2, ReadCSV ReadCSV2) {
        this.JobLogUtil = JobLogUtil2;
        this.ReadXls = ReadXls2;
        this.ReadXlsx = ReadXlsx2;
        this.ReadCSV = ReadCSV2;
    }
}

