/*
 * Decompiled with CFR 0.152.
 */
package com.internetitem.logback.elasticsearch;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.internetitem.logback.elasticsearch.ElasticsearchOutputAggregator;
import com.internetitem.logback.elasticsearch.config.ElasticsearchProperties;
import com.internetitem.logback.elasticsearch.config.Property;
import com.internetitem.logback.elasticsearch.config.Settings;
import com.internetitem.logback.elasticsearch.util.AbstractPropertyAndEncoder;
import com.internetitem.logback.elasticsearch.util.ErrorReporter;
import com.internetitem.logback.elasticsearch.writer.ElasticsearchWriter;
import com.internetitem.logback.elasticsearch.writer.LoggerWriter;
import com.internetitem.logback.elasticsearch.writer.StdErrWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.DatatypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElasticsearchPublisher<T>
implements Runnable {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger(1);
    private static final String MDC_PROPERTY_NAME = "mdc";
    public static final String THREAD_NAME_PREFIX = "es-writer-";
    private volatile List<T> events;
    private ElasticsearchOutputAggregator outputAggregator;
    private List<AbstractPropertyAndEncoder<T>> propertyList;
    private AbstractPropertyAndEncoder<T> indexPattern;
    private JsonFactory jf;
    private JsonGenerator jsonGenerator;
    private ErrorReporter errorReporter;
    private Settings settings;
    private final Object lock;
    private volatile boolean working;

    public AbstractElasticsearchPublisher(Context context, ErrorReporter errorReporter, Settings settings, ElasticsearchProperties properties) throws IOException {
        this.errorReporter = errorReporter;
        this.events = new ArrayList<T>();
        this.lock = new Object();
        this.settings = settings;
        this.outputAggregator = AbstractElasticsearchPublisher.configureOutputAggregator(settings, errorReporter);
        this.jf = new JsonFactory();
        this.jf.setRootValueSeparator(null);
        this.jsonGenerator = this.jf.createGenerator((Writer)this.outputAggregator);
        this.indexPattern = this.buildPropertyAndEncoder(context, new Property("<index>", settings.getIndex(), false));
        this.propertyList = this.generatePropertyList(context, properties);
    }

    private static ElasticsearchOutputAggregator configureOutputAggregator(Settings settings, ErrorReporter errorReporter) {
        ElasticsearchOutputAggregator spigot = new ElasticsearchOutputAggregator(settings, errorReporter);
        if (settings.isLogsToStderr()) {
            spigot.addWriter(new StdErrWriter());
        }
        if (settings.getLoggerName() != null) {
            spigot.addWriter(new LoggerWriter(settings.getLoggerName()));
        }
        if (settings.getUrl() != null) {
            spigot.addWriter(new ElasticsearchWriter(errorReporter, settings));
        }
        return spigot;
    }

    private List<AbstractPropertyAndEncoder<T>> generatePropertyList(Context context, ElasticsearchProperties properties) {
        ArrayList<AbstractPropertyAndEncoder<T>> list = new ArrayList<AbstractPropertyAndEncoder<T>>();
        if (properties != null) {
            for (Property property : properties.getProperties()) {
                list.add(this.buildPropertyAndEncoder(context, property));
            }
        }
        return list;
    }

    protected abstract AbstractPropertyAndEncoder<T> buildPropertyAndEncoder(Context var1, Property var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(T event) {
        if (!this.outputAggregator.hasOutputs()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.events.add(event);
            if (!this.working) {
                this.working = true;
                Thread thread = new Thread((Runnable)this, THREAD_NAME_PREFIX + THREAD_COUNTER.getAndIncrement());
                thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int currentTry = 1;
        int maxRetries = this.settings.getMaxRetries();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.settings.getSleepTime());
                    List<T> eventsCopy = null;
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.events.isEmpty()) {
                            eventsCopy = this.events;
                            this.events = new ArrayList<T>();
                            currentTry = 1;
                        }
                        if (eventsCopy == null) {
                            if (!this.outputAggregator.hasPendingData()) {
                                this.working = false;
                                return;
                            }
                            if (currentTry > maxRetries) {
                                this.working = false;
                                return;
                            }
                        }
                    }
                    if (eventsCopy != null) {
                        this.serializeEvents(this.jsonGenerator, eventsCopy, this.propertyList);
                    }
                    if (this.outputAggregator.sendData()) continue;
                    ++currentTry;
                }
            }
            catch (Exception e) {
                this.errorReporter.logError("Internal error handling log data: " + e.getMessage(), e);
                ++currentTry;
                continue;
            }
            break;
        }
    }

    private void serializeEvents(JsonGenerator gen, List<T> eventsCopy, List<AbstractPropertyAndEncoder<T>> propertyList) throws IOException {
        for (T event : eventsCopy) {
            this.serializeIndexString(gen, event);
            gen.writeRaw('\n');
            this.serializeEvent(gen, event, propertyList);
            gen.writeRaw('\n');
        }
        gen.flush();
    }

    private void serializeIndexString(JsonGenerator gen, T event) throws IOException {
        gen.writeStartObject();
        gen.writeObjectFieldStart("index");
        gen.writeObjectField("_index", (Object)this.indexPattern.encode(event));
        String type = this.settings.getType();
        if (type != null) {
            gen.writeObjectField("_type", (Object)type);
        }
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void serializeEvent(JsonGenerator gen, T event, List<AbstractPropertyAndEncoder<T>> propertyList) throws IOException {
        gen.writeStartObject();
        this.serializeCommonFields(gen, event);
        for (AbstractPropertyAndEncoder<T> pae : propertyList) {
            String name = pae.getName();
            if (MDC_PROPERTY_NAME.equalsIgnoreCase(name)) {
                this.splitMDCFields(event, gen);
                continue;
            }
            String value = pae.encode(event);
            if (!pae.allowEmpty() && (value == null || value.isEmpty())) continue;
            gen.writeObjectField(pae.getName(), (Object)value);
        }
        gen.writeEndObject();
    }

    private void splitMDCFields(T event, JsonGenerator gen) throws IOException {
        ILoggingEvent logEvent = (ILoggingEvent)event;
        Map mdcPropertyMap = logEvent.getMDCPropertyMap();
        for (Map.Entry entry : mdcPropertyMap.entrySet()) {
            gen.writeStringField((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected abstract void serializeCommonFields(JsonGenerator var1, T var2) throws IOException;

    protected static String getTimestamp(long timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        return DatatypeConverter.printDateTime((Calendar)cal);
    }
}

