/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.SAXParserFactory;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.stream.Materializer;
import play.api.Application;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.i18n.MessagesApi;
import play.utils.Threads$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.XML$;
import scala.xml.factory.XMLLoader;

public final class Play$ {
    public static final Play$ MODULE$ = new Play$();
    private static SAXParserFactory xercesSaxParserFactory;
    private static final Logger logger;
    private static final String GlobalAppConfigKey;
    private static final AtomicReference<Application> _currentApp;
    private static volatile boolean bitmap$0;

    static {
        logger = Logger$.MODULE$.apply(MODULE$.getClass());
        GlobalAppConfigKey = "play.allowGlobalApplication";
        _currentApp = new AtomicReference();
    }

    private Logger logger() {
        return logger;
    }

    public String GlobalAppConfigKey() {
        return GlobalAppConfigKey;
    }

    /*
     * WARNING - void declaration
     */
    private SAXParserFactory xercesSaxParserFactory$lzycompute() {
        Play$ play$ = this;
        synchronized (play$) {
            if (!bitmap$0) {
                void var2_2;
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                xercesSaxParserFactory = var2_2;
                bitmap$0 = true;
            }
        }
        return xercesSaxParserFactory;
    }

    public SAXParserFactory xercesSaxParserFactory() {
        if (!bitmap$0) {
            return this.xercesSaxParserFactory$lzycompute();
        }
        return xercesSaxParserFactory;
    }

    public XMLLoader<Elem> XML() {
        return XML$.MODULE$.withSAXParser(this.xercesSaxParserFactory().newSAXParser());
    }

    public Try<Application> privateMaybeApplication() {
        if (this._currentApp().get() != null) {
            return new Success((Object)this._currentApp().get());
        }
        return new Failure((Throwable)new RuntimeException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |The global application reference is disabled. Play's global state is deprecated and will\n             |be removed in a future release. You should use dependency injection instead. To enable\n             |the global application anyway, set " + this.GlobalAppConfigKey() + " = true.\n       "))));
    }

    public Option<Application> routesCompilerMaybeApplication() {
        return this.privateMaybeApplication().toOption();
    }

    private AtomicReference<Application> _currentApp() {
        return _currentApp;
    }

    public synchronized void start(Application app) {
        Mode mode;
        boolean globalApp = app.globalApplicationEnabled();
        if (globalApp && this._currentApp().get() != null) {
            this.logger().info((Function0<String>)(Function0 & Serializable)() -> "Stopping current application", MarkerContext$.MODULE$.NoMarker());
            this.stop(this._currentApp().get());
        }
        if (Mode.Test$.MODULE$.equals(mode = app.mode())) {
        } else {
            this.logger().info((Function0<String>)(Function0 & Serializable)() -> "Application started (" + mode + ")" + (!globalApp ? " (no global state)" : ""), MarkerContext$.MODULE$.NoMarker());
        }
        if (globalApp) {
            this.logger().warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |You are using the deprecated global state to set and access the current running application. If you\n           |need an instance of Application, set " + MODULE$.GlobalAppConfigKey() + " = false and use Dependency Injection instead.\n        ")), MarkerContext$.MODULE$.NoMarker());
            this._currentApp().set(app);
            app.coordinatedShutdown().addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "unregister-global-app", (Function0 & Serializable)() -> {
                MODULE$.unsetGlobalApp(app);
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            });
            return;
        }
    }

    public void stop(Application app) {
        if (app != null) {
            Threads$.MODULE$.withContextClassLoader(app.classloader(), (Function0 & Serializable)() -> {
                Awaitable awaitable;
                try {
                    awaitable = Await$.MODULE$.ready(app.stop(), (Duration)Duration$.MODULE$.Inf());
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        MODULE$.logger().warn((Function0<String>)(Function0 & Serializable)() -> "Error stopping application", (Function0<Throwable>)(Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
                        awaitable = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                return awaitable;
            });
            return;
        }
    }

    private boolean unsetGlobalApp(Application app) {
        return this._currentApp().compareAndSet(app, null);
    }

    public String langCookieName(MessagesApi messagesApi) {
        return messagesApi.langCookieName();
    }

    public boolean langCookieSecure(MessagesApi messagesApi) {
        return messagesApi.langCookieSecure();
    }

    public boolean langCookieHttpOnly(MessagesApi messagesApi) {
        return messagesApi.langCookieHttpOnly();
    }

    public Materializer materializer(Application app) {
        return app.materializer();
    }

    private Play$() {
    }
}

