/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import fr.aquasys.daeau.materiel.domain.output.MaterielsOutput;
import fr.aquasys.daeau.materiel.domain.output.MaterielsOutput$;
import fr.aquasys.daeau.materiel.itf.central.MaterielCentralDao;
import fr.aquasys.daeau.materiel.itf.equipment.MaterielEquipmentDao;
import fr.aquasys.daeau.materiel.itf.powerSupply.MaterielPowerSupplyDao;
import fr.aquasys.daeau.materiel.itf.sensor.MaterielSensorDao;
import fr.aquasys.daeau.materiel.itf.sim.MaterielSimDao;
import fr.aquasys.daeau.materiel.itf.subscription.SubscriptionDao;
import fr.aquasys.daeau.materiel.itf.telecom.TelecomDao;
import fr.aquasys.daeau.materiel.itf.variousMateriel.MaterielVariousMaterielDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import utils.MaterielUtils$;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\u0007\u000e\u0001AA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u0007\u0005\tI\u0001\u0011\t\u0011)A\u0005K!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00059\")!\r\u0001C\u0001G\")\u0001\u0010\u0001C\u0001s\n9R*\u0019;fe&,G.\u0012<f]R\u001cuN\u001c;s_2dWM\u001d\u0006\u0002\u001d\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"!\u0007\u0012\u000e\u0003iQ!a\u0007\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003;y\t\u0001B]1cE&$X.\u001d\u0006\u0003?\u0001\nq!Y9vCNL8OC\u0001\"\u0003\t1'/\u0003\u0002$5\t9Aj\\4Vi&d\u0017AC2f]R\u0014\u0018\r\u001c#b_B\u0011aeL\u0007\u0002O)\u0011\u0001&K\u0001\bG\u0016tGO]1m\u0015\tQ3&A\u0002ji\u001aT!\u0001L\u0017\u0002\u00115\fG/\u001a:jK2T!A\f\u0010\u0002\u000b\u0011\fW-Y;\n\u0005A:#AE'bi\u0016\u0014\u0018.\u001a7DK:$(/\u00197EC>\f\u0011b]3og>\u0014H)Y8\u0011\u0005M2T\"\u0001\u001b\u000b\u0005UJ\u0013AB:f]N|'/\u0003\u00028i\t\tR*\u0019;fe&,GnU3og>\u0014H)Y8\u0002\u001dA|w/\u001a:TkB\u0004H.\u001f#b_B\u0011!(P\u0007\u0002w)\u0011A(K\u0001\fa><XM]*vaBd\u00170\u0003\u0002?w\t1R*\u0019;fe&,G\u000eU8xKJ\u001cV\u000f\u001d9ms\u0012\u000bw.\u0001\u0004tS6$\u0015m\u001c\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007&\n1a]5n\u0013\t)%I\u0001\bNCR,'/[3m'&lG)Y8\u0002\u0015Q,G.Z2p[\u0012\u000bw\u000e\u0005\u0002I\u00176\t\u0011J\u0003\u0002KS\u00059A/\u001a7fG>l\u0017B\u0001'J\u0005)!V\r\\3d_6$\u0015m\\\u0001\u0013m\u0006\u0014\u0018n\\;t\u001b\u0006$XM]5fY\u0012\u000bw\u000e\u0005\u0002P%6\t\u0001K\u0003\u0002RS\u0005ya/\u0019:j_V\u001cX*\u0019;fe&,G.\u0003\u0002T!\nQR*\u0019;fe&,GNV1sS>,8/T1uKJLW\r\u001c#b_\u0006aQ-];ja6,g\u000e\u001e#b_B\u0011a+W\u0007\u0002/*\u0011\u0001,K\u0001\nKF,\u0018\u000e]7f]RL!AW,\u0003)5\u000bG/\u001a:jK2,\u0015/^5q[\u0016tG\u000fR1p\u0003=\u0019XOY:de&\u0004H/[8o\t\u0006|\u0007CA/a\u001b\u0005q&BA0*\u00031\u0019XOY:de&\u0004H/[8o\u0013\t\tgLA\bTk\n\u001c8M]5qi&|g\u000eR1p\u0003\u0019a\u0014N\\5u}QQAMZ4iS*\\G.\u001c8\u0011\u0005\u0015\u0004Q\"A\u0007\t\u000b]Q\u0001\u0019\u0001\r\t\u000b\u0011R\u0001\u0019A\u0013\t\u000bER\u0001\u0019\u0001\u001a\t\u000baR\u0001\u0019A\u001d\t\u000b}R\u0001\u0019\u0001!\t\u000b\u0019S\u0001\u0019A$\t\u000b5S\u0001\u0019\u0001(\t\u000bQS\u0001\u0019A+\t\u000bmS\u0001\u0019\u0001/)\u0005)\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003\u0019IgN[3di*\tQ/A\u0003kCZ\f\u00070\u0003\u0002xe\n1\u0011J\u001c6fGR\fAdZ3u\u001b\u0006$XM]5fY\nK\b+[3{_6,G/\u001a:Fm\u0016tG\u000fF\u0005{\u0003\u0017\t9#a\u000e\u0002<A\u001910!\u0002\u000f\u0007q\f\t\u0001\u0005\u0002~'5\taP\u0003\u0002\u0000\u001f\u00051AH]8pizJ1!a\u0001\u0014\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\u0019\u0019FO]5oO*\u0019\u00111A\n\t\u000f\u000551\u00021\u0001\u0002\u0010\u00059Q.Z:tC\u001e,\u0007\u0003BA\t\u0003Gi!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0005UN|gN\u0003\u0003\u0002\u001a\u0005m\u0011\u0001\u00027jENTA!!\b\u0002 \u0005\u0019\u0011\r]5\u000b\u0005\u0005\u0005\u0012\u0001\u00029mCfLA!!\n\u0002\u0014\t9!j\u001d,bYV,\u0007bBA\u0015\u0017\u0001\u0007\u00111F\u0001\bQ\u0016\fG-\u001a:t!\u0019Y\u0018Q\u0006>\u00022%!\u0011qFA\u0005\u0005\ri\u0015\r\u001d\t\u0004%\u0005M\u0012bAA\u001b'\t\u0019\u0011I\\=\t\r\u0005e2\u00021\u0001{\u0003\u0019iw\u000eZ;mK\"1\u0011QH\u0006A\u0002i\fA!^:fe\u0002")
public class MaterielEventController {
    private final LogUtil logUtil;
    private final MaterielCentralDao centralDao;
    private final MaterielSensorDao sensorDao;
    private final MaterielPowerSupplyDao powerSupplyDao;
    private final MaterielSimDao simDao;
    private final TelecomDao telecomDao;
    private final MaterielVariousMaterielDao variousMaterielDao;
    private final MaterielEquipmentDao equipmentDao;
    private final SubscriptionDao subscriptionDao;

    public String getMaterielByPiezometerEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielsOutput$.MODULE$.eventMaterielReads()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            long timestamp = tuple2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(id, timestamp);
            int id2 = sp2._1$mcI$sp();
            long timestamp2 = sp2._2$mcJ$sp();
            DateTime date = new DateTime(timestamp2);
            MaterielsOutput materiels = new MaterielsOutput($this.centralDao.getAllCentralByEvent(id2, date), $this.sensorDao.getAllSensorByEvent(id2, date), $this.powerSupplyDao.getAllPowerSuppliesByEvent(id2, date), $this.telecomDao.getAllByEvent(id2, date), $this.simDao.getAllSimByEvent(id2, date), $this.equipmentDao.getAllByEvent(id2, date), $this.variousMaterielDao.getAllVariousMaterielByEvent(id2, date), $this.subscriptionDao.getAllSubscriptionByEvent(id2, date));
            return Json$.MODULE$.toJson((Object)materiels, (Writes)MaterielsOutput$.MODULE$.materielsOutputFormat()).toString();
        });
    }

    @Inject
    public MaterielEventController(LogUtil logUtil, MaterielCentralDao centralDao, MaterielSensorDao sensorDao, MaterielPowerSupplyDao powerSupplyDao, MaterielSimDao simDao, TelecomDao telecomDao, MaterielVariousMaterielDao variousMaterielDao, MaterielEquipmentDao equipmentDao, SubscriptionDao subscriptionDao) {
        this.logUtil = logUtil;
        this.centralDao = centralDao;
        this.sensorDao = sensorDao;
        this.powerSupplyDao = powerSupplyDao;
        this.simDao = simDao;
        this.telecomDao = telecomDao;
        this.variousMaterielDao = variousMaterielDao;
        this.equipmentDao = equipmentDao;
        this.subscriptionDao = subscriptionDao;
    }
}

