/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import anorm.package;
import anorm.package$;
import domain.model.StationKey$;
import fr.aquasys.daeau.materiel.domain.output.MaterielsAssignatedOutput;
import fr.aquasys.daeau.materiel.domain.output.MaterielsAssignatedOutput$;
import fr.aquasys.daeau.materiel.itf.MaterielDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.db.Database;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import utils.MaterielUtils$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\f\u0018\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A\u0011\b\u0001B\u0001B\u0003%!\bC\u0003E\u0001\u0011\u0005Q\tC\u0004U\u0001\t\u0007I\u0011A+\t\ra\u0004\u0001\u0015!\u0003W\u0011\u001dI\bA1A\u0005\u0002UCaA\u001f\u0001!\u0002\u00131\u0006bB>\u0001\u0005\u0004%\t!\u0016\u0005\u0007y\u0002\u0001\u000b\u0011\u0002,\t\u000fu\u0004!\u0019!C\u0001+\"1a\u0010\u0001Q\u0001\nYCqa \u0001C\u0002\u0013\u0005Q\u000bC\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002,\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002f\u0001!\t!a\u001a\u000335\u000bG/\u001a:jK2\u001cF/\u0019;j_:\u001cuN\u001c;s_2dWM\u001d\u0006\u00021\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"a\t\u0017\u000e\u0003\u0011R!!\n\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0003O!\n\u0001B]1cE&$X.\u001d\u0006\u0003S)\nq!Y9vCNL8OC\u0001,\u0003\t1'/\u0003\u0002.I\t9Aj\\4Vi&d\u0017aC7bi\u0016\u0014\u0018.\u001a7EC>\u0004\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0007%$hM\u0003\u00025k\u0005AQ.\u0019;fe&,GN\u0003\u00027Q\u0005)A-Y3bk&\u0011\u0001(\r\u0002\f\u001b\u0006$XM]5fY\u0012\u000bw.\u0001\u0005eCR\f'-Y:f!\tY$)D\u0001=\u0015\tid(\u0001\u0002eE*\u0011q\bQ\u0001\u0004CBL'\"A!\u0002\tAd\u0017-_\u0005\u0003\u0007r\u0012\u0001\u0002R1uC\n\f7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0019C\u0015J\u0013\t\u0003\u000f\u0002i\u0011a\u0006\u0005\u0006C\u0011\u0001\rA\t\u0005\u0006]\u0011\u0001\ra\f\u0005\u0006s\u0011\u0001\rA\u000f\u0015\u0003\t1\u0003\"!\u0014*\u000e\u00039S!a\u0014)\u0002\r%t'.Z2u\u0015\u0005\t\u0016!\u00026bm\u0006D\u0018BA*O\u0005\u0019IeN[3di\u0006\u0011\u0002/[3{_6,G/\u001a:JIN\u0014V-\u00193t+\u00051\u0006cA,]=6\t\u0001L\u0003\u0002Z5\u0006!!n]8o\u0015\tYf(\u0001\u0003mS\n\u001c\u0018BA/Y\u0005\u0015\u0011V-\u00193t!\u0011ar,\u00197\n\u0005\u0001l\"A\u0002+va2,'\u0007\u0005\u0002cS:\u00111m\u001a\t\u0003Ivi\u0011!\u001a\u0006\u0003Mf\ta\u0001\u0010:p_Rt\u0014B\u00015\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011!n\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!l\u0002cA7sk:\u0011a\u000e\u001d\b\u0003I>L\u0011AH\u0005\u0003cv\tq\u0001]1dW\u0006<W-\u0003\u0002ti\n\u00191+Z9\u000b\u0005El\u0002C\u0001\u000fw\u0013\t9XDA\u0002J]R\f1\u0003]5fu>lW\r^3s\u0013\u0012\u001c(+Z1eg\u0002\nA#];bY&$x.\\3uKJLEm\u001d*fC\u0012\u001c\u0018!F9vC2LGo\\7fi\u0016\u0014\u0018\nZ:SK\u0006$7\u000fI\u0001\u001cQf$'o\u001c7pO&\u001c\u0017\r\\*uCRLwN\\%egJ+\u0017\rZ:\u00029!LHM]8m_\u001eL7-\u00197Ti\u0006$\u0018n\u001c8JIN\u0014V-\u00193tA\u0005\u0019\u0002\u000f\\;wS>lW\r^3s\u0013\u0012\u001c(+Z1eg\u0006!\u0002\u000f\\;wS>lW\r^3s\u0013\u0012\u001c(+Z1eg\u0002\nA#\u001b8ti\u0006dG.\u0019;j_:LEm\u001d*fC\u0012\u001c\u0018!F5ogR\fG\u000e\\1uS>t\u0017\nZ:SK\u0006$7\u000fI\u0001\u001aO\u0016$X*\u0019;fe&,Gn\u001d\"z!&,'p\\7fi\u0016\u00148\u000fF\u0005b\u0003\u000f\t\t\"!\t\u0002&!9\u0011\u0011B\bA\u0002\u0005-\u0011aB7fgN\fw-\u001a\t\u0004/\u00065\u0011bAA\b1\n9!j\u001d,bYV,\u0007bBA\n\u001f\u0001\u0007\u0011QC\u0001\bQ\u0016\fG-\u001a:t!\u0019\u0011\u0017qC1\u0002\u001c%\u0019\u0011\u0011D6\u0003\u00075\u000b\u0007\u000fE\u0002\u001d\u0003;I1!a\b\u001e\u0005\r\te.\u001f\u0005\u0007\u0003Gy\u0001\u0019A1\u0002\r5|G-\u001e7f\u0011\u0019\t9c\u0004a\u0001C\u0006!Qo]3s\u0003m9W\r^'bi\u0016\u0014\u0018.\u001a7t\u0005f\fV/\u00197ji>lW\r^3sgRI\u0011-!\f\u00020\u0005E\u00121\u0007\u0005\b\u0003\u0013\u0001\u0002\u0019AA\u0006\u0011\u001d\t\u0019\u0002\u0005a\u0001\u0003+Aa!a\t\u0011\u0001\u0004\t\u0007BBA\u0014!\u0001\u0007\u0011-A\u0011hKRl\u0015\r^3sS\u0016d7OQ=Is\u0012\u0014x\u000e\\8hS\u000e\fGn\u0015;bi&|g\u000eF\u0005b\u0003s\tY$!\u0010\u0002@!9\u0011\u0011B\tA\u0002\u0005-\u0001bBA\n#\u0001\u0007\u0011Q\u0003\u0005\u0007\u0003G\t\u0002\u0019A1\t\r\u0005\u001d\u0012\u00031\u0001b\u0003i9W\r^'bi\u0016\u0014\u0018.\u001a7t\u0005f\u0004F.\u001e<j_6,G/\u001a:t)%\t\u0017QIA$\u0003\u0013\nY\u0005C\u0004\u0002\nI\u0001\r!a\u0003\t\u000f\u0005M!\u00031\u0001\u0002\u0016!1\u00111\u0005\nA\u0002\u0005Da!a\n\u0013\u0001\u0004\t\u0017aG4fi6\u000bG/\u001a:jK2\u001c()_%ogR\fG\u000e\\1uS>t7\u000fF\u0005b\u0003#\n\u0019&!\u0016\u0002X!9\u0011\u0011B\nA\u0002\u0005-\u0001bBA\n'\u0001\u0007\u0011Q\u0003\u0005\u0007\u0003G\u0019\u0002\u0019A1\t\r\u0005\u001d2\u00031\u0001b\u0003Y9W\r^'bi\u0016\u0014\u0018.\u001a7t\u0005f\u001cF/\u0019;j_:\u001cH#B1\u0002^\u0005\u0005\u0004BBA0)\u0001\u0007A.\u0001\u0006ti\u0006$\u0018n\u001c8JINDa!a\u0019\u0015\u0001\u0004)\u0018aC:uCRLwN\u001c+za\u0016\fqaZ3u\u0017\u0016L8\u000fF\u0005b\u0003S\nY'!\u001c\u0002p!9\u0011\u0011B\u000bA\u0002\u0005-\u0001bBA\n+\u0001\u0007\u0011Q\u0003\u0005\u0007\u0003G)\u0002\u0019A1\t\r\u0005\u001dR\u00031\u0001b\u0001")
public class MaterielStationController {
    private final LogUtil logUtil;
    private final MaterielDao materielDao;
    private final Database database;
    private final Reads<Tuple2<String, Seq<Object>>> piezometerIdsReads;
    private final Reads<Tuple2<String, Seq<Object>>> qualitometerIdsReads;
    private final Reads<Tuple2<String, Seq<Object>>> hydrologicalStationIdsReads;
    private final Reads<Tuple2<String, Seq<Object>>> pluviometerIdsReads;
    private final Reads<Tuple2<String, Seq<Object>>> installationIdsReads;

    public Reads<Tuple2<String, Seq<Object>>> piezometerIdsReads() {
        return this.piezometerIdsReads;
    }

    public Reads<Tuple2<String, Seq<Object>>> qualitometerIdsReads() {
        return this.qualitometerIdsReads;
    }

    public Reads<Tuple2<String, Seq<Object>>> hydrologicalStationIdsReads() {
        return this.hydrologicalStationIdsReads;
    }

    public Reads<Tuple2<String, Seq<Object>>> pluviometerIdsReads() {
        return this.pluviometerIdsReads;
    }

    public Reads<Tuple2<String, Seq<Object>>> installationIdsReads() {
        return this.installationIdsReads;
    }

    public String getMaterielsByPiezometers(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.piezometerIdsReads()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String validateUser = (String)tuple2._1();
            Seq piezometerIds = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)validateUser, (Object)piezometerIds);
            String validateUser2 = (String)tuple22._1();
            Seq piezometerIds2 = (Seq)tuple22._2();
            return this.getMaterielsByStations((Seq<Object>)piezometerIds2, 1);
        });
    }

    public String getMaterielsByQualitometers(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.qualitometerIdsReads()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String validateUser = (String)tuple2._1();
            Seq qualitometerIds = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)validateUser, (Object)qualitometerIds);
            String validateUser2 = (String)tuple22._1();
            Seq qualitometerIds2 = (Seq)tuple22._2();
            return this.getMaterielsByStations((Seq<Object>)qualitometerIds2, 3);
        });
    }

    public String getMaterielsByHydrologicalStation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.hydrologicalStationIdsReads()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String validateUser = (String)tuple2._1();
            Seq hydrologicalStationIds = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)validateUser, (Object)hydrologicalStationIds);
            String validateUser2 = (String)tuple22._1();
            Seq hydrologicalStationIds2 = (Seq)tuple22._2();
            return this.getMaterielsByStations((Seq<Object>)hydrologicalStationIds2, 4);
        });
    }

    public String getMaterielsByPluviometers(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.pluviometerIdsReads()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String validateUser = (String)tuple2._1();
            Seq pluviometerIds = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)validateUser, (Object)pluviometerIds);
            String validateUser2 = (String)tuple22._1();
            Seq pluviometerIds2 = (Seq)tuple22._2();
            return this.getMaterielsByStations((Seq<Object>)pluviometerIds2, 2);
        });
    }

    public String getMaterielsByInstallations(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.installationIdsReads()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String validateUser = (String)tuple2._1();
            Seq installationIds = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)validateUser, (Object)installationIds);
            String validateUser2 = (String)tuple22._1();
            Seq installationIds2 = (Seq)tuple22._2();
            return this.getMaterielsByStations((Seq<Object>)installationIds2, 7);
        });
    }

    public String getMaterielsByStations(Seq<Object> stationIds, int stationType) {
        if (stationIds.isEmpty()) {
            return Json$.MODULE$.toJson((Object)Nil$.MODULE$, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)MaterielsAssignatedOutput$.MODULE$.materielsOutputFormat())).toString();
        }
        MaterielsAssignatedOutput materiels = this.materielDao.getAllMaterielByStations(stationIds, stationType);
        return Json$.MODULE$.toJson((Object)materiels, (Writes)MaterielsAssignatedOutput$.MODULE$.materielsOutputFormat()).toString();
    }

    public String getKeys(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.database.withConnection((Function1 & Serializable)c -> (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select * from mat_cles"}))), (Seq)Nil$.MODULE$).as(StationKey$.MODULE$.parser().$times(), c)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), StationKey$.MODULE$.format())).toString();
    }

    @Inject
    public MaterielStationController(LogUtil logUtil, MaterielDao materielDao, Database database) {
        this.logUtil = logUtil;
        this.materielDao = materielDao;
        this.database = database;
        this.piezometerIdsReads = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("piezometerIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.qualitometerIdsReads = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("qualitometerIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.hydrologicalStationIdsReads = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("hydrologicalStationIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.pluviometerIdsReads = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("pluviometerIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.installationIdsReads = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("installationIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

