/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.google.inject.Inject;
import fr.aquasys.daeau.materiel.domain.output.MonitoredMaterielEventOutput$;
import fr.aquasys.daeau.materiel.domain.output.MonitoredMaterielOutput$;
import fr.aquasys.daeau.materiel.itf.MaterielDao;
import fr.aquasys.daeau.materiel.itf.central.CentralSituationDao;
import fr.aquasys.daeau.materiel.itf.powerSupply.PowerSupplySituationDao;
import fr.aquasys.daeau.materiel.itf.sensor.SensorSituationDao;
import fr.aquasys.daeau.materiel.itf.sim.SimSituationDao;
import fr.aquasys.daeau.materiel.itf.telecom.TelecomSituationDao;
import fr.aquasys.daeau.materiel.itf.variousMateriel.VariousSituationDao;
import fr.aquasys.daeau.materiel.rpc.MonitoredStationDaoRpc;
import fr.aquasys.daeau.quality.domain.input.UserInput;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import utils.CommonReadUtil$;
import utils.ErrorUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\b\u0010\u0001IA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\tM\u0001\u0011\t\u0011)A\u0005O!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011=\u0003!\u0011!Q\u0001\nAC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"A!\r\u0001B\u0001B\u0003%1\rC\u0003k\u0001\u0011\u00051\u000eC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\tYRj\u001c8ji>\u0014X\rZ'bi\u0016\u0014\u0018.\u001a7D_:$(o\u001c7mKJT\u0011\u0001E\u0001\fG>tGO]8mY\u0016\u00148o\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-A\u0004m_\u001e,F/\u001b7\u0011\u0005m!S\"\u0001\u000f\u000b\u0005uq\u0012\u0001B;uS2T!a\b\u0011\u0002\u0011I\f'MY5u[FT!!\t\u0012\u0002\u000f\u0005\fX/Y:zg*\t1%\u0001\u0002ge&\u0011Q\u0005\b\u0002\b\u0019><W\u000b^5m\u0003M\u0019WM\u001c;sC2\u001c\u0016\u000e^;bi&|g\u000eR1p!\tA\u0013'D\u0001*\u0015\tQ3&A\u0004dK:$(/\u00197\u000b\u00051j\u0013aA5uM*\u0011afL\u0001\t[\u0006$XM]5fY*\u0011\u0001\u0007I\u0001\u0006I\u0006,\u0017-^\u0005\u0003e%\u00121cQ3oiJ\fGnU5uk\u0006$\u0018n\u001c8EC>\f!c]3og>\u00148+\u001b;vCRLwN\u001c#b_B\u0011Q\u0007O\u0007\u0002m)\u0011qgK\u0001\u0007g\u0016t7o\u001c:\n\u0005e2$AE*f]N|'oU5uk\u0006$\u0018n\u001c8EC>\fq\u0003]8xKJ\u001cV\u000f\u001d9msNKG/^1uS>tG)Y8\u0011\u0005qzT\"A\u001f\u000b\u0005yZ\u0013a\u00039po\u0016\u00148+\u001e9qYfL!\u0001Q\u001f\u0003/A{w/\u001a:TkB\u0004H._*jiV\fG/[8o\t\u0006|\u0017a\u0005;fY\u0016\u001cw.\\*jiV\fG/[8o\t\u0006|\u0007CA\"G\u001b\u0005!%BA#,\u0003\u001d!X\r\\3d_6L!a\u0012#\u0003'Q+G.Z2p[NKG/^1uS>tG)Y8\u0002\u001fMLWnU5uk\u0006$\u0018n\u001c8EC>\u0004\"AS'\u000e\u0003-S!\u0001T\u0016\u0002\u0007MLW.\u0003\u0002O\u0017\ny1+[7TSR,\u0018\r^5p]\u0012\u000bw.A\nwCJLw.^:TSR,\u0018\r^5p]\u0012\u000bw\u000e\u0005\u0002R)6\t!K\u0003\u0002TW\u0005ya/\u0019:j_V\u001cX*\u0019;fe&,G.\u0003\u0002V%\n\u0019b+\u0019:j_V\u001c8+\u001b;vCRLwN\u001c#b_\u00061Rn\u001c8ji>\u0014X\rZ*uCRLwN\u001c#b_J\u00038\r\u0005\u0002Y76\t\u0011L\u0003\u0002[[\u0005\u0019!\u000f]2\n\u0005qK&AF'p]&$xN]3e'R\fG/[8o\t\u0006|'\u000b]2\u0002\u00175\fG/\u001a:jK2$\u0015m\u001c\t\u0003?\u0002l\u0011aK\u0005\u0003C.\u00121\"T1uKJLW\r\u001c#b_\u00069Qo]3s\t\u0006|\u0007C\u00013i\u001b\u0005)'B\u0001\u0017g\u0015\t9w&\u0001\u0003vg\u0016\u0014\u0018BA5f\u0005\u001d)6/\u001a:EC>\fa\u0001P5oSRtDc\u00037o_B\f(o\u001d;vm^\u0004\"!\u001c\u0001\u000e\u0003=AQ!G\u0006A\u0002iAQAJ\u0006A\u0002\u001dBQaM\u0006A\u0002QBQAO\u0006A\u0002mBQ!Q\u0006A\u0002\tCQ\u0001S\u0006A\u0002%CQaT\u0006A\u0002ACQAV\u0006A\u0002]CQ!X\u0006A\u0002yCQAY\u0006A\u0002\rD#aC=\u0011\u0007i\f\u0019!D\u0001|\u0015\taX0\u0001\u0004j]*,7\r\u001e\u0006\u0003}~\faaZ8pO2,'BAA\u0001\u0003\r\u0019w.\\\u0005\u0004\u0003\u000bY(AB%oU\u0016\u001cG/\u0001\fhKRl\u0015-\u001b8uK:\fgnY3NCR,'/[3m))\tY!!\t\u0002>\u00055\u0013\u0011\u000b\t\u0005\u0003\u001b\tYB\u0004\u0003\u0002\u0010\u0005]\u0001cAA\t+5\u0011\u00111\u0003\u0006\u0004\u0003+\t\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u001aU\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u000f\u0003?\u0011aa\u0015;sS:<'bAA\r+!9\u00111\u0005\u0007A\u0002\u0005\u0015\u0012aB7fgN\fw-\u001a\t\u0005\u0003O\tI$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0011Q7o\u001c8\u000b\t\u0005=\u0012\u0011G\u0001\u0005Y&\u00147O\u0003\u0003\u00024\u0005U\u0012aA1qS*\u0011\u0011qG\u0001\u0005a2\f\u00170\u0003\u0003\u0002<\u0005%\"a\u0002&t-\u0006dW/\u001a\u0005\b\u0003\u007fa\u0001\u0019AA!\u0003\u001dAW-\u00193feN\u0004\u0002\"!\u0004\u0002D\u0005-\u0011qI\u0005\u0005\u0003\u000b\nyBA\u0002NCB\u00042\u0001FA%\u0013\r\tY%\u0006\u0002\u0004\u0003:L\bbBA(\u0019\u0001\u0007\u00111B\u0001\u0007[>$W\u000f\\3\t\r\u001dd\u0001\u0019AA\u0006\u0003Q9W\r^'p]&$xN]3e\u001b\u0006$XM]5fYRQ\u00111BA,\u00033\nY&!\u0018\t\u000f\u0005\rR\u00021\u0001\u0002&!9\u0011qH\u0007A\u0002\u0005\u0005\u0003bBA(\u001b\u0001\u0007\u00111\u0002\u0005\u0007O6\u0001\r!a\u0003")
public class MonitoredMaterielController {
    private final LogUtil logUtil;
    private final CentralSituationDao centralSituationDao;
    private final SensorSituationDao sensorSituationDao;
    private final PowerSupplySituationDao powerSupplySituationDao;
    private final TelecomSituationDao telecomSituationDao;
    private final SimSituationDao simSituationDao;
    private final VariousSituationDao variousSituationDao;
    private final MonitoredStationDaoRpc monitoredStationDaoRpc;
    private final MaterielDao materielDao;
    private final UserDao userDao;

    public String getMaintenanceMateriel(JsValue message, Map<String, Object> headers, String module, String user) {
        Seq monitoredCentral = (Seq)this.centralSituationDao.getAllMaintenanceCentral().map((Function1 & Serializable)ces -> MonitoredMaterielOutput$.MODULE$.toMonitoredMaterielOutputFromCentral(ces));
        Seq monitoredSensor = (Seq)this.sensorSituationDao.getAllMaintenanceSensor().map((Function1 & Serializable)ses -> MonitoredMaterielOutput$.MODULE$.toMonitoredMaterielOutputFromSensor(ses));
        Seq monitoredPowerSupply = (Seq)this.powerSupplySituationDao.getAllMaintenancePowerSupply().map((Function1 & Serializable)pss -> MonitoredMaterielOutput$.MODULE$.toMonitoredMaterielOutputFromPowerSuplly(pss));
        Seq monitoredPowerSupplyToReplace = (Seq)this.powerSupplySituationDao.getPowerSupplyToReplace().map((Function1 & Serializable)pss -> MonitoredMaterielOutput$.MODULE$.toMonitoredMaterielOutputFromPowerSuplly(pss));
        Seq monitoredTelecom = (Seq)this.telecomSituationDao.getAllMaintenanceTelecom().map((Function1 & Serializable)tes -> MonitoredMaterielOutput$.MODULE$.toMonitoredMaterielOutputFromTelecom(tes));
        Seq monitoredSim = (Seq)this.simSituationDao.getAllMaintenanceSim().map((Function1 & Serializable)sis -> MonitoredMaterielOutput$.MODULE$.toMonitoredMaterielOutputFromSim(sis));
        Seq monitoredVarious = (Seq)this.variousSituationDao.getAllMaintenanceVarious().map((Function1 & Serializable)vas -> MonitoredMaterielOutput$.MODULE$.toMonitoredMaterielOutputFromVarious(vas));
        Seq result = (Seq)new .colon.colon((Object)monitoredCentral, (List)new .colon.colon((Object)monitoredSensor, (List)new .colon.colon((Object)monitoredPowerSupply, (List)new .colon.colon((Object)monitoredPowerSupplyToReplace, (List)new .colon.colon((Object)monitoredTelecom, (List)new .colon.colon((Object)monitoredSim, (List)new .colon.colon((Object)monitoredVarious, (List)Nil$.MODULE$))))))).flatten(Predef$.MODULE$.$conforms());
        return Json$.MODULE$.toJson((Object)result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)MonitoredMaterielOutput$.MODULE$.formatMonitoredMaterielOutput())).toString();
    }

    public String getMonitoredMateriel(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.userReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(52).append("Error validate entry to get all monitored devices : ").append(error.toString()).toString(), 400), (Function1 & Serializable)userLogin -> {
            UserInput userInput = $this.userDao.getUser(userLogin);
            Option option = userInput.error();
            if (option instanceof Some) {
                Some some = (Some)option;
                int error = BoxesRunTime.unboxToInt((Object)some.value());
                return ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(21).append("Error getting user : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3());
            }
            Seq monitoredStation = $this.monitoredStationDaoRpc.getMonitoredStation(userLogin);
            if (userInput.isAdmin().isDefined()) {
                Object object = userInput.isAdmin().get();
                String string = "1";
                if (!(object != null ? !object.equals(string) : string != null)) {
                    return Json$.MODULE$.toJson((Object)$this.materielDao.getAllMonitoredMateriels(monitoredStation), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)MonitoredMaterielEventOutput$.MODULE$.format())).toString();
                }
            }
            return Json$.MODULE$.toJson((Object)$this.materielDao.getMonitoredMateriels(monitoredStation, userInput.contributorCode(), userInput.login()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)MonitoredMaterielEventOutput$.MODULE$.format())).toString();
        });
    }

    @Inject
    public MonitoredMaterielController(LogUtil logUtil, CentralSituationDao centralSituationDao, SensorSituationDao sensorSituationDao, PowerSupplySituationDao powerSupplySituationDao, TelecomSituationDao telecomSituationDao, SimSituationDao simSituationDao, VariousSituationDao variousSituationDao, MonitoredStationDaoRpc monitoredStationDaoRpc, MaterielDao materielDao, UserDao userDao) {
        this.logUtil = logUtil;
        this.centralSituationDao = centralSituationDao;
        this.sensorSituationDao = sensorSituationDao;
        this.powerSupplySituationDao = powerSupplySituationDao;
        this.telecomSituationDao = telecomSituationDao;
        this.simSituationDao = simSituationDao;
        this.variousSituationDao = variousSituationDao;
        this.monitoredStationDaoRpc = monitoredStationDaoRpc;
        this.materielDao = materielDao;
        this.userDao = userDao;
    }
}

